/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.main.controller;

import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.product.main.services.IProductListQueryService;
import com.newtouch.nms.sip.product.main.services.ITestService;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ProductListQueryController {
    @Autowired
    private IProductListQueryService listQueryService;
    @Autowired
    private ITestService TestService;

    @ResponseBody
    @RequestMapping(value={"/doProductListQuery.do"})
    public String doProductListQuery(HttpServletRequest request) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        SipProducts sip = (SipProducts)RequestUtils.getRequestMap((Map)param.getParam(), SipProducts.class);
        ReturnMsg msg = this.listQueryService.queryProductList(sip.getProductName(), sip.getProductNo());
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @ResponseBody
    @RequestMapping(value={"/doCancelProductRiskRelation.do"})
    public String doCancelProductRiskRelation(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String product_uuid = param.get("product_uuid");
        String risk_uuid = param.get("risk_uuid");
        ReturnMsg msg = this.listQueryService.doCancelProductRiskRelation(product_uuid, risk_uuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @ResponseBody
    @RequestMapping(value={"/doProductChannelMessage.do"})
    public boolean doProductChannelMessage(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String product_uuid = param.get("product_uuid");
        boolean msg = this.listQueryService.getProductConfigStatus(product_uuid);
        return msg;
    }

    @ResponseBody
    @RequestMapping(value={"/queryPublishStateByRisk.do"})
    public boolean queryPublishStateByRisk(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        List risk_uuid = (List)param.get("risk_uuid");
        boolean msg = this.listQueryService.queryPublishStateByRisk(risk_uuid);
        return msg;
    }

    @ResponseBody
    @RequestMapping(value={"/doAddProductRiskRelation.do"}, method={RequestMethod.POST})
    public String doAddProductRiskRelation(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.listQueryService.addRisk(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @ResponseBody
    @RequestMapping(value={"/doDelProduct.do"}, method={RequestMethod.POST})
    public String doDelProduct(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.listQueryService.deleteProduct(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @ResponseBody
    @RequestMapping(value={"/queryProductByNo.do", "/queryProductByNo.serv"}, method={RequestMethod.POST})
    public String queryProductByNo(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String productUuid = map.get("product_uuid");
        ReturnMsg msg = this.listQueryService.queryProductByNo(productUuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @ResponseBody
    @RequestMapping(value={"/queryProductListByNo.do", "/queryProductListByNo.serv"}, method={RequestMethod.POST})
    public String queryProductListByNo(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String productNos = map.get("riskNos");
        ReturnMsg msg = this.listQueryService.queryProductListByNo(productNos);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @ResponseBody
    @RequestMapping(value={"/queryRiskInfo.do", "/queryRiskInfo.serv"}, method={RequestMethod.POST})
    public String queryRiskInfo(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String productNos = map.get("riskNos");
        ReturnMsg msg = this.listQueryService.queryRiskInfo(productNos);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

