/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.excel;

import com.uniapis.logger.Ulog;
import com.uniapis.utils.StrUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWrite {
    private boolean isMergeCell = false;
    private Map<String, List<LinkedHashMap<String, String>>> sheetHead = new HashMap<String, List<LinkedHashMap<String, String>>>();
    private CreationHelper helper = null;
    private CellStyle sytle_yyMMdd = null;
    private Map<String, List<Map<String, Integer>>> lockArray = new HashMap<String, List<Map<String, Integer>>>();
    private Workbook workbook = null;
    private Map<String, List<Map<String, Object>>> excelData = new HashMap<String, List<Map<String, Object>>>();
    private Map<String, Map<Integer, String>> sheetStyle = new HashMap<String, Map<Integer, String>>();

    public void writeExcel() {
        String[] head = null;
        for (String sheetName : this.sheetHead.keySet()) {
            head = this.writeHead(sheetName, this.workbook);
            this.writeSheet(sheetName, head, this.excelData.get(sheetName), this.workbook);
        }
    }

    public void setSheetStyle(String sheetName, Map<Integer, String> sheetStyle) {
        this.sheetStyle.put(sheetName, sheetStyle);
    }

    public void writeExcel(Map<String, List<Map<String, Object>>> excelMap) {
        String[] head = null;
        for (String sheetName : this.sheetHead.keySet()) {
            head = this.writeHead(sheetName, this.workbook);
            this.writeSheet(sheetName, head, excelMap.get(sheetName), this.workbook);
        }
    }

    public Workbook writeExcel4Jsp(Map<String, List<Map<String, Object>>> excelMap) {
        HSSFWorkbook wb = new HSSFWorkbook();
        String[] head = null;
        for (String sheetName : excelMap.keySet()) {
            head = this.writeHead(sheetName, (Workbook)wb);
            this.writeSheet(sheetName, head, excelMap.get(sheetName), (Workbook)wb);
        }
        return wb;
    }

    private String[] writeHead(String sheetName, Workbook wb) {
        Sheet aSheet = wb.createSheet(sheetName);
        this.setColumnStyle(wb, aSheet);
        String[] headList = this.notMergeCell(sheetName, aSheet);
        if (!this.isMergeCell) {
            return headList;
        }
        List<int[]> mergeList = this.mergeCell(sheetName, aSheet);
        for (int[] mArray : mergeList) {
            aSheet.addMergedRegion(new CellRangeAddress(mArray[0], mArray[1], mArray[2], mArray[3]));
            Ulog.debug((String)("\u5408\u5e76\u7b2c[" + mArray[0] + "]\u884c\u5230\u7b2c[" + mArray[1] + "]\u884c\uff0c\u7b2c[" + mArray[2] + "]\u5217\u5230\u7b2c[" + mArray[3] + "]\u5217\u3002"));
        }
        return headList;
    }

    private void setColumnStyle(Workbook wb, Sheet aSheet) {
        Map<Integer, String> style = this.sheetStyle.get(aSheet.getSheetName());
        if (style == null || style.isEmpty()) {
            return;
        }
        if (this.helper == null) {
            this.helper = wb.getCreationHelper();
        }
        for (Map.Entry<Integer, String> entry : style.entrySet()) {
            CellStyle clmStyle = wb.createCellStyle();
            clmStyle.setDataFormat(this.helper.createDataFormat().getFormat(entry.getValue()));
            aSheet.setDefaultColumnStyle(entry.getKey().intValue(), clmStyle);
        }
    }

    private String[] notMergeCell(String sheetName, Sheet aSheet) {
        String[] headList = null;
        int rownum = 0;
        int cellNum = 0;
        for (LinkedHashMap<String, String> aHead : this.sheetHead.get(sheetName)) {
            Row aRow = aSheet.createRow(rownum);
            cellNum = 0;
            headList = new String[aHead.size()];
            Iterator<String> iterator = aHead.keySet().iterator();
            while (iterator.hasNext()) {
                String cellKey;
                headList[cellNum] = cellKey = iterator.next();
                aRow.createCell(cellNum).setCellValue(StrUtils.trimStr((Object)aHead.get(cellKey)));
                ++cellNum;
            }
            ++rownum;
        }
        return headList;
    }

    private List<int[]> mergeCell(String sheetName, Sheet aSheet) {
        int rownum = 0;
        int cellNum = 0;
        int _m_row_s = -1;
        int _m_row_e = -1;
        int _m_clm_s = -1;
        int _m_clm_e = -1;
        String cellVal = "";
        ArrayList<int[]> mergeList = new ArrayList<int[]>();
        for (LinkedHashMap<String, String> aHead : this.sheetHead.get(sheetName)) {
            cellNum = 0;
            for (String cellKey : aHead.keySet()) {
                cellVal = StrUtils.trimStr((Object)aHead.get(cellKey));
                if ("".equals(cellVal) && _m_clm_s == -1) {
                    _m_clm_s = cellNum - 1;
                }
                if (!"".equals(cellVal) && _m_clm_s != -1) {
                    _m_clm_e = cellNum - 1;
                }
                if ("".equals(cellVal) && _m_clm_s != -1 && cellNum + 1 == aHead.size()) {
                    _m_clm_e = cellNum;
                }
                if (_m_clm_s != -1 && _m_clm_e != -1) {
                    mergeList.add(new int[]{rownum, rownum, _m_clm_s, _m_clm_e});
                    _m_clm_s = -1;
                    _m_clm_e = -1;
                }
                ++cellNum;
            }
            ++rownum;
        }
        if (this.sheetHead.get(sheetName).size() == 1) {
            return mergeList;
        }
        Object obj = null;
        Object before = null;
        int row_num = this.sheetHead.get(sheetName).size();
        for (int clm = 0; clm < this.sheetHead.get(sheetName).get(0).size(); ++clm) {
            obj = null;
            before = null;
            for (int row = 0; row < row_num; ++row) {
                obj = this.getValue(this.sheetHead.get(sheetName).get(row), clm);
                if ("".equals(obj)) continue;
                if (_m_row_s == -1 && obj.equals(before)) {
                    _m_row_s = row - 1;
                }
                if (_m_row_e == -1 && _m_row_s != -1 && !obj.equals(before)) {
                    _m_row_e = row - 1;
                }
                if (row + 1 == row_num && _m_row_s != -1 && _m_row_e == -1) {
                    _m_row_e = row;
                }
                if (_m_row_s != -1 && _m_row_e != -1) {
                    mergeList.add(new int[]{_m_row_s, _m_row_e, clm, clm});
                    _m_row_s = -1;
                    _m_row_e = -1;
                }
                before = obj;
            }
        }
        return mergeList;
    }

    private Object getValue(LinkedHashMap<String, String> link, int size) {
        int i = 0;
        for (String key : link.keySet()) {
            if (i == size) {
                return StrUtils.trimStr((Object)link.get(key));
            }
            ++i;
        }
        return "";
    }

    private void writeSheet(String sheetName, String[] sheetHead, List<Map<String, Object>> sheetValue, Workbook wb) {
        if (sheetValue == null || sheetValue.isEmpty()) {
            return;
        }
        Sheet aSheet = wb.getSheet(sheetName);
        int rownum = aSheet.getLastRowNum() + 1;
        for (Map<String, Object> rowValue : sheetValue) {
            Row aRow = aSheet.createRow(rownum);
            int cellnum = -1;
            for (String cellKey : sheetHead) {
                Object obj = rowValue.get(cellKey);
                Cell aCell = aRow.createCell(++cellnum);
                if (obj instanceof Boolean) {
                    aCell.setCellValue(((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof Double) {
                    aCell.setCellValue(((Double)obj).doubleValue());
                    continue;
                }
                if (obj instanceof String) {
                    aCell.setCellValue((String)obj);
                    continue;
                }
                if (obj instanceof Calendar) {
                    this.initDateStyle(wb);
                    aCell.setCellValue((Calendar)obj);
                    aCell.setCellStyle(this.sytle_yyMMdd);
                    aSheet.setColumnWidth(cellnum, 3000);
                    continue;
                }
                if (obj instanceof Date) {
                    this.initDateStyle(wb);
                    aCell.setCellValue((Date)obj);
                    aCell.setCellStyle(this.sytle_yyMMdd);
                    aSheet.setColumnWidth(cellnum, 3000);
                    continue;
                }
                aCell.setCellValue((String)obj);
            }
            ++rownum;
        }
        if (this.lockArray.get(sheetName) == null) {
            return;
        }
        XSSFSheet sheet = (XSSFSheet)aSheet;
        sheet.protectSheet("");
        this.setCellLocked(sheetName, wb);
    }

    private void initDateStyle(Workbook wb) {
        if (this.helper == null) {
            this.helper = wb.getCreationHelper();
        }
        if (this.sytle_yyMMdd == null) {
            this.sytle_yyMMdd = wb.createCellStyle();
            this.sytle_yyMMdd.setDataFormat(this.helper.createDataFormat().getFormat("yyyy-MM-dd"));
        }
    }

    public void setMergeCell(boolean isMergeCell) {
        this.isMergeCell = isMergeCell;
    }

    public void setSheetHead(Map<String, List<LinkedHashMap<String, String>>> sheetHead) {
        this.sheetHead = sheetHead;
    }

    public void addNotLockArea(String sheetName, List<String> lockArray) {
        ArrayList<Map<String, Integer>> list = new ArrayList<Map<String, Integer>>();
        for (String lockArea : lockArray) {
            list.add(this.initLockArea(lockArea));
        }
        this.lockArray.put(sheetName, list);
    }

    public void addNotLockArea(String sheetName, String lockArea) {
        ArrayList<Map<String, Integer>> list = new ArrayList<Map<String, Integer>>();
        list.add(this.initLockArea(lockArea));
        this.lockArray.put(sheetName, list);
    }

    private Map<String, Integer> initLockArea(String lockArea) {
        Integer[] area = this.str2Arr(lockArea).toArray(new Integer[0]);
        HashMap<String, Integer> areaMap = new HashMap<String, Integer>();
        areaMap.put("startClm", area[0]);
        areaMap.put("startRow", area[1] - 1);
        areaMap.put("endClm", area[2]);
        areaMap.put("endRow", area[3] - 1);
        return areaMap;
    }

    private void setCellLocked(String sheetName, Workbook wb) {
        Sheet sheet = wb.getSheet(sheetName);
        CellStyle lockStyle = wb.createCellStyle();
        lockStyle.setLocked(false);
        int lastRowNum = sheet.getLastRowNum();
        short lastCellNum = 0;
        for (Map<String, Integer> lockArea : this.lockArray.get(sheetName)) {
            for (int startRow = lockArea.get("startRow").intValue(); startRow <= lockArea.get("endRow"); ++startRow) {
                if (startRow > lastRowNum) continue;
                Row aRow = sheet.getRow(startRow);
                lastCellNum = aRow.getLastCellNum();
                for (int startClm = lockArea.get("startClm").intValue(); startClm <= lockArea.get("endClm"); ++startClm) {
                    if (startClm > lastCellNum) continue;
                    Cell cell = aRow.getCell(startClm);
                    cell.setCellStyle(lockStyle);
                    Ulog.debug((String)("\u53d6\u6d88\u9501\u5b9a[" + startRow + "]\u884c[" + startClm + "]\u5217"));
                }
            }
        }
    }

    private List<Integer> str2Arr(String s) {
        if (s.contains(":")) {
            String[] sArr = s.split(":");
            ArrayList<Integer> intList = new ArrayList<Integer>();
            intList.addAll(this.str2Arr(sArr[0]));
            intList.addAll(this.str2Arr(sArr[1]));
            return intList;
        }
        String array = s.toUpperCase();
        String lie = "";
        String hang = "";
        for (int i = 0; i < array.length(); ++i) {
            if (Character.isUpperCase(array.charAt(i))) {
                lie = lie + array.charAt(i);
                continue;
            }
            hang = hang + array.charAt(i);
        }
        ArrayList<Integer> intList = new ArrayList<Integer>();
        intList.add(this.str2Num(lie));
        if ("".equals(hang)) {
            intList.add(65535);
            return intList;
        }
        intList.add(Integer.parseInt(hang));
        return intList;
    }

    private int str2Num(String s) {
        int r = 0;
        for (int i = 0; i < s.length(); ++i) {
            r = r * 26 + s.charAt(i) - 65 + 1;
        }
        return r - 1;
    }

    public Map<String, List<Map<String, Object>>> getExcelData() {
        return this.excelData;
    }

    public void setExcelData(Map<String, List<Map<String, Object>>> excelData) {
        this.excelData = excelData;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public static void main(String[] args) throws IOException {
        HashMap<String, List<Map<String, Object>>> excelMap = new HashMap<String, List<Map<String, Object>>>();
        for (int i = 0; i < 2; ++i) {
            ArrayList sheetList = new ArrayList();
            for (int j = 0; j < 10; ++j) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int k = 0; k < 15; ++k) {
                    hashMap.put("\u5217" + k, "\u503c" + k);
                }
                sheetList.add(hashMap);
            }
            excelMap.put("\u6d4b\u8bd5" + i, sheetList);
        }
        LinkedHashMap<String, String> head = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> headrow = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> headcol = new LinkedHashMap<String, String>();
        head.put("\u52171", "\u5e8f\u53f7");
        head.put("\u52172", "\u540d\u79f0");
        head.put("\u52173", "\u5f53\u65e5\u53d7\u7406");
        head.put("\u52174", "");
        head.put("\u52175", "");
        head.put("\u52176", "\u4fdd\u9669\u4e1a\u7ee9");
        head.put("\u52177", "");
        head.put("\u52178", "");
        head.put("\u52179", "");
        head.put("\u521710", "");
        head.put("\u521711", "");
        head.put("\u521712", "2014\u5e74\u5168\u5e74\u7d2f\u8ba1\u6807\u4fdd");
        head.put("\u521713", "");
        head.put("\u521714", "");
        headrow.put("\u52171", "\u5e8f\u53f7");
        headrow.put("\u52172", "\u540d\u79f0");
        headrow.put("\u52173", "\u89c4\u6a21\u4fdd\u8d39");
        headrow.put("\u52174", "\u6807\u51c6\u4fdd\u8d39");
        headrow.put("\u52175", "\u4ef6\u6570");
        headrow.put("\u52176", "\u5f53\u6708\u53d7\u7406");
        headrow.put("\u52177", "");
        headrow.put("\u52178", "");
        headrow.put("\u52179", "\u5f53\u6708\u627f\u4fdd");
        headrow.put("\u521710", "");
        headrow.put("\u521711", "");
        headrow.put("\u521712", "\u89c4\u6a21\u4fdd\u8d39");
        headrow.put("\u521713", "\u6807\u51c6\u4fdd\u8d39");
        headrow.put("\u521714", "\u4ef6\u6570");
        headcol.put("\u52171", "\u5e8f\u53f7");
        headcol.put("\u52172", "\u540d\u79f0");
        headcol.put("\u52173", "\u89c4\u6a21\u4fdd\u8d39");
        headcol.put("\u52174", "\u6807\u51c6\u4fdd\u8d39");
        headcol.put("\u52175", "\u4ef6\u6570");
        headcol.put("\u52176", "\u89c4\u6a21\u4fdd\u8d39");
        headcol.put("\u52177", "\u6807\u51c6\u4fdd\u8d39");
        headcol.put("\u52178", "\u4ef6\u6570");
        headcol.put("\u52179", "\u89c4\u6a21\u4fdd\u8d39");
        headcol.put("\u521710", "\u6807\u51c6\u4fdd\u8d39");
        headcol.put("\u521711", "\u4ef6\u6570");
        headcol.put("\u521712", "\u89c4\u6a21\u4fdd\u8d39");
        headcol.put("\u521713", "\u6807\u51c6\u4fdd\u8d39");
        headcol.put("\u521714", "\u4ef6\u6570");
        ArrayList<LinkedHashMap<String, String>> sheetHead = new ArrayList<LinkedHashMap<String, String>>();
        sheetHead.add(head);
        sheetHead.add(headrow);
        sheetHead.add(headcol);
        HashMap<String, List<LinkedHashMap<String, String>>> map = new HashMap<String, List<LinkedHashMap<String, String>>>();
        map.put("\u6d4b\u8bd50", sheetHead);
        map.put("\u6d4b\u8bd51", sheetHead);
        ExcelWrite write = new ExcelWrite();
        write.setWorkbook((Workbook)new XSSFWorkbook());
        write.setSheetHead(map);
        write.setMergeCell(true);
        write.addNotLockArea("\u6d4b\u8bd51", "A3:F8");
        write.writeExcel(excelMap);
        File f = new File("/Users/Works/picclife/trace/test.xlsx");
        write.getWorkbook().write((OutputStream)new FileOutputStream(f));
    }
}

