/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.config.controller;

import com.newtouch.nms.sip.design.utils.RequestsUtil;
import com.newtouch.nms.sip.product.config.service.IProductConfigService;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProductConfigController {
    @Autowired
    private IProductConfigService productConfigService;
    @Value(value="${sqlPath:}")
    private String sqlPath;

    @RequestMapping(value={"/doMdfProductOpenState.do"})
    public String goProductOpenStateMdf(HttpServletRequest request, HttpServletResponse response) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.mdfOpenState(requestMap);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    private String handleChannelInfo(Map<String, Object> otherPropertyMap) {
        StringBuffer tmpStrBuffer = new StringBuffer();
        otherPropertyMap.remove("rqstType");
        for (Map.Entry<String, Object> entry : otherPropertyMap.entrySet()) {
            if (StrUtils.isNull((Object)entry.getValue())) continue;
            tmpStrBuffer.append(entry.getValue()).append(",");
        }
        String resultStr = tmpStrBuffer.toString();
        if (!StrUtils.isNull((Object)resultStr)) {
            resultStr = resultStr.substring(0, resultStr.length() - 1);
        }
        return resultStr;
    }

    @RequestMapping(value={"/goProductConfigAddition.do"})
    public String goProductConfigAddition(HttpServletRequest request, HttpServletResponse response) {
        return RequestUtils.return2Json(null);
    }

    @RequestMapping(value={"/goProductFrom3rd.do"})
    public String goProductFrom3rd(HttpServletRequest request, HttpServletResponse response) {
        return RequestUtils.return2Json(null);
    }

    @RequestMapping(value={"/doGetProductFromPiccLife.do"})
    public String dogetProductfrom3rd(HttpServletRequest request, HttpServletResponse response) {
        Return rn = new Return();
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        String prdCode = StrUtils.trimStr(param.get("prd_code"));
        if ("1".equals(CacheManager.get((String)prdCode))) {
            rn.setSuccessMsg(new Message("\u4ea7\u54c1" + prdCode + "\u540c\u6b65\u6267\u884c\u4e2d,\u8bf7\u7a0d\u540e\u518d\u8bd5"));
            return RequestUtils.return2Json((ReturnMsg)rn.msg());
        }
        CacheManager.put((String)prdCode, (Object)"1");
        CacheManager.expire((String)prdCode, (long)600L);
        try {
            this.productConfigService.getProductfrom3rdPiccLife(param);
        }
        catch (Exception e) {
            e.printStackTrace();
            rn.setFailMsg(new Message("\u4ea7\u54c1\u540c\u6b65\u5931\u8d25"));
            rn.setFailMsg(new Message("\u4ea7\u54c1\u540c\u6b65\u5931\u8d25" + e.getMessage()));
            CacheManager.remove((String)prdCode);
            return RequestUtils.return2Json((ReturnMsg)rn.msg());
        }
        rn.setSuccessMsg(new Message("\u4ea7\u54c1\u540c\u6b65\u6210\u529f"));
        CacheManager.remove((String)prdCode);
        return RequestUtils.return2Json((ReturnMsg)rn.msg());
    }

    @RequestMapping(value={"/goProductConfigParent.do"})
    public String goProductConfigParent(HttpServletRequest request, HttpServletResponse response) {
        return RequestUtils.return2Json(null);
    }

    @RequestMapping(value={"/goProductConfigEmailModel.do"})
    public String goProductConfigEmailModel(HttpServletRequest request, HttpServletResponse response) {
        return RequestUtils.return2Json(null);
    }

    @RequestMapping(value={"/goProductConfigPutaway.do"})
    public String goProductConfigPutaway(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.queryPutawayMessage(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goProductConfigUnderShelf.do"})
    public String goProductConfigUnderShelf(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.queryPutawayMessage(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doProductConfigDel.do"})
    public String doProductConfigDel(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.delProduct(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goProductConfigCopy.do"})
    public String goProductConfigCopy(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        Return r = new Return();
        r.setDataTable(param);
        return RequestUtils.return2Json(null);
    }

    @RequestMapping(value={"/doProductConfigCopy.do"})
    public String doProductConfigCopy(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String sourcePrdUuid = param.get("product_uuid");
        String targetPrdName = param.get("product_name");
        String isMaster = param.get("is_master");
        Map riskList = (Map)param.get("risk_list", Map.class);
        ReturnMsg msg = this.productConfigService.copyProduct(sourcePrdUuid, targetPrdName, isMaster, riskList);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doFindProductChannel.do"})
    public String doFindProductChannel(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.queryProductChannel(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goOrganTree.do"})
    public String goOrganTree(HttpServletRequest request, HttpServletResponse response) {
        ReturnMsg msg = null;
        return RequestUtils.return2Json(msg);
    }

    @RequestMapping(value={"/doOrganTree.do"})
    public String doOrganTree(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = null;
        return RequestUtils.return2Json(msg);
    }

    @RequestMapping(value={"/queryOrganDate.do"})
    public String queryOrganDate(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.queryAllOrgan(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doProductConfigPutaway.do"})
    public String doProductConfigPutaway(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.putawayProduct(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doSoldProduct.do"})
    public String doSoldProduct(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.soldProduct(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doQueryChannel.do"})
    public String doQueryChannel(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.queryChannel(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/goProductConfigModify.do"})
    public String goProductConfigModify(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        Return r = new Return();
        r.setDataTable(param);
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/prepareDoDownloadSql.do"})
    public String prepareDoDownloadSql(HttpServletRequest request, HttpServletResponse response) {
        Return msg = new Return();
        try {
            Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
            String product_uuid = StrUtils.trimStr(map.get("product_uuid"));
            String start_date = StrUtils.trimStr(map.get("start_date"));
            String filePath = "";
            filePath = filePath + this.sqlPath + File.separator;
            String date = start_date.substring(0, start_date.indexOf(" "));
            String[] d = date.split("-");
            for (int i = 0; i < d.length; ++i) {
                filePath = filePath + d[i] + File.separator;
            }
            String time = start_date.substring(start_date.indexOf(" ") + 1);
            time = time.replace(":", "-");
            File file = new File(filePath = filePath + product_uuid + "_" + time + ".zip");
            if (!file.exists()) {
                msg.setFailMsg(filePath + "\u672a\u627e\u5230\uff01");
                return RequestUtils.return2Json((ReturnMsg)msg.msg());
            }
        }
        catch (Exception e) {
            Ulog.info((String)e.getMessage());
        }
        return RequestUtils.return2Json((ReturnMsg)msg.msg());
    }

    @RequestMapping(value={"/doDownloadSql.do"})
    public void doDownloadSql(HttpServletRequest request, HttpServletResponse response) {
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        String product_uuid = StrUtils.trimStr(map.get("product_uuid"));
        String start_date = StrUtils.trimStr(map.get("start_date"));
        String filePath = "";
        try {
            int j;
            filePath = filePath + this.sqlPath + File.separator;
            String date = start_date.substring(0, start_date.indexOf(" "));
            String[] d = date.split("-");
            for (int i = 0; i < d.length; ++i) {
                filePath = filePath + d[i] + File.separator;
            }
            String time = start_date.substring(start_date.indexOf(" ") + 1);
            time = time.replace(":", "-");
            filePath = filePath + product_uuid + "_" + time + ".zip";
            File file = new File(filePath);
            FileInputStream in = new FileInputStream(file);
            BufferedInputStream buff = new BufferedInputStream(in);
            response.reset();
            response.setContentType("text/html;charset=ISO8859-1");
            response.setContentType("Application/x-msdownload");
            response.setHeader("Content-Disposition", "attachment;fileName=" + product_uuid + "_" + time + ".zip");
            ServletOutputStream os = response.getOutputStream();
            byte[] b = new byte[1024];
            for (long k = 0L; k < file.length(); k += (long)j) {
                j = buff.read(b, 0, 1024);
                os.write(b, 0, j);
            }
            os.flush();
            os.close();
            buff.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ResponseBody
    @RequestMapping(value={"/doExportConfigFile.do"})
    public String doExportConfigFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map maps = RequestUtils.getRequestMap((HttpServletRequest)request);
        String email_address = request.getParameter("email_address");
        ArrayList<Map> dataList = new ArrayList<Map>();
        dataList.add(maps);
        Return r = new Return();
        r.setSuccessMsg("\u5df2\u5f00\u59cb\u751f\u6210\u4ea7\u54c1\u914d\u7f6e\uff0c\u8bf7\u7a0d\u5019\u67e5\u6536\u90ae\u4ef6\u901a\u77e5");
        String requestUrl = request.getRequestURL().substring(0, request.getRequestURL().lastIndexOf("/"));
        if (requestUrl.contains("tree")) {
            requestUrl = requestUrl.replace("/tree", "");
        }
        String finalRequestUrl = requestUrl;
        new Thread(() -> this.startJob(dataList, email_address, finalRequestUrl)).start();
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    private void startJob(List<Map<String, Object>> dataList, String email_address, String requestUrl) {
        for (Map<String, Object> product : dataList) {
            Map productInfo = (Map)product.get("file_export_model");
            String product_uuid = (String)productInfo.get("product_uuid");
            Ulog.info((String)("\u5f00\u59cb\u5bfc\u51fa\u4ea7\u54c1\uff1a" + product_uuid + "\u5f00\u59cb\u6267\u884c\u7ed3\u675f\u3002"));
            Ulog.info((String)("\u5f00\u59cb\u5bfc\u51fa\u4ea7\u54c1\uff1a" + product_uuid + "\u7ed3\u675f\u3002"));
        }
    }

    @RequestMapping(value={"/doClient.do"})
    public String doClient(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.doClient(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doQueryRelation.do"})
    public String doQueryRelation(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.queryRelation(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/deleteRedis.do"})
    public String deleteRedis(HttpServletRequest request) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String deliveryPlatform = StrUtils.trimStr(requestMap.get("delivery_platform"));
        ReturnMsg msg = this.productConfigService.deleteReids(requestMap, deliveryPlatform);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/deleteMultiRedis.do"})
    public String deleteMultiRedis(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        List reqList = map.getList("reqList", Map.class);
        String deliveryPlatform = StrUtils.trimStr((Object)map.get("delivery_platform"));
        for (Map requestMap : reqList) {
            this.productConfigService.deleteReids(requestMap, deliveryPlatform);
        }
        Return r = new Return();
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    @RequestMapping(value={"/deleteAllRedis.do"})
    public String deleteAllRedis(HttpServletRequest request, HttpServletResponse response) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String delType = StrUtils.trimStr(requestMap.get("delType"));
        Return r = new Return();
        if (StrUtils.isNull((Object)delType)) {
            r.setFailMsg("\u53c2\u6570\u5f02\u5e38");
        }
        Map<Object, Object> result = new HashMap();
        if ("list".equals(delType)) {
            result = this.deleteRedisByType("prdList*");
        }
        if ("detail".equals(delType)) {
            result = this.deleteRedisByType("prdDetail*");
        }
        if ("all".equals(delType)) {
            result = this.deleteRedisByType("prdList*");
            result.putAll(this.deleteRedisByType("prdDetail*"));
        }
        r.setDataTable(result);
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }

    private Map<String, Object> deleteRedisByType(String keyReg) {
        Set keys = CacheManager.keys((String)keyReg);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("keys[" + keyReg + "]", keys);
        result.put("keysSize[" + keyReg + "]", keys.size());
        for (String key : keys) {
            CacheManager.remove((String)key);
        }
        Ulog.info((String)("\u6e05\u9664\u4ea7\u54c1\u7f13\u5b58:" + JsonUtils.toJson(result)));
        return result;
    }

    @RequestMapping(value={"/doProductOrganConfig.do"})
    public String doProductConfigOrgan(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.saveProductOrganConfig(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/delProductOrganConfig.do"})
    public String delProductConfigOrgan(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.delProductOrganConfig(param);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/queryProductOrganConfig.do"})
    public String queryProductConfigOrgan(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.queryProductOrganConfig(param, "1");
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/queryProductOrganConfigHistory.do"})
    public String queryProductConfigOrganHistory(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productConfigService.queryProductOrganConfig(param, "2");
        return RequestsUtil.return2Json(msg);
    }
}

