/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.cache.controller;

import com.newtouch.nms.sip.product.cache.service.IProductCacheService;
import com.newtouch.nms.sip.vo.QueryPdDetailVo;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProductCacheController {
    @Autowired
    private IProductCacheService productService;

    @PostMapping(value={"/queryProductListCache.do"})
    public String queryAppProductList(HttpServletRequest request) {
        RequestMap requestMap = RequestUtils.getRequest((HttpServletRequest)request);
        String organId = StrUtils.trimStr((Object)requestMap.get("organ_id"));
        String channelNo = StrUtils.trimStr((Object)requestMap.get("channel_no"));
        String deliveryPlatform = StrUtils.trimStr((Object)requestMap.get("delivery_platform"));
        ReturnMsg msg = this.productService.queryProductListCache(organId, channelNo, deliveryPlatform);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/saveProductListToRedis.do"})
    public String saveProductListToRedis(HttpServletRequest request) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productService.queryProductListToRedis(requestMap);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/queryProductDetailFromRedis2.do", "/queryProductDetailFromRedis2.serv"})
    public String queryProductDetailFromRedis2(HttpServletRequest request) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        QueryPdDetailVo queryPdDetailVo = (QueryPdDetailVo)RequestUtils.getRequestMap((Map)param.getParam(), QueryPdDetailVo.class);
        String addBatch = queryPdDetailVo.getAddBatch();
        if (StrUtils.isNull((Object)addBatch)) {
            throw new BusinessException("\u5165\u53c2\u6279\u6b21\u53f7\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        String deliveryPlatform = queryPdDetailVo.getDeliveryPlatform();
        String[] deliveryPlatformArr = deliveryPlatform.split(",");
        if (deliveryPlatformArr.length > 1) {
            throw new BusinessException("\u6295\u653e\u5e73\u53f0\u4f20\u53c2\u6709\u8bef\uff0c\u53ea\u652f\u6301\u4e00\u4e2a\u6295\u653e\u5e73\u53f0\u4f20\u5165");
        }
        String json = this.productService.queryPrdDetailFromRedis(queryPdDetailVo);
        Map map = JsonUtils.json2Map((String)json);
        return JsonUtils.toJson((Object)map, (String[])new String[]{"serno", "crt_user", "crt_date", "mdf_user", "mdf_date", "data_flag"});
    }

    @PostMapping(value={"/queryProductDetailFromRedis3.do", "/queryProductDetailFromRedis3.serv"})
    public String queryProductDetailFromRedis3(HttpServletRequest request) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        QueryPdDetailVo queryPdDetailVo = (QueryPdDetailVo)RequestUtils.getRequestMap((Map)param.getParam(), QueryPdDetailVo.class);
        String organId = queryPdDetailVo.getOrgan_id();
        if (StrUtils.isNull((Object)organId)) {
            throw new BusinessException("\u5165\u53c2\u673a\u6784\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        String channelNo = queryPdDetailVo.getChannel_no();
        if (StrUtils.isNull((Object)channelNo)) {
            throw new BusinessException("\u5165\u53c2\u6e20\u9053\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        String deliveryPlatform = queryPdDetailVo.getDeliveryPlatform();
        if (StrUtils.isNull((Object)deliveryPlatform)) {
            throw new BusinessException("\u5165\u53c2\u6295\u653e\u5e73\u53f0\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        String[] deliveryPlatformArr = deliveryPlatform.split(",");
        if (deliveryPlatformArr.length > 1) {
            throw new BusinessException("\u6295\u653e\u5e73\u53f0\u4f20\u53c2\u6709\u8bef\uff0c\u53ea\u652f\u6301\u4e00\u4e2a\u6295\u653e\u5e73\u53f0\u4f20\u5165");
        }
        String json = this.productService.queryPrdDetailFromRedis3(queryPdDetailVo);
        Map map = JsonUtils.json2Map((String)json);
        return JsonUtils.toJson((Object)map, (String[])new String[]{"serno", "crt_user", "crt_date", "mdf_user", "mdf_date", "data_flag"});
    }

    @PostMapping(value={"/saveProductDetailToRedis2.do"})
    public String saveProductDetailToRedis2(HttpServletRequest request) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String organPrdUuid = (String)requestMap.get("organ_prd_uuid");
        if (StrUtils.isNull((Object)organPrdUuid)) {
            throw new BusinessException("\u5165\u53c2\u4e0a\u67b6organ_prd_uuid\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        ReturnMsg msg = this.productService.saveProductDetailToRedis(organPrdUuid);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/saveRateDetailToRedis.do"})
    public String saveRateDetailToRedis(HttpServletRequest request) {
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg msg = this.productService.saveRateDetailToRedis(requestMap);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/queryRateFromRedis.do"})
    public String queryRateFromRedis(HttpServletRequest request) {
        Return r = new Return();
        Map requestMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        List<Map> mapList = this.productService.queryRateFromRedis(requestMap, StrUtils.trimStr(requestMap.get("rate_no")), StrUtils.trimStr(requestMap.get("risk_no")));
        r.setDataList(mapList, Map.class);
        return RequestUtils.return2Json((ReturnMsg)r.msg());
    }
}

