/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.product.utils;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.HashMap;
import java.util.Map;

public class NodeSeqUtils {
    private static Map<String, Map<String, String>> NODE_SEQ_MAP = new HashMap<String, Map<String, String>>();

    public static String getMainRiskUuid4DetailNode(String nodeSeq) {
        String mainRiskUuid = NodeSeqUtils.getRiskUuid(nodeSeq, NodeType.MAIN_RISKS.code());
        if (!StrUtils.isNull((Object)mainRiskUuid)) {
            return mainRiskUuid;
        }
        String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(nodeSeq);
        if (nodeSeqArray.length < 4) {
            throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u672a\u5305\u542b\u4e3b\u9669UUID");
        }
        if (nodeSeqArray.length > 5) {
            throw new BusinessException("\u975e\u4e3b\u9669\u7684\u9669\u79cd\u4fe1\u606f\u4e0b\u7684\u5c5e\u6027\u8282\u70b9\uff0c\u53d6\u4e0d\u5230\u4e3b\u9669\u7684risk_uuid");
        }
        NodeSeqUtils.putNodeSeqMap(nodeSeq, NodeType.MAIN_RISKS.code(), nodeSeqArray[3]);
        return nodeSeqArray[3];
    }

    public static String getAccyRiskUuid(String nodeSeq) {
        String accyRiskUuid = NodeSeqUtils.getRiskUuid(nodeSeq, NodeType.ACCY_RISKS.code());
        if (!StrUtils.isNull((Object)accyRiskUuid)) {
            return accyRiskUuid;
        }
        String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(nodeSeq);
        if (nodeSeqArray.length < 6) {
            throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u672a\u5305\u542b\u9644\u52a0\u9669UUID");
        }
        if (nodeSeqArray.length > 7) {
            throw new BusinessException("\u975e\u9644\u52a0\u9669\u7684\u9669\u79cd\u4fe1\u606f\u4e0b\u7684\u5c5e\u6027\u8282\u70b9\uff0c\u53d6\u4e0d\u5230\u9644\u52a0\u9669\u7684risk_uuid");
        }
        AbsModelRepository dao = (AbsModelRepository)SpringContext.getBean(AbsModelRepository.class);
        DsnStructure ds = (DsnStructure)dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeSeqArray[4]).model());
        if (!NodeType.ACCY_RISKS.code().equals(ds.getNodeType())) {
            throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u975e\u9644\u52a0\u9669\u5e8f\u5217");
        }
        NodeSeqUtils.putNodeSeqMap(nodeSeq, NodeType.ACCY_RISKS.code(), nodeSeqArray[5]);
        return nodeSeqArray[5];
    }

    public static String getExemptUuid4Accy(String nodeSeq) {
        String exemptRiskUuid = NodeSeqUtils.getRiskUuid(nodeSeq, NodeType.EXEMPT.code() + NodeType.ACCY_RISKS.code());
        if (!StrUtils.isNull((Object)exemptRiskUuid)) {
            return exemptRiskUuid;
        }
        String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(nodeSeq);
        if (nodeSeqArray.length < 8) {
            throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u672a\u5305\u542b\u9644\u52a0\u9669\u4e0b\u8c41\u514d\u9669\u7684UUID");
        }
        if (nodeSeqArray.length > 9) {
            throw new BusinessException("\u975e\u9644\u52a0\u9669\u4e0b\u7684\u8c41\u514d\u9669\u7684\u9669\u79cd\u4fe1\u606f\u4e0b\u7684\u5c5e\u6027\u8282\u70b9\uff0c\u53d6\u4e0d\u5230\u8c41\u514d\u9669\u7684risk_uuid");
        }
        AbsModelRepository dao = (AbsModelRepository)SpringContext.getBean(AbsModelRepository.class);
        DsnStructure ds = (DsnStructure)dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeSeqArray[6]).model());
        if (!NodeType.EXEMPT.code().equals(ds.getNodeType())) {
            throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u975e\u9644\u52a0\u9669\u4e0b\u8c41\u514d\u9669\u5e8f\u5217");
        }
        NodeSeqUtils.putNodeSeqMap(nodeSeq, NodeType.EXEMPT.code() + NodeType.ACCY_RISKS.code(), nodeSeqArray[7]);
        return nodeSeqArray[7];
    }

    public static String getExemptUuid4MainRisk(String nodeSeq) {
        String exemptRiskUuid = NodeSeqUtils.getRiskUuid(nodeSeq, NodeType.EXEMPT.code() + NodeType.MAIN_RISKS.code());
        if (!StrUtils.isNull((Object)exemptRiskUuid)) {
            return exemptRiskUuid;
        }
        String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(nodeSeq);
        if (nodeSeqArray.length < 6) {
            throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u672a\u5305\u542b\u4e3b\u9669\u4e0b\u8c41\u514d\u9669\u7684UUID");
        }
        if (nodeSeqArray.length > 7) {
            throw new BusinessException("\u975e\u4e3b\u9669\u4e0b\u8c41\u514d\u9669\u7684\u9669\u79cd\u4fe1\u606f\u4e0b\u7684\u5c5e\u6027\u8282\u70b9\uff0c\u53d6\u4e0d\u5230\u8c41\u514d\u9669\u7684risk_uuid");
        }
        AbsModelRepository dao = (AbsModelRepository)SpringContext.getBean(AbsModelRepository.class);
        DsnStructure ds = (DsnStructure)dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeSeqArray[4]).model());
        if (!NodeType.EXEMPT.code().equals(ds.getNodeType())) {
            throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u975e\u4e3b\u9669\u4e0b\u8c41\u514d\u9669\u5e8f\u5217");
        }
        NodeSeqUtils.putNodeSeqMap(nodeSeq, NodeType.EXEMPT.code() + NodeType.MAIN_RISKS.code(), nodeSeqArray[5]);
        return nodeSeqArray[7];
    }

    public static String getProductUuid(String nodeSeq) {
        Map<String, String> prdUuidMap = NODE_SEQ_MAP.get(nodeSeq);
        if (prdUuidMap == null || prdUuidMap.isEmpty()) {
            String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(nodeSeq);
            if (nodeSeqArray.length < 1) {
                throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u672a\u5305\u542b\u4ea7\u54c1UUID");
            }
            NodeSeqUtils.putNodeSeqMap(nodeSeq, NodeType.PRD_DETAIL.code(), nodeSeqArray[1]);
            return nodeSeqArray[1];
        }
        return prdUuidMap.get(NodeType.PRD_DETAIL.code());
    }

    public static String getPrdNodeNo(String nodeSeq) {
        Map<String, String> prdUuidMap = NODE_SEQ_MAP.get(nodeSeq);
        if (prdUuidMap == null || prdUuidMap.isEmpty()) {
            String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(nodeSeq);
            if (nodeSeqArray.length < 1) {
                throw new BusinessException("\u8282\u70b9\u5e8f\u5217\u672a\u5305\u542b\u4ea7\u54c1UUID");
            }
            NodeSeqUtils.putNodeSeqMap(nodeSeq, NodeType.PRD.code(), nodeSeqArray[0]);
            return nodeSeqArray[0];
        }
        return prdUuidMap.get(NodeType.PRD.code());
    }

    public static String getNearestRiskUuid(String nodeSeq) {
        AbsModelRepository dao;
        DsnStructure ds;
        String[] nodeSqlArr = NodeSeqUtils.splitNodeSeq(nodeSeq);
        int length = nodeSqlArr.length;
        String nodeNo = "";
        String nodeType = "";
        if (length > 3) {
            nodeNo = nodeSqlArr[2];
            nodeType = NodeType.MAIN_RISKS.code();
        }
        if (length > 5) {
            nodeNo = nodeSqlArr[4];
            nodeType = NodeType.ACCY_RISKS.code() + "|" + NodeType.EXEMPT.code() + "|" + NodeType.SUB_RISKS.code();
        }
        if (length > 7) {
            nodeNo = nodeSqlArr[6];
            nodeType = NodeType.EXEMPT.code() + "|" + NodeType.SUB_RISKS.code();
        }
        if (length > 9) {
            nodeNo = nodeSqlArr[8];
            nodeType = NodeType.SUB_RISKS.code();
        }
        if (!nodeType.contains((ds = (DsnStructure)(dao = (AbsModelRepository)SpringContext.getBean(AbsModelRepository.class)).findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeNo).model())).getNodeType())) {
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u7b26\u5408\u89c4\u5219\u7684\u9669\u79cd\u540d\u79f0\u8282\u70b9\uff0c\u65e0\u6cd5\u627e\u5230\u4e0b\u7ea7\u9669\u79cd\u8be6\u60c5\u8282\u70b9");
        }
        DsnStructure riskUuidNode = (DsnStructure)dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)ds.getNodeNo()).addIn(DsnStructure.NODE_TYPE, new String[]{NodeType.N_RISK_DETAIL.code()}).model());
        if (StrUtils.isNull((Object)riskUuidNode.getNodeNo())) {
            throw new BusinessException("\u672a\u67e5\u627e\u5230\u7b26\u5408\u89c4\u5219\u7684\u9669\u79cduuid");
        }
        return riskUuidNode.getNodeNo();
    }

    public static String getRelationType(String nodeSeq) {
        String relationTYpe = NodeSeqUtils.getRiskUuid(nodeSeq, "relation_type");
        if (!StrUtils.isNull((Object)relationTYpe)) {
            return relationTYpe;
        }
        String[] nodeSeqArray = NodeSeqUtils.splitNodeSeq(nodeSeq);
        String upNode = nodeSeqArray[nodeSeqArray.length - 2];
        AbsModelRepository dao = (AbsModelRepository)SpringContext.getBean(AbsModelRepository.class);
        DsnStructure ds = (DsnStructure)dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)upNode).model());
        switch (NodeType.valueOf((String)ds.getNodeType().toUpperCase())) {
            case ACCY_RISKS: {
                return "ADDED";
            }
            case EXEMPT: {
                if (nodeSeqArray.length <= 6) {
                    return "EXEMPT";
                }
                return "EXEMPT4ACC";
            }
        }
        return "error";
    }

    public static String[] splitNodeSeq(String nodeSeq) {
        if (StrUtils.isNull((Object)nodeSeq)) {
            return new String[0];
        }
        return nodeSeq.split("\\.");
    }

    private static void putNodeSeqMap(String nodeSeq, String nodeType, String nodeValue) {
        if (NODE_SEQ_MAP.get(nodeSeq) == null) {
            NODE_SEQ_MAP.put(nodeSeq, new HashMap());
        }
        NODE_SEQ_MAP.get(nodeSeq).put(nodeType, nodeValue);
    }

    private static String getRiskUuid(String nodeSeq, String nodeCode) {
        Map<String, String> seqMap = NODE_SEQ_MAP.get(nodeSeq);
        if (seqMap == null) {
            return null;
        }
        return seqMap.get(nodeCode);
    }
}

