/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.rule;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.DsnStructureRules;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.rule.StructureRule;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class Rule {
    private DsnStructure rule;
    private List<StructureRule> structureRuleList;

    public Rule load(String upNode, String nodeType) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.rule = utils.queryStructure(upNode, nodeType);
        if (this.rule == null) {
            return this;
        }
        List<DsnStructureRules> structureRulesList = utils.queryStructureRules(this.rule.getNodeNo());
        this.structureRuleList = new ArrayList<StructureRule>();
        for (DsnStructureRules dsnStructureRules : structureRulesList) {
            StructureRule structureRule = new StructureRule();
            structureRule.load(dsnStructureRules);
            this.structureRuleList.add(structureRule);
        }
        return this;
    }

    public void merge(Rule rule) {
        this.rule = ProductEqualsUtils.merge(this.rule, rule.getRule());
        this.structureRuleList = ProductEqualsUtils.merge(this.structureRuleList, rule.getStructureRuleList(), StructureRule.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.rule);
        }
        if (this.structureRuleList != null) {
            this.structureRuleList.forEach(structureRule -> structureRule.save());
        }
    }

    public TreeNode fetchTreeNode() {
        if (this.rule == null) {
            return null;
        }
        TreeNode node = new TreeNode(CompareEnum.NodeType.RULE.getTag() + this.rule.getSerno(), CompareEnum.NodeType.RULE.getLable());
        node.getChildren().add(new TreeNode(this.rule.getSerno(), this.rule, CompareEnum.NodeType.STRUCTURE));
        if (this.structureRuleList != null && this.structureRuleList.size() > 0) {
            TreeNode ruleArrayNode = new TreeNode(CompareEnum.NodeType.RULE_ARRAY.getTag() + this.rule.getSerno(), CompareEnum.NodeType.RULE_ARRAY.getLable());
            node.getChildren().add(ruleArrayNode);
            this.structureRuleList.forEach(structureRule -> ruleArrayNode.getChildren().add(structureRule.fetchTreeNode()));
        }
        return node;
    }

    public DsnStructure getRule() {
        return this.rule;
    }

    public void setRule(DsnStructure rule) {
        this.rule = rule;
    }

    public List<StructureRule> getStructureRuleList() {
        return this.structureRuleList;
    }

    public void setStructureRuleList(List<StructureRule> structureRuleList) {
        this.structureRuleList = structureRuleList;
    }
}

