/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.attribute.Attribute;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;

public class RiskAttribute {
    private DsnStructure riskAttr;
    private List<Attribute> attributeList = new ArrayList<Attribute>();

    public RiskAttribute load(String upNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.riskAttr = utils.queryStructure(upNode, NodeType.N_RISK_ATTR.code());
        if (!StrUtils.isNull((Object)this.riskAttr)) {
            utils.queryStructures(this.riskAttr.getNodeNo()).forEach(dsnAttr -> {
                Attribute attribute = new Attribute();
                attribute.load((DsnStructure)dsnAttr);
                this.attributeList.add(attribute);
            });
        }
        return this;
    }

    public void merge(RiskAttribute attribute) {
        this.riskAttr = ProductEqualsUtils.merge(this.riskAttr, attribute.getRiskAttr());
        this.attributeList = ProductEqualsUtils.merge(this.attributeList, attribute.getAttributeList(), Attribute.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        if (this.riskAttr != null) {
            update.update((AbsModel)this.riskAttr);
        }
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.attributeList != null) {
            this.attributeList.forEach(attr -> attr.save());
        }
    }

    public TreeNode fetchTreeNode() {
        if (this.riskAttr == null) {
            return null;
        }
        TreeNode node = new TreeNode(CompareEnum.NodeType.RISK_ATTRIBUTE.getTag() + this.riskAttr.getSerno(), CompareEnum.NodeType.RISK_ATTRIBUTE.getLable());
        node.getChildren().add(new TreeNode(this.riskAttr.getSerno(), this.riskAttr, CompareEnum.NodeType.STRUCTURE));
        if (this.attributeList != null && this.attributeList.size() > 0) {
            TreeNode riskAttr = new TreeNode(CompareEnum.NodeType.ATTRIBUTES.getTag() + this.riskAttr.getSerno(), CompareEnum.NodeType.ATTRIBUTES.getLable());
            node.getChildren().add(riskAttr);
            this.attributeList.forEach(attr -> riskAttr.getChildren().add(attr.fetchTreeNode()));
        }
        return node;
    }

    public DsnStructure getRiskAttr() {
        return this.riskAttr;
    }

    public void setRiskAttr(DsnStructure riskAttr) {
        this.riskAttr = riskAttr;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }
}

