/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.transfer.domain.propose.BenefitDemo;
import com.newtouch.nms.sip.product.transfer.domain.propose.RateGroup;
import com.newtouch.nms.sip.product.transfer.domain.risk.ExemptRisk;
import com.newtouch.nms.sip.product.transfer.domain.risk.ExemptRiskNode;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.uniapis.context.ThreadLocalContext;

public class AccyRisk
extends ExemptRisk {
    private ExemptRiskNode exemptRiskNode;
    private RateGroup rateGroup;
    private BenefitDemo benefitDemo;

    @Override
    public AccyRisk load(DsnStructure riskNode) {
        super.load(riskNode);
        this.exemptRiskNode = new ExemptRiskNode();
        this.exemptRiskNode.setRisk(this.getBaseRisk());
        this.exemptRiskNode.load(this.getRiskNode().getNodeNo());
        this.rateGroup = new RateGroup();
        this.rateGroup.load(this.getRiskNode().getNodeNo());
        this.benefitDemo = new BenefitDemo();
        this.benefitDemo.load(this.getRiskNode().getNodeNo());
        return this;
    }

    public void merge(AccyRisk accyRisk) {
        super.merge(accyRisk);
        this.exemptRiskNode = ProductEqualsUtils.merge(this.exemptRiskNode, accyRisk.getExemptRiskNode(), ExemptRiskNode.class);
        this.benefitDemo = ProductEqualsUtils.merge(this.benefitDemo, accyRisk.getBenefitDemo(), BenefitDemo.class);
        this.rateGroup = ProductEqualsUtils.merge(null, accyRisk.getRateGroup(), RateGroup.class);
    }

    @Override
    public void save() {
        String source = ThreadLocalContext.get().getRqstSource();
        super.save();
        if (this.exemptRiskNode != null && !this.isOnlyReslation()) {
            this.exemptRiskNode.save();
        }
        if (this.benefitDemo != null) {
            this.benefitDemo.save();
        }
        if (this.rateGroup != null) {
            this.rateGroup.save();
        }
    }

    @Override
    public TreeNode fetchTreeNode() {
        TreeNode treeNode = super.fetchTreeNode();
        if (this.exemptRiskNode != null) {
            treeNode.getChildren().add(this.exemptRiskNode.fetchTreeNode());
        }
        return treeNode;
    }

    @Override
    public String detailNodeType() {
        return NodeType.N_RISK_DETAIL.code();
    }

    public ExemptRiskNode getExemptRiskNode() {
        return this.exemptRiskNode;
    }

    public void setExemptRiskNode(ExemptRiskNode exemptRiskNode) {
        this.exemptRiskNode = exemptRiskNode;
    }

    @Override
    public RateGroup getRateGroup() {
        return this.rateGroup;
    }

    @Override
    public void setRateGroup(RateGroup rateGroup) {
        this.rateGroup = rateGroup;
    }

    @Override
    public BenefitDemo getBenefitDemo() {
        return this.benefitDemo;
    }

    @Override
    public void setBenefitDemo(BenefitDemo benefitDemo) {
        this.benefitDemo = benefitDemo;
    }
}

