/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.propose;

import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.propose.RateDetail;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;

public class RateInfo
implements Comparable {
    private DsnStructure rateInfoDsnStru;
    private DsnDynamicData rateDynamicData;
    private RateDetail inputRate;
    private RateDetail ouputRate;

    public RateInfo load(DsnStructure riskNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.rateInfoDsnStru = utils.queryStructure(riskNode.getNodeNo());
        this.inputRate = new RateDetail();
        this.inputRate.load(riskNode, NodeType.INPUT.code());
        this.ouputRate = new RateDetail();
        this.ouputRate.load(riskNode, NodeType.OUTPUT.code());
        this.rateDynamicData = utils.queryDynamic(riskNode.getNodeNo());
        return this;
    }

    public void merge(RateInfo rateInfo) {
        this.rateDynamicData = ProductEqualsUtils.merge(this.rateDynamicData, rateInfo.getRateDynamicData());
        this.ouputRate = ProductEqualsUtils.merge(this.ouputRate, rateInfo.getOuputRate(), RateDetail.class);
        this.inputRate = ProductEqualsUtils.merge(this.inputRate, rateInfo.getInputRate(), RateDetail.class);
        this.rateInfoDsnStru = ProductEqualsUtils.merge(this.rateInfoDsnStru, rateInfo.getRateInfoDsnStru());
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        if (this.ouputRate != null) {
            this.ouputRate.save();
        }
        if (this.inputRate != null) {
            this.inputRate.save();
        }
        if (this.rateDynamicData != null) {
            update.update((AbsModel)this.rateDynamicData);
        }
        if (this.rateInfoDsnStru != null) {
            update.update((AbsModel)this.rateInfoDsnStru);
        }
    }

    public TreeNode fetchTreeNode() {
        TreeNode node = new TreeNode(CompareEnum.NodeType.FEE_RATE_DETAIL.getLable(), CompareEnum.NodeType.FEE_RATE_DETAIL.getLable());
        if (this.rateInfoDsnStru != null) {
            node.getChildren().add(new TreeNode(this.rateInfoDsnStru.getSerno(), this.rateInfoDsnStru, CompareEnum.NodeType.STRUCTURE));
        }
        if (this.rateDynamicData != null) {
            node.getChildren().add(new TreeNode(this.rateDynamicData.getSerno(), this.rateDynamicData, CompareEnum.NodeType.DYNAMIC_TABLE));
        }
        if (this.inputRate != null) {
            node.getChildren().add(this.inputRate.fetchTreeNode(CompareEnum.NodeType.INPUT.getTag()));
        }
        if (this.ouputRate != null) {
            node.getChildren().add(this.ouputRate.fetchTreeNode(CompareEnum.NodeType.OUTPUT.getTag()));
        }
        return node;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public DsnStructure getRateInfoDsnStru() {
        return this.rateInfoDsnStru;
    }

    public void setRateInfoDsnStru(DsnStructure rateInfoDsnStru) {
        this.rateInfoDsnStru = rateInfoDsnStru;
    }

    public RateDetail getInputRate() {
        return this.inputRate;
    }

    public void setInputRate(RateDetail inputRate) {
        this.inputRate = inputRate;
    }

    public RateDetail getOuputRate() {
        return this.ouputRate;
    }

    public void setOuputRate(RateDetail ouputRate) {
        this.ouputRate = ouputRate;
    }

    public DsnDynamicData getRateDynamicData() {
        return this.rateDynamicData;
    }

    public void setRateDynamicData(DsnDynamicData rateDynamicData) {
        this.rateDynamicData = rateDynamicData;
    }
}

