/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.propose;

import com.newtouch.base.model.DsnRules;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class BenefitRules {
    private List<DsnStructure> benefitRuleNode;
    private List<DsnRules> benefitRules;

    public BenefitRules load(List<DsnStructure> dsnStructures) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.benefitRules = new ArrayList<DsnRules>();
        this.benefitRuleNode = new ArrayList<DsnStructure>();
        for (DsnStructure structure : dsnStructures) {
            DsnStructure dsnStructure = utils.queryStructure(structure.getNodeNo(), "rule");
            if (StrUtils.isNull((Object)dsnStructure)) continue;
            this.benefitRuleNode.add(dsnStructure);
        }
        for (DsnStructure rule : this.benefitRuleNode) {
            List<DsnRules> rules = utils.queryRules(rule.getNodeNo());
            if (CollectionUtils.isEmpty(rules)) continue;
            this.benefitRules.addAll(rules);
        }
        return this;
    }

    public void merge(BenefitRules benefitRules) {
        this.benefitRuleNode = ProductEqualsUtils.merge(this.benefitRuleNode, benefitRules.getBenefitRuleNode());
        this.benefitRules = ProductEqualsUtils.merge(this.benefitRules, benefitRules.getBenefitRules());
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        if (this.benefitRuleNode != null) {
            this.benefitRuleNode.forEach(n -> update.update((AbsModel)n));
        }
        if (this.benefitRules != null) {
            this.benefitRules.forEach(m -> update.update((AbsModel)m));
        }
    }

    public List<DsnStructure> getBenefitRuleNode() {
        return this.benefitRuleNode;
    }

    public void setBenefitRuleNode(List<DsnStructure> benefitRuleNode) {
        this.benefitRuleNode = benefitRuleNode;
    }

    public List<DsnRules> getBenefitRules() {
        return this.benefitRules;
    }

    public void setBenefitRules(List<DsnRules> benefitRules) {
        this.benefitRules = benefitRules;
    }
}

