/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.propose;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.transfer.domain.propose.BenefitTarget;
import com.newtouch.nms.sip.product.transfer.domain.propose.LiabilityTable;
import com.newtouch.nms.sip.product.transfer.domain.propose.SecurityTarget;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;

public class BenefitDemo {
    private DsnStructure benefitNode;
    private BenefitTarget benefitTarget;
    private LiabilityTable liabilityTable;
    private SecurityTarget securityTarget;

    public BenefitDemo load(String upNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.benefitNode = utils.queryStructure(upNode, NodeType.N_BENEFIT.code());
        if (this.benefitNode != null) {
            this.benefitTarget = new BenefitTarget();
            this.benefitTarget.load(this.benefitNode.getNodeNo());
            this.liabilityTable = new LiabilityTable();
            this.liabilityTable.load(this.benefitNode.getNodeNo());
            this.securityTarget = new SecurityTarget();
            this.securityTarget.load(this.benefitNode.getNodeNo());
        }
        return this;
    }

    public void merge(BenefitDemo benefitDemo) {
        this.benefitNode = ProductEqualsUtils.merge(this.benefitNode, benefitDemo.getBenefitNode());
        this.benefitTarget = ProductEqualsUtils.merge(this.benefitTarget, benefitDemo.getBenefitTarget(), BenefitTarget.class);
        this.liabilityTable = ProductEqualsUtils.merge(null, benefitDemo.getLiabilityTable(), LiabilityTable.class);
        this.securityTarget = ProductEqualsUtils.merge(this.securityTarget, benefitDemo.getSecurityTarget(), SecurityTarget.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        if (this.benefitTarget != null) {
            this.benefitTarget.save();
        }
        if (this.liabilityTable != null) {
            this.liabilityTable.save();
        }
        if (this.securityTarget != null) {
            this.securityTarget.save();
        }
        if (this.benefitNode != null) {
            update.update((AbsModel)this.benefitNode);
        }
    }

    public DsnStructure getBenefitNode() {
        return this.benefitNode;
    }

    public void setBenefitNode(DsnStructure benefitNode) {
        this.benefitNode = benefitNode;
    }

    public BenefitTarget getBenefitTarget() {
        return this.benefitTarget;
    }

    public void setBenefitTarget(BenefitTarget benefitTarget) {
        this.benefitTarget = benefitTarget;
    }

    public LiabilityTable getLiabilityTable() {
        return this.liabilityTable;
    }

    public void setLiabilityTable(LiabilityTable liabilityTable) {
        this.liabilityTable = liabilityTable;
    }

    public SecurityTarget getSecurityTarget() {
        return this.securityTarget;
    }

    public void setSecurityTarget(SecurityTarget securityTarget) {
        this.securityTarget = securityTarget;
    }
}

