/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.services.impl;

import com.newtouch.nms.sip.design.data.service.StructureService;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.product.main.services.impl.ProductCopyServiceImpl;
import com.newtouch.nms.sip.product.risk.services.IRiskAddService;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.callback.RowCallback;
import com.uniapis.util.date.DateUtil;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class RiskAddServiceImpl
implements IRiskAddService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private StructureService structureService;
    private final String allowSuffix = "png,gif,jpg,jpeg,bmp,tiff,txt,xml,pdf,zip,rar,doc,ppt,xls,docx,pptx,xlsx,html,htm,webp";
    private final long allowSize = 0x500000L;
    private final String FIELD_VALUE = "field_value";

    @Override
    public ReturnMsg queryMainRiskUnderProduct(String risk, String productUuid, String isMainRisk) {
        String sql = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid Not IN ( SELECT distinct sip_product_risks.risk_uuid FROM sip_product_risks WHERE sip_product_risks.product_uuid = ?) AND sip_risks.is_main_risk = ?  AND (  sip_risks.risk_no LIKE ? OR sip_risks.risk_name LIKE ?) AND sip_risks.data_flag = ?;";
        ArrayList<String> searchParam = new ArrayList<String>();
        searchParam.add(productUuid);
        searchParam.add(isMainRisk);
        searchParam.add("%" + risk + "%");
        searchParam.add("%" + risk + "%");
        searchParam.add("1");
        List riskList = this.dao.findAll(sql, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchParam)});
        Return msg = new Return();
        msg.setDataList4includes(riskList, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk", "risk_uuid"});
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRisk(String risk, String riskUuid, String isMainRisk) {
        String sql = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid Not IN ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ?AND ( sip_risks.risk_no LIKE ? OR sip_risks.risk_name LIKE ?)AND sip_risks.data_flag = ? ;";
        ArrayList<String> searchParam = new ArrayList<String>();
        searchParam.add(riskUuid);
        searchParam.add(isMainRisk);
        searchParam.add("%" + risk + "%");
        searchParam.add("%" + risk + "%");
        searchParam.add("1");
        List riskList = this.dao.findAll(sql, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchParam)});
        Return msg = new Return();
        msg.setDataList4includes(riskList, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk"});
        return msg.msg();
    }

    @Override
    public ReturnMsg queryMainRiskPage(String riskName, String riskNo, String isMainRisk, String row4Page, String nowPage) {
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)riskName)) {
            risk.where().addLike(SipRisks.RISK_NAME, (Object)riskName);
        }
        if (!StrUtils.isNull((Object)riskNo)) {
            risk.where().addLike(SipRisks.RISK_NO, (Object)riskNo);
        }
        if (!StrUtils.isNull((Object)isMainRisk)) {
            risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk);
        }
        risk.setOrderBy(new Sort.Order[]{SipRisks.MDF_DATE.desc()});
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        ThreadLocalContext.get().getPageCount().setNowPage(Integer.valueOf(nowPage));
        ThreadLocalContext.get().getPageCount().setRows4Page(Integer.valueOf(row4Page));
        ArrayList mainRiskList = new ArrayList();
        List riskMainList = this.dao.findAll((AbsModel)risk, Boolean.valueOf(true));
        riskMainList.stream().forEach(mainRisk -> {
            HashMap<String, Object> mapMain = new HashMap<String, Object>();
            mapMain.put("risk_no", mainRisk.getRiskNo());
            mapMain.put("risk_name", mainRisk.getRiskName());
            mapMain.put("is_main_risk", mainRisk.getIsMainRisk());
            mapMain.put("risk_uuid", mainRisk.getRiskUuid());
            String sqlSubRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchAddParam = new ArrayList<String>();
            searchAddParam.add(mainRisk.getRiskUuid());
            searchAddParam.add("A");
            searchAddParam.add("1");
            List riskSubList = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchAddParam)});
            ArrayList aRiskList = new ArrayList();
            riskSubList.stream().forEach(aRisk -> {
                HashMap<String, Object> mapAdd = new HashMap<String, Object>();
                mapAdd.put("risk_no", aRisk.getRiskNo());
                mapAdd.put("risk_name", aRisk.getRiskName());
                mapAdd.put("is_main_risk", aRisk.getIsMainRisk());
                mapAdd.put("risk_uuid", aRisk.getRiskUuid());
                String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
                ArrayList<String> searchExeParam = new ArrayList<String>();
                searchExeParam.add(mainRisk.getRiskUuid());
                searchExeParam.add("W");
                searchExeParam.add("1");
                List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExeParam)});
                ArrayList exemptsRiskList = new ArrayList();
                riskExemptsList.stream().forEach(exemptsRisk -> {
                    HashMap<String, String> mapExe = new HashMap<String, String>();
                    mapExe.put("risk_no", exemptsRisk.getRiskNo());
                    mapExe.put("risk_name", exemptsRisk.getRiskName());
                    mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                    mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                    exemptsRiskList.add(mapExe);
                });
                mapAdd.put("exempt_risk", exemptsRiskList);
                aRiskList.add(mapAdd);
            });
            mapMain.put("accy_risk", aRiskList);
            String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchExemptsParam = new ArrayList<String>();
            searchExemptsParam.add(mainRisk.getRiskUuid());
            searchExemptsParam.add("W");
            searchExemptsParam.add("1");
            List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExemptsParam)});
            ArrayList exemptsRiskList = new ArrayList();
            riskExemptsList.stream().forEach(exemptsRisk -> {
                HashMap<String, String> mapExe = new HashMap<String, String>();
                mapExe.put("risk_no", exemptsRisk.getRiskNo());
                mapExe.put("risk_name", exemptsRisk.getRiskName());
                mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                exemptsRiskList.add(mapExe);
            });
            mapMain.put("exempt_risk", exemptsRiskList);
            mainRiskList.add(mapMain);
        });
        Return msg = new Return();
        msg.setDataList(mainRiskList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryMainRiskUnPage(String riskName, String riskNo, String isMainRisk) {
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)riskName)) {
            risk.where().addLike(SipRisks.RISK_NAME, (Object)riskName);
        }
        if (!StrUtils.isNull((Object)riskNo)) {
            risk.where().addLike(SipRisks.RISK_NO, (Object)riskNo);
        }
        if (!StrUtils.isNull((Object)isMainRisk)) {
            risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk);
        }
        risk.setOrderBy(new Sort.Order[]{SipRisks.MDF_DATE.desc()});
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        ArrayList mainRiskList = new ArrayList();
        List riskMainList = this.dao.findAll((AbsModel)risk);
        riskMainList.stream().forEach(mainRisk -> {
            HashMap<String, Object> mapMain = new HashMap<String, Object>();
            mapMain.put("risk_no", mainRisk.getRiskNo());
            mapMain.put("risk_name", mainRisk.getRiskName());
            mapMain.put("is_main_risk", mainRisk.getIsMainRisk());
            mapMain.put("risk_uuid", mainRisk.getRiskUuid());
            String sqlSubRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchAddParam = new ArrayList<String>();
            searchAddParam.add(mainRisk.getRiskUuid());
            searchAddParam.add("A");
            searchAddParam.add("1");
            List riskSubList = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchAddParam)});
            ArrayList aRiskList = new ArrayList();
            riskSubList.stream().forEach(aRisk -> {
                HashMap<String, Object> mapAdd = new HashMap<String, Object>();
                mapAdd.put("risk_no", aRisk.getRiskNo());
                mapAdd.put("risk_name", aRisk.getRiskName());
                mapAdd.put("is_main_risk", aRisk.getIsMainRisk());
                mapAdd.put("risk_uuid", aRisk.getRiskUuid());
                String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
                ArrayList<String> searchExeParam = new ArrayList<String>();
                searchExeParam.add(mainRisk.getRiskUuid());
                searchExeParam.add("W");
                searchExeParam.add("1");
                List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExeParam)});
                ArrayList exemptsRiskList = new ArrayList();
                riskExemptsList.stream().forEach(exemptsRisk -> {
                    HashMap<String, String> mapExe = new HashMap<String, String>();
                    mapExe.put("risk_no", exemptsRisk.getRiskNo());
                    mapExe.put("risk_name", exemptsRisk.getRiskName());
                    mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                    mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                    exemptsRiskList.add(mapExe);
                });
                mapAdd.put("exempt_risk", exemptsRiskList);
                aRiskList.add(mapAdd);
            });
            mapMain.put("accy_risk", aRiskList);
            String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
            ArrayList<String> searchExemptsParam = new ArrayList<String>();
            searchExemptsParam.add(mainRisk.getRiskUuid());
            searchExemptsParam.add("W");
            searchExemptsParam.add("1");
            List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExemptsParam)});
            ArrayList exemptsRiskList = new ArrayList();
            riskExemptsList.stream().forEach(exemptsRisk -> {
                HashMap<String, String> mapExe = new HashMap<String, String>();
                mapExe.put("risk_no", exemptsRisk.getRiskNo());
                mapExe.put("risk_name", exemptsRisk.getRiskName());
                mapExe.put("is_main_risk", exemptsRisk.getIsMainRisk());
                mapExe.put("risk_uuid", exemptsRisk.getRiskUuid());
                exemptsRiskList.add(mapExe);
            });
            mapMain.put("exempt_risk", exemptsRiskList);
            mainRiskList.add(mapMain);
        });
        Return msg = new Return();
        msg.setDataList(mainRiskList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskPage(String riskName, String riskNo, String isMainRisk, String row4Page, String nowPage) {
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)riskName)) {
            risk.where().addLike(SipRisks.RISK_NAME, (Object)riskName);
        }
        if (!StrUtils.isNull((Object)riskNo)) {
            risk.where().addLike(SipRisks.RISK_NO, (Object)riskNo);
        }
        if (!StrUtils.isNull((Object)isMainRisk)) {
            risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk);
        }
        risk.setOrderBy(new Sort.Order[]{SipRisks.MDF_DATE.desc()});
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        ThreadLocalContext.get().getPageCount().setNowPage(Integer.valueOf(nowPage));
        ThreadLocalContext.get().getPageCount().setRows4Page(Integer.valueOf(row4Page));
        List riskList2 = this.dao.findAll((AbsModel)risk, Boolean.valueOf(true));
        Return msg = new Return();
        msg.setDataList4includes(riskList2, SipRisks.class, new String[]{"risk_name", "risk_no", "is_main_risk"});
        return msg.msg();
    }

    @Override
    public ReturnMsg addRisk(DsnStructure node, Map<String, Object> paramMap) {
        Return msg = new Return();
        List rightSelectList = (List)paramMap.get("rigthSelect");
        if (null == rightSelectList || rightSelectList.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u9669\u79cd\uff01");
            return msg.msg();
        }
        int countNum = Integer.parseInt(((DsnStructure)this.dao.findOne(((DsnStructure)DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model()).groupBy().count(DsnStructure.NODE_NO))).getOtherProperty("count_node_num").toString());
        for (Map tmpMap : rightSelectList) {
            String riskNodeNo = StrUtils.trimStr(tmpMap.get("rigthSelect"));
            DsnStructure riskDetailsNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskNodeNo).model());
            DsnStructure riskNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskDetailsNode.getUpNode()).model());
            riskNode.setSerno(UUID.shortUUID());
            riskNode.setNodeSeq(node.getNodeSeq() + riskNode.getNodeNo() + ".");
            riskNode.setUpNode(node.getNodeNo());
            riskNode.setDisplayOrder(Integer.valueOf(countNum++));
            this.dao.save((AbsModel)riskNode);
            ProductCopyServiceImpl.saveRiskRelation(riskDetailsNode, this.dao);
        }
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg.msg();
    }

    private void renameRiskNode(String riskName, String riskDetailNodeno) {
        if (!StrUtils.isNull((Object)riskName)) {
            DsnStructure dsn = new DsnStructure();
            dsn.where().addEq(DsnStructure.NODE_NO, (Object)riskDetailNodeno);
            dsn = (DsnStructure)this.dao.findOne((AbsModel)dsn);
            dsn.where().addEq(DsnStructure.NODE_NO, (Object)dsn.getUpNode());
            List dsnList = this.dao.findAll((AbsModel)dsn);
            for (DsnStructure dsn1 : dsnList) {
                DsnStructure mdfDsn = new DsnStructure();
                mdfDsn.where().addEq(DsnStructure.NODE_NO, (Object)dsn1.getNodeNo());
                mdfDsn.where().addEq(DsnStructure.UP_NODE, (Object)dsn1.getUpNode());
                mdfDsn.where().addEq(DsnStructure.SERNO, (Object)dsn1.getSerno());
                mdfDsn.setNodeName(riskName);
                this.dao.update((AbsModel)mdfDsn);
            }
        }
    }

    private void maintainProductAndRiskRelation(String productNodeNo, String currentNodeNo) {
        SipProductRisks sip_product_risks4Query = new SipProductRisks();
        sip_product_risks4Query.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productNodeNo);
        sip_product_risks4Query.where().addEq(SipProductRisks.RISK_UUID, (Object)currentNodeNo);
        List sip_product_riskses = this.dao.findAll((AbsModel)sip_product_risks4Query);
        if (null == sip_product_riskses || sip_product_riskses.isEmpty()) {
            SipProductRisks sip_product_risks4Insert = new SipProductRisks();
            sip_product_risks4Insert.setProductUuid(productNodeNo);
            sip_product_risks4Insert.setRiskUuid(currentNodeNo);
            this.dao.save((AbsModel)sip_product_risks4Insert);
        } else {
            SipProductRisks sip_product_risks4Update = new SipProductRisks();
            sip_product_risks4Update.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productNodeNo);
            sip_product_risks4Update.where().addEq(SipProductRisks.RISK_UUID, (Object)currentNodeNo);
            this.dao.update((AbsModel)sip_product_risks4Update);
        }
    }

    public boolean checkMainRisk(String isMainRisk, String bizUUUD4RiskType) {
        boolean mainRiskFlag = false;
        List<DsnBizAttributeOption> dsnBizAttributeOptionList = this.queryDic4RiskType(bizUUUD4RiskType);
        if (null != dsnBizAttributeOptionList && !dsnBizAttributeOptionList.isEmpty()) {
            for (DsnBizAttributeOption dsnBizAttributeOption : dsnBizAttributeOptionList) {
                String optionValue = dsnBizAttributeOption.getOptionValue();
                String optionName = dsnBizAttributeOption.getOptionName();
                if (!isMainRisk.equals(optionValue) || !"\u4e3b\u9669".equals(optionName)) continue;
                mainRiskFlag = true;
            }
        } else if ("M".equals(StrUtils.trimStr((Object)isMainRisk)) || "1".equals(StrUtils.trimStr((Object)isMainRisk)) || "\u662f".equals(StrUtils.trimStr((Object)isMainRisk))) {
            mainRiskFlag = true;
        }
        return mainRiskFlag;
    }

    private List<DsnBizAttributeOption> queryDic4RiskType(String bizUUID) {
        DsnBizAttributeOption dsnBizAttributeOption4Query = new DsnBizAttributeOption();
        dsnBizAttributeOption4Query.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizUUID);
        List dsnBizAttributeOptionList = this.dao.findAll((AbsModel)dsnBizAttributeOption4Query);
        if (null != dsnBizAttributeOptionList && !dsnBizAttributeOptionList.isEmpty()) {
            return dsnBizAttributeOptionList;
        }
        return null;
    }

    private void maintainSipRiskRelation(Map<String, Object> paramMap) {
        String mainRisk = StrUtils.trimStr((Object)paramMap.get("parent_risk_uuid"));
        String riskUUID = StrUtils.trimStr((Object)paramMap.get("current_node_no"));
        String riskOrderRelation = StrUtils.trimStr((Object)paramMap.get("risk_order_relation"));
        String isMainRisk = StrUtils.trimStr((Object)paramMap.get("is_main_risk"));
        String bizUUUD4RiskType = StrUtils.trimStr((Object)paramMap.get("bizUUUD4RiskType"));
        String relationType = this.getRelationType(StrUtils.trimStr((Object)paramMap.get("bizUUUD4RiskType")), isMainRisk);
        String isRequired = StrUtils.trimStr((Object)paramMap.get("is_required"));
        String isRecommend = StrUtils.trimStr((Object)paramMap.get("is_recommend"));
        if ("S".equals(isRequired)) {
            isRequired = "N";
        } else if ("M".equals(isRequired)) {
            isRequired = "Y";
        }
        Date startDate = StrUtils.isNull((Object)paramMap.get("start_date")) ? DateUtil.sysDate() : DateUtil.object2Date((Object)paramMap.get("start_date"));
        Date endDate = StrUtils.isNull((Object)paramMap.get("end_date")) ? DateUtil.sysDate() : DateUtil.object2Date((Object)paramMap.get("end_date"));
        this.dealRiskRelation(mainRisk, riskUUID, riskOrderRelation, relationType, isRequired, isRecommend, startDate, endDate);
    }

    private String getRelationType(String bizUUUD4RiskType, String isMainRisk) {
        List<DsnBizAttributeOption> dsnBizAttributeOptionList = this.queryDic4RiskType(bizUUUD4RiskType);
        String relationType = "";
        if (null == dsnBizAttributeOptionList || dsnBizAttributeOptionList.isEmpty()) {
            relationType = "2".equals(isMainRisk) || "A".equals(isMainRisk) ? "ADDED" : ("3".equals(isMainRisk) || "W".equals(isMainRisk) ? "EXEMPT" : "");
        } else {
            for (DsnBizAttributeOption dsnBizAttributeOption : dsnBizAttributeOptionList) {
                String optionName = dsnBizAttributeOption.getOptionName();
                String optionValue = dsnBizAttributeOption.getOptionValue();
                if (optionName.equals("\u9644\u52a0\u9669") && isMainRisk.equals(optionValue)) {
                    relationType = "ADDED";
                    break;
                }
                if (optionName.equals("\u8c41\u514d\u9669") && isMainRisk.equals(optionValue)) {
                    relationType = "EXEMPT";
                    break;
                }
                if (!optionName.equals("\u5b50\u9669") || !isMainRisk.equals(optionValue)) continue;
                relationType = "SUB";
                break;
            }
        }
        return relationType;
    }

    private void dealdsn_dynamic_data(Map<String, Object> paramMap, String currentNodeNo) {
        StringBuilder str = new StringBuilder();
        str.append("select * from dsn_biz_attribute where biz_uuid in ( SELECT node_no from dsn_structure where up_node = ? )  and stored_tab = ?  order by display_order ");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(currentNodeNo);
        list.args().add("dsn_dynamic_data");
        List attrList = this.dao.findAll(String.valueOf(str), new AbsModelRepository.Args[]{list});
        if (attrList == null || attrList.isEmpty()) {
            return;
        }
        String biz_uuid = "";
        String storedField = "";
        for (Map dsn_biz_attribute : attrList) {
            if (StrUtils.isNull(dsn_biz_attribute.get("biz_uuid"))) continue;
            biz_uuid = StrUtils.trimStr(dsn_biz_attribute.get("biz_uuid"));
            DsnDynamicData dynamicData = new DsnDynamicData();
            dynamicData.where().addEq(DsnDynamicData.RELATE_TAB, (Object)"dsn_biz_attribute");
            dynamicData.where().addEq(DsnDynamicData.RELATE_FIELD, (Object)"biz_uuid");
            dynamicData.where().addEq(DsnDynamicData.RELATE_FK, (Object)biz_uuid);
            dynamicData = (DsnDynamicData)this.dao.findOne((AbsModel)dynamicData);
            if (!StrUtils.isNull((Object)dynamicData.getSerno())) {
                DsnDynamicData dsn_Dynamic4Delete = new DsnDynamicData();
                dsn_Dynamic4Delete.where().addEq(DsnDynamicData.SERNO, (Object)dynamicData.getSerno());
                this.dao.delete((AbsModel)dsn_Dynamic4Delete);
            }
            DsnDynamicData dynamicDataSave = new DsnDynamicData();
            dynamicDataSave.setRelateTab("dsn_biz_attribute");
            dynamicDataSave.setRelateField("biz_uuid");
            dynamicDataSave.setRelateFk(biz_uuid);
            storedField = StrUtils.trimStr(dsn_biz_attribute.get("stored_field"));
            try {
                BeanUtils.setProperty((Object)dynamicDataSave, (String)storedField.replace("_", ""), (Object)StrUtils.trimStr((Object)paramMap.get(storedField)));
            }
            catch (Exception e) {
                Ulog.error((String)("\u52a8\u6001\u8868\u5b58\u50a8\u9669\u79cd\u4fe1\u606f\u5f02\u5e38\uff1a\uff1a\u52a8\u6001\u8868\u5b57\u6bb5[" + storedField + "]\u5185\u5bb9\u3010" + StrUtils.trimStr((Object)paramMap.get("attr_no")) + "\u3011"));
                e.printStackTrace();
            }
            this.dao.save((AbsModel)dynamicDataSave);
        }
    }

    private void dealRiskRelation(String mainRiskUUid, String subRiskUUID, String riskOrderRelation, String relationType, String isRequired, String isRecommend, java.util.Date startDate, java.util.Date endDate) {
        SipRiskRelation sipRiskRelation4Query = new SipRiskRelation();
        sipRiskRelation4Query.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRiskUUid);
        sipRiskRelation4Query.where().addEq(SipRiskRelation.RISK_UUID, (Object)subRiskUUID);
        SipRiskRelation sipRiskRelation4Result = (SipRiskRelation)this.dao.findOne((AbsModel)sipRiskRelation4Query);
        if (!StrUtils.isNull((Object)isRequired)) {
            SipRiskRelation sipRiskRelation4Delete = new SipRiskRelation();
            sipRiskRelation4Delete.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRiskUUid);
            sipRiskRelation4Delete.where().addEq(SipRiskRelation.RISK_UUID, (Object)subRiskUUID);
            this.dao.delete((AbsModel)sipRiskRelation4Delete);
        }
        if (StrUtils.isNull((Object)sipRiskRelation4Result.getSerno()) || !StrUtils.isNull((Object)isRequired)) {
            SipRiskRelation sipRiskRelation4Insert = new SipRiskRelation();
            sipRiskRelation4Insert.setMainRisk(mainRiskUUid);
            sipRiskRelation4Insert.setRiskUuid(subRiskUUID);
            sipRiskRelation4Insert.setRelationType(relationType.equals("") ? "null" : relationType);
            sipRiskRelation4Insert.setIsRequired(isRequired);
            sipRiskRelation4Insert.setIsRecommend(isRecommend);
            this.dao.save((AbsModel)sipRiskRelation4Insert);
        }
    }
}

