/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.main.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.newtouch.nms.sip.design.data.service.StructureService;
import com.newtouch.nms.sip.design.product.utils.NodeSeqUtils;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipOrganProducts;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipProductsChannel;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.config.service.IProductConfigService;
import com.newtouch.nms.sip.product.main.services.IProductListQueryService;
import com.newtouch.nms.sip.product.risk.services.IRiskListQueryService;
import com.newtouch.nms.sip.product.structure.service.IStructureSearchService;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.callback.RowCallback;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProductListQueryServiceImpl
implements IProductListQueryService {
    @Autowired(required=false)
    private AbsModelRepository dao;
    @Autowired
    private IStructureSearchService structureSearchService;
    @Autowired
    private StructureService structureService;
    @Autowired
    private IProductConfigService productConfigService;
    @Autowired
    private IRiskListQueryService iRiskListQueryService;

    @Override
    public ReturnMsg queryProductList(String prd_name, String prd_no) {
        SipProducts prd = (SipProducts)SipProducts.n().where().addEq(SipProducts.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)prd_name)) {
            prd.where().addLike(SipProducts.PRODUCT_NAME, (Object)prd_name);
        }
        if (!StrUtils.isNull((Object)prd_no)) {
            prd.where().addLike(SipProducts.PRODUCT_NO, (Object)prd_no);
        }
        prd.setOrderBy(new Sort.Order[]{SipProducts.MDF_DATE.desc()});
        prd.where().addCallback((RowCallback)new RowCallback<SipProducts>(){

            public void callback(SipProducts sipProducts, List<? extends SipProducts> list, int i) {
                sipProducts.putOtherProperty("true_product_uuid", (Object)sipProducts.getProductUuid());
                sipProducts.putOtherProperty("node_no", (Object)sipProducts.getProductUuid());
            }
        });
        List proList = this.dao.findAll((AbsModel)prd, Boolean.valueOf(true));
        ArrayList mainRiskList = new ArrayList();
        proList.stream().forEach(queryProduct -> {
            HashMap<String, Object> mapMainQuery = new HashMap<String, Object>();
            mapMainQuery.put("product_name", queryProduct.getProductName());
            mapMainQuery.put("product_no", queryProduct.getProductNo());
            mapMainQuery.put("product_uuid", queryProduct.getProductUuid());
            DsnStructure products = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)queryProduct.getProductUuid()).model());
            mapMainQuery.put("prd_node_no", products == null ? "" : products.getUpNode());
            mapMainQuery.put("node_seq", products == null ? "" : products.getNodeSeq());
            String sql2 = "SELECT sip_risks.risk_name,sip_product_risks.risk_uuid,sip_product_risks.product_uuid,sip_risks.risk_no FROM sip_product_risks INNER JOIN sip_products on sip_products.product_uuid = sip_product_risks.product_uuid INNER JOIN sip_risks on sip_risks.risk_uuid = sip_product_risks.risk_uuid AND sip_products.product_no = ? AND sip_risks.is_main_risk = ? ";
            ArrayList<String> searchParam2 = new ArrayList<String>();
            searchParam2.add(queryProduct.getProductNo());
            searchParam2.add("M");
            List proList2 = this.dao.findAll(sql2, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchParam2)});
            ArrayList aMainRiskList = new ArrayList();
            proList2.stream().forEach(aMain -> {
                HashMap<String, String> mapMainRiskQuery = new HashMap<String, String>();
                mapMainRiskQuery.put("risk_no", aMain.getRiskNo());
                mapMainRiskQuery.put("risk_name", aMain.getRiskName());
                mapMainRiskQuery.put("risk_uuid", aMain.getRiskUuid());
                aMainRiskList.add(mapMainRiskQuery);
            });
            mapMainQuery.put("main_risk", aMainRiskList);
            if (this.getProductConfigStatus(queryProduct.getProductUuid())) {
                mapMainQuery.put("product_state", "\u5df2\u53d1\u5e03");
                List sipOrganProductsList = this.dao.findAll(SipOrganProducts.n().where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)queryProduct.getProductUuid()).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").addEq(SipOrganProducts.IS_ENABLE, (Object)"ON").model());
                if (!CollectionUtils.isEmpty((Collection)sipOrganProductsList)) {
                    mapMainQuery.put("product_state", "\u5df2\u4e0a\u67b6");
                }
            } else {
                mapMainQuery.put("product_state", "\u5f85\u53d1\u5e03");
            }
            mainRiskList.add(mapMainQuery);
        });
        Return msg = new Return();
        msg.setDataList(mainRiskList);
        return msg.msg();
    }

    @Override
    public ReturnMsg doCancelProductRiskRelation(String product_uuid, String risk_uuid) {
        Return msg = new Return();
        if (!this.getProductConfigStatus(product_uuid)) {
            DsnStructure dsn = new DsnStructure();
            SipProductRisks sip = new SipProductRisks();
            sip.where().addEq(SipProductRisks.RISK_UUID, (Object)risk_uuid);
            sip.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid);
            SipProductRisks proRiskList = (SipProductRisks)this.dao.findOne((AbsModel)sip);
            DsnStructure existProRisk = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.SERNO, (Object)proRiskList.getSerno()).model());
            dsn.where().addEq(DsnStructure.SERNO, (Object)existProRisk.getSerno());
            DsnStructure n_risk = this.getNRiskbyUUID(product_uuid);
            dsn.where().addEq(DsnStructure.UP_NODE, (Object)n_risk.getNodeNo());
            DsnStructure dsnList = (DsnStructure)this.dao.findOne((AbsModel)dsn);
            if (dsnList.getNodeType().equals(NodeType.MAIN_RISKS.code())) {
                this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.SERNO, (Object)existProRisk.getSerno()).addEq(DsnStructure.UP_NODE, (Object)n_risk.getNodeNo()).model());
                this.maintainProductAndMainRisks(product_uuid, risk_uuid);
                msg.setSuccessMsg("\u53d6\u6d88\u5173\u8054\u6210\u529f");
            } else {
                msg.setFailMsg("\u4e0d\u53ef\u53d6\u6d88\u5173\u8054");
            }
        } else {
            msg.setFailMsg("\u4ea7\u54c1\u5904\u4e8e\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u53ef\u53d6\u6d88");
        }
        return msg.msg();
    }

    private ReturnMsg maintainProductAndMainRisks(String product_uuid, String risk_uuid) {
        this.dao.delete(SipProductRisks.n().where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid).addEq(SipProductRisks.RISK_UUID, (Object)risk_uuid).model());
        Return r = new Return();
        return r.msg();
    }

    @Override
    public boolean getProductConfigStatus(String product_uuid) {
        ArrayList<String> productUuid = new ArrayList<String>();
        productUuid.add(product_uuid);
        return this.getProductConfigStatus(productUuid);
    }

    private boolean getProductConfigStatus(List<String> product_uuid) {
        boolean statusFlag = false;
        Date date = new Date();
        SipProductsChannel productsChannel = new SipProductsChannel();
        productsChannel.where().addIn(SipProductsChannel.PRODUCT_UUID, product_uuid);
        List channelProduct = this.dao.findAll((AbsModel)productsChannel);
        for (int i = 0; i < channelProduct.size(); ++i) {
            SipProductsChannel channel_Product = (SipProductsChannel)channelProduct.get(i);
            if (!date.after(channel_Product.getStartDate()) || !date.before(channel_Product.getEndDate())) continue;
            statusFlag = true;
            break;
        }
        return statusFlag;
    }

    @Override
    public boolean queryPublishStateByRisk(List<String> risk_uuid) {
        SipProductRisks sipProductRisks = new SipProductRisks();
        sipProductRisks.where().addIn(SipProductRisks.RISK_UUID, risk_uuid);
        List sipProductRisksList = this.dao.findAll((AbsModel)sipProductRisks);
        List<String> productUuid = sipProductRisksList.stream().map(SipProductRisks::getProductUuid).collect(Collectors.toList());
        return this.getProductConfigStatus(productUuid);
    }

    public ReturnMsg addMainRisk(Map<String, Object> paramMap) {
        Return msg = new Return();
        String product_uuid = StrUtils.trimStr((Object)paramMap.get("product_uuid"));
        List riskList = (List)paramMap.get("risk_list");
        for (Map risk_list : riskList) {
            String risk_uuid = StrUtils.trimStr(risk_list.get("risk_uuid"));
            SipProductRisks sip = new SipProductRisks();
            sip.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid);
            sip.where().addEq(SipProductRisks.RISK_UUID, (Object)risk_uuid);
            List result = this.dao.findAll((AbsModel)sip);
            if (result.isEmpty()) {
                SipProductRisks Sip = new SipProductRisks();
                Sip.where().addEq(SipProductRisks.RISK_UUID, (Object)risk_uuid);
                SipProductRisks risk = (SipProductRisks)this.dao.findOne((AbsModel)Sip);
                DsnStructure dsn_risk = new DsnStructure();
                dsn_risk.where().addEq(DsnStructure.SERNO, (Object)risk.getSerno());
                DsnStructure toAddRisk = (DsnStructure)this.dao.findOne((AbsModel)dsn_risk);
                DsnStructure dsnNRiskNode = this.getNRiskbyUUID(product_uuid);
                this.saveNewRiskNode(toAddRisk, dsnNRiskNode, "main_risks");
                this.handleRiskRelation(product_uuid, risk_uuid);
                continue;
            }
            msg.setFailMsg("\u8be5\u9669\u79cd\u5df2\u5b58\u5728\uff01");
        }
        return msg.msg();
    }

    private DsnStructure getNRiskbyUUID(String product_uuid) {
        DsnStructure dsn_pro_detail = new DsnStructure();
        dsn_pro_detail.where().addEq(DsnStructure.NODE_NO, (Object)product_uuid);
        DsnStructure prdDetailNode = (DsnStructure)this.dao.findOne((AbsModel)dsn_pro_detail);
        DsnStructure dsn_pro = new DsnStructure();
        dsn_pro.where().addEq(DsnStructure.NODE_NO, (Object)prdDetailNode.getUpNode());
        DsnStructure dsnPrdNode = (DsnStructure)this.dao.findOne((AbsModel)dsn_pro);
        DsnStructure dsn_n_risk = new DsnStructure();
        dsn_n_risk.where().addEq(DsnStructure.UP_NODE, (Object)dsnPrdNode.getNodeNo());
        dsn_n_risk.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk");
        return (DsnStructure)this.dao.findOne((AbsModel)dsn_n_risk);
    }

    private DsnStructure saveNewRiskNode(DsnStructure oldNode, DsnStructure newUpNode, String newNodeType) {
        String oldNodeNo = oldNode.getNodeNo();
        oldNode.setSerno(UUID.shortUUID());
        oldNode.setNodeNo(oldNodeNo);
        oldNode.setUpNode(newUpNode.getNodeNo());
        oldNode.setNodeType(newNodeType);
        StringBuffer noSeq = new StringBuffer(newUpNode.getNodeSeq()).append(oldNodeNo).append(".");
        oldNode.setNodeSeq(noSeq.toString());
        oldNode.setDisplayOrder(Integer.valueOf(this.getMaxDisplayorder(newUpNode.getNodeNo()) + 1));
        this.dao.save((AbsModel)oldNode);
        return oldNode;
    }

    public int getMaxDisplayorder(String upNode) {
        DsnStructure maxOrder = new DsnStructure();
        maxOrder.where().addEq(DsnStructure.UP_NODE, (Object)upNode);
        maxOrder.groupBy().max(DsnStructure.DISPLAY_ORDER);
        maxOrder = (DsnStructure)this.dao.findOne((AbsModel)maxOrder);
        Object maxDisplayOrder = maxOrder.getOtherProperty("max_display_order", String.class);
        return Integer.parseInt(StrUtils.isNull((Object)maxDisplayOrder) ? "0" : maxDisplayOrder.toString());
    }

    private void handleRiskRelation(String product_uuid, String risk_uuid) {
        SipProductRisks productRiskRelation = new SipProductRisks();
        productRiskRelation.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid);
        productRiskRelation.where().addEq(SipProductRisks.RISK_UUID, (Object)risk_uuid);
        this.dao.save((AbsModel)productRiskRelation);
    }

    @Override
    public ReturnMsg deleteProduct(Map<String, Object> param) {
        Return r = new Return();
        List proListParam = (List)param.get("product_list");
        for (Map proMap : proListParam) {
            String product_uuid = StrUtils.trimStr(proMap.get("product_uuid"));
            String product_name = StrUtils.trimStr(proMap.get("product_name"));
            boolean productChannelStatus = this.getProductConfigStatus(product_uuid);
            if (productChannelStatus) {
                r.setFailMsg(product_name + "\u5904\u4e8e\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
                continue;
            }
            SipProductRisks proRisk = new SipProductRisks();
            proRisk.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid);
            List existProRisks = this.dao.findAll((AbsModel)proRisk);
            if (!existProRisks.isEmpty()) {
                r.setFailMsg(product_name + "\u8fd8\u6709\u4e3b\u9669\u672a\u53d6\u6d88\u5173\u8054\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
                continue;
            }
            SipProducts sip = SipProducts.n();
            sip.where().addEq(SipProducts.PRODUCT_UUID, (Object)product_uuid).model();
            this.dao.delete((AbsModel)sip);
            DsnStructure dsnPrdDetail = DsnStructure.n();
            dsnPrdDetail.where().addEq(DsnStructure.NODE_NO, (Object)product_uuid);
            dsnPrdDetail = (DsnStructure)this.dao.findOne((AbsModel)dsnPrdDetail);
            DsnStructure dsnPrdAttrDetail = DsnStructure.n();
            dsnPrdAttrDetail.where().addEq(DsnStructure.UP_NODE, (Object)product_uuid);
            dsnPrdAttrDetail.where().addEq(DsnStructure.NODE_TYPE, (Object)"attr_detail");
            DsnStructure dsnPrd = DsnStructure.n();
            dsnPrd.where().addEq(DsnStructure.NODE_NO, (Object)dsnPrdDetail.getUpNode());
            dsnPrd.where().addEq(DsnStructure.NODE_TYPE, (Object)"prd");
            dsnPrd = (DsnStructure)this.dao.findOne((AbsModel)dsnPrd);
            DsnStructure dsnNRisk = DsnStructure.n();
            dsnNRisk.where().addEq(DsnStructure.UP_NODE, (Object)dsnPrd.getNodeNo());
            dsnNRisk.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk");
            DsnStructure dsnMainRisks = DsnStructure.n();
            dsnMainRisks.where().addEq(DsnStructure.UP_NODE, (Object)dsnNRisk.getNodeNo());
            dsnMainRisks.where().addEq(DsnStructure.NODE_TYPE, (Object)"main_risks");
            this.dao.delete((AbsModel)dsnMainRisks);
            this.dao.delete((AbsModel)dsnNRisk);
            this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)dsnPrdDetail.getUpNode()).addEq(DsnStructure.NODE_TYPE, (Object)"prd").model());
            this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)product_uuid).model());
            this.productConfigService.delProductOrganConfigByProductUuid(product_uuid);
            SipProductsChannel productsChannel = new SipProductsChannel();
            productsChannel.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)productsChannel);
            List attr_list = this.dao.findAll((AbsModel)dsnPrdAttrDetail);
            attr_list.stream().forEach(attr_detail -> {
                DsnBizAttribute bizAttribute = new DsnBizAttribute();
                bizAttribute.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)attr_detail.getNodeNo());
                this.dao.delete((AbsModel)bizAttribute);
                DsnBizAttributeOption bizAttributeOption = new DsnBizAttributeOption();
                bizAttributeOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)attr_detail.getNodeNo());
                this.dao.delete((AbsModel)bizAttributeOption);
            });
            this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)product_uuid).addEq(DsnStructure.NODE_TYPE, (Object)"attr_detail").model());
        }
        return r.msg();
    }

    public ReturnMsg queryRisk4Ajax(DsnStructure node, String riskName) {
        String isMainRisk = "M";
        switch (NodeType.valueOf((String)node.getNodeType().toUpperCase())) {
            case N_SUB_RISKS: {
                isMainRisk = "S";
                break;
            }
            case N_ACCY_RISKS: {
                isMainRisk = "A";
                break;
            }
            case N_EXEMPT: {
                isMainRisk = "W";
            }
        }
        List riskNameList = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model());
        SipRisks risk = (SipRisks)SipRisks.n().where().addEq(SipRisks.IS_MAIN_RISK, (Object)isMainRisk).model();
        riskNameList.forEach(dsn -> risk.where().addNotIn(SipRisks.RISK_NAME, new String[]{dsn.getNodeName()}));
        risk.where().addCallback((RowCallback & Serializable)(aRisk, riskList, i) -> {
            aRisk.getOtherProperty().put("code", aRisk.getRiskUuid());
            aRisk.getOtherProperty().put("name", aRisk.getRiskName());
        });
        List riskList2 = this.dao.findAll((AbsModel)risk);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("leftSelect", riskList2);
        map.put("ajaxtype", "select");
        map.put("blankline", false);
        Return msg = new Return();
        msg.getDataList().add(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg addRisk(Map<String, Object> paramMap) {
        Return msg = new Return();
        List selectedRiskList = (List)paramMap.get("risk_list");
        String product_uuid = StrUtils.trimStr((Object)paramMap.get("product_uuid"));
        DsnStructure n_risk_node = this.getNRiskbyUUID(product_uuid);
        if (null == selectedRiskList || selectedRiskList.isEmpty()) {
            msg.setFailMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u4e3b\u9669\uff01");
            return msg.msg();
        }
        boolean proChannelStatus = this.getProductConfigStatus(product_uuid);
        if (proChannelStatus) {
            msg.setFailMsg("\u8be5\u4ea7\u54c1\u5904\u4e8e\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u53ef\u6dfb\u52a0\u4e3b\u9669\uff01");
            return msg.msg();
        }
        int displayNum = this.structureService.getMaxDisplayOrder(n_risk_node.getNodeNo());
        for (Map eachRisk : selectedRiskList) {
            String riskNodeNo = StrUtils.trimStr(eachRisk.get("risk_uuid"));
            SipProductRisks productRisks = new SipProductRisks();
            List proRiskList = this.dao.findAll(productRisks.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid).model());
            for (SipProductRisks proRisk : proRiskList) {
                if (!proRisk.getRiskUuid().contains(riskNodeNo)) continue;
                msg.setFailMsg("\u8be5\u4e3b\u9669\u5728\u4ea7\u54c1\u4e0b\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u518d\u6b21\u7ed1\u5b9a\uff01");
                return msg.msg();
            }
            DsnStructure nRiskDetailsNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskNodeNo).model());
            DsnStructure riskNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nRiskDetailsNode.getUpNode()).model());
            riskNode.setSerno(UUID.shortUUID());
            riskNode.setNodeSeq(n_risk_node.getNodeSeq() + riskNode.getNodeNo() + ".");
            riskNode.setUpNode(n_risk_node.getNodeNo());
            riskNode.setDisplayOrder(Integer.valueOf(++displayNum));
            this.dao.save((AbsModel)riskNode);
            this.saveRiskRelation(nRiskDetailsNode, product_uuid);
        }
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg.msg();
    }

    public void saveRiskRelation(DsnStructure node, String proUuid) {
        List relationList = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)node.getUpNode()).model());
        SipRiskRelation srr = SipRiskRelation.n();
        HashMap<String, DsnStructure> nodeSernoMap = new HashMap<String, DsnStructure>();
        for (Object ds : relationList) {
            nodeSernoMap.put(ds.getSerno(), (DsnStructure)ds);
            srr.where().addIn(SipRiskRelation.SERNO, new String[]{ds.getSerno()});
        }
        List srrList = this.dao.findAll((AbsModel)srr);
        for (SipRiskRelation aSrr : srrList) {
            nodeSernoMap.remove(aSrr.getSerno());
        }
        Collection dsnList = nodeSernoMap.values();
        for (DsnStructure dsn : dsnList) {
            DsnStructure existPro = new DsnStructure();
            String[] nodeSeqArray = dsn.getNodeSeq().split("\\.");
            DsnStructure proRoot = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeSeqArray[0]).model());
            existPro.where().addEq(DsnStructure.UP_NODE, (Object)proRoot.getNodeNo());
            existPro.where().addEq(DsnStructure.NODE_TYPE, (Object)"prd_detail");
            DsnStructure existedPro = (DsnStructure)this.dao.findOne((AbsModel)existPro);
            DsnStructure existRisk = new DsnStructure();
            existRisk.where().addEq(DsnStructure.UP_NODE, (Object)node.getUpNode());
            existRisk.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_risk_detail");
            DsnStructure existedRisk = (DsnStructure)this.dao.findOne((AbsModel)existRisk);
            SipProductRisks existProRisk = new SipProductRisks();
            existProRisk.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)existedPro.getNodeNo());
            existProRisk.where().addEq(SipProductRisks.RISK_UUID, (Object)existedRisk.getNodeNo());
            List sipProductRisks = this.dao.findAll((AbsModel)existProRisk);
            if (!sipProductRisks.isEmpty()) continue;
            node.setNodeSeq(dsn.getNodeSeq() + node.getNodeNo() + ".");
            this.saveRelation(dsn.getSerno(), node, proUuid);
        }
    }

    private ReturnMsg saveRelation(String serno, DsnStructure node, String proUuid) {
        boolean isMainRiks;
        Return r = new Return();
        String[] nodeSeqArray = node.getNodeSeq().split("\\.");
        boolean bl = isMainRiks = nodeSeqArray.length == 4;
        if (isMainRiks) {
            SipProductRisks spr = new SipProductRisks();
            String prdNodeNo = NodeSeqUtils.getPrdNodeNo(node.getNodeSeq());
            DsnStructure prd = new DsnStructure();
            prd.where().addEq(DsnStructure.UP_NODE, (Object)prdNodeNo);
            prd.where().addEq(DsnStructure.NODE_TYPE, (Object)"prd_detail");
            DsnStructure prdStructure2 = (DsnStructure)this.dao.findOne((AbsModel)prd);
            spr.setSerno(serno);
            spr.setProductUuid(prdStructure2.getNodeNo());
            spr.setRiskUuid(node.getNodeNo());
            this.dao.save((AbsModel)spr);
            return r.msg();
        }
        r.setFailMsg("\u65e0\u6cd5\u6dfb\u52a0\u4e3b\u9669\uff01");
        return r.msg();
    }

    @Override
    public ReturnMsg queryProductByNo(String productUuid) {
        Return msg = new Return();
        try {
            SipProducts sipProducts = new SipProducts();
            sipProducts.where().addEq(SipProducts.PRODUCT_UUID, (Object)productUuid);
            SipProducts product = (SipProducts)this.dao.findOne((AbsModel)sipProducts);
            List<SipProductRisks> riskList = this.getRiskList(productUuid);
            List<Map<String, Object>> mainRiskList = this.processRiskList(riskList);
            String optionNames = "";
            String optionName = "";
            String[] array = product.getProductType().split(",");
            if (!StrUtils.isNull((Object)array)) {
                for (String optionValue : array) {
                    if (StrUtils.isNull((Object)optionValue) || StrUtils.isNull((Object)(optionName = this.queryAllAttr(product.getProductUuid(), "product_type", optionValue)))) continue;
                    optionNames = StrUtils.isNull((Object)optionNames) ? optionName : optionNames + "," + optionName;
                }
            }
            Map<String, Object> productRes = this.buildProductResponse(product, optionNames, mainRiskList);
            msg.setDataTable(productRes);
        }
        catch (DataAccessException e) {
            Ulog.info((String)"\u67e5\u8be2\u4ea7\u54c1\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
            Ulog.error((Throwable)e);
            msg.setFailMsg("\u67e5\u8be2\u4ea7\u54c1\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
        }
        return msg.msg();
    }

    private List<SipProductRisks> getRiskList(String productUuid) {
        SipProductRisks risks = (SipProductRisks)SipProductRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)productUuid)) {
            risks.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUuid);
        }
        risks.setOrderBy(new Sort.Order[]{SipProductRisks.MDF_DATE.desc()});
        return this.dao.findAll((AbsModel)risks);
    }

    private List<Map<String, Object>> processRiskList(List<SipProductRisks> riskList) {
        ArrayList<Map<String, Object>> mainRiskList = new ArrayList<Map<String, Object>>();
        ObjectMapper objectMapper = new ObjectMapper();
        riskList.forEach(risk -> {
            SipRisks mainRisk = (SipRisks)SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)risk.getRiskUuid()).model();
            mainRisk = (SipRisks)this.dao.findOne((AbsModel)mainRisk);
            Map mapMain = (Map)objectMapper.convertValue((Object)mainRisk, Map.class);
            mapMain.put("accy_risk", this.getSubRisks(mainRisk.getRiskUuid(), "A"));
            mapMain.put("exempt_risk", this.getSubRisks(mainRisk.getRiskUuid(), "W"));
            mainRiskList.add(mapMain);
        });
        return mainRiskList;
    }

    private List<Map<String, Object>> getSubRisks(String mainRiskUuid, String isMainRisk) {
        ArrayList<Map<String, Object>> subRiskList = new ArrayList<Map<String, Object>>();
        ObjectMapper objectMapper = new ObjectMapper();
        String sqlSubRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
        List<String> searchParams = Arrays.asList(mainRiskUuid, isMainRisk, "1");
        List subRisks = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchParams)});
        if ("A".equals(isMainRisk)) {
            subRisks.stream().forEach(aRisk -> {
                Map mapAdd = (Map)objectMapper.convertValue(aRisk, Map.class);
                List<String> subSearchParams = Arrays.asList(aRisk.getRiskUuid(), "W", "1");
                List riskExemptsList = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(subSearchParams)});
                ArrayList exemptsRiskList = new ArrayList();
                riskExemptsList.stream().forEach(exemptsRisk -> {
                    Map mapExe = (Map)objectMapper.convertValue(exemptsRisk, Map.class);
                    exemptsRiskList.add(mapExe);
                });
                mapAdd.put("exempt_risk", exemptsRiskList);
                subRiskList.add(mapAdd);
            });
        } else {
            subRisks.stream().forEach(sub -> {
                Map mapExe = (Map)objectMapper.convertValue(sub, Map.class);
                subRiskList.add(mapExe);
            });
        }
        return subRiskList;
    }

    private Map<String, Object> buildProductResponse(SipProducts product, String optionNames, List<Map<String, Object>> mainRiskList) {
        HashMap<String, Object> productRes = new HashMap<String, Object>();
        productRes.put("product_no", product.getProductNo());
        productRes.put("product_name", product.getProductName());
        productRes.put("product_type", product.getProductType());
        productRes.put("product_code", product.getProductNo());
        productRes.put("product_uuid", product.getProductUuid());
        productRes.put("product_type_name", optionNames);
        productRes.put("is_health_told", product.getIsHealthTold());
        productRes.put("is_intelligent_underwrite", product.getIsIntelligentUnderwrite());
        productRes.put("risk", mainRiskList);
        productRes.put("insurance_company", "picclife");
        return productRes;
    }

    private String queryAllAttr(String upNode, String attrNo, String optionValue) {
        String queryAttr = "select option_name from dsn_biz_attribute_option where biz_uuid =   (SELECT biz_uuid FROM    dsn_biz_attribute    WHERE biz_uuid in       (SELECT node_no FROM        dsn_structure        WHERE up_node = ? )         and attr_no = ?)  and option_value = ?";
        List allAttrList = this.dao.findAll(queryAttr, DsnBizAttributeOption.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{upNode, attrNo, optionValue})});
        String optionName = "";
        if (!CollectionUtils.isEmpty((Collection)allAttrList)) {
            optionName = ((DsnBizAttributeOption)allAttrList.get(0)).getOptionName();
        }
        return optionName;
    }

    @Override
    public ReturnMsg queryProductListByNo(String productNos) {
        Return msg = new Return();
        String[] array = productNos.split(",");
        HashSet<String> products = new HashSet<String>();
        for (String productNo : array) {
            products.add(productNo);
        }
        ArrayList productResList = new ArrayList();
        ObjectMapper objectMapper = new ObjectMapper();
        for (String productNo : products) {
            SipProducts sipProducts = new SipProducts();
            sipProducts.where().addEq(SipProducts.PRODUCT_NO, (Object)("PK" + productNo));
            SipProducts product = (SipProducts)this.dao.findOne((AbsModel)sipProducts);
            SipProductRisks risks = (SipProductRisks)SipProductRisks.n().where().addEq(SipRisks.DATA_FLAG, (Object)"1").model();
            if (!StrUtils.isNull((Object)product.getProductUuid())) {
                risks.where().addLike(SipProductRisks.PRODUCT_UUID, (Object)product.getProductUuid());
            }
            risks.setOrderBy(new Sort.Order[]{SipProductRisks.MDF_DATE.desc()});
            List riskList = this.dao.findAll((AbsModel)risks);
            ArrayList mainRiskList = new ArrayList();
            riskList.stream().forEach(risk -> {
                SipRisks riskUuid = (SipRisks)SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)risk.getRiskUuid()).model();
                SipRisks mainRisk = (SipRisks)this.dao.findOne((AbsModel)riskUuid);
                Map mapMain = (Map)objectMapper.convertValue((Object)mainRisk, Map.class);
                String sqlSubRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
                ArrayList<String> searchAddParam = new ArrayList<String>();
                searchAddParam.add(mainRisk.getRiskUuid());
                searchAddParam.add("A");
                searchAddParam.add("1");
                List riskSubList = this.dao.findAll(sqlSubRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchAddParam)});
                ArrayList aRiskList = new ArrayList();
                riskSubList.stream().forEach(aRisk -> {
                    Map mapAdd = (Map)objectMapper.convertValue(aRisk, Map.class);
                    String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
                    ArrayList<String> searchExeParam = new ArrayList<String>();
                    searchExeParam.add(aRisk.getRiskUuid());
                    searchExeParam.add("W");
                    searchExeParam.add("1");
                    List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExeParam)});
                    ArrayList exemptsRiskList = new ArrayList();
                    riskExemptsList.stream().forEach(exemptsRisk -> {
                        Map mapExe = (Map)objectMapper.convertValue(exemptsRisk, Map.class);
                        mapExe.put("node_seq", "PK" + productNo + "," + mapMain.get("policy_id") + "," + mapAdd.get("policy_id") + "," + mapExe.get("policy_id"));
                        mapExe.put("parent_node_seq", "PK" + productNo + "," + mapMain.get("policy_id") + "," + mapAdd.get("policy_id"));
                        mapExe.put("insure_type", product.getInsureType());
                        exemptsRiskList.add(mapExe);
                    });
                    mapAdd.put("node_seq", "PK" + productNo + "," + mapMain.get("policy_id") + "," + mapAdd.get("policy_id"));
                    mapAdd.put("parent_node_seq", "PK" + productNo + "," + mapMain.get("policy_id"));
                    mapAdd.put("exempt_risk", exemptsRiskList);
                    mapAdd.put("insure_type", product.getInsureType());
                    aRiskList.add(mapAdd);
                });
                mapMain.put("accy_risk", aRiskList);
                String sqlExemptsRisk = "SELECT * FROM sip_risks WHERE sip_risks.risk_uuid In ( SELECT distinct sip_risk_relation.risk_uuid FROM sip_risk_relation WHERE sip_risk_relation.main_risk = ?) AND sip_risks.is_main_risk = ? AND sip_risks.data_flag = ?;";
                ArrayList<String> searchExemptsParam = new ArrayList<String>();
                searchExemptsParam.add(mainRisk.getRiskUuid());
                searchExemptsParam.add("W");
                searchExemptsParam.add("1");
                List riskExemptsList = this.dao.findAll(sqlExemptsRisk, SipRisks.class, new AbsModelRepository.Args[]{this.dao.args(searchExemptsParam)});
                ArrayList exemptsRiskList = new ArrayList();
                riskExemptsList.stream().forEach(exemptsRisk -> {
                    Map mapExe = (Map)objectMapper.convertValue(exemptsRisk, Map.class);
                    mapExe.put("node_seq", "PK" + productNo + "," + mapMain.get("policy_id") + "," + mapExe.get("policy_id"));
                    mapExe.put("parent_node_seq", "PK" + productNo + "," + mapMain.get("policy_id"));
                    mapExe.put("insure_type", product.getInsureType());
                    exemptsRiskList.add(mapExe);
                });
                mapMain.put("node_seq", "PK" + productNo + "," + mapMain.get("policy_id"));
                mapMain.put("parent_node_seq", "PK" + productNo);
                mapMain.put("insure_type", product.getInsureType());
                mapMain.put("exempt_risk", exemptsRiskList);
                mainRiskList.add(mapMain);
            });
            HashMap<String, Object> productRes = new HashMap<String, Object>();
            productRes.put("productData", product);
            productRes.put("risk", mainRiskList);
            productRes.put("insurance_company", "picclife");
            productResList.add(productRes);
        }
        msg.setDataList(productResList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskInfo(String productNos) {
        Return msg = new Return();
        String[] array = productNos.split(",");
        HashSet<String> products = new HashSet<String>();
        for (String productNo : array) {
            products.add(productNo);
        }
        List sipRisks = this.dao.findAll(SipRisks.n().where().addIn(SipRisks.RISK_NO, array).model());
        msg.setDataList(sipRisks, SipRisks.class);
        return msg.msg();
    }
}

