/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.main.controller;

import com.newtouch.nms.insure.model.enums.YNType;
import com.newtouch.nms.sip.design.tree.services.IPublicTreeService;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.product.main.services.IProductAddService;
import com.newtouch.nms.sip.product.main.services.IProductMainService;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/prd"})
public class ProductAddController {
    @Autowired
    private IProductMainService mainService;
    @Autowired
    private IProductAddService addService;
    @Autowired
    private IPublicTreeService tree;
    @Autowired
    private IPublicTreeService treeService;

    @GetMapping(value={"/test.do"})
    public String test() {
        return "hello picc";
    }

    @RequestMapping(value={"/doProductAdd4Template.do", "/doProductConfigAddition.do"})
    public String doProductAdd4Template(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String sourcePrdUuid = param.get("product_uuid");
        String targetPrdName = param.get("product_name");
        HashMap<String, String> riskList = new HashMap<String, String>();
        ReturnMsg msg = this.addService.addProduct4Template(sourcePrdUuid, targetPrdName, riskList);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doRiskAdd4Template.do", "/doRiskConfigAddition.do"})
    public String doRiskAdd4Template(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        String sourcePrdUuid = param.get("product_uuid");
        String mainRiskUuid = param.get("main_risk_node_no");
        String accyRisksNodeNo = param.get("accy_risks_node_no");
        String targetPrdName = param.get("product_name");
        String addType = param.get("add_type");
        if (StrUtils.isNull((Object)addType)) {
            throw new BusinessException("\u5165\u53c2\u65b0\u589e\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (("A".equals(addType) || "M_W".equals(addType) || "A_W".equals(addType)) && StrUtils.isNull((Object)mainRiskUuid)) {
            throw new BusinessException("\u5165\u53c2main_risk_uuid\u4e3a\u7a7a");
        }
        if ("A_W".equals(addType) && StrUtils.isNull((Object)accyRisksNodeNo)) {
            throw new BusinessException("\u5165\u53c2\u9009\u4e2d\u7684\u9644\u52a0\u9669\u8282\u70b9accy_risks_node_no\u4e3a\u7a7a");
        }
        HashMap<String, String> riskList = (HashMap<String, String>)param.get("risk_list", Map.class);
        if (riskList == null) {
            riskList = new HashMap<String, String>();
        }
        ReturnMsg msg = this.addService.addMainRisk4Template(addType, sourcePrdUuid, targetPrdName, riskList, mainRiskUuid, accyRisksNodeNo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doTemplateAdd.do"})
    public String doProductConfigParent(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        ReturnMsg msg = this.addService.addTemplate(param.get("product_name"));
        if (msg.isSuccessflag()) {
            msg = this.tree.queryTree(StrUtils.trimStr(msg.getDataTable().get("node_no")));
            msg.getDataListIncludes().addAll(Arrays.asList("serno", "node_no", "node_name", "node_type", "display_order", "node_code", "node_seq", "up_node"));
        }
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doFindParentProduct.do", "/doQueryPrdTemplate.do"})
    public String doQueryPrdTemplate(HttpServletRequest request, HttpServletResponse response) {
        ReturnMsg msg = this.mainService.queryProduct("", "", YNType.Y.code());
        msg.getDataListIncludes().add(SipProducts.PRODUCT_NO.column());
        msg.getDataListIncludes().add(SipProducts.PRODUCT_UUID.column());
        msg.getDataListIncludes().add(SipProducts.PRODUCT_NAME.column());
        msg.getDataListIncludes().add("prd_node_no");
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doQueryRisksName.do"})
    public String doQueryRisksName(HttpServletRequest request, HttpServletResponse response) {
        String nodeNo = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"node_no");
        ReturnMsg msg = this.addService.queryRisksName(nodeNo);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/doQueryProductName.do"})
    public String doQueryProductName(HttpServletRequest request, HttpServletResponse response) {
        String productName = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"product_name");
        ReturnMsg msg = this.addService.queryProductName(productName);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

