/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.excel;

import com.newtouch.nms.sip.product.excel.ExcelWrite;
import com.newtouch.nms.sip.product.excel.pojo.Excel;
import com.newtouch.nms.sip.product.excel.pojo.Sheet;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.servlet.view.document.AbstractXlsView;

public class ExcelView
extends AbstractXlsView {
    protected void buildExcelDocument(Map<String, Object> data, Workbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExcelWrite excelWrite = new ExcelWrite();
        excelWrite.setWorkbook(workbook);
        Excel excel = (Excel)data.get("excel");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(excel.getExcelName(), "UTF-8"));
        HashMap<String, List<LinkedHashMap<String, String>>> sheetHead = new HashMap<String, List<LinkedHashMap<String, String>>>();
        HashMap<String, List<Map<String, Object>>> excelData = new HashMap<String, List<Map<String, Object>>>();
        for (Sheet sheet : excel.getSheets()) {
            sheetHead.put(sheet.getSheetName(), sheet.getHead());
            if (!sheet.getNotLockArrer().isEmpty()) {
                excelWrite.addNotLockArea(sheet.getSheetName(), sheet.getNotLockArrer());
            }
            excelWrite.setMergeCell(sheet.isMergeCell());
            if (!sheet.getData().isEmpty()) {
                excelData.put(sheet.getSheetName(), sheet.getData());
            }
            excelWrite.setSheetStyle(sheet.getSheetName(), sheet.getColumnStyle());
        }
        excelWrite.setSheetHead(sheetHead);
        excelWrite.setExcelData(excelData);
        excelWrite.writeExcel();
    }
}

