/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.excel;

import com.newtouch.nms.sip.product.excel.pojo.Excel;
import com.newtouch.nms.sip.product.excel.pojo.Sheet;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.pojo.Message;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.StrUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelRead {
    private Workbook workBook = null;
    private Map<String, List<Map<String, Object>>> excelMap = new LinkedHashMap<String, List<Map<String, Object>>>();
    private boolean ignoreBlankRow = false;
    private org.apache.poi.ss.usermodel.Sheet sheet = null;
    private Row oneRow = null;
    private int headNum = 1;
    private Return returnmsg = new Return();
    private boolean checkTemplate = false;
    private String excelName = "";
    private static Map<String, String> cache = new HashMap<String, String>();

    public String getExcelName() {
        return this.excelName;
    }

    public void setExcelName(String excelName) {
        this.excelName = excelName;
    }

    public void setCheckTemplate(boolean checkTemplate) {
        this.checkTemplate = checkTemplate;
    }

    public void initExcel(String filePath) {
        try {
            if (filePath.endsWith(".xls")) {
                POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(filePath));
                this.workBook = new HSSFWorkbook(fs);
            } else {
                this.workBook = new XSSFWorkbook(filePath);
            }
        }
        catch (IOException e) {
            Ulog.error((Throwable)e);
        }
    }

    public void initExcel(InputStream in) {
        try {
            if (this.excelName.endsWith(".xls")) {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                this.workBook = new HSSFWorkbook(fs);
            } else {
                this.workBook = new XSSFWorkbook(in);
            }
        }
        catch (IOException e) {
            Ulog.error((Throwable)e);
        }
    }

    public Excel initExcelData() {
        ArrayList<String> list = new ArrayList<String>();
        Excel excel = new Excel();
        org.apache.poi.ss.usermodel.Sheet _sheet = null;
        Row fstRow = null;
        Iterator cellIt = null;
        Cell aCell2 = null;
        for (int i = 0; i < this.workBook.getNumberOfSheets(); ++i) {
            _sheet = this.workBook.getSheetAt(i);
            if (_sheet.getPhysicalNumberOfRows() <= 1) continue;
            list.clear();
            Sheet sheet = new Sheet();
            sheet.setSheetName(_sheet.getSheetName());
            fstRow = this.workBook.getSheetAt(i).getRow(0);
            for (Cell aCell2 : fstRow) {
                if (aCell2 == null) continue;
                String cellData = StrUtils.trimStr((Object)this.initCellData(aCell2));
                sheet.addHead(cellData, cellData);
                list.add(cellData);
            }
            sheet.setData(this.initSheetData(i, list.toArray(new String[0]), list.toArray(new String[0])));
            excel.addSheets(sheet);
        }
        return excel;
    }

    public Map<String, List<Map<String, Object>>> initSheet(Object object, String[] titles, String[] chTitle) {
        Ulog.debug((String)("\u5171[" + this.workBook.getNumberOfSheets() + "]\u4e2aSheet"));
        for (int i = 0; i < this.workBook.getNumberOfSheets(); ++i) {
            Ulog.debug((String)("\u7b2c[" + (i + 1) + "]\u4e2aSheet"));
            this.excelMap.put(this.workBook.getSheetName(i), this.initSheetData(i, titles, chTitle));
        }
        return this.excelMap;
    }

    public Map<String, List<Map<String, Object>>> initSheet(int sheetNum, String[] titles, String[] chTitle) {
        Ulog.debug((String)("\u5171[" + this.workBook.getNumberOfSheets() + "]\u4e2aSheet"));
        if (sheetNum - 1 < this.workBook.getNumberOfSheets()) {
            Ulog.debug((String)("\u7b2c[" + sheetNum + "]\u4e2aSheet"));
            this.excelMap.put(this.workBook.getSheetName(sheetNum - 1).toLowerCase(Locale.ROOT), this.initSheetData(sheetNum - 1, titles, chTitle));
        }
        return this.excelMap;
    }

    private List<Object> initSheetData(int sheetNum, String[] titles, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>();
        this.sheet = this.workBook.getSheetAt(sheetNum);
        if (this.sheet == null) {
            return list;
        }
        int rows = this.sheet.getPhysicalNumberOfRows();
        if (rows <= 0) {
            return list;
        }
        int i = 0;
        int j = 0;
        while (i < rows) {
            if (i < this.headNum) {
                ++i;
                ++j;
                continue;
            }
            Ulog.debug((String)("\u7b2c[" + (i + 1) + "]\u884c"));
            this.oneRow = this.sheet.getRow(i == j ? i : j);
            while ((this.oneRow == null || StrUtils.isNull((Object)this.oneRow.getCell(0))) && this.ignoreBlankRow && j <= rows) {
                this.oneRow = this.sheet.getRow(++j);
            }
            ++i;
            ++j;
            if (this.oneRow == null) continue;
            try {
                Object aObject = Class.forName(obj.getClass().getName()).newInstance();
                if (!this.initRowData(this.oneRow, aObject, titles)) continue;
                list.add(aObject);
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
            }
        }
        return list;
    }

    private List<Map<String, Object>> initSheetData(int sheetNum, String[] titles, String[] chTitle) {
        HashMap<String, String> clmKey = new HashMap<String, String>();
        for (int tit = 0; tit < titles.length; ++tit) {
            clmKey.put(chTitle[tit], titles[tit]);
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.sheet = this.workBook.getSheetAt(sheetNum);
        if (this.sheet == null) {
            return list;
        }
        int rows = this.sheet.getPhysicalNumberOfRows();
        if (rows <= 0) {
            return list;
        }
        int i = 0;
        int j = 0;
        ArrayList<String> headerList = new ArrayList<String>();
        while (i < rows) {
            if (i < this.headNum) {
                headerList = new ArrayList();
                this.oneRow = this.sheet.getRow(i);
                boolean isTemplate = this.initHeader(chTitle, clmKey, headerList);
                if (this.checkTemplate && !isTemplate) {
                    this.returnmsg.setFailMsg(new Message("\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e\uff01"));
                    return list;
                }
                ++i;
                ++j;
                continue;
            }
            titles = headerList.toArray(new String[0]);
            Ulog.debug((String)("\u7b2c[" + (i + 1) + "]\u884c"));
            this.oneRow = this.sheet.getRow(i == j ? i : j);
            while ((this.oneRow == null || StrUtils.isNull((Object)this.oneRow.getCell(0))) && this.ignoreBlankRow && j <= rows) {
                this.oneRow = this.sheet.getRow(++j);
            }
            ++i;
            ++j;
            if (this.oneRow == null) continue;
            try {
                HashMap<String, Object> aObject = new HashMap<String, Object>();
                if (!this.initRowData(this.oneRow, aObject, titles, i + 1)) continue;
                list.add(aObject);
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
            }
        }
        if (list.size() == 0) {
            this.returnmsg.setFailMsg(new Message("\u8bf7\u6dfb\u52a0\u5b8c\u6570\u636e\u518d\u8fdb\u884c\u5bfc\u5165\uff01"));
        }
        return list;
    }

    private boolean initHeader(String[] chTitle, Map<String, String> clmKey, List<String> headerList) {
        int clmNum = this.oneRow.getLastCellNum();
        boolean isTemplate = clmNum == chTitle.length;
        for (int c = 0; c < clmNum; ++c) {
            String titleValue = StrUtils.trimStr((Object)this.oneRow.getCell(c).getStringCellValue());
            String titleKey = clmKey.get(titleValue);
            if (c < chTitle.length) {
                boolean bl = isTemplate = isTemplate && chTitle[c].equals(titleValue);
            }
            if (StrUtils.isNull((Object)titleKey)) {
                headerList.add(titleValue);
                continue;
            }
            headerList.add(titleKey);
        }
        return isTemplate;
    }

    private boolean initRowData(Row aRow, Object aObject, String[] titles) {
        Cell cell = null;
        int cells = titles.length;
        Object obj = null;
        for (int i = 0; i < cells; ++i) {
            Ulog.debug((String)("\u7b2c[" + (i + 1) + "]\u4e2a\u5355\u5143\u683c"));
            cell = aRow.getCell(i);
            if (cell == null) continue;
            obj = this.initCellData(cell);
            if (!this.ignoreBlankRow || i != 0 || !"".equals(obj)) continue;
            return false;
        }
        return true;
    }

    private boolean initRowData(Row aRow, Map<String, Object> aObject, String[] titles, int rownum) {
        Cell cell = null;
        int cells = titles.length;
        Object obj = null;
        for (int i = 0; i < cells; ++i) {
            Ulog.debug((String)("\u7b2c[" + (i + 1) + "]\u4e2a\u5355\u5143\u683c"));
            cell = aRow.getCell(i);
            if (cell == null) {
                aObject.put(titles[i], "");
                continue;
            }
            obj = this.initCellData(cell);
            if (obj == "") {
                aObject.put(titles[i], obj);
                continue;
            }
            if (this.ignoreBlankRow && i == 0 && "".equals(obj)) {
                return false;
            }
            if (titles[i].endsWith("date")) {
                if (!DateUtils.isValidDate((String)obj.toString())) {
                    this.returnmsg.setFailMsg(new Message("\u5bfc\u5165\u5931\u8d25\uff01\u7b2c[" + (rownum - 1) + "]\u884c\u7b2c[" + (i + 1) + "]\u4e2a\u5355\u5143\u683c\u65e5\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01"));
                    continue;
                }
                aObject.put(titles[i], DateUtils.string2Date((Object)StrUtils.trimStr((Object)obj)));
                continue;
            }
            if (titles[i].indexOf("#") != -1) {
                String[] arr = titles[i].split("#");
                if (arr.length != 2) continue;
                String enumCode = this.getEnumCodeByName(arr[1], (String)obj);
                aObject.put(arr[0], enumCode);
                continue;
            }
            aObject.put(titles[i], obj);
        }
        return true;
    }

    private String getEnumCodeByName(String enumParent, String enumName) {
        String enumCode = StrUtils.trimStr((Object)cache.get("RepEnum_" + enumParent + enumName));
        if (!StrUtils.isNull((Object)enumCode)) {
            return enumCode;
        }
        enumCode = StrUtils.trimStr((Object)cache.get("RepEnum_" + enumParent + enumName));
        return enumCode;
    }

    private Object initCellData(Cell cell) {
        Object value = "";
        String formula = "";
        block0 : switch (cell.getCellType()) {
            case STRING: {
                value = StrUtils.trimStr((Object)cell.getRichStringCellValue());
                Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3aString,\u503c\u4e3a[" + value + "]"));
                break;
            }
            case NUMERIC: {
                double d = 0.0;
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = DateUtil.getJavaDate((double)cell.getNumericCellValue());
                    Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3aDate,\u503c\u4e3a[" + value + "]"));
                    break;
                }
                d = cell.getNumericCellValue();
                value = d - (double)((int)d) < Double.MIN_VALUE ? Integer.toString((int)d) : Double.toString(d);
                Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3aDouble,\u503c\u4e3a[" + value + "]"));
                break;
            }
            case FORMULA: {
                formula = cell.getCellFormula();
                switch (cell.getCachedFormulaResultType()) {
                    case BOOLEAN: {
                        value = cell.getBooleanCellValue();
                        Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3aBoolean,\u503c\u4e3a[" + value + "]"));
                        break block0;
                    }
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            value = DateUtil.getJavaDate((double)cell.getNumericCellValue());
                            Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3aDate,\u503c\u4e3a[" + value + "]"));
                            break block0;
                        }
                        value = cell.getNumericCellValue();
                        Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3aDouble,\u503c\u4e3a[" + value + "]"));
                        break block0;
                    }
                    case STRING: {
                        value = StrUtils.trimStr((Object)cell.getRichStringCellValue());
                        Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3aString,\u503c\u4e3a[" + value + "]"));
                        break block0;
                    }
                    case BLANK: {
                        value = "";
                        Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3a \u7a7a\u503c,\u503c\u4e3a[" + value + "]"));
                        break block0;
                    }
                    case ERROR: {
                        value = "";
                        Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u53d6\u503c\u4e3a ERROR,\u503c\u4e3a[" + value + "]"));
                        break block0;
                    }
                }
                value = StrUtils.trimStr((Object)cell.getRichStringCellValue());
                Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3a\u516c\u5f0f,\u516c\u5f0f\u4e3a[" + formula + "],\u8f6c\u4e3a\u53d6\u503c\u4e3aString,\u503c\u4e3a[" + value + "]"));
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                Ulog.debug((String)("\u6570\u636e\u7c7b\u578b\u4e3aBoolean,\u503c\u4e3a[" + value + "]"));
                break;
            }
            case BLANK: {
                value = "";
                Ulog.debug((String)"\u5355\u5143\u683c\u503c\u4e3a\u7a7a");
                break;
            }
            case ERROR: {
                value = "";
                Ulog.debug((String)"\u5355\u5143\u683c\u53d6\u503c\u51fa\u73b0\u9519\u8bef");
                break;
            }
            default: {
                value = StrUtils.trimStr((Object)cell.getRichStringCellValue());
                Ulog.debug((String)("\u9ed8\u8ba4\u6309String\u7c7b\u578b\u5904\u7406,\u503c\u4e3a[" + value + "]"));
            }
        }
        return value;
    }

    public Map<String, List<Map<String, Object>>> getExcelData() {
        return this.excelMap;
    }

    public List<?> getExcelData(String sheetName) {
        return this.excelMap.get(sheetName);
    }

    public boolean isIgnoreBlankRow() {
        return this.ignoreBlankRow;
    }

    public void setIgnoreBlankRow(boolean ignoreBlankRow) {
        this.ignoreBlankRow = ignoreBlankRow;
    }

    public int getHeadNum() {
        return this.headNum;
    }

    public void setHeadNum(int headNum) {
        this.headNum = headNum;
    }

    public Return getReturnmsg() {
        return this.returnmsg;
    }

    public void setReturnmsg(Return returnmsg) {
        this.returnmsg = returnmsg;
    }
}

