/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.product.transfer.domain.propose.BenefitDemo;
import com.newtouch.nms.sip.product.transfer.domain.propose.RateGroup;
import com.newtouch.nms.sip.product.transfer.domain.risk.Risk;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;

public class LiabilityRisk
extends Risk {
    private Risk mainRisk;
    private RateGroup rateGroup;
    private BenefitDemo benefitDemo;
    private SipRiskRelation relation;

    @Override
    public LiabilityRisk load(DsnStructure riskNode) {
        super.load(riskNode);
        if (this.mainRisk == null) {
            return this;
        }
        String mainRisk = this.mainRisk.detailNode().getNodeNo();
        String riskUuid = this.detailNode().getNodeNo();
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.relation = utils.queryRiskRelation(mainRisk, riskUuid);
        this.rateGroup = new RateGroup();
        this.rateGroup.load(this.getRiskNode().getNodeNo());
        this.benefitDemo = new BenefitDemo();
        this.benefitDemo.load(this.getRiskNode().getNodeNo());
        return this;
    }

    public void merge(LiabilityRisk liabilityRisk) {
        super.merge(liabilityRisk);
        this.relation = ProductEqualsUtils.merge(this.relation, liabilityRisk.getRelation());
        this.benefitDemo = ProductEqualsUtils.merge(this.benefitDemo, liabilityRisk.getBenefitDemo(), BenefitDemo.class);
        this.rateGroup = ProductEqualsUtils.merge(null, liabilityRisk.getRateGroup(), RateGroup.class);
    }

    @Override
    public void save() {
        super.save();
        String source = ThreadLocalContext.get().getRqstSource();
        if (this.relation != null && !ProductEqualsUtils.isPropose(source)) {
            ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
            update.update((AbsModel)this.relation);
        }
        if (this.benefitDemo != null) {
            this.benefitDemo.save();
        }
        if (this.rateGroup != null) {
            this.rateGroup.save();
        }
    }

    @Override
    public TreeNode fetchTreeNode() {
        TreeNode treeNode = super.fetchTreeNode();
        if (this.rateGroup != null) {
            treeNode.getChildren().add(this.rateGroup.fetchTreeNode());
        }
        return treeNode;
    }

    public Risk getMainRisk() {
        return this.mainRisk;
    }

    public void setMainRisk(Risk mainRisk) {
        this.mainRisk = mainRisk;
    }

    public SipRiskRelation getRelation() {
        return this.relation;
    }

    public void setRelation(SipRiskRelation relation) {
        this.relation = relation;
    }

    public RateGroup getRateGroup() {
        return this.rateGroup;
    }

    public void setRateGroup(RateGroup rateGroup) {
        this.rateGroup = rateGroup;
    }

    public BenefitDemo getBenefitDemo() {
        return this.benefitDemo;
    }

    public void setBenefitDemo(BenefitDemo benefitDemo) {
        this.benefitDemo = benefitDemo;
    }
}

