/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.services.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipOrganRiskRelation;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.risk.services.IRiskRelationService;
import com.newtouch.nms.sys.model.SysTreeMenu;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RiskRelationServiceImpl
implements IRiskRelationService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg addRisksRelation(Map<String, Object> paramMap) {
        Return msg = new Return();
        String mainRisk = StrUtils.trimStr((Object)paramMap.get("main_risk"));
        List riskList = (List)paramMap.get("risk_list");
        if (null == riskList || riskList.isEmpty()) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u9669\u79cd\uff01");
            return msg.msg();
        }
        for (Map tmpMap : riskList) {
            String relationType;
            String riskUuid = StrUtils.trimStr(tmpMap.get("risk_uuid"));
            if (this.addRiskRelation(mainRisk, riskUuid, relationType = StrUtils.trimStr(tmpMap.get("relation_type"))).isSuccessflag()) continue;
            msg.setWarnMsg("\u6dfb\u52a0\u9669\u79cd\u5931\u8d25\uff01");
            return msg.msg();
        }
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg.msg();
    }

    public Return addRiskRelation(String mainRisk, String riskUuid, String relationType) {
        Return msg = new Return();
        String sqlMainRiskNodeNo = "SELECT * FROM dsn_structure WHERE node_no IN (SELECT up_node FROM dsn_structure WHERE  node_no LIKE ?)";
        ArrayList<String> searchMainRiskNodeNo = new ArrayList<String>();
        searchMainRiskNodeNo.add(mainRisk);
        List mainRiskNodeNoList = this.dao.findAll(sqlMainRiskNodeNo, DsnStructure.class, new AbsModelRepository.Args[]{this.dao.args(searchMainRiskNodeNo)});
        String mainRiskNodeNo = ((DsnStructure)mainRiskNodeNoList.get(0)).getNodeNo();
        DsnStructure downRiskNode = new DsnStructure();
        downRiskNode.where().addLike(DsnStructure.UP_NODE, (Object)mainRiskNodeNo);
        switch (relationType) {
            case "n_accy_risks": {
                downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_accy_risks");
                break;
            }
            case "n_exempt": {
                downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_exempt");
                break;
            }
            default: {
                msg.setFailMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9669\u79cd\u5173\u7cfb\uff01");
                return msg;
            }
        }
        List downRiskNodeList = this.dao.findAll((AbsModel)downRiskNode);
        String sqlRiskUuidNodeNo = "SELECT * FROM dsn_structure WHERE node_no IN (SELECT up_node FROM dsn_structure WHERE  node_no LIKE ?)";
        ArrayList<String> searchRiskUuidNodeNo = new ArrayList<String>();
        searchRiskUuidNodeNo.add(riskUuid);
        List riskUuidNodeNo = this.dao.findAll(sqlRiskUuidNodeNo, DsnStructure.class, new AbsModelRepository.Args[]{this.dao.args(searchRiskUuidNodeNo)});
        DsnStructure riskUuidDsn = new DsnStructure();
        riskUuidDsn.setUpNode(((DsnStructure)downRiskNodeList.get(0)).getNodeNo());
        riskUuidDsn.setSerno(UUID.shortUUID());
        riskUuidDsn.setNodeNo(((DsnStructure)riskUuidNodeNo.get(0)).getNodeNo());
        riskUuidDsn.setNodeName(((DsnStructure)riskUuidNodeNo.get(0)).getNodeName());
        riskUuidDsn.setNodeType(((DsnStructure)riskUuidNodeNo.get(0)).getNodeType());
        riskUuidDsn.setNodeSeq(((DsnStructure)downRiskNodeList.get(0)).getNodeSeq() + ((DsnStructure)riskUuidNodeNo.get(0)).getNodeNo() + ".");
        riskUuidDsn.setDisplayOrder(Integer.valueOf(1));
        riskUuidDsn.setRelateField("serno");
        riskUuidDsn.setRelateTab("sip_risk_relation");
        riskUuidDsn.setRelateFk(riskUuidDsn.getSerno());
        this.dao.save((AbsModel)riskUuidDsn);
        DsnStructure riskUuidUpNode = new DsnStructure();
        riskUuidUpNode.where().addLike(DsnStructure.NODE_NO, (Object)((DsnStructure)riskUuidNodeNo.get(0)).getUpNode());
        riskUuidUpNode = (DsnStructure)this.dao.findOne((AbsModel)riskUuidUpNode);
        SipRiskRelation sipRiskRelation = new SipRiskRelation();
        sipRiskRelation.setSerno(riskUuidDsn.getSerno());
        sipRiskRelation.setMainRisk(mainRisk);
        sipRiskRelation.setRiskUuid(riskUuid);
        switch (relationType) {
            case "n_accy_risks": {
                sipRiskRelation.setRelationType("ADDED");
                break;
            }
            case "n_exempt": {
                sipRiskRelation.setRelationType("EXEMPT");
                break;
            }
            default: {
                msg.setFailMsg("relation\u8868\u9669\u79cd\u5173\u7cfb\u9519\u8bef\uff01");
                return msg;
            }
        }
        this.dao.save((AbsModel)sipRiskRelation);
        msg.setSuccessMsg("\u6dfb\u52a0\u9669\u79cd\u6210\u529f\uff01");
        return msg;
    }

    public ReturnMsg addTreeNode(String mainRiskNodeNo, String riskUuidNodeNo, String mainRiskNodeSeq, String mainRiskNodeName, String relationType) {
        Return r = new Return();
        DsnStructure structure = new DsnStructure();
        String nodeNo = UUID.shortUUID();
        structure.setNodeNo(nodeNo);
        structure.setUpNode(mainRiskNodeNo);
        structure.setNodeType(riskUuidNodeNo);
        structure.setNodeSeq(mainRiskNodeSeq + riskUuidNodeNo + ".");
        switch (relationType) {
            case "ADDED": {
                structure.setNodeType("accy_risks");
                break;
            }
            case "EXEMPT": {
                structure.setNodeType("exempt_risks");
                break;
            }
            default: {
                return r.msg();
            }
        }
        structure.setNodeName(mainRiskNodeName);
        this.dao.save((AbsModel)structure);
        this.saveChildNode(structure);
        return r.msg();
    }

    private void saveChildNode(DsnStructure ds) {
        Return r = new Return();
        List<DsnStructure> nextNodeList = this.queryChildNode(ds.getNodeType(), ds.getNodeNo(), ds.getNodeSeq());
        if (!nextNodeList.isEmpty()) {
            this.dao.save(nextNodeList);
            for (DsnStructure dsNew : nextNodeList) {
                this.saveChildNode(dsNew);
            }
        }
    }

    private List<DsnStructure> queryChildNode(String node_type, String parentNodeNo, String parentNodeSeq) {
        SysTreeMenu queryNode = new SysTreeMenu();
        queryNode.where().addEq(SysTreeMenu.UP_MENU, (Object)node_type);
        queryNode.where().addEq(SysTreeMenu.MENU_TYPE, (Object)"node");
        List<DsnStructure> nextNodeList = this.dao.findAll((AbsModel)queryNode, Boolean.valueOf(false)).stream().map(node -> {
            DsnStructure nextNode = new DsnStructure();
            String nodeNo = UUID.shortUUID();
            nextNode.setNodeNo(nodeNo);
            nextNode.setNodeName(node.getMenuName());
            nextNode.setNodeType(node.getNodeType());
            nextNode.setUpNode(parentNodeNo);
            nextNode.setDisplayOrder(node.getDisplayOrder());
            nextNode.setNodeSeq(parentNodeSeq + nodeNo + ".");
            return nextNode;
        }).collect(Collectors.toList());
        return nextNodeList;
    }

    @Override
    public ReturnMsg cancelRisksRelation(String mainRisk, String riskUuid, String relationType) {
        Return msg = new Return();
        String sqlMainRiskNodeNo = "SELECT * FROM dsn_structure WHERE node_no IN (SELECT up_node FROM dsn_structure WHERE  node_no LIKE ?);";
        ArrayList<String> searchMainRiskNodeNo = new ArrayList<String>();
        searchMainRiskNodeNo.add(mainRisk);
        List mainRiskNodeNoList = this.dao.findAll(sqlMainRiskNodeNo, DsnStructure.class, new AbsModelRepository.Args[]{this.dao.args(searchMainRiskNodeNo)});
        String mainRiskNodeNo = ((DsnStructure)mainRiskNodeNoList.get(0)).getNodeNo();
        String mainRiskNodeSeq = ((DsnStructure)mainRiskNodeNoList.get(0)).getNodeSeq();
        String mainRiskNodeName = ((DsnStructure)mainRiskNodeNoList.get(0)).getNodeName();
        String sqlRiskUuidNodeNo = "SELECT * FROM dsn_structure WHERE node_no IN (SELECT up_node FROM dsn_structure WHERE  node_no LIKE ?);";
        ArrayList<String> searchRiskUuidNodeNo = new ArrayList<String>();
        searchRiskUuidNodeNo.add(riskUuid);
        List riskUuidNodeNoList = this.dao.findAll(sqlRiskUuidNodeNo, DsnStructure.class, new AbsModelRepository.Args[]{this.dao.args(searchRiskUuidNodeNo)});
        String riskUuidNodeNo = ((DsnStructure)riskUuidNodeNoList.get(0)).getNodeNo();
        List dss = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)riskUuidNodeNo).model());
        if (dss.size() == 1) {
            msg.setFailMsg("\u9669\u79cd\u6240\u5c5e\u7684\u4ea7\u54c1\u5728\u53d1\u5e03\u72b6\u6001\u4e2d\uff0c\u4e0d\u80fd\u53d6\u6d88\u5173\u8054\uff01");
            return msg.msg();
        }
        DsnStructure downRiskNode = new DsnStructure();
        downRiskNode.where().addLike(DsnStructure.UP_NODE, (Object)mainRiskNodeNo);
        switch (relationType) {
            case "n_accy_risks": {
                downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_accy_risks");
                break;
            }
            case "n_exempt": {
                downRiskNode.where().addLike(DsnStructure.NODE_TYPE, (Object)"n_exempt");
                break;
            }
            default: {
                msg.setFailMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9669\u79cd\u5173\u7cfb\uff01");
                return msg.msg();
            }
        }
        String downRiskNodeNo = ((DsnStructure)this.dao.findOne((AbsModel)downRiskNode)).getNodeNo();
        String relationNodeSeq = mainRiskNodeNo + "." + downRiskNodeNo + "." + riskUuidNodeNo + ".";
        DsnStructure dsnStructure = (DsnStructure)DsnStructure.n().where().addEq(DsnStructure.DATA_FLAG, (Object)"1").model();
        dsnStructure.where().addLikeL(DsnStructure.NODE_SEQ, (Object)relationNodeSeq);
        this.dao.delete((AbsModel)dsnStructure);
        SipRiskRelation sipRiskRelation = (SipRiskRelation)SipRiskRelation.n().where().addEq(SipRiskRelation.DATA_FLAG, (Object)"1").model();
        if (!StrUtils.isNull((Object)mainRisk)) {
            sipRiskRelation.where().addEq(SipRiskRelation.MAIN_RISK, (Object)mainRisk);
        }
        if (!StrUtils.isNull((Object)riskUuid)) {
            sipRiskRelation.where().addEq(SipRiskRelation.RISK_UUID, (Object)riskUuid);
        }
        this.dao.delete((AbsModel)sipRiskRelation);
        msg.setSuccessMsg("\u5220\u9664\u9669\u79cd\u5173\u7cfb\u6210\u529f\uff01");
        return msg.msg();
    }

    public ReturnMsg cancelRisks(String nodeSeq, String serno, String nodeNo, String upNode, String nodeType) {
        Return r = new Return();
        DsnStructure ds = new DsnStructure();
        ds.where().addLikeR(DsnStructure.NODE_SEQ, (Object)nodeSeq);
        ds.where().addNotEq(DsnStructure.SERNO, (Object)serno);
        List dsList = this.dao.findAll((AbsModel)ds);
        if (dsList.isEmpty()) {
            DsnStructure ds1 = new DsnStructure();
            ds1.where().addEq(DsnStructure.SERNO, (Object)serno);
            this.dao.delete((AbsModel)ds1);
            r = this.maintainRelation(nodeNo, upNode, nodeType);
            if (!r.isSuccessflag()) {
                return r.msg();
            }
        } else {
            r.setFailMsg("\u8be5\u9669\u79cd\u662f\u65b0\u589e\u9669\u79cd,\u4e0d\u53ef\u53d6\u6d88\u9669\u79cd\u5173\u7cfb!");
        }
        return r.msg();
    }

    private Return maintainRelation(String nodeNo, String upNode, String nodeType) {
        Return msg = new Return();
        String parentNodeNo = upNode;
        Map<String, Object> nodeTypeMap = this.judgeHandleClass(nodeType, parentNodeNo, nodeNo);
        if (null == nodeTypeMap || nodeTypeMap.isEmpty()) {
            msg.setFailMsg("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8282\u70b9\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u67e5\u627e\u95ee\u9898\uff01");
            return msg;
        }
        String parentNodeType = StrUtils.trimStr((Object)nodeTypeMap.get("parent"));
        String currentNodeType = StrUtils.trimStr((Object)nodeTypeMap.get("current"));
        String mainRiskFlag = "main_risks";
        if (mainRiskFlag.equals(nodeType)) {
            int deleteFlag = this.maintainProductAndMainRisks(parentNodeType, currentNodeType);
            if (deleteFlag != 1) {
                msg.setFailMsg("\u7ef4\u62a4\u4ea7\u54c1\u548c\u9669\u79cd\u5173\u7cfb\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6dfb\u52a0\u4e86\u5df2\u6709\u9669\u79cd\u540e\u662f\u5426\u70b9\u51fb\u4e86\"\u9669\u79cd\u8be6\u60c5\"\u4e2d\u7684\u4fdd\u5b58\u6309\u94ae\uff01");
            }
            return msg;
        }
        return msg;
    }

    private Map<String, Object> judgeHandleClass(String nodeType, String upNode, String nodeNo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        switch (nodeType) {
            case "main_risks": {
                DsnStructure dsnStructure4Query = this.getNodeInfo(upNode);
                if (null == dsnStructure4Query || StrUtils.isNull((Object)dsnStructure4Query.getSerno())) break;
                String[] nodeSeqArray = dsnStructure4Query.getNodeSeq().split("\\.");
                resultMap.put("parent", nodeSeqArray[0]);
                String risk_uuid = this.getCurrentInfo(nodeNo, "n_risk_detail");
                resultMap.put("current", risk_uuid);
                break;
            }
            case "accy_risks": {
                resultMap.put("parent", "n_risk_detail");
                resultMap.put("current", "n_accy_detail");
                break;
            }
            case "n_main_exempt": 
            case "n_accy_exempt": {
                int mainRiskExemptLength;
                DsnStructure dsnStructure = this.getNodeInfo(upNode);
                if (null == dsnStructure || StrUtils.isNull((Object)dsnStructure.getSerno())) break;
                String[] nodeSeqArray = dsnStructure.getNodeSeq().split("\\.");
                if (nodeSeqArray.length == (mainRiskExemptLength = 4)) {
                    resultMap.put("parent", "n_risk_detail");
                    resultMap.put("current", "n_exempt_detail");
                    break;
                }
                resultMap.put("parent", "n_accy_detail");
                resultMap.put("current", "n_exempt_detail");
                break;
            }
            default: {
                Ulog.info((String)"\u6839\u636e\u8282\u70b9\u7684nodeType\u672a\u627e\u5230\u5339\u914d\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        return resultMap;
    }

    private int maintainProductAndMainRisks(String productUUID, String riskUUID) {
        SipProductRisks sipProductRisks4Delete = new SipProductRisks();
        sipProductRisks4Delete.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUUID);
        sipProductRisks4Delete.where().addEq(SipProductRisks.RISK_UUID, (Object)riskUUID);
        return this.dao.delete((AbsModel)sipProductRisks4Delete);
    }

    private DsnStructure getNodeInfo(String nodeNo) {
        DsnStructure dsnStructure4Query = new DsnStructure();
        dsnStructure4Query.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure4Query);
        return null == dsnStructure4Result ? null : dsnStructure4Result;
    }

    private String getCurrentInfo(String nodeNo, String nodeType) {
        DsnStructure dsnStructure4Query = new DsnStructure();
        dsnStructure4Query.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure4Query.where().addEq(DsnStructure.NODE_TYPE, (Object)nodeType);
        DsnStructure dsnStructure4Result = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure4Query);
        return null == dsnStructure4Result ? null : dsnStructure4Result.getNodeNo();
    }

    @Override
    public ReturnMsg delRisks(DsnStructure risk) {
        List sprs = this.dao.findAll("SELECT risk_uuid FROM " + risk.getRelateTab() + " WHERE serno = ? \uff03NOTCHECK", SipProductRisks.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{risk.getSerno()})});
        Return msg = new Return();
        if (sprs.isEmpty()) {
            msg.setFailMsg("\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684\u9669\u79cd\u5173\u7cfb\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            return msg.msg();
        }
        String riskUuid = ((SipProductRisks)sprs.get(0)).getRiskUuid();
        List sorrs = this.dao.findAll("SELECT * FROM sip_organ_risk_relation WHERE main_risk = ? OR risk_uuid = ? \uff03NOTCHECK", SipOrganRiskRelation.class, new AbsModelRepository.Args[]{this.dao.args(new Object[]{riskUuid, riskUuid})});
        if (!sorrs.isEmpty()) {
            msg.setFailMsg("\u9669\u79cd\u5df2\u4e0a\u67b6\uff0c\u65e0\u6cd5\u5220\u9664\u9669\u79cd");
            return msg.msg();
        }
        List dss = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)risk.getNodeNo()).model());
        if (dss.size() >= 2) {
            msg.setFailMsg("\u9669\u79cd\u5df2\u88ab\u5176\u4ed6\u4ea7\u54c1\u4f7f\u7528\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u9669\u79cd\u64cd\u4f5c\uff0c\u53ea\u80fd\u8fdb\u884c\u53d6\u6d88\u9669\u79cd\u5173\u7cfb\u64cd\u4f5c");
            return msg.msg();
        }
        dss = this.dao.findAll(DsnStructure.n().where().addLike(DsnStructure.NODE_SEQ, (Object)risk.getNodeNo()).addNotEq(DsnStructure.NODE_NO, (Object)risk.getNodeNo()).addIn(DsnStructure.NODE_TYPE, new String[]{NodeType.ACCY_RISKS.code(), NodeType.EXEMPT.code(), NodeType.SUB_RISKS.code()}).model());
        if (!dss.isEmpty()) {
            msg.setFailMsg("\u5b58\u5728\u4e0b\u7ea7\u9669\u79cd\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u5148\u5220\u9664\u6216\u8005\u53d6\u6d88\u4e0b\u7ea7\u5173\u7cfb\u4e4b\u540e\u518d\u5220\u9664\u5f53\u524d\u9669\u79cd");
            return msg.msg();
        }
        RiskRelationServiceImpl.queryChildNodeAndDel(risk.getNodeNo(), this.dao);
        this.dao.delete(risk.where().addEq(DsnStructure.SERNO, (Object)risk.getSerno()).model());
        return msg.msg();
    }

    public static void queryChildNodeAndDel(String upNode, AbsModelRepository dao) {
        List nodeList = dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNode).model());
        if (nodeList.isEmpty()) {
            return;
        }
        for (DsnStructure node : nodeList) {
            switch (NodeType.valueOf((String)node.getNodeType().toUpperCase())) {
                case PRD: {
                    break;
                }
                case ATTR: 
                case ATTR_DETAIL: 
                case ATTR4RATE: {
                    RiskRelationServiceImpl.delDnsBizAttribute(node, dao);
                    break;
                }
                case N_RISK_DETAIL: {
                    RiskRelationServiceImpl.delSipRisks(node, dao);
                    break;
                }
                case RULE: {
                    dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)node.getNodeNo()).model());
                    dao.delete(DsnRulesConst.n().where().addEq(DsnRulesConst.RULE_ID, (Object)node.getNodeNo()).model());
                    break;
                }
                case RATE: 
                case ATTR4LIABILITY: {
                    try {
                        if (!StrUtils.isNull((Object)node.getRelateTab())) {
                            dao.getJdbcTemplate().execute("DROP TABLE " + node.getRelateTab());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dao.delete(DsnDynamicData.n().where().addEq(DsnDynamicData.RELATE_TAB, (Object)"dsn_structure").addEq(DsnDynamicData.RELATE_FIELD, (Object)"node_no").addEq(DsnDynamicData.RELATE_FK, (Object)node.getNodeNo()).model());
                    break;
                }
                case N_RULE: {
                    break;
                }
                case N_RATE: {
                    break;
                }
                case N_BENEFIT: {
                    break;
                }
                case N_RISK: {
                    break;
                }
                case MAIN_RISKS: {
                    break;
                }
                case ACCY_RISKS: {
                    break;
                }
                case SUB_RISKS: {
                    break;
                }
                case EXEMPT: {
                    break;
                }
                case N_RISK_ATTR: {
                    break;
                }
                case N_ACCY_RISKS: {
                    break;
                }
                case N_EXEMPT: {
                    break;
                }
                case N_SUB_RISKS: {
                    break;
                }
                case N_TBR: {
                    break;
                }
                case N_BBR: {
                    break;
                }
                case N_SYR: {
                    break;
                }
            }
            RiskRelationServiceImpl.queryChildNodeAndDel(node.getNodeNo(), dao);
            dao.delete(node.where().addEq(DsnStructure.SERNO, (Object)node.getSerno()).model());
        }
    }

    private static void delSipRisks(DsnStructure node, AbsModelRepository dao) {
        dao.delete(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)node.getNodeNo()).model());
        RiskRelationServiceImpl.delRiskRelation(node, dao);
    }

    private static void delRiskRelation(DsnStructure node, AbsModelRepository dao) {
        String[] nodeSeqArray = node.getNodeSeq().split("\\.");
        boolean isMainRiks = nodeSeqArray.length == 4;
        String serno = nodeSeqArray[nodeSeqArray.length - 2];
        if (isMainRiks) {
            dao.delete(SipProductRisks.n().where().addEq(SipProductRisks.SERNO, (Object)serno).model());
            return;
        }
        dao.delete(SipRiskRelation.n().where().addEq(SipRiskRelation.SERNO, (Object)serno).model());
    }

    private static void delDnsBizAttribute(DsnStructure node, AbsModelRepository dao) {
        dao.delete(DsnBizAttribute.n().where().addEq(DsnBizAttribute.BIZ_UUID, (Object)node.getNodeNo()).model());
        dao.delete(DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)node.getNodeNo()).model());
    }

    @Override
    public ReturnMsg cancelRiskRelation(DsnStructure risk) {
        Return msg = new Return();
        List dss = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)risk.getNodeNo()).model());
        if (dss.size() == 1) {
            msg.setFailMsg("\u9669\u79cd\u6240\u5c5e\u7684\u4ea7\u54c1\u5728\u53d1\u5e03\u72b6\u6001\u4e2d\uff0c\u4e0d\u80fd\u53d6\u6d88\u5173\u8054\uff01");
            return msg.msg();
        }
        RiskRelationServiceImpl.delRiskRelation(risk, this.dao);
        this.dao.delete(risk.where().addEq(DsnStructure.SERNO, (Object)risk.getSerno()).model());
        return msg.msg();
    }
}

