/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.risk.dao.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.DsnStructureRules;
import com.newtouch.nms.sip.model.SipOrganProducts;
import com.newtouch.nms.sip.model.SipOrganRiskInfo;
import com.newtouch.nms.sip.model.SipOrganRules;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.config.service.IConfigFunction;
import com.newtouch.nms.sip.product.risk.dao.IRiskDao;
import com.newtouch.nms.sip.product.utils.PinYin4J;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.DBTypes;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;

@Repository
public class RiskDaoImpl
implements IRiskDao {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private RuleUsedService ruleUsedService;
    private static Map<String, String> riskCodeMap = new HashMap<String, String>();

    @Override
    public List<Map<String, Object>> queryRiskDetail(Map<String, Object> param, String nodeNo, String type) {
        String organRiskUuid = StrUtils.trimStr((Object)param.get("organ_prd_uuid"));
        DsnStructure riskVo = this.getDsnStructureInfo(nodeNo, type);
        List attrList = null;
        List<Map<String, Object>> optionList = null;
        String nodeType = NodeType.ATTR_DETAIL.code();
        String queryAttr = "SELECT * FROM dsn_structure str  join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type =? ";
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(riskVo.getNodeNo());
        list.args().add(nodeType);
        attrList = this.dao.findAll(String.valueOf(queryAttr), new AbsModelRepository.Args[]{list});
        for (Map attr : attrList) {
            String ui_type = StrUtils.trimStr(attr.get("ui_type"));
            if ("date".equals(ui_type) || "text".equals(ui_type) || "number".equals(ui_type)) continue;
            optionList = this.queryAttrOption(attr);
            attr.put("attrOption", optionList);
        }
        this.getFieldValueOrgan(attrList, riskVo, organRiskUuid, param);
        return attrList;
    }

    @Override
    public Map<String, Object> queryRiskDetailInfo(Map<String, Object> param, String nodeNo, String type) {
        String productUuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        String organId = StrUtils.trimStr((Object)param.get("organ_id"));
        String channelNo = StrUtils.trimStr((Object)param.get("channel_no"));
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        String addBatch = StrUtils.trimStr((Object)param.get("add_batch"));
        String organPrdUuid = StrUtils.trimStr((Object)param.get("organ_prd_uuid"));
        DsnStructure riskVo = this.getDsnStructureInfo(nodeNo, type);
        List riskInfo = this.dao.findAll4Map(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)riskVo.getNodeNo()).model());
        Map risk = riskInfo.isEmpty() ? null : (Map)riskInfo.get(0);
        HashMap<String, Object> funcNeedParam = new HashMap<String, Object>();
        funcNeedParam.put("risk_uuid", riskVo.getNodeNo());
        this.replaceOrganConfigInfo(productUuid, deliveryPlatform, addBatch, organId, channelNo, funcNeedParam, risk, new IConfigFunction(){

            @Override
            public void replaceOrganConfig(Map<String, Object> funcParam, Map<String, Object> resultMap) {
                List organRiskInfoList = RiskDaoImpl.this.dao.findAll(SipOrganRiskInfo.n().where().addEq(SipOrganRiskInfo.ORGAN_PRD_UUID, funcParam.get("organ_prd_uuid")).addEq(SipOrganRiskInfo.RISK_UUID, funcParam.get("risk_uuid")).addEq(SipOrganRiskInfo.DATA_FLAG, (Object)"1").model());
                Map<String, SipOrganRiskInfo> collect = organRiskInfoList.stream().collect(Collectors.groupingBy(SipOrganRiskInfo::getAttrNo, Collectors.collectingAndThen(Collectors.toList(), val -> val != null && !val.isEmpty() ? (SipOrganRiskInfo)val.get(0) : null)));
                for (Map.Entry<String, Object> next : resultMap.entrySet()) {
                    SipOrganRiskInfo organRiskInfo = collect.get(next.getKey());
                    if (organRiskInfo == null || StrUtils.isNull((Object)organRiskInfo)) continue;
                    resultMap.put(next.getKey(), organRiskInfo.getAttrValue());
                }
            }
        });
        risk.put("risk_code", risk.get("policy_code"));
        return risk;
    }

    @Override
    public List<Map<String, Object>> queryOrganPrd(String orgPrdUuid) {
        return null;
    }

    @Override
    public List<Map<String, Object>> queryRiskLiability(String nodeNo, String type) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)type);
        DsnStructure dsnResult = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
        dsnStructure.clear();
        String libiaity = "select * from dsn_structure where up_node=?";
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(dsnResult.getNodeNo());
        list.args().add(libiaity);
        List result = this.dao.findAll(String.valueOf(libiaity), new AbsModelRepository.Args[]{list});
        List index = null;
        for (Map li : result) {
            List ruleList;
            AbsModelRepository.Args list33;
            String ruleSql;
            String nodeType = StrUtils.trimStr(li.get("node_type"));
            String indexSql = "select a.node_no,b.field_1 name,b.field_2 code,b.field_3 sort from dsn_structure a left join\ndsn_dynamic_data b\non a.node_no = b.relate_fk\nwhere up_node=?";
            AbsModelRepository.Args list2 = this.dao.args(new Object[0]);
            list2.args().add(StrUtils.trimStr(li.get("node_no")));
            list2.args().add(indexSql);
            index = this.dao.findAll(String.valueOf(indexSql), new AbsModelRepository.Args[]{list2});
            if (!NodeType.N_LIABILITY_TABLE.code().equals(nodeType)) {
                for (Map rule : index) {
                    ruleSql = "select a.node_name,a.node_no,b.rule_name,b.rule_info from dsn_structure a  left join dsn_rules b\non a.node_no=b.node_no\nwhere a.up_node=?";
                    list33 = this.dao.args(new Object[0]);
                    list33.args().add(StrUtils.trimStr(rule.get("node_no")));
                    list33.args().add("dsn_dynamic_data");
                    ruleList = this.dao.findAll(String.valueOf(ruleSql), new AbsModelRepository.Args[]{list33});
                    rule.put("ruleList", ruleList);
                }
            } else {
                for (Map rule : index) {
                    ruleSql = "SELECT a.node_name,\n  a.node_no,\n  b.field_1 name,\n  b.field_2 code,\n  b.field_3 sort\nFROM dsn_structure a\nLEFT JOIN dsn_dynamic_data b\nON a.node_no   =b.relate_fk\nWHERE a.up_node=?";
                    list33 = this.dao.args(new Object[0]);
                    list33.args().add(StrUtils.trimStr(rule.get("node_no")));
                    list33.args().add("dsn_dynamic_data");
                    ruleList = this.dao.findAll(String.valueOf(ruleSql), new AbsModelRepository.Args[]{list33});
                    rule.put("ruleList", ruleList);
                    rule.put("ruleList", ruleList);
                }
            }
            li.put("indexList", index);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryRiskRate(String nodeNo, String type) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)type);
        DsnStructure dsnResult = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
        dsnStructure.clear();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure.where().addEq(DsnStructure.NODE_NAME, (Object)"\u9669\u79cd\u4fe1\u606f");
        DsnStructure riskResule = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
        dsnStructure.clear();
        String rate = "select a.node_no,b.field_1 name,b.field_2 code, field_5 risk_no, field_7 rateType from dsn_structure a join\ndsn_dynamic_data b\non a.node_no = b.relate_fk\nwhere up_node=?";
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(dsnResult.getNodeNo());
        List<Map<String, Object>> result = this.dao.findAll(rate, new AbsModelRepository.Args[]{list});
        result = result.stream().filter(p -> "ruleData".equals(StrUtils.trimStr(p.get("ratetype")))).collect(Collectors.toList());
        for (Map map : result) {
            String tableName = "dsn_rate_" + StrUtils.trimStr(map.get("risk_no")) + "_" + StrUtils.trimStr(map.get("code")).toLowerCase();
            List<Map<String, Object>> rateDetail = null;
            try {
                if (this.queryTableInDB(tableName)) {
                    rateDetail = this.getRateDetail(tableName);
                }
            }
            catch (SQLException e) {
                throw new BusinessException(new Message("\u67e5\u8be2\u8868\u662f\u5426\u5b58\u5728\u5f02\u5e38"));
            }
            map.put("rateDetail", rateDetail);
            String node = StrUtils.trimStr(map.get("node_no"));
            List<Map<String, Object>> input = this.getParmer(node, NodeType.INPUT.code());
            this.switchParmer(input);
            map.put(NodeType.INPUT.code(), input);
            List<Map<String, Object>> output = this.getParmer(node, NodeType.OUTPUT.code());
            this.switchParmer(output);
            map.put(NodeType.OUTPUT.code(), output);
        }
        return result;
    }

    private boolean queryTableInDB(String table_name) throws SQLException {
        Connection conn = this.dao.getJdbcTemplate().getDataSource().getConnection();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = conn.getMetaData().getTables(null, null, "%", types);
        while (rs.next()) {
            String tabName = StrUtils.trimStr((Object)rs.getObject("TABLE_NAME"));
            if (DBTypes.ORACLE.equals((Object)this.dao.getDbType())) {
                table_name = table_name.toUpperCase();
            }
            if (!tabName.equals(table_name)) continue;
            rs.close();
            conn.close();
            return true;
        }
        rs.close();
        conn.close();
        return false;
    }

    private void switchParmer(List<Map<String, Object>> input) {
        for (Map<String, Object> map : input) {
            map.put("column", PinYin4J.converterToFirstSpell(StrUtils.trimStr((Object)map.get("name"))).toLowerCase());
        }
    }

    private List<Map<String, Object>> getRateDetail(String tableName) {
        String sql = "select * from " + tableName + " \uff03NOTCHECK";
        return this.dao.findAll(sql, new AbsModelRepository.Args[0]);
    }

    private List<Map<String, Object>> getParmer(String nodeNo, String type) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)type);
        DsnStructure structure = (DsnStructure)this.dao.findOne((AbsModel)dsn);
        dsn.clear();
        String rates = "select b.attr_name name,b.attr_no code from   dsn_structure a\nleft join dsn_biz_attribute  b\non a.relate_fk=b.biz_uuid\nwhere a.up_node=?";
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(structure.getNodeNo());
        return this.dao.findAll(rates, new AbsModelRepository.Args[]{list});
    }

    private List<Map<String, Object>> queryAttrOption(Map<String, Object> attr) {
        List optionList = this.dao.findAll4Map((AbsModel)((DsnBizAttributeOption)DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, attr.get("biz_uuid")).model()).setOrderBy(new Sort.Order[]{DsnBizAttributeOption.OPTION_ORDER.asc()}));
        return optionList;
    }

    @Override
    public Map<String, Object> getFieldValueApp(List<Map<String, Object>> attrList) {
        HashMap<String, Object> attrValueNew = new HashMap<String, Object>();
        for (Map<String, Object> attrValue : attrList) {
            String key = StrUtils.trimStr((Object)attrValue.get("attr_no"));
            Object value = attrValue.get("field_value");
            attrValueNew.put(key, value);
            if (!"risk_no".equals(key)) continue;
            attrValueNew.put("risk_code", value);
        }
        return attrValueNew;
    }

    @Override
    public List<Map<String, Object>> queryRiskAttrOption(String subUuid, String key) {
        return null;
    }

    @Override
    public String getRiskUuid(String productUuid, String riskNo) {
        return null;
    }

    @Override
    public List<Map<String, Object>> getOrganPrdUuid(String productUuid) {
        return null;
    }

    @Override
    public List<Map<String, Object>> getOrganPrdUuidByChannel(String productUuid, String channelNo, String organId) {
        return null;
    }

    @Override
    public String getRiskUUIDByRiskNo(String riskNo) {
        SipRisks risk4Query = new SipRisks();
        risk4Query.where().addEq(SipRisks.RISK_NO, (Object)riskNo);
        risk4Query.where().addEq(SipRisks.DATA_FLAG, (Object)"1");
        risk4Query = (SipRisks)this.dao.findOne((AbsModel)risk4Query);
        return risk4Query.getRiskUuid();
    }

    @Override
    public DsnStructure getRiskNodeNoByRiskUUID(String riskUUID) {
        DsnStructure dsn = this.getDsnStructure(riskUUID);
        dsn.where().addEq(DsnStructure.NODE_NO, (Object)dsn.getUpNode());
        dsn = (DsnStructure)this.dao.findOne((AbsModel)dsn);
        return dsn;
    }

    @Override
    public String getPrduuidByRiskUUID(String mainRiskUUID) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.NODE_NO, (Object)mainRiskUUID);
        List mainRiskAll = this.dao.findAll((AbsModel)dsn);
        if (mainRiskAll.isEmpty()) {
            return "";
        }
        String prsUuid = ((DsnStructure)mainRiskAll.get(0)).getNodeSeq();
        return prsUuid.substring(0, prsUuid.indexOf(46));
    }

    @Override
    public SipRisks queryRiskByRiskNo(String riskNo) {
        SipRisks risk = new SipRisks();
        risk.where().addEq(SipRisks.RISK_NO, (Object)riskNo);
        List risks = this.dao.findAll((AbsModel)risk);
        return risks == null || risks.isEmpty() ? null : (SipRisks)risks.get(0);
    }

    @Override
    public DsnStructure queryRiskRootNode(String upNodeSeq, String riskUuid) {
        DsnStructure riskDetail = this.getDsnStructure(riskUuid);
        riskDetail.where().addEq(DsnStructure.NODE_NO, (Object)riskDetail.getUpNode());
        riskDetail.where().addEq(DsnStructure.UP_NODE, (Object)"root");
        List structures = this.dao.findAll((AbsModel)riskDetail);
        if (structures.isEmpty()) {
            riskDetail.where().addEq(DsnStructure.NODE_NO, (Object)riskDetail.getUpNode());
            structures = this.dao.findAll((AbsModel)riskDetail);
        }
        for (DsnStructure structure : structures) {
            if (StrUtils.isNull((Object)structure)) continue;
            return structure;
        }
        return null;
    }

    @Override
    public String getRiskDetailNodeBySerno(String newRiskSerno) {
        DsnStructure rootRiskNode = new DsnStructure();
        rootRiskNode.where().addEq(DsnStructure.SERNO, (Object)newRiskSerno);
        rootRiskNode = (DsnStructure)this.dao.findOne((AbsModel)rootRiskNode);
        return this.getRiskUuidByNodeNo(rootRiskNode.getNodeNo());
    }

    @Override
    public String getRiskUuidByNode(DsnStructure riskNode) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.UP_NODE, (Object)riskNode.getNodeNo());
        dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code());
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            throw new BusinessException(new Message("2016003", riskNode.getNodeName() + "\u9669\u79cd\u6570\u636e\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return ((DsnStructure)queryList.get(0)).getNodeNo();
    }

    @Override
    public String getRiskUuidByNodeNo(String upRiskNodeNo) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.UP_NODE, (Object)upRiskNodeNo);
        dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_DETAIL.code());
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            return null;
        }
        return ((DsnStructure)queryList.get(0)).getNodeNo();
    }

    @Override
    public DsnStructure queryRiskAttrByRiskRootNode(String riskNodeNo) {
        DsnStructure dsn = new DsnStructure();
        dsn.where().addEq(DsnStructure.UP_NODE, (Object)riskNodeNo);
        dsn.where().addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_ATTR.code());
        List queryList = this.dao.findAll((AbsModel)dsn);
        if (queryList == null || queryList.isEmpty()) {
            return null;
        }
        return (DsnStructure)queryList.get(0);
    }

    private void getFieldValueOrgan(List<Map<String, Object>> attrList, DsnStructure riskVo, String organPrdUuid, Map<String, Object> param) {
        List riskInfo = this.dao.findAll4Map(SipRisks.n().where().addEq(SipRisks.RISK_UUID, (Object)riskVo.getNodeNo()).model());
        Map risk = riskInfo.isEmpty() ? null : (Map)riskInfo.get(0);
        for (Map<String, Object> attrValue : attrList) {
            this.detalFieldData(riskVo, organPrdUuid, risk, attrValue, param);
        }
    }

    private void detalFieldData(DsnStructure riskVo, String organPrdUuid, Map<String, Object> risk, Map<String, Object> attrValue, Map<String, Object> param) {
        String attrVal;
        String storedTab = StrUtils.trimStr((Object)attrValue.get("stored_tab"));
        String storedField = StrUtils.trimStr((Object)attrValue.get("stored_field"));
        String attrUuid = StrUtils.trimStr((Object)attrValue.get("attr_uuid"));
        String attrNo = StrUtils.trimStr((Object)attrValue.get("attr_no"));
        if ("sip_risks".equalsIgnoreCase(storedTab) && null != risk) {
            if ("risk_no".equals(attrNo)) {
                String policyId = StrUtils.trimStr((Object)risk.get("policy_code"));
                attrValue.put("field_value", policyId);
            } else {
                attrValue.put("field_value", risk.get(storedField));
            }
        }
        if (!StrUtils.isNull((Object)organPrdUuid) && !StrUtils.isNull((Object)(attrVal = this.getNeaUpOrgRiskInfo(StrUtils.trimStr((Object)param.get("risk_uuid")), StrUtils.trimStr((Object)param.get("organ_id")), StrUtils.trimStr((Object)param.get("channel_no")), StrUtils.trimStr((Object)riskVo.getNodeNo()), storedField)))) {
            attrValue.put("field_value", attrVal);
        }
    }

    @Override
    public List<Map<String, Object>> queryRiskAttr(Map<String, Object> param, String nodeNo) {
        String organRiskUuid = StrUtils.trimStr((Object)param.get("organ_prd_uuid"));
        List<Map<String, Object>> optionList = null;
        DsnStructure dsnStructure = new DsnStructure();
        DsnStructure riskAttr = this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_ATTR.code());
        String attr = NodeType.ATTR.code();
        String queryProduct = "SELECT * FROM dsn_structure str  join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type = ?";
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(riskAttr.getNodeNo());
        list.args().add(attr);
        List riskAttrInfo = this.dao.findAll(String.valueOf(queryProduct), new AbsModelRepository.Args[]{list});
        for (Map attrVo : riskAttrInfo) {
            optionList = this.queryAttrOption(attrVo);
            attrVo.put("attrOption", optionList);
            dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)StrUtils.trimStr(attrVo.get("node_no")));
            DsnStructure ruleNo = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
            Map<String, Object> ruleInfo = this.queryRiskRule(ruleNo.getNodeNo(), param, null, null);
            attrVo.put("ruleOption", ruleInfo);
        }
        return riskAttrInfo;
    }

    private DsnStructure getDsnStructure(String riskUuid) {
        DsnStructure riskDetail = new DsnStructure();
        riskDetail.where().addEq(DsnStructure.NODE_NO, (Object)riskUuid);
        riskDetail = (DsnStructure)this.dao.findOne((AbsModel)riskDetail);
        return riskDetail;
    }

    @Override
    public DsnStructure getDsnStructureInfo(String nodeNo, String type) {
        if (NodeType.N_RISK_DETAIL.code().equals(type) || NodeType.N_ACCY_EXEMPT.code().equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        }
        if (NodeType.MAIN_EXEMPT.code().equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        }
        if (NodeType.N_ACCY_RISKS.code().equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        }
        if (NodeType.N_SUB_RISKS_DETAIL.code().equals(type)) {
            return this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_DETAIL.code());
        }
        return this.getDsnStructureByUpNode(nodeNo);
    }

    public DsnStructure getDsnStructureByUpNodeAndNodeType(String nodeNo, String type) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)type);
        return (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
    }

    public List<DsnStructure> getDsnStructureList(String nodeNo, String type) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        dsnStructure.where().addEq(DsnStructure.NODE_TYPE, (Object)type);
        return this.dao.findAll((AbsModel)dsnStructure);
    }

    public DsnStructure getDsnStructureByUpNode(String nodeNo) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.UP_NODE, (Object)nodeNo);
        return (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
    }

    @Override
    public List<SipRisks> queryRiskStructure(List<Map<String, Object>> riskList) {
        SipRisks sipRisks = new SipRisks();
        ArrayList<Map<String, Object>> risks = new ArrayList<Map<String, Object>>();
        sipRisks.where().addNotEq(SipRisks.IS_MAIN_RISK, (Object)"S");
        risks.addAll(riskList);
        riskList.forEach(e -> risks.addAll((List)e.get("additional_risk")));
        ArrayList<SipRisks> returnList = new ArrayList<SipRisks>();
        risks.forEach(risk -> {
            String riskUuid = "";
            if ("common-add".equalsIgnoreCase(StrUtils.trimStr(risk.get("risk_no")))) {
                String riskNo = StrUtils.trimStr(risk.get("risk_no"));
                riskUuid = riskCodeMap.get(riskNo);
            } else {
                riskUuid = riskCodeMap.get(StrUtils.trimStr(risk.get("policy_code")));
            }
            SipRisks sip = new SipRisks();
            sip.where().addEq(SipRisks.RISK_UUID, (Object)riskUuid);
            SipRisks one = (SipRisks)this.dao.findOne((AbsModel)sip);
            if (!StrUtils.isNull((Object)one.getSerno())) {
                returnList.add(one);
            } else if ("common-add".equalsIgnoreCase(StrUtils.trimStr(risk.get("risk_no")))) {
                sipRisks.where().addIn(SipRisks.POLICY_CODE, new String[]{StrUtils.trimStr(risk.get("risk_no"))});
            } else {
                sipRisks.where().addIn(SipRisks.POLICY_CODE, new String[]{StrUtils.trimStr(risk.get("policy_code"))});
            }
        });
        List risksList = this.dao.findAll((AbsModel)sipRisks);
        ArrayList risksListNew = new ArrayList();
        risksList.forEach(e -> {
            DsnStructure riskNodeNoByRiskUUID = this.getRiskNodeNoByRiskUUID(e.getRiskUuid());
            if (!"root".equalsIgnoreCase(riskNodeNoByRiskUUID.getNodeType())) {
                risksListNew.add(e);
            }
        });
        Map<String, List<SipRisks>> collect = risksListNew.stream().collect(Collectors.groupingBy(SipRisks::getPolicyCode));
        if (!collect.isEmpty()) {
            collect.forEach((k, v) -> returnList.add((SipRisks)v.get(0)));
        }
        return returnList;
    }

    @Override
    public String ruleNodeNo(String productUuid, String type) {
        DsnStructure riskDsn = this.getDsnStructure(productUuid);
        DsnStructure ruleDsn = this.getDsnStructureByUpNodeAndNodeType(riskDsn.getUpNode(), NodeType.N_RULE.code());
        DsnStructure insureRuleDsn = this.getDsnStructureByUpNodeAndNodeType(ruleDsn.getNodeNo(), type);
        return insureRuleDsn.getNodeNo();
    }

    @Override
    public List<DsnStructure> queryNewRiskUuid(String productUuid) {
        return null;
    }

    @Override
    public String queryPolicyCodeBySerno(String serno) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.SERNO, (Object)serno);
        DsnStructure addRiskNode = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
        DsnStructure addRiskDetail = this.getDsnStructureByUpNodeAndNodeType(addRiskNode.getNodeNo(), NodeType.N_RISK_DETAIL.code());
        SipRisks risk = new SipRisks();
        risk.where().addEq(SipRisks.RISK_UUID, (Object)addRiskDetail.getNodeNo());
        SipRisks riskResult = (SipRisks)this.dao.findOne((AbsModel)risk);
        return riskResult.getPolicyCode();
    }

    @Override
    public String queryPolicyCodeByAdd(String nodeNo) {
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)nodeNo);
        DsnStructure upNode = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
        DsnStructure addRiskDetail = this.getDsnStructureByUpNodeAndNodeType(upNode.getUpNode(), NodeType.N_RISK_DETAIL.code());
        SipRisks risk = new SipRisks();
        risk.where().addEq(SipRisks.RISK_UUID, (Object)addRiskDetail.getNodeNo());
        SipRisks riskResult = (SipRisks)this.dao.findOne((AbsModel)risk);
        return riskResult.getPolicyCode();
    }

    @Override
    public boolean validRiskCommon(String addNodeNo, String mainNodeNo) {
        return false;
    }

    @Override
    public List<SipRisks> queryRiskByRiskClassify() {
        SipRisks sipRisks = new SipRisks();
        sipRisks.where().addLike(SipRisks.RISK_CLASSIFY, (Object)"904");
        return this.dao.findAll((AbsModel)sipRisks);
    }

    @Override
    public List<SipRisks> queryRiskByRiskClassify2() {
        SipRisks sipRisks = new SipRisks();
        sipRisks.where().addLike(SipRisks.RISK_CLASSIFY, (Object)"903");
        return this.dao.findAll((AbsModel)sipRisks);
    }

    @Override
    public List<Map<String, Object>> queryRiskAttrForNodeNo(String nodeNo) {
        List<Map<String, Object>> optionList = null;
        DsnStructure riskAttr = this.getDsnStructureByUpNodeAndNodeType(nodeNo, NodeType.N_RISK_ATTR.code());
        String attr = NodeType.ATTR.code();
        String queryProduct = "SELECT attr.attr_no,attr.attr_name,str.display_order,attr.biz_uuid FROM dsn_structure str  join dsn_biz_attribute attr on str.node_no = attr.biz_uuid WHERE str.up_node = ? and str.node_type = ?";
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.args().add(riskAttr.getNodeNo());
        list.args().add(attr);
        List riskAttrInfo = this.dao.findAll(queryProduct, new AbsModelRepository.Args[]{list});
        for (Map attrVo : riskAttrInfo) {
            optionList = this.queryAttrOption(attrVo);
            attrVo.put("attrOption", optionList);
        }
        return riskAttrInfo;
    }

    private String getNeaUpOrgRiskInfo(String productUuid, String organId, String channelNo, String riskUuid, String key) {
        SipOrganRiskInfo organRiskInfo;
        SipOrganProducts organProduct = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid).addEq(SipOrganProducts.ORGAN_ID, (Object)organId).addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model());
        if (organProduct != null && null != (organRiskInfo = (SipOrganRiskInfo)this.dao.findOne(SipOrganRiskInfo.n().where().addEq(SipOrganRiskInfo.ORGAN_PRD_UUID, (Object)organId).addEq(SipOrganRiskInfo.RISK_UUID, (Object)riskUuid).addEq(SipOrganRiskInfo.ATTR_NO, (Object)key).addEq(SipOrganRiskInfo.DATA_FLAG, (Object)"1").model()))) {
            return organRiskInfo.getAttrValue();
        }
        String sql = "select c.parent_id,c.organ_id,c.company_name,c.class_id from ws_life_t_company_organ  c where c.organ_id = ? and c.data_flag = ? ";
        Map map = this.dao.getJdbcTemplate().queryForMap(sql, new Object[]{organId, "1"});
        String parentOrganId = (String)map.get("parent_id");
        if (StrUtils.isNull((Object)parentOrganId)) {
            return null;
        }
        return this.getNeaUpOrgRiskInfo(productUuid, parentOrganId, channelNo, riskUuid, key);
    }

    @Override
    public Map<String, Object> queryRiskRule(String ruleNo, Map<String, Object> param, Map<String, Object> product, Map<String, Object> riskDetailInfo) {
        HashMap<String, Object> riskRule = new HashMap<String, Object>();
        String productUuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        String organId = StrUtils.trimStr((Object)param.get("organ_id"));
        String channelNo = StrUtils.trimStr((Object)param.get("channel_no"));
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        String addBatch = StrUtils.trimStr((Object)param.get("add_batch"));
        List configRuleList = NodeType.RULE_LIST;
        Iterator iterator = configRuleList.iterator();
        while (iterator.hasNext()) {
            String configRule;
            String ruleName = configRule = (String)iterator.next();
            String key = RiskDaoImpl.toCamelCase(ruleName);
            Map<String, Object> initRuleInfo = this.queryRule(deliveryPlatform, addBatch, ruleNo, ruleName, productUuid, organId, channelNo, product, riskDetailInfo);
            riskRule.put(key, initRuleInfo);
        }
        ArrayList<DsnRules> msgRules = new ArrayList<DsnRules>();
        HashSet<String> setMsfMethod = new HashSet<String>();
        setMsfMethod.add("smm");
        setMsfMethod.add("sawm");
        setMsfMethod.add("sdm");
        for (String key : riskRule.keySet()) {
            if (RiskDaoImpl.toCamelCase(NodeType.FEE_FINISH_RULE.code()).equals(key)) continue;
            Map map = (Map)riskRule.get(key);
            List list = (List)map.get("headRuleInfo");
            block2: for (DsnRules rule : list) {
                for (String msfMethod : setMsfMethod) {
                    if (!rule.getRuleInfo().contains(msfMethod)) continue;
                    msgRules.add(rule);
                    continue block2;
                }
            }
        }
        riskRule.put("msg_rule", msgRules);
        return riskRule;
    }

    private Map<String, Object> queryRule(String deliveryPlatform, String addBatch, String ruleNo, String nodeType, String productUuid, String organId, String channelNo, Map<String, Object> product, Map<String, Object> riskDetail) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DsnStructure dsnStruct = new DsnStructure();
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)ruleNo);
        dsnStruct.where().addEq(DsnStructure.NODE_TYPE, (Object)nodeType);
        final DsnStructure rule = (DsnStructure)this.dao.findOne((AbsModel)dsnStruct);
        if (rule == null) {
            return null;
        }
        dsnStruct.where().addEq(DsnStructure.UP_NODE, (Object)rule.getNodeNo());
        List allRule = this.dao.findAll((AbsModel)dsnStruct);
        ArrayList<Object> queryRuleInfoList = new ArrayList<Object>();
        HashMap<String, Object> organRulesMap = new HashMap<String, Object>();
        ArrayList queryOrganRuleInfo = new ArrayList();
        for (DsnStructure dsnRule : allRule) {
            FkRulesReqParam param = new FkRulesReqParam();
            param.setRelateField("node_no");
            param.setRelateFk(dsnRule.getNodeNo());
            param.setRelateTab("dsn_structure");
            ReturnMsg msg = this.ruleUsedService.queryFkRules(param);
            if (!msg.isSuccessflag()) {
                throw new BusinessException((Message)msg.getMsgList().get(0));
            }
            Map dsnRules = JsonUtils.json2Map((String)JsonUtils.toJson(msg.getDataTable().get("dsn_rules")));
            String ruleInfo = StrUtils.trimStr(dsnRules.get("rule_info"));
            List dsnRulesConstList = JsonUtils.json2List((String)JsonUtils.toJson(msg.getDataTable().get("dsn_rules_const")), DsnRulesConst.class);
            for (DsnRulesConst factInfo : dsnRulesConstList) {
                if ("rearEnd".equals(StrUtils.trimStr(dsnRules.get("use_scene")))) continue;
                String constMapping = factInfo.getConstMapping();
                String constId = factInfo.getConstId();
                String[] factSplit = constId.split("\\.");
                String key = factSplit[1];
                String value = factSplit[2];
                boolean isNumber = false;
                ruleInfo = this.getRuleInfo(product, riskDetail, ruleInfo, constMapping, key, value, isNumber);
            }
            List dsnRulesParamList = JsonUtils.json2List((String)JsonUtils.toJson(msg.getDataTable().get("dsn_rules_param")), DsnRulesParam.class);
            for (DsnRulesParam rulesParam : dsnRulesParamList) {
                String a = StrUtils.trimStr(dsnRules.get("rule_template_id")) + ".###" + rulesParam.getParamCode() + "###";
                String paramStr = rulesParam.getParamFact().replaceAll("\"", "\\\\\"");
                ruleInfo = ruleInfo.replace(a, paramStr);
            }
            dsnRules.put("rule_info", ruleInfo);
            queryRuleInfoList.add(JsonUtils.map2Class((Map)dsnRules, DsnRules.class));
        }
        HashMap<String, Object> funcNeedParam = new HashMap<String, Object>();
        funcNeedParam.put("node_no", rule.getNodeNo());
        this.replaceOrganConfigInfo(productUuid, deliveryPlatform, addBatch, organId, channelNo, funcNeedParam, organRulesMap, new IConfigFunction(){

            @Override
            public void replaceOrganConfig(Map<String, Object> funcParam, Map<String, Object> resultMap) {
                SipOrganRules organRules = new SipOrganRules();
                organRules.where().addEq(SipOrganRules.NODE_NO, funcParam.get("node_no"));
                organRules.where().addEq(SipOrganRules.ORGAN_PRD_UUID, funcParam.get("organ_prd_uuid"));
                List findOrganRule = RiskDaoImpl.this.dao.findAll((AbsModel)organRules);
                if (null != findOrganRule && !findOrganRule.isEmpty()) {
                    for (SipOrganRules one : findOrganRule) {
                        resultMap.put(rule.getNodeNo(), one);
                    }
                }
            }
        });
        result.put("headRuleInfo", queryRuleInfoList);
        return result;
    }

    @Override
    public Map<String, Object> queryRuleNew(String riskUuid, Map<String, Object> product, Map<String, Object> riskDetail) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> queryRuleInfoList = new ArrayList<Object>();
        List structureRulesList = this.dao.findAll(DsnStructureRules.n().where().addEq(DsnStructureRules.RISK_UUID, (Object)riskUuid).addEq(DsnStructureRules.STATUS, (Object)"1").model());
        result.put("riskRuleRelation", structureRulesList);
        Set ruleIdSet = structureRulesList.stream().filter(a -> a.getStatus().equals("1")).map(p -> {
            if ("Y".equals(p.getIsQuote())) {
                return p.getQuoteRuleId();
            }
            return p.getRuleId();
        }).collect(Collectors.toSet());
        for (String ruleId : ruleIdSet) {
            ReturnMsg msg = this.ruleUsedService.queryRuleInfoByRuleId(ruleId);
            if (!msg.isSuccessflag()) {
                throw new BusinessException((Message)msg.getMsgList().get(0));
            }
            Map dsnRules = JsonUtils.json2Map((String)JsonUtils.toJson(msg.getDataTable().get("dsn_rules")));
            String ruleInfo = StrUtils.trimStr(dsnRules.get("rule_info"));
            List dsnRulesConstList = JsonUtils.json2List((String)JsonUtils.toJson(msg.getDataTable().get("dsn_rules_const")), DsnRulesConst.class);
            for (DsnRulesConst factInfo : dsnRulesConstList) {
                if ("rearEnd".equals(StrUtils.trimStr(dsnRules.get("use_scene")))) continue;
                String constMapping = factInfo.getConstMapping();
                String constId = factInfo.getConstId();
                String[] factSplit = constId.split("\\.");
                String key = factSplit[1];
                String value = factSplit[2];
                boolean isNumber = false;
                ruleInfo = this.getRuleInfo(product, riskDetail, ruleInfo, constMapping, key, value, isNumber);
            }
            List dsnRulesParamList = JsonUtils.json2List((String)JsonUtils.toJson(msg.getDataTable().get("dsn_rules_param")), DsnRulesParam.class);
            for (DsnRulesParam rulesParam : dsnRulesParamList) {
                String a2 = StrUtils.trimStr(dsnRules.get("rule_template_id")) + ".###" + rulesParam.getParamCode() + "###";
                String paramFact = rulesParam.getParamFact();
                String paramStr = "";
                if (paramFact.contains("option_json") && paramFact.contains("\\\"")) {
                    paramStr = paramFact.replaceAll("\\\\\"", "------");
                    paramStr = paramStr.replaceAll("\"", "\\\\\"");
                    paramStr = paramStr.replaceAll("------", "\\\\\\\\\\\\\"");
                } else {
                    paramStr = paramFact.replaceAll("\"", "\\\\\"");
                }
                ruleInfo = ruleInfo.replace(a2, paramStr);
            }
            dsnRules.put("rule_info", ruleInfo);
            queryRuleInfoList.add(JsonUtils.map2Class((Map)dsnRules, DsnRules.class));
        }
        result.put("riskRule", queryRuleInfoList);
        return result;
    }

    @Override
    public void replaceOrganConfigInfo(String productUuid, String deliveryPlatform, String addBatch, String organId, String channelNo, Map<String, Object> funcNeedParam, Map<String, Object> resultMap, IConfigFunction function) {
        String curOrganId = "1000000";
        int endIndex = 1;
        while (true) {
            List sipOrganProductsList;
            SipOrganProducts sopSelect = new SipOrganProducts();
            sopSelect.where().addEq(SipOrganProducts.ORGAN_ID, (Object)curOrganId);
            sopSelect.where().addEq(SipOrganProducts.IS_ENABLE, (Object)"ON");
            sopSelect.where().addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo);
            sopSelect.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
            sopSelect.where().addLike(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform);
            sopSelect.where().addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model();
            if (organId.equals(curOrganId) && !StrUtils.isNull((Object)addBatch)) {
                sopSelect.where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)addBatch).model();
            }
            if ((sipOrganProductsList = this.dao.findAll((AbsModel)sopSelect)) != null) {
                if (sipOrganProductsList.size() == 1) {
                    funcNeedParam.put("organ_prd_uuid", ((SipOrganProducts)sipOrganProductsList.get(0)).getOrganPrdUuid());
                    function.replaceOrganConfig(funcNeedParam, resultMap);
                }
                if (sipOrganProductsList.size() > 1) {
                    for (SipOrganProducts sipOrganProducts : sipOrganProductsList) {
                        if (!sipOrganProducts.getOrganPrdUuid().equals(addBatch)) continue;
                        funcNeedParam.put("organ_prd_uuid", ((SipOrganProducts)sipOrganProductsList.get(0)).getOrganPrdUuid());
                        function.replaceOrganConfig(funcNeedParam, resultMap);
                    }
                }
            }
            if (organId.equals(curOrganId)) break;
            curOrganId = organId.substring(0, endIndex += 2).concat(curOrganId.substring(endIndex));
        }
    }

    public static String toCamelCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String getRuleInfo(Map<String, Object> product, Map<String, Object> riskDetail, String ruleInfo, String fact, String key, String value, boolean isNumber) {
        String data = null;
        if ("prd_details".equals(key)) {
            String valueIndex = StrUtils.trimStr((Object)product.get(value));
            try {
                Double.parseDouble(valueIndex);
                isNumber = true;
            }
            catch (Exception e) {
                Ulog.info((String)"\u5e38\u91cf\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b");
            }
            data = valueIndex;
        } else {
            String valueIndex = StrUtils.trimStr((Object)riskDetail.get(value));
            try {
                Double.parseDouble(valueIndex);
                isNumber = true;
            }
            catch (Exception e) {
                Ulog.info((String)"\u5e38\u91cf\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b");
            }
            data = valueIndex;
        }
        ruleInfo = isNumber ? ruleInfo.replace(fact, data.toString()) : ruleInfo.replace(fact, "'" + data.toString() + "'");
        return ruleInfo;
    }

    static {
        riskCodeMap.put("D4R", "NLsUpu9q");
        riskCodeMap.put("982", "r7mmDkAl");
        riskCodeMap.put("983", "E96lIUMb");
        riskCodeMap.put("984", "OsxUBFZm");
        riskCodeMap.put("682", "y3nduygq");
        riskCodeMap.put("common-add", "7hPRKPZF");
    }
}

