/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.config.service.impl;

import com.newtouch.nms.sip.design.tree.services.IPublicTreeService;
import com.newtouch.nms.sip.model.DsnAttribute;
import com.newtouch.nms.sip.model.DsnAttributeOption;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipOrganProductInfo;
import com.newtouch.nms.sip.model.SipOrganProducts;
import com.newtouch.nms.sip.model.SipOrganProductsHistory;
import com.newtouch.nms.sip.model.SipOrganRiskInfo;
import com.newtouch.nms.sip.model.SipOrganRiskRelation;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.SipProductsChannel;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.SysEnumConf;
import com.newtouch.nms.sip.model.WsLifeTCompanyOrgan;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.config.service.IProductConfigService;
import com.newtouch.nms.sip.product.main.services.IProductCopyService;
import com.newtouch.nms.sip.product.risk.services.IRiskService;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.model.sys.SysEnum;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.DBTypes;
import com.uniapis.repository.core.callback.RowCallback;
import com.uniapis.rms.model.RmsUser;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"springContext"})
public class ProductConfigServiceImp
implements IProductConfigService {
    private static final String AGENCY_ORGAN_FLAG = "100";
    private static final String AGENTCATENAME = "\u56e2\u9669\u4e2d\u4ecb";
    @Autowired
    private AbsModelRepository dao;
    @Value(value="${sqlPath:}")
    private String sqlPath;
    @Autowired
    private IPublicTreeService publicTreeService;
    @Autowired
    private IRiskService riskServiceImp;
    private String info01 = "\u8bf7\u6c42\u6570\u636e\uff1a||";
    private String info02 = "\u8bf7\u6c42\u8def\u5f84\uff1a";
    private String info03 = "\u54cd\u5e94\u6570\u636e\uff1a[";
    private String errMsg01 = "\u4ea7\u54c1\u914d\u7f6e\u670d\u52a1\u3010module-product-engine\u3011\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002";
    private final String IS_TEMPLATE = "Y";
    private final String NOT_TEMPLATE = "N";
    private final List detailNodeTypeList = new ArrayList();
    @Autowired
    private IProductCopyService copyProduct;
    private final String product_uuid_tag = "product_uuid";
    private final String organ_tag = "organ";
    private final String start_date_tag = "date";
    private final String file_no_tag = "file_no";
    private final String riskRelationSernoList_tag = "riskRelationSernoList";
    private final String class_1_tag = "class_1";
    private final String class_2_tag = "class_2";
    private final String class_3_tag = "class_3";
    private final String class_4_tag = "class_4";
    private final String class_100_tag = "class_100";

    public ProductConfigServiceImp() {
        this.detailNodeTypeList.add(NodeType.N_RISK_DETAIL.code());
        this.product_uuid_tag = "product_uuid";
        this.organ_tag = "organ";
        this.start_date_tag = "date";
        this.file_no_tag = "file_no";
        this.riskRelationSernoList_tag = "riskRelationSernoList";
        this.class_1_tag = "class_1";
        this.class_2_tag = "class_2";
        this.class_3_tag = "class_3";
        this.class_4_tag = "class_4";
        this.class_100_tag = "class_100";
    }

    private void copyAttributeTable(String oldNodeNo, String node_no) {
        DsnBizAttribute biz_attr = new DsnBizAttribute();
        biz_attr.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)oldNodeNo);
        biz_attr = (DsnBizAttribute)this.dao.findOne((AbsModel)biz_attr);
        String attr_uuid = "";
        String old_attr_uuid = "";
        if (biz_attr != null) {
            attr_uuid = UUID.shortUUID();
            old_attr_uuid = biz_attr.getAttrUuid();
            if (!StrUtils.isNull((Object)biz_attr.getBizUuid())) {
                biz_attr.setAttrUuid(attr_uuid);
                biz_attr.setBizUuid(node_no);
                biz_attr.setSerno(UUID.shortUUID());
                this.dao.save((AbsModel)biz_attr);
            }
        }
        DsnBizAttributeOption biz_attr_option = new DsnBizAttributeOption();
        biz_attr_option.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)oldNodeNo);
        biz_attr_option.setOrderBy(new Sort.Order[]{DsnBizAttributeOption.OPTION_ORDER.asc()});
        List biz_attr_optionList = this.dao.findAll((AbsModel)biz_attr_option);
        if (biz_attr_optionList != null && !biz_attr_optionList.isEmpty()) {
            for (DsnBizAttributeOption option : biz_attr_optionList) {
                option.setSerno(UUID.shortUUID());
                option.setBizUuid(node_no);
                option.setOptionNo(UUID.shortUUID());
                this.dao.save((AbsModel)option);
            }
        }
        DsnAttribute attr = new DsnAttribute();
        attr.where().addEq(DsnAttribute.ATTR_UUID, (Object)old_attr_uuid);
        attr = (DsnAttribute)this.dao.findOne((AbsModel)attr);
        if (attr != null && !StrUtils.isNull((Object)attr.getAttrUuid())) {
            attr.setSerno(UUID.shortUUID());
            attr.setAttrUuid(attr_uuid);
            this.dao.save((AbsModel)attr);
        }
        DsnAttributeOption attr_option = new DsnAttributeOption();
        attr_option.where().addEq(DsnAttributeOption.ATTR_UUID, (Object)old_attr_uuid);
        attr_option.setOrderBy(new Sort.Order[]{DsnAttributeOption.OPTION_ORDER.asc()});
        List attr_optionList = this.dao.findAll((AbsModel)attr_option);
        if (attr_optionList != null && !attr_optionList.isEmpty()) {
            String finalAttr_uuid = attr_uuid;
            attr_optionList.stream().forEach(x -> {
                x.setSerno(UUID.shortUUID());
                x.setAttrUuid(finalAttr_uuid);
                this.dao.save((AbsModel)x);
            });
        }
    }

    @Override
    public ReturnMsg delProduct(Map<String, Object> param) {
        Return r = new Return();
        List newListParam = (List)param.get("checkbox");
        for (Map tempMap : newListParam) {
            if ("ALL".equals(StrUtils.trimStr(tempMap.get("open_state"))) || "PART".equals(StrUtils.trimStr(tempMap.get("open_state")))) {
                r.setFailMsg("\u5f00\u653e\u72b6\u6001\u4e3a\u90e8\u5206\u9500\u552e\u548c\u5168\u90e8\u9500\u552e\u7684\u4ea7\u54c1\u4e0d\u80fd\u5220\u9664");
                break;
            }
            String product_uuid = StrUtils.trimStr(tempMap.get("true_product_uuid"));
            SipProducts sp = new SipProducts();
            sp.where().addEq(SipProducts.PRODUCT_UUID, (Object)product_uuid);
            this.dao.delete((AbsModel)sp);
            List subNodes = null;
            for (DsnStructure subNode : subNodes) {
                String nodeType = subNode.getNodeType();
                if (NodeType.PRD_DETAIL.code().equals(nodeType)) {
                    this.deleteAttrDetail(subNode.getNodeSeq(), "attr_detail");
                }
                if (!NodeType.N_RISK.code().equals(nodeType)) continue;
                this.deleteRisk(subNode);
            }
            DsnStructure dsn = new DsnStructure();
            dsn.where().addEq(DsnStructure.NODE_NO, (Object)product_uuid);
            this.dao.delete((AbsModel)dsn);
        }
        return r.msg();
    }

    private void deleteRisk(DsnStructure subNode) {
        List riskNodeList = null;
        if (StrUtils.isNull(riskNodeList) || riskNodeList.isEmpty()) {
            return;
        }
        for (DsnStructure riskNode : riskNodeList) {
            this.deleteSubRisk(riskNode);
        }
    }

    @Override
    public void deleteSubRisk(DsnStructure riskNode) {
        DsnStructure main = new DsnStructure();
        main.where().addEq(DsnStructure.NODE_NO, (Object)riskNode.getNodeNo());
        List riskList = this.dao.findAll((AbsModel)main);
        boolean delSubflag = false;
        if (riskList.size() == 1) {
            delSubflag = true;
        } else if (riskList.size() == 2) {
            for (DsnStructure structureTemp : riskList) {
                if (!StrUtils.isNull((Object)structureTemp.getUpNode())) continue;
                delSubflag = true;
                break;
            }
        }
        if (delSubflag) {
            this.deleteRiskDetail(riskNode, riskNode.getNodeType());
            return;
        }
    }

    @Override
    public void getProductfrom3rdPiccLife(Map<String, Object> param) throws Exception {
        Ulog.info((String)("\u8f6c\u6362\u540e\u62a5\u6587\uff1a" + JsonUtils.toJson(param)));
    }

    @Override
    public ReturnMsg mdfOpenState(Map<String, Object> param) {
        Return _return = new Return();
        String openState = StrUtils.trimStr((Object)param.get("open_state"));
        String productUuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        if (StrUtils.isNull((Object)productUuid)) {
            _return.setFailMsg("\u4ea7\u54c1\u7f16\u7801\u5fc5\u987b\u4f20\u5165\u3002");
            return _return.msg();
        }
        SipProducts product = new SipProducts();
        product.where().addEq(SipProducts.PRODUCT_UUID, (Object)productUuid);
        product = (SipProducts)this.dao.findOne((AbsModel)product);
        product.setOpenState(openState);
        product.where().addEq(SipProducts.PRODUCT_UUID, (Object)productUuid);
        int update = this.dao.update((AbsModel)product);
        if (update < 1) {
            _return.setFailMsg("\u72b6\u6001\u4fee\u6539\u5931\u8d25\u3002");
            return _return.msg();
        }
        SipProducts siProducts = new SipProducts();
        siProducts.setProductName("");
        siProducts.setProductNo("");
        siProducts.setState("");
        return _return.msg();
    }

    @Override
    public Return deleteRiskDetail(DsnStructure deleteRisk, String deleteRiskNodeType) {
        Return _return = new Return();
        String nodeSeq = deleteRisk.getNodeSeq();
        String riskNodeNo = deleteRisk.getNodeNo();
        List subNodes = null;
        String riskUUid = "";
        for (DsnStructure subNode : subNodes) {
            String nodeType = subNode.getNodeType();
            String subNodeSeq = subNode.getNodeSeq();
            if (this.detailNodeTypeList.contains(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, NodeType.ATTR_DETAIL.code());
            }
            if (NodeType.N_RISK_ATTR.code().equals(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, NodeType.ATTR.code());
            }
            if (NodeType.N_ACCY_RISKS.code().equals(nodeType)) {
                this.deleteRisk(subNode);
            }
            if (NodeType.MAIN_EXEMPT.code().equals(nodeType)) {
                this.deleteRisk(subNode);
            }
            if (NodeType.N_RULE.code().equals(nodeType)) {
                this.deleteRule(subNode);
            }
            if (NodeType.N_RATE.code().equals(nodeType)) {
                this.deleteRatesGroup(deleteRisk, riskUUid);
            }
            if (NodeType.N_BENEFIT.code().equals(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, NodeType.ATTR4LIABILITY.code());
            }
            if (NodeType.N_TBR.code().equals(nodeType)) {
                _return = this.deleteAttrDetail(subNodeSeq, NodeType.TBR_ATTR.code());
            }
            if (NodeType.N_BBR.code().equals(nodeType)) {
                this.deleteAttrDetail(subNodeSeq, NodeType.BBR_ATTR.code());
            }
            if (!NodeType.N_SYR.code().equals(nodeType)) continue;
            this.deleteAttrDetail(subNodeSeq, NodeType.SYR_ATTR.code());
        }
        this.delSipRisk(riskUUid);
        return _return;
    }

    private void delSipRisk(String riskUUid) {
        SipRisks risks = new SipRisks();
        risks.where().addEq(SipRisks.RISK_UUID, (Object)riskUUid);
        this.dao.delete((AbsModel)risks);
    }

    private Return deleteRatesGroup(DsnStructure risk, String riskUUid) {
        Return _return = new Return();
        String sql = "select * from DsnStructure where up_node = (select node_no from DsnStructure where up_node = ? and node_type = ?)";
        ArrayList<String> list = new ArrayList<String>();
        list.add(risk.getNodeNo());
        list.add("n_rate");
        List rateList = this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(list)});
        for (Map rate : rateList) {
            DsnStructure attrRate = new DsnStructure();
            attrRate.where().addLikeR(DsnStructure.NODE_SEQ, rate.get("node_seq"));
            attrRate.where().addEq(DsnStructure.NODE_TYPE, (Object)"attr4Rate");
            List attrRateList = this.dao.findAll((AbsModel)attrRate);
            _return = this.deleteAttribute(attrRateList, "attr4Rate");
            attrRate.where().addLikeR(DsnStructure.NODE_SEQ, rate.get("node_seq"));
            this.dao.delete((AbsModel)attrRate);
            DsnDynamicData dynamicData = new DsnDynamicData();
            dynamicData.where().addEq(DsnDynamicData.RELATE_FK, rate.get("node_no"));
            dynamicData = (DsnDynamicData)this.dao.findOne((AbsModel)dynamicData);
            if (!StrUtils.isNull((Object)riskUUid) && !StrUtils.isNull((Object)dynamicData.getField2())) {
                String rateTableName = "dsn_rate_" + riskUUid.toLowerCase() + "_" + dynamicData.getField2();
                String drop = "";
                if (DBTypes.ORACLE.equals((Object)this.dao.getDbType())) {
                    try {
                        drop = "drop table " + rateTableName;
                    }
                    catch (Exception e) {
                        Ulog.info((String)"oracle \u6ca1\u6709if exsit \u8bed\u6cd5\u6545\u6355\u83b7\u8be5\u5f02\u5e38");
                    }
                } else if (DBTypes.MYSQL.equals((Object)this.dao.getDbType())) {
                    drop = "drop table if exists " + rateTableName;
                } else {
                    throw new BusinessException("\u5f53\u524d\u6570\u636e\u7c7b\u7c7b\u578b\u6682\u65f6\u6ca1\u6709\u5339\u914d\uff01");
                }
                this.dao.update(drop, new Object[0]);
                this.dao.getJdbcTemplate().execute(drop);
            }
            dynamicData.where().addEq(DsnDynamicData.RELATE_FK, rate.get("node_no"));
            this.dao.delete((AbsModel)dynamicData);
        }
        DsnStructure rateGroup = new DsnStructure();
        rateGroup.where().addEq(DsnStructure.UP_NODE, (Object)risk.getNodeNo());
        rateGroup.where().addEq(DsnStructure.NODE_TYPE, (Object)"n_rate");
        this.dao.delete((AbsModel)rateGroup);
        return _return;
    }

    private Return deleteRule(DsnStructure rule) {
        Return r = new Return();
        rule.where().addLikeR(DsnStructure.NODE_SEQ, (Object)rule.getNodeSeq());
        rule.where().addEq(DsnStructure.NODE_TYPE, (Object)"rule");
        List ruleList = this.dao.findAll((AbsModel)rule);
        rule.where().addLikeR(DsnStructure.NODE_SEQ, (Object)rule.getNodeSeq());
        if (!StrUtils.isNull((Object)rule.getNodeSeq())) {
            this.dao.delete((AbsModel)rule);
        }
        return r;
    }

    private Return deleteAttrDetail(String node_seq, String node_type) {
        Return r = new Return();
        DsnStructure attr_detail = new DsnStructure();
        attr_detail.where().addLikeR(DsnStructure.NODE_SEQ, (Object)node_seq);
        attr_detail.where().addEq(DsnStructure.NODE_TYPE, (Object)node_type);
        List attr_detailList = this.dao.findAll((AbsModel)attr_detail);
        r = this.deleteAttribute(attr_detailList, node_type);
        attr_detail.where().addLikeR(DsnStructure.NODE_SEQ, (Object)node_seq);
        attr_detail.where().addEq(DsnStructure.NODE_TYPE, (Object)node_type);
        this.dao.delete((AbsModel)attr_detail);
        return r;
    }

    private Return deleteAttribute(List<DsnStructure> attrList, String node_type) {
        Return r = new Return();
        for (DsnStructure detail : attrList) {
            DsnBizAttribute attr_biz = new DsnBizAttribute();
            attr_biz.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)detail.getNodeNo());
            attr_biz = (DsnBizAttribute)this.dao.findOne((AbsModel)attr_biz);
            attr_biz.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)detail.getNodeNo());
            this.dao.delete((AbsModel)attr_biz);
            DsnBizAttributeOption biz_option = new DsnBizAttributeOption();
            biz_option.where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)detail.getNodeNo());
            this.dao.delete((AbsModel)biz_option);
            DsnAttribute attr = new DsnAttribute();
            attr.where().addEq(DsnAttribute.ATTR_UUID, (Object)attr_biz.getAttrUuid());
            attr = (DsnAttribute)this.dao.findOne((AbsModel)attr);
            attr.where().addEq(DsnAttribute.ATTR_UUID, (Object)attr_biz.getAttrUuid());
            this.dao.delete((AbsModel)attr);
            DsnAttributeOption dsn_option = new DsnAttributeOption();
            dsn_option.where().addEq(DsnAttributeOption.ATTR_UUID, (Object)attr.getAttrUuid());
            this.dao.delete((AbsModel)dsn_option);
            DsnStructure rule = new DsnStructure();
            rule.where().addEq(DsnStructure.UP_NODE, (Object)detail.getNodeNo());
            if (!"attr4Liability".equals(node_type)) {
                if (!StrUtils.isNull((Object)(rule = (DsnStructure)this.dao.findOne((AbsModel)rule)).getNodeNo())) {
                    r = this.deleteRule(rule);
                }
            } else {
                List list = this.dao.findAll((AbsModel)rule);
            }
            DsnStructure dsn = new DsnStructure();
            dsn.where().addEq(DsnStructure.NODE_SEQ, (Object)detail.getNodeSeq());
            this.dao.delete((AbsModel)dsn);
        }
        return r;
    }

    @Override
    public ReturnMsg copyProduct(String sourceNodeNo, String targetPrdName, String isMaster, Map<String, String> riskName) {
        String master = "Y";
        if ("\u5426".equals(isMaster)) {
            master = "N";
        }
        SipProducts product = this.copyProduct.copyProduct(sourceNodeNo, targetPrdName, riskName);
        Return msg = new Return();
        msg.getDataTable().put("node_no", product.getProductUuid());
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProductChannel(Map<String, Object> param) {
        String product_uuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        SysEnumConf sysEnumConf = new SysEnumConf();
        sysEnumConf.where().addEq(SysEnumConf.UP_ENUM, (Object)"channel_type");
        List enumList = this.dao.findAll((AbsModel)sysEnumConf);
        SipProductsChannel spc = new SipProductsChannel();
        spc.where().addEq(SipProductsChannel.PRODUCT_UUID, (Object)product_uuid);
        spc.where().addCallback((RowCallback & Serializable)(aSpc, spcList, i) -> {
            SysEnumConf aChannel = enumList.stream().filter(o -> o.getEnumCode().equals(aSpc.getChannelNo())).findAny().orElse(null);
            aSpc.getOtherProperty().put("channel_name", aChannel.getEnumName());
        });
        List spcList2 = this.dao.findAll((AbsModel)spc);
        Return r = new Return();
        if (spcList2.size() > 0) {
            r.setDataList(spcList2, SipProductsChannel.class);
        }
        return r.msg();
    }

    public ReturnMsg queryFindAllOrgan(Map<String, Object> param) {
        Return r = new Return();
        String organ_id = StrUtils.trimStr((Object)param.get("organ_id"));
        return null;
    }

    @Override
    public ReturnMsg queryAllOrgan(Map<String, Object> param) {
        Return msg = new Return();
        String redisOrganDataStr = StrUtils.trimStr((Object)CacheManager.get((String)"organData"));
        if (redisOrganDataStr.isEmpty()) {
            String sql = "select c.parent_id,c.organ_id,c.company_name,c.class_id from ws_life_t_company_organ  c where c.data_flag = ? ";
            List organTree = this.dao.getJdbcTemplate().queryForList(sql, new Object[]{"1"});
            CacheManager.put((String)"organData", (Object)JsonUtils.toJson((Object)organTree));
            msg.setDataList(organTree);
            return msg.msg();
        }
        List redisOrganData = JsonUtils.json2List((String)StrUtils.trimStr((Object)redisOrganDataStr));
        msg.setDataList(redisOrganData);
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteReids(Map<String, Object> requestMap, String deliveryPlatform) {
        Return r = new Return();
        ArrayList<Map<String, Object>> productList = new ArrayList();
        ArrayList<String> removeList = new ArrayList<String>();
        String flag = StrUtils.trimStr((Object)requestMap.get("flag"));
        String key = "prdDetail:" + deliveryPlatform + ":" + StrUtils.trimStr((Object)(requestMap.get("product_code") + "*"));
        String key2 = "prpPrdDetail:" + deliveryPlatform + ":" + StrUtils.trimStr((Object)(requestMap.get("product_code") + "*"));
        if ("1".equals(flag)) {
            for (String key3 : CacheManager.keys((String)key2)) {
                CacheManager.remove((String)key3);
                r.setSuccessMsg("\u6e05\u7406\u6210\u529f");
            }
            System.out.println(CacheManager.get((String)key));
            Iterator iterator = CacheManager.keys((String)key).iterator();
            if (iterator.hasNext()) {
                String key1 = (String)iterator.next();
                CacheManager.remove((String)key1);
                r.setSuccessMsg("\u6e05\u7406\u6210\u529f");
                return r.msg();
            }
        } else if ("2".equals(flag)) {
            productList = this.queryProduct(StrUtils.trimStr((Object)requestMap.get("product_code")), "M");
            this.queryProductCode(removeList, productList, deliveryPlatform);
        } else if ("3".equals(flag)) {
            productList = this.queryProduct(StrUtils.trimStr((Object)requestMap.get("product_code")), "A");
            this.queryProductCode(removeList, productList, deliveryPlatform);
        }
        r.setSuccessMsg("\u6279\u91cf\u6e05\u7406\u5173\u8054\u4ea7\u54c1");
        r.setDataList(productList);
        return r.msg();
    }

    private void queryProductCode(List<String> removeList, List<Map<String, Object>> productList, String deliveryPlatform) {
        for (Map<String, Object> product : productList) {
            String productNo = StrUtils.trimStr((Object)product.get("product_no"));
            for (String key1 : CacheManager.keys((String)("prdDetail:" + deliveryPlatform + ":" + productNo + "*"))) {
                CacheManager.remove((String)key1);
            }
            for (String key2 : CacheManager.keys((String)("prpPrdDetail:" + deliveryPlatform + ":" + productNo + "*"))) {
                CacheManager.remove((String)key2);
            }
            removeList.add(productNo);
        }
    }

    @Override
    public ReturnMsg putawayProduct(Map<String, Object> requestParam) {
        Return r = new Return();
        Map<String, Object> parmMap = null;
        try {
            parmMap = this.getInnerParm(requestParam);
        }
        catch (BusinessException e) {
            r.setFailMsg(e.getMessage());
            return r.msg();
        }
        ReturnMsg class1RM = this.class1Deal((Map)parmMap.get("class_1"), parmMap);
        if (class1RM == null) {
            this.saveParentAndDelsub((List)parmMap.get("class_2"), parmMap, (List)parmMap.get("class_3"));
            this.saveParentAndDelsub((List)parmMap.get("class_3"), parmMap, (List)parmMap.get("class_4"));
            this.saveOrganData((List)parmMap.get("class_4"), parmMap);
            this.saveOrganData((List)parmMap.get("class_100"), parmMap);
        }
        String sql = "update sip_products set state = ? where product_uuid = ?";
        this.dao.update(sql, new Object[]{"putaway", parmMap.get("product_uuid")});
        r.setSuccessMsg("\u4e0a\u67b6\u6210\u529f");
        return r.msg();
    }

    private Map<String, Object> getInnerParm(Map<String, Object> requestParam) {
        HashMap<String, Object> innerParmMap = new HashMap<String, Object>();
        String product_uuid = StrUtils.trimStr((Object)requestParam.get("product_uuid"));
        innerParmMap.put("product_uuid", product_uuid);
        if (this.checkPutawayCondition(product_uuid)) {
            throw new BusinessException("\u8be5\u4ea7\u54c1\u8fd8\u672a\u914d\u7f6e\u9669\u79cd\u4fe1\u606f\uff0c\u8bf7\u5b8c\u6210\u9669\u79cd\u7684\u914d\u7f6e\u518d\u64cd\u4f5c\u4e0a\u67b6\uff01");
        }
        if (this.checkPutawayProductInfo(requestParam)) {
            throw new BusinessException("\u4e0d\u53ef\u4e0a\u67b6\u91cd\u590d\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\u673a\u6784\uff0c\u6e20\u9053\uff0c\u5efa\u8bae\u4e66\u3001\u51fa\u5355\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        String prd_chanl_uuid = StrUtils.trimStr((Object)requestParam.get("prd_chanl_uuid"));
        Date policyStartDate = DateUtils.string2Date((Object)StrUtils.trimStr((Object)requestParam.get("start_date")));
        innerParmMap.put("date", policyStartDate);
        Date policyEndDate = DateUtils.string2Date((Object)StrUtils.trimStr((Object)requestParam.get("end_date")));
        List checkboxMapList = (List)requestParam.get("checkbox");
        this.organizationSelectDeal(checkboxMapList, innerParmMap);
        List riskRelationSernoList = (List)requestParam.get("riskRelationSernoJson");
        innerParmMap.put("riskRelationSernoList", riskRelationSernoList);
        String file_no = UUID.shortUUID();
        innerParmMap.put("file_no", file_no);
        return innerParmMap;
    }

    private void organizationSelectDeal(List<Map<String, Object>> checkboxMapList, Map<String, Object> innerParmMap) {
        if (checkboxMapList == null || checkboxMapList.isEmpty()) {
            throw new BusinessException("\u9009\u62e9\u7684\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<Object, Object> class_1 = new HashMap();
        ArrayList<Map<String, Object>> class_2 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> class_3 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> class_4 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> class_100 = new ArrayList<Map<String, Object>>();
        block14: for (Map<String, Object> map : checkboxMapList) {
            String class_id;
            switch (class_id = StrUtils.trimStr((Object)map.get("class_id"))) {
                case "1": {
                    class_1 = map;
                    continue block14;
                }
                case "2": {
                    class_2.add(map);
                    continue block14;
                }
                case "3": {
                    class_3.add(map);
                    continue block14;
                }
                case "4": {
                    class_4.add(map);
                    continue block14;
                }
                case "100": {
                    class_100.add(map);
                    continue block14;
                }
            }
            Ulog.warn((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u673a\u6784\u7ea7\u522b\uff01");
        }
        innerParmMap.put("class_1", class_1);
        innerParmMap.put("class_2", class_2);
        innerParmMap.put("class_3", class_3);
        innerParmMap.put("class_4", class_4);
        innerParmMap.put("class_100", class_100);
    }

    private void saveOrganData(List<Map<String, Object>> dataList, Map<String, Object> parmMap) {
        if (dataList.isEmpty()) {
            return;
        }
    }

    private void saveParentAndDelsub(List<Map<String, Object>> parentClassList, Map<String, Object> parmMap, List<Map<String, Object>> subClassList) {
        if (parentClassList.isEmpty()) {
            return;
        }
        List riskRelationSernoList = (List)parmMap.get("riskRelationSernoList");
        HashSet<String> parentOrganIDList = new HashSet<String>();
        for (Map<String, Object> map : parentClassList) {
            parentOrganIDList.add(StrUtils.trimStr((Object)map.get("organ_id")));
        }
        Iterator<Map<String, Object>> i4 = subClassList.iterator();
        while (i4.hasNext()) {
            String parent_id = StrUtils.trimStr((Object)i4.next().get("parent_id"));
            if (!parentOrganIDList.contains(parent_id)) continue;
            i4.remove();
        }
    }

    private ReturnMsg class1Deal(Map<String, Object> class_1, Map<String, Object> parmMap) {
        if (class_1.isEmpty()) {
            return null;
        }
        Return r = new Return();
        r.setSuccessMsg("\u4e0a\u67b6\u6210\u529f!");
        return r.msg();
    }

    private boolean checkPutawayProductInfo(Map<String, Object> param) {
        Return msg = new Return();
        boolean timeFlag = this.checkPutawayProductTime(param);
        boolean channelFlag = this.checkPutawayProductChannel(param);
        boolean organFlag = this.checkPutawayProductOrgan(param);
        return organFlag && channelFlag && timeFlag;
    }

    private boolean checkPutawayProductOrgan(Map<String, Object> param) {
        String shelfFlag = "1";
        boolean flag = false;
        String startDate = StrUtils.trimStr((Object)param.get("start_date"));
        String endDate = StrUtils.trimStr((Object)param.get("end_date"));
        String product_uuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        List mapList = (List)param.get("checkbox");
        Map class_1 = new HashMap();
        ArrayList<Map> class_2 = new ArrayList<Map>();
        ArrayList<Map> class_3 = new ArrayList<Map>();
        ArrayList<Map<String, Object>> class_4 = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> class_100 = new ArrayList<Map<String, Object>>();
        block14: for (Map map : mapList) {
            String class_id;
            switch (class_id = StrUtils.trimStr(map.get("class_id"))) {
                case "1": {
                    class_1 = map;
                    continue block14;
                }
                case "2": {
                    class_2.add(map);
                    continue block14;
                }
                case "3": {
                    class_3.add(map);
                    continue block14;
                }
                case "4": {
                    class_4.add(map);
                    continue block14;
                }
                case "100": {
                    class_100.add(map);
                    continue block14;
                }
            }
            Ulog.warn((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u673a\u6784\u7ea7\u522b\uff01");
        }
        if (!class_1.isEmpty()) {
            String string = StrUtils.trimStr(class_1.get("organ_id"));
        }
        if (!class_2.isEmpty()) {
            // empty if block
        }
        if (!class_3.isEmpty()) {
            // empty if block
        }
        if (!class_4.isEmpty() && (flag = this.checkOrganData(class_4, product_uuid, startDate, endDate))) {
            return flag;
        }
        if (!class_100.isEmpty() && (flag = this.checkOrganData(class_100, product_uuid, startDate, endDate))) {
            return flag;
        }
        return flag;
    }

    private boolean checkOrganData(List<Map<String, Object>> dataList, String product_uuid, String startDate, String endDate) {
        String shelfFlag = "1";
        return false;
    }

    private boolean checkPutawayProductChannel(Map<String, Object> param) {
        String shelfFlag = "1";
        String product_uuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        String product_channel_uuid = StrUtils.trimStr((Object)param.get("prd_chanl_uuid"));
        return false;
    }

    private boolean checkPutawayProductTime(Map<String, Object> param) {
        String shelfFlag = "1";
        String product_uuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        String startDate = StrUtils.trimStr((Object)param.get("start_date"));
        String endDate = StrUtils.trimStr((Object)param.get("end_date"));
        String proposeStartDate = StrUtils.trimStr((Object)param.get("propose_start_date"));
        String proposeEndDate = StrUtils.trimStr((Object)param.get("propose_end_date"));
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("     serno ").append(" FROM ").append("     sip_products_organ ").append(" WHERE ").append("     product_uuid = ? ").append(" AND shelf_flag = ? ").append(" AND ( ").append("     start_date BETWEEN ? ").append("     AND ? ").append("     OR end_date BETWEEN ? ").append("     AND ?  ").append("     OR propose_start_date BETWEEN ? ").append("     AND ? ").append("     OR propose_end_date BETWEEN ? ").append("     AND ? ").append(" ) ");
        AbsModelRepository.Args list = this.dao.args(new Object[0]);
        list.add(product_uuid);
        list.add(shelfFlag);
        list.add(startDate);
        list.add(endDate);
        list.add(startDate);
        list.add(endDate);
        list.add(proposeStartDate);
        list.add(proposeEndDate);
        list.add(proposeStartDate);
        list.add(proposeEndDate);
        List resultList = this.dao.findAll(sqlBuffer.toString(), new AbsModelRepository.Args[]{list});
        return null != resultList && !resultList.isEmpty();
    }

    private void savePrdOrganRiskRelation(String prdOrganUUID, List<Map<String, Object>> riskRelationSernoList) {
    }

    private void updateShelfFlag(String ShelfFlag, String prdOrganUUID) {
    }

    private boolean checkPutawayCondition(String productUUID) {
        SipProductRisks sipProductRisks4Query = new SipProductRisks();
        sipProductRisks4Query.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUUID);
        List sipProductRisksList = this.dao.findAll((AbsModel)sipProductRisks4Query);
        return null == sipProductRisksList || sipProductRisksList.isEmpty();
    }

    @Override
    public ReturnMsg queryPutawayMessage(Map<String, Object> param) {
        Return msg = new Return();
        String product_uuid = StrUtils.trimStr((Object)param.get("true_product_uuid"));
        if (StrUtils.isNull((Object)product_uuid)) {
            product_uuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        }
        if (StrUtils.isNull((Object)product_uuid)) {
            msg.setFailMsg("\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        SipProducts sip_product = new SipProducts();
        sip_product.where().addEq(SipProducts.PRODUCT_UUID, (Object)product_uuid);
        SipProducts product = (SipProducts)this.dao.findOne((AbsModel)sip_product);
        Map productMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)product));
        if (StrUtils.isNull((Object)product.getProductNo())) {
            msg.setFailMsg("\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u4fe1\u606f");
            return msg.msg();
        }
        SipProductRisks productRisk = new SipProductRisks();
        productRisk.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)product_uuid);
        List mainRiskList = this.dao.findAll((AbsModel)productRisk);
        ArrayList<Map<String, Object>> mainRisks = new ArrayList<Map<String, Object>>();
        if (mainRiskList.isEmpty()) {
            productMap.put("mainRisks", mainRisks);
            msg.setDataTable(productMap);
            return msg.msg();
        }
        for (SipProductRisks risk : mainRiskList) {
            Map<String, Object> riskMap = this.getSipRisk(risk.getRiskUuid());
            riskMap.put("addedRisks", this.getSubRisk(risk.getRiskUuid(), "ADDED"));
            riskMap.put("exemptRisks", this.getSubRisk(risk.getRiskUuid(), "EXEMPT"));
            mainRisks.add(riskMap);
        }
        productMap.put("mainRisks", mainRisks);
        msg.setDataTable(productMap);
        return msg.msg();
    }

    private Map<String, Object> getSipRisk(String risk_uuid) {
        SipRisks sip_risks = new SipRisks();
        sip_risks.where().addEq(SipRisks.RISK_UUID, (Object)risk_uuid);
        SipRisks risks = (SipRisks)this.dao.findOne((AbsModel)sip_risks);
        return JsonUtils.json2Map((String)JsonUtils.toJson((Object)risks));
    }

    private List<Map<String, Object>> getSubRisk(String main_risk_uuid, String relation_type) {
        ArrayList<Map<String, Object>> subRiskList = new ArrayList<Map<String, Object>>();
        SipRiskRelation riskRelation = new SipRiskRelation();
        riskRelation.where().addEq(SipRiskRelation.MAIN_RISK, (Object)main_risk_uuid);
        riskRelation.where().addEq(SipRiskRelation.RELATION_TYPE, (Object)relation_type);
        List riskRelationList = this.dao.findAll((AbsModel)riskRelation);
        for (SipRiskRelation relation : riskRelationList) {
            Map<String, Object> subRiskMap = this.getSipRisk(relation.getRiskUuid());
            if ("ADDED".equals(relation_type)) {
                subRiskMap.put("exemptRisks", this.getSubRisk(relation.getRiskUuid(), "EXEMPT"));
            }
            subRiskList.add(subRiskMap);
        }
        return subRiskList;
    }

    public ReturnMsg queryPutawayMessage1(Map<String, Object> param) {
        String product_uuid = StrUtils.trimStr((Object)param.get("true_product_uuid"));
        if (StrUtils.isNull((Object)product_uuid)) {
            product_uuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        }
        String organName = StrUtils.trimStr((Object)param.get("organ_name"));
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT ").append("     c.channel_type AS channel_type, ").append("     w.company_name AS organ_name, ").append("     o.start_date AS start_date, ").append(" o.end_date AS end_date, ").append(" o.propose_start_date as propose_start_date, o.propose_end_date as propose_end_date, ").append("o.prd_organ_uuid AS prd_organ_uuid, o.shelf_flag, o.crt_user,").append(" c.prd_chanl_uuid AS prd_chanl_uuid ").append(" FROM ").append("     sip_products_channel c, ").append("     sip_products_organ o, ").append("     ws_life_t_company_organ w").append(" WHERE ").append("     c.prd_chanl_uuid=o.prd_chanl_uuid ").append(" AND o.organ_id=w.organ_id ").append(" AND c.product_uuid= ?   ").append(" AND o.class_id <> ? ");
        if (!StrUtils.isNull((Object)organName)) {
            sqlBuffer.append(" and w.company_name like ? ");
        }
        sqlBuffer.append(" order by o.mdf_date desc  ");
        AbsModelRepository.Args querySql = this.dao.args(new Object[0]);
        ArrayList<1> cbList = new ArrayList<1>();
        querySql.add(product_uuid);
        querySql.add(AGENCY_ORGAN_FLAG);
        if (!StrUtils.isNull((Object)organName)) {
            querySql.add("%" + organName + "%");
        }
        cbList.add(new RowCallback<Map<String, Object>>(){

            public void callback(Map<String, Object> row, List<? extends Map<String, Object>> data, int index) {
                String userID = StrUtils.trimStr((Object)row.get("crt_user"));
                String sql = " select user_name from rms_user where pk_uuid = ? ";
                List userList = ProductConfigServiceImp.this.dao.findAll(sql, new AbsModelRepository.Args[]{ProductConfigServiceImp.this.dao.args(new Object[]{userID})});
                if (null != userList && !userList.isEmpty()) {
                    Map userMap = (Map)userList.get(0);
                    row.put("crt_user", StrUtils.trimStr(userMap.get("user_name")));
                } else {
                    row.put("crt_user", StrUtils.trimStr((Object)"\u672a\u67e5\u8be2\u5230\u7528\u6237\uff01"));
                }
            }
        });
        List resultDBList = this.dao.findAll(sqlBuffer.toString(), cbList, new AbsModelRepository.Args[]{querySql});
        Return r = new Return();
        r.setDataTable(param);
        Map<String, Object> organMap = this.handleOrganData(product_uuid);
        if (!StrUtils.isNull((Object)organName)) {
            organMap.put("organName", organName);
        }
        r.setDataList(resultDBList);
        r.getDataTable().put("product_uuid", product_uuid);
        List<Map<String, Object>> addedRisksList = this.getADDEDRisks(product_uuid);
        if (null != addedRisksList && !addedRisksList.isEmpty()) {
            r.getDataTable().put("addedRisks", addedRisksList);
        }
        return r.msg();
    }

    private List<Map<String, Object>> getADDEDRisks(String productUUID) {
        HashMap<String, Object> resultMap = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        SipProductRisks sipProductRisk4Query = new SipProductRisks();
        sipProductRisk4Query.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUUID);
        List sipProductRisksList = this.dao.findAll((AbsModel)sipProductRisk4Query);
        SipRisks sipRisk4Result = null;
        List<Map<String, Object>> addedRiskInfoList = null;
        List<Map<String, Object>> exemptRiskInfoList = null;
        List<Map<String, Object>> exemptRiskInfoInAddedRiskList = null;
        for (SipProductRisks tmpProductRisk : sipProductRisksList) {
            resultMap = new HashMap<String, Object>(16);
            String mainRiskUUID = tmpProductRisk.getRiskUuid();
            sipRisk4Result = this.getRiskInfo(mainRiskUUID);
            if (null == sipRisk4Result) continue;
            resultMap.put("mainRisk", sipRisk4Result);
            addedRiskInfoList = this.queryAddedOrExemptRisk(mainRiskUUID, "ADDED");
            for (Map<String, Object> tmpMap : addedRiskInfoList) {
                String addedRiskUUID = StrUtils.trimStr((Object)tmpMap.get("risk_uuid"));
                exemptRiskInfoInAddedRiskList = this.queryAddedOrExemptRisk(addedRiskUUID, "EXEMPT");
                tmpMap.put("exemptRisk", exemptRiskInfoInAddedRiskList);
            }
            exemptRiskInfoList = this.queryAddedOrExemptRisk(mainRiskUUID, "EXEMPT");
            resultMap.put("addedRisk", addedRiskInfoList);
            resultMap.put("exemptRisk", exemptRiskInfoList);
            resultList.add(resultMap);
        }
        return resultList;
    }

    private List<Map<String, Object>> queryAddedOrExemptRisk(String riskUUID, String riskType) {
        ArrayList<Map<String, Object>> riskInfoList = new ArrayList<Map<String, Object>>(10);
        SipRiskRelation sipRiskRelation4Query = new SipRiskRelation();
        sipRiskRelation4Query.where().addEq(SipRiskRelation.MAIN_RISK, (Object)riskUUID);
        sipRiskRelation4Query.where().addEq(SipRiskRelation.RELATION_TYPE, (Object)riskType);
        List sipRiskRelationList = this.dao.findAll((AbsModel)sipRiskRelation4Query);
        Map riskMap = null;
        for (SipRiskRelation tmpRiskRelation : sipRiskRelationList) {
            String riskUUID4Result = tmpRiskRelation.getRiskUuid();
            String isRequired = tmpRiskRelation.getIsRequired();
            String isRecommend = tmpRiskRelation.getIsRecommend();
            String riskRelationSerno = tmpRiskRelation.getSerno();
            SipRisks risk = this.getRiskInfo(riskUUID4Result);
            if (null == risk || StrUtils.isNull((Object)risk.getSerno())) continue;
            riskMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)risk));
            riskMap.put("isRequired", isRequired);
            riskMap.put("isRecommend", isRecommend);
            riskMap.put("riskRelationSerno", riskRelationSerno);
            riskInfoList.add(riskMap);
        }
        return riskInfoList;
    }

    private SipRisks getRiskInfo(String riskUUID) {
        String isSaleFlag = "Y";
        SipRisks sipRisk4Query = new SipRisks();
        sipRisk4Query.where().addEq(SipRisks.RISK_UUID, (Object)riskUUID);
        SipRisks sipRisks = (SipRisks)this.dao.findOne((AbsModel)sipRisk4Query);
        if (null == sipRisks || !StrUtils.isNull((Object)sipRisks.getSerno())) {
            // empty if block
        }
        return null;
    }

    private Map<String, Object> handleOrganData(String product_uuid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        return resultMap;
    }

    @Override
    public ReturnMsg soldProduct(Map<String, Object> param) {
        Return r = new Return();
        String prd_organ_uuid = StrUtils.trimStr((Object)param.get("prd_organ_uuid"));
        String product_uuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        Timestamp end_date = DateUtils.sysTimestamp();
        String shelfFlag = "0";
        List prdMap = (List)param.get("checkbox");
        if (StrUtils.isNull((Object)prd_organ_uuid)) {
            for (Map map : prdMap) {
                String string = StrUtils.trimStr(map.get("prd_organ_uuid"));
            }
        } else {
            Date date = DateUtils.string2Date((Object)StrUtils.trimStr((Object)param.get("start_date")));
            int n = DateUtils.compareDate((Date)date, (Date)end_date);
        }
        r.setSuccessMsg("\u4e0b\u67b6\u6210\u529f");
        return r.msg();
    }

    @Override
    public ReturnMsg queryRisksName(String node_no) {
        return null;
    }

    @Override
    public ReturnMsg queryChannel(Map<String, Object> param) {
        Return r = new Return();
        SysEnum sysEnum = new SysEnum();
        sysEnum.where().addEq(SysEnum.UP_ENUM, (Object)"channel_type");
        List enumList = this.dao.findAll((AbsModel)sysEnum);
        String node_no = StrUtils.trimStr((Object)param.get("node_no"));
        String up_node = StrUtils.trimStr((Object)param.get("up_node"));
        DsnStructure dsn = new DsnStructure();
        if (!StrUtils.isNull((Object)node_no) && !StrUtils.isNull((Object)up_node)) {
            String sql = "select node_no from dsn_structure where up_node = (select up_node from dsn_structure where node_no = ? ) and node_type in (?,?)";
            Map mainMap = (Map)this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(new Object[]{up_node, "n_risk_detail"})}).get(0);
            dsn = new DsnStructure();
            dsn.where().addEq(DsnStructure.UP_NODE, (Object)node_no);
            dsn.where().addIn(DsnStructure.NODE_TYPE, new String[]{"n_accy_detail", "n_exempt_detail"});
            dsn = (DsnStructure)this.dao.findOne((AbsModel)dsn);
        }
        ArrayList<Map> list = new ArrayList<Map>();
        for (SysEnum e : enumList) {
            Map map = JsonUtils.json2Map((String)JsonUtils.toJson((Object)e));
            list.add(map);
        }
        r.setDataList(list);
        return r.msg();
    }

    @Override
    public ReturnMsg doClient(Map<String, Object> param) {
        String product_uuids = "";
        List newListParam = (List)param.get("checkbox");
        Return r = new Return();
        ArrayList<String> productUuids = new ArrayList<String>();
        for (Map tempMap : newListParam) {
            String product_uuid = StrUtils.trimStr(tempMap.get("true_product_uuid"));
            product_uuids = product_uuids + product_uuid + ",";
            productUuids.add(product_uuid);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organ_id", "000000");
        map.put("product_uuid", product_uuids.substring(0, product_uuids.length() - 1));
        r.setSuccessMsg("\u4ea7\u54c1\u7f13\u5b58\u5df2\u542f\u52a8");
        return r.msg();
    }

    private void UpdateProductRedisInfo(List<String> productUuids, String info) {
        if (productUuids == null || productUuids.isEmpty()) {
            return;
        }
        String sysDate = DateUtils.date2String((Date)DateUtils.sysDate(), (String)"yyyy-MM-dd HH:mm:ss");
        for (String productUuid : productUuids) {
            String sql = "update sip_products set redis_deal_info = ? where product_uuid = ?";
            this.dao.update(sql, new Object[]{info + " " + sysDate, productUuid});
        }
    }

    @Override
    public ReturnMsg queryRelation(Map<String, Object> param) {
        String node_no = StrUtils.trimStr((Object)param.get("node_no"));
        String up_node = StrUtils.trimStr((Object)param.get("up_node"));
        DsnStructure risk = new DsnStructure();
        risk.where().addEq(DsnStructure.UP_NODE, (Object)node_no);
        risk.where().addIn(DsnStructure.NODE_TYPE, new String[]{"n_accy_detail", "n_exempt_detail"});
        risk = (DsnStructure)this.dao.findOne((AbsModel)risk);
        String sql = "select node_no from DsnStructure where up_node = (select up_node from DsnStructure where node_no = ?) and node_type in (?,?)";
        Map main = (Map)this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(new Object[]{up_node, "n_risk_detail", "n_accy_detail"})}).get(0);
        SipRiskRelation relation = new SipRiskRelation();
        relation.where().addEq(SipRiskRelation.MAIN_RISK, main.get("node_no"));
        relation.where().addEq(SipRiskRelation.RISK_UUID, (Object)risk.getNodeNo());
        relation = (SipRiskRelation)this.dao.findOne((AbsModel)relation);
        Return r = new Return();
        r.setDataTable(new Object[]{relation});
        return r.msg();
    }

    @Override
    public List<Map<String, Object>> queryProduct(String request, String flag) {
        List resultDao = null;
        if ("M".equals(flag)) {
            String sql = "select product_no from sip_products where product_uuid in(\nselect product_uuid from sip_product_risks  where risk_uuid=?\n)";
            resultDao = this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(new Object[]{this.queryRiskUuid(request, flag)})});
        } else if ("A".equals(flag)) {
            String sql = "select product_no from sip_products e right join (\nselect * from sip_product_risks where risk_uuid in(\nselect main_risk from sip_risk_relation  where risk_uuid=?\n)) s\non  e.product_uuid = s.product_uuid";
            resultDao = this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(new Object[]{this.queryRiskUuid(request, flag)})});
        }
        return resultDao;
    }

    private String queryRiskUuid(String request, String flag) {
        SipRisks risk = new SipRisks();
        risk.where().addEq(SipRisks.POLICY_CODE, (Object)request);
        risk.where().addEq(SipRisks.IS_MAIN_RISK, (Object)flag);
        SipRisks risk1 = (SipRisks)this.dao.findOne((AbsModel)risk);
        return risk1.getRiskUuid();
    }

    private void addNode(DsnStructure dsn) {
        DsnStructure nlt = DsnStructure.n().setNodeName("\u5229\u76ca\u6f14\u793a\u6307\u6807").setNodeType("n_liability_target").setNodeNo(dsn.getNodeNo()).setUpNode(dsn.getNodeNo()).setNodeSeq(dsn.getNodeSeq());
        this.publicTreeService.addTreeNode(nlt);
        nlt.setNodeName("\u4fdd\u969c\u6c47\u603b\u6307\u6807").setNodeType("n_security_target");
        this.publicTreeService.addTreeNode(nlt);
        nlt.setNodeName("\u5229\u76ca\u6f14\u793a\u8868\u5934").setNodeType("n_liability_table");
        this.publicTreeService.addTreeNode(nlt);
    }

    @Override
    public ReturnMsg saveProductOrganConfig(Map<String, Object> requestParam) {
        Return r = new Return();
        Message message = new Message();
        String productUuid = StrUtils.trimStr((Object)requestParam.get("product_uuid"));
        Map productConfiguration = (Map)requestParam.get("product_configuration");
        String organIdReq = StrUtils.trimStr(productConfiguration.get("organ_id"));
        String deliveryPlatform = StrUtils.trimStr((Object)requestParam.get("delivery_platform"));
        if (StrUtils.isNull((Object)productUuid)) {
            message = new Message("100002", "product_uuid\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            r.setFailMsg(message);
            return r.msg();
        }
        if (productConfiguration == null || productConfiguration.isEmpty()) {
            message = new Message("200901", "\u8bf7\u586b\u5199\u914d\u7f6e\u4fe1\u606f");
            r.setFailMsg(message);
            return r.msg();
        }
        if (organIdReq.isEmpty()) {
            message = new Message("100002", "organ_id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            r.setFailMsg(message);
            return r.msg();
        }
        if (deliveryPlatform.isEmpty()) {
            message = new Message("100002", "delivery_platform\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            r.setFailMsg(message);
            return r.msg();
        }
        if (StrUtils.trimStr(productConfiguration.get("channel_no")).isEmpty()) {
            message = new Message("100002", "channel_no\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            r.setFailMsg(message);
            return r.msg();
        }
        String[] organList = organIdReq.split("#");
        String organPrdUuid = this.saveConfig(productUuid, organList, requestParam);
        message = new Message("000000", "\u6210\u529f");
        r.setSuccessMsg(message);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("organ_prd_uuid", organPrdUuid);
        r.setDataTable(res);
        return r.msg();
    }

    private void valideSaveInfo(String productUuid, String[] organList, Map<String, Object> productConfiguration, String deliveryPlatform) {
        SipOrganProducts sipOrganProducts = new SipOrganProducts();
        sipOrganProducts.where().addIn(SipOrganProducts.ORGAN_ID, organList);
        sipOrganProducts.where().addEq(SipOrganProducts.CHANNEL_NO, (Object)StrUtils.trimStr((Object)productConfiguration.get("channel_no")));
        sipOrganProducts.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
        sipOrganProducts.where().addEq(SipOrganProducts.DATA_FLAG, (Object)"1");
        sipOrganProducts.where().addLike(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform);
        List sipOrganProductsExist = this.dao.findAll((AbsModel)sipOrganProducts);
        if (!sipOrganProductsExist.isEmpty()) {
            throw new BusinessException(new Message("200902", "\u540c\u4e00\u6e20\u9053\u540c\u4e00\u673a\u6784\u540c\u4e00\u6295\u653e\u5e73\u53f0\u4e0d\u53ef\u91cd\u590d\u4e0a\u67b6,\u8bf7\u5148\u4e0b\u67b6\u76f8\u5173\u914d\u7f6e"));
        }
    }

    private String saveConfig(String productUuid, String[] organList, Map<String, Object> requestParam) {
        String addBatch = StrUtils.trimStr((Object)requestParam.get("add_batch"));
        String organPrdUuid = UUID.uuid();
        if (!StrUtils.isNull((Object)addBatch)) {
            organPrdUuid = addBatch;
        }
        Map productConfiguration = (Map)requestParam.get("product_configuration");
        String deliveryPlatform = StrUtils.trimStr((Object)requestParam.get("delivery_platform"));
        this.saveProductConfiguration(organPrdUuid, productUuid, organList, productConfiguration, deliveryPlatform);
        List riskConfiguration = (List)requestParam.get("risk_configuration");
        this.saveRiskConfiguration(organPrdUuid, productUuid, riskConfiguration, productConfiguration);
        List productInfo = (List)requestParam.get("product_info");
        this.saveProductInfo(organPrdUuid, productUuid, productInfo);
        List riskInfo = (List)requestParam.get("risk_info");
        this.saveRiskInfo(organPrdUuid, riskInfo);
        return organPrdUuid;
    }

    private void saveProductConfiguration(String organPrdUuid, String productUuid, String[] organList, Map<String, Object> productConfiguration, String deliveryPlatform) {
        String[] channelNos = StrUtils.trimStr((Object)productConfiguration.get("channel_no")).split(",");
        ArrayList<SipOrganProducts> organProducts = new ArrayList<SipOrganProducts>();
        for (String tmpOrgan : organList) {
            for (String channelNo : channelNos) {
                SipOrganProducts organProduct = new SipOrganProducts();
                organProduct.setOrganPrdUuid(organPrdUuid);
                organProduct.setProductUuid(productUuid);
                organProduct.setOrganId(tmpOrgan);
                organProduct.setIsEnable("wait_ground");
                organProduct.setDeliveryPlatform(deliveryPlatform);
                organProduct.setChannelNo(channelNo);
                organProduct.setPrpStartDate(DateUtils.string2Date((Object)productConfiguration.get("prp_start_date")));
                organProduct.setPrpEndDate(DateUtils.string2Date((Object)productConfiguration.get("prp_end_date")));
                organProduct.setPolStartDate(DateUtils.string2Date((Object)productConfiguration.get("pol_start_date")));
                organProduct.setPolEndDate(DateUtils.string2Date((Object)productConfiguration.get("pol_end_date")));
                organProducts.add(organProduct);
            }
        }
        List sipOrganProducts = this.dao.findAll(SipOrganProducts.n().where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)organPrdUuid).model());
        if (!sipOrganProducts.isEmpty()) {
            this.dao.delete(SipOrganProducts.n().where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)organPrdUuid).model());
        }
        this.dao.save(organProducts);
    }

    private void saveRiskConfiguration(String organPrdUuid, String productUuid, List<Map<String, Object>> riskConfiguration, Map<String, Object> productConfiguration) {
        for (Map<String, Object> tmpMap : riskConfiguration) {
            String mainRisk = StrUtils.trimStr((Object)tmpMap.get("main_risk"));
            List addedRisks = (List)tmpMap.get("added");
            List exemptRisks = (List)tmpMap.get("exempt");
            this.dao.delete(SipOrganRiskRelation.n().where().addEq(SipOrganRiskRelation.ORGAN_PRD_UUID, (Object)organPrdUuid).addEq(SipOrganRiskRelation.MAIN_RISK_UUID, (Object)mainRisk).model());
            if (null != addedRisks && !addedRisks.isEmpty()) {
                for (Map tRiskAdded : addedRisks) {
                    this.dao.save((AbsModel)this.assembleSipOrganRiskRelation(tRiskAdded, organPrdUuid, mainRisk, mainRisk));
                    List addedExemtRisks = (List)tRiskAdded.get("exempt");
                    if (null == addedExemtRisks || addedExemtRisks.isEmpty()) continue;
                    for (Map tAddedExemtRisk : addedExemtRisks) {
                        this.dao.save((AbsModel)this.assembleSipOrganRiskRelation(tAddedExemtRisk, organPrdUuid, (String)tRiskAdded.get("risk_uuid"), mainRisk));
                    }
                }
            }
            if (null != exemptRisks && !exemptRisks.isEmpty()) {
                for (Map tRiskExempt : exemptRisks) {
                    this.dao.save((AbsModel)this.assembleSipOrganRiskRelation(tRiskExempt, organPrdUuid, mainRisk, mainRisk));
                }
            }
            if (!tmpMap.containsKey("is_required")) continue;
            tmpMap.put("risk_uuid", mainRisk);
            tmpMap.put("prp_start_date", productConfiguration.get("prp_start_date"));
            tmpMap.put("prp_end_date", productConfiguration.get("prp_end_date"));
            tmpMap.put("pol_start_date", productConfiguration.get("pol_start_date"));
            tmpMap.put("pol_end_date", productConfiguration.get("pol_end_date"));
            tmpMap.put("is_recommend", "N");
            this.dao.save((AbsModel)this.assembleSipOrganRiskRelation(tmpMap, organPrdUuid, mainRisk, mainRisk));
        }
        Ulog.info((String)"RiskRelation\u4fdd\u5b58\u6210\u529f");
    }

    private SipOrganRiskRelation assembleSipOrganRiskRelation(Map<String, Object> subRiskParam, String organPrdUuid, String upRiskUuid, String mainRiskUuid) {
        SipOrganRiskRelation sipOrganRiskRelation = new SipOrganRiskRelation();
        sipOrganRiskRelation.setOrganPrdUuid(organPrdUuid);
        sipOrganRiskRelation.setMainRisk(upRiskUuid);
        sipOrganRiskRelation.setMainRiskUuid(mainRiskUuid);
        String riskUuid = StrUtils.trimStr((Object)subRiskParam.get("risk_uuid"));
        sipOrganRiskRelation.setRiskUuid(riskUuid);
        String proposeStartDate = StrUtils.trimStr((Object)subRiskParam.get("prp_start_date"));
        if (StrUtils.isNull((Object)proposeStartDate)) {
            new BusinessException("\u5efa\u8bae\u4e66\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sipOrganRiskRelation.setPrpStartDate(DateUtils.string2Date((String)proposeStartDate, (String)"yyyy-MM-dd HH:mm:ss"));
        String proposeEndDate = StrUtils.trimStr((Object)subRiskParam.get("prp_end_date"));
        if (StrUtils.isNull((Object)proposeEndDate)) {
            new BusinessException("\u5efa\u8bae\u4e66\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sipOrganRiskRelation.setPrpEndDate(DateUtils.string2Date((String)proposeEndDate, (String)"yyyy-MM-dd HH:mm:ss"));
        String policyStartDate = StrUtils.trimStr((Object)subRiskParam.get("pol_start_date"));
        if (StrUtils.isNull((Object)policyStartDate)) {
            new BusinessException("\u51fa\u5355\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sipOrganRiskRelation.setPolStartDate(DateUtils.string2Date((String)policyStartDate, (String)"yyyy-MM-dd HH:mm:ss"));
        String policyEndDate = StrUtils.trimStr((Object)subRiskParam.get("pol_end_date"));
        if (StrUtils.isNull((Object)policyEndDate)) {
            new BusinessException("\u51fa\u5355\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sipOrganRiskRelation.setPolEndDate(DateUtils.string2Date((String)policyEndDate, (String)"yyyy-MM-dd HH:mm:ss"));
        String isRequired = StrUtils.trimStr((Object)subRiskParam.get("is_required"));
        sipOrganRiskRelation.setIsRequired(isRequired);
        String isRecommend = StrUtils.trimStr((Object)subRiskParam.get("is_recommend"));
        sipOrganRiskRelation.setIsRecommend(isRecommend);
        return sipOrganRiskRelation;
    }

    private void saveProductInfo(String organPrdUuid, String productUuid, List<Map<String, Object>> productInfo) {
        List sipOrganProductInfos = JsonUtils.listMap2ListClass(productInfo, SipOrganProductInfo.class);
        for (SipOrganProductInfo oneSipOrganProductInfo : sipOrganProductInfos) {
            oneSipOrganProductInfo.setOrganPrdUuid(organPrdUuid);
        }
        this.dao.delete(SipOrganProductInfo.n().where().addEq(SipOrganProductInfo.ORGAN_PRD_UUID, (Object)organPrdUuid).model());
        this.dao.save(sipOrganProductInfos);
    }

    private void saveRiskInfo(String organPrdUuid, List<Map<String, Object>> riskInfo) {
        List sipOrganRiskInfos = JsonUtils.listMap2ListClass(riskInfo, SipOrganRiskInfo.class);
        for (SipOrganRiskInfo oneRiskInfo : sipOrganRiskInfos) {
            oneRiskInfo.setOrganPrdUuid(organPrdUuid);
        }
        this.dao.delete(SipOrganRiskInfo.n().where().addEq(SipOrganRiskInfo.ORGAN_PRD_UUID, (Object)organPrdUuid).model());
        this.dao.save(sipOrganRiskInfos);
    }

    @Override
    public ReturnMsg delProductOrganConfig(Map<String, Object> requestParam) {
        Return r = new Return();
        Message message = new Message();
        String[] organPrdUuid = StrUtils.trimStr((Object)requestParam.get("organ_prd_uuid")).split("#");
        String deliveryPlatform = StrUtils.trimStr((Object)requestParam.get("delivery_platform"));
        if (StrUtils.isNull((Object)organPrdUuid) || organPrdUuid.length == 0) {
            message = new Message("100002", "[organ_prd_uuid]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            r.setFailMsg(message);
            return r.msg();
        }
        SipOrganProducts sipOrganProducts = new SipOrganProducts();
        sipOrganProducts.where().addIn(SipOrganProducts.ORGAN_PRD_UUID, organPrdUuid);
        sipOrganProducts.where().addEq(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform);
        sipOrganProducts.setDataFlag("0");
        this.dao.update((AbsModel)sipOrganProducts);
        SipOrganRiskRelation sipOrganRiskRelation = new SipOrganRiskRelation();
        sipOrganRiskRelation.where().addIn(SipOrganRiskRelation.ORGAN_PRD_UUID, organPrdUuid);
        sipOrganRiskRelation.setDataFlag("0");
        this.dao.update((AbsModel)sipOrganRiskRelation);
        SipOrganProductInfo sipOrganProductInfo = new SipOrganProductInfo();
        sipOrganProductInfo.where().addIn(SipOrganProductInfo.ORGAN_PRD_UUID, organPrdUuid);
        sipOrganProductInfo.setDataFlag("0");
        this.dao.update((AbsModel)sipOrganProductInfo);
        SipOrganRiskInfo sipOrganRiskInfo = new SipOrganRiskInfo();
        sipOrganRiskInfo.where().addIn(SipOrganRiskInfo.ORGAN_PRD_UUID, organPrdUuid);
        sipOrganRiskInfo.setDataFlag("0");
        this.dao.update((AbsModel)sipOrganRiskInfo);
        message = new Message("000000", "\u6210\u529f");
        r.setSuccessMsg(message);
        return r.msg();
    }

    @Override
    public ReturnMsg queryProductOrganConfig(Map<String, Object> requestParam, String queryScope) {
        Return r = new Return();
        Message message = new Message();
        String productUuid = StrUtils.trimStr((Object)requestParam.get("product_uuid"));
        String deliveryPlatform = StrUtils.trimStr((Object)requestParam.get("delivery_platform"));
        String channelNo = StrUtils.trimStr((Object)requestParam.get("channel_no"));
        String organId = StrUtils.trimStr((Object)requestParam.get("organ_id"));
        String flowUuid = StrUtils.trimStr((Object)requestParam.get("flow_uuid"));
        SipOrganProductsHistory sipOrganProducts = new SipOrganProductsHistory();
        sipOrganProducts.where().addEq(SipOrganProductsHistory.PRODUCT_UUID, (Object)productUuid);
        sipOrganProducts.where().addNotEq(SipOrganProductsHistory.IS_ENABLE, (Object)"wait_ground");
        if (!StrUtils.isNull((Object)deliveryPlatform)) {
            sipOrganProducts.where().addEq(SipOrganProductsHistory.DELIVERY_PLATFORM, (Object)deliveryPlatform);
        }
        if (!StrUtils.isNull((Object)channelNo)) {
            sipOrganProducts.where().addEq(SipOrganProductsHistory.CHANNEL_NO, (Object)channelNo);
        }
        if (!StrUtils.isNull((Object)organId)) {
            sipOrganProducts.where().addIn(SipOrganProductsHistory.ORGAN_ID, organId.split(","));
        }
        if (queryScope.equals("1")) {
            sipOrganProducts.where().addEq(SipOrganProductsHistory.DATA_FLAG, (Object)"1");
        }
        sipOrganProducts.setOrderBy(new Sort.Order[]{SipOrganProductsHistory.MDF_DATE.desc()});
        List sipOrganProductsList = this.dao.findAll((AbsModel)sipOrganProducts, Boolean.valueOf(true));
        List<Map<String, Object>> configurationList = this.assembleConfiguration(sipOrganProductsList);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("product_uuid", productUuid);
        resultMap.put("product_configuration_list", configurationList);
        resultMap.put("delivery_platform", deliveryPlatform);
        r.setDataTable(resultMap);
        message = new Message("000000", "\u6210\u529f");
        r.setSuccessMsg(message);
        return r.msg();
    }

    private List<String> findOrganPrdUuid(List<SipOrganProducts> sipOrganProductsList) {
        ArrayList<String> organPrdUuidList = new ArrayList<String>();
        for (SipOrganProducts sipOrganProducts : sipOrganProductsList) {
            String organPrdUuid = sipOrganProducts.getOrganPrdUuid();
            if (organPrdUuidList.contains(organPrdUuid)) continue;
            organPrdUuidList.add(organPrdUuid);
        }
        return organPrdUuidList;
    }

    private List<Map<String, Object>> assembleConfiguration(List<SipOrganProductsHistory> sipOrganProducts) {
        ArrayList<Map<String, Object>> configurationList = new ArrayList<Map<String, Object>>();
        HashSet<String> organIdSet = new HashSet<String>();
        HashSet<String> channelNoSet = new HashSet<String>();
        for (SipOrganProductsHistory tSipOrganProducts : sipOrganProducts) {
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            organIdSet.add(tSipOrganProducts.getOrganId());
            channelNoSet.add(tSipOrganProducts.getChannelNo());
            configuration.put("prp_start_date", tSipOrganProducts.getPrpStartDate());
            configuration.put("prp_end_date", tSipOrganProducts.getPrpEndDate());
            configuration.put("pol_start_date", tSipOrganProducts.getPolStartDate());
            configuration.put("pol_end_date", tSipOrganProducts.getPolEndDate());
            configuration.put("crt_date", tSipOrganProducts.getCrtDate());
            configuration.put("mdf_date", tSipOrganProducts.getMdfDate());
            String crtUser = tSipOrganProducts.getCrtUser();
            RmsUser rmsUser = new RmsUser();
            rmsUser.where().addEq(RmsUser.PK_UUID, (Object)crtUser);
            rmsUser = (RmsUser)this.dao.findOne((AbsModel)rmsUser);
            configuration.put("crt_user", rmsUser == null ? crtUser : rmsUser.getUserName());
            configuration.put("data_flag", tSipOrganProducts.getDataFlag());
            configuration.put("zip_path", tSipOrganProducts.getZipPath());
            if (tSipOrganProducts.getIsEnable().equals("ON")) {
                configuration.put("data_flag_dec", "\u4ea7\u54c1\u5df2\u4e0a\u67b6");
            }
            if (tSipOrganProducts.getIsEnable().equals("OFF")) {
                configuration.put("data_flag_dec", "\u4ea7\u54c1\u5df2\u4e0b\u67b6");
            }
            if ("FINISH".equals(tSipOrganProducts.getState())) {
                configuration.put("state", "\u5b8c\u6210");
            }
            configuration.put("organ_prd_uuid", tSipOrganProducts.getOrganPrdUuid());
            configuration.put("delivery_platform", tSipOrganProducts.getDeliveryPlatform());
            String organId = StringUtil.join((Object[])organIdSet.toArray(), (String)"#");
            String channelNo = StringUtil.join((Object[])channelNoSet.toArray(), (String)"#");
            configuration.put("organ_id", organId);
            configuration.put("channel_no", channelNo);
            List wsLifeTCompanyOrgan = this.dao.findAll(WsLifeTCompanyOrgan.n().where().addIn(WsLifeTCompanyOrgan.ORGAN_ID, new ArrayList(organIdSet)).model());
            String organStr = wsLifeTCompanyOrgan.stream().map(WsLifeTCompanyOrgan::getCompanyName).collect(Collectors.joining("#"));
            List sysEnumConf = this.dao.findAll(SysEnumConf.n().where().addEq(SysEnumConf.UP_ENUM, (Object)"channel_type").addIn(SysEnumConf.ENUM_CODE, new ArrayList(channelNoSet)).model());
            String channelStr = sysEnumConf.stream().map(SysEnumConf::getEnumName).collect(Collectors.joining("#"));
            configuration.put("organ_name", organStr);
            configuration.put("channel_name", channelStr);
            configuration.put("rn", tSipOrganProducts.getOtherProperty("rn"));
            configurationList.add(configuration);
        }
        return configurationList;
    }

    @Override
    public void delProductOrganConfigByProductUuid(String productUuid) {
        if (productUuid.isEmpty()) {
            throw new BusinessException(new Message("100002", "[product_uuid]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        SipOrganProducts sipOrganProducts = new SipOrganProducts();
        sipOrganProducts.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
        List sipOrganProductsList = this.dao.findAll((AbsModel)sipOrganProducts);
        List<String> organPrdUuidList = this.findOrganPrdUuid(sipOrganProductsList);
        if (organPrdUuidList.isEmpty()) {
            Ulog.info((String)"\u6b64\u9669\u79cd\u6ca1\u6709\u4e0a\u67b6\u4fe1\u606f");
            return;
        }
        sipOrganProducts.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
        this.dao.delete((AbsModel)sipOrganProducts);
        SipOrganProductInfo sipOrganProductInfo = new SipOrganProductInfo();
        sipOrganProductInfo.where().addIn(SipOrganProductInfo.ORGAN_PRD_UUID, organPrdUuidList);
        this.dao.delete((AbsModel)sipOrganProductInfo);
        SipOrganRiskRelation sipOrganRiskRelation = new SipOrganRiskRelation();
        sipOrganRiskRelation.where().addIn(SipOrganRiskRelation.ORGAN_PRD_UUID, organPrdUuidList);
        this.dao.delete((AbsModel)sipOrganRiskRelation);
        SipOrganRiskInfo sipOrganRiskInfo = new SipOrganRiskInfo();
        sipOrganRiskInfo.where().addIn(SipOrganRiskInfo.ORGAN_PRD_UUID, organPrdUuidList);
        this.dao.delete((AbsModel)sipOrganRiskInfo);
        Ulog.info((String)"\u4e0a\u4e0b\u67b6\u4fe1\u606f\u5220\u9664\u6210\u529f");
    }
}

