/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.cache.service.impl;

import com.huawei.shade.com.alibaba.fastjson.JSONArray;
import com.huawei.shade.com.alibaba.fastjson.JSONObject;
import com.newtouch.nms.sip.design.utils.RequestsUtil;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnDynamicData;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipOrganProductInfo;
import com.newtouch.nms.sip.model.SipOrganProducts;
import com.newtouch.nms.sip.model.SipProducts;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.cache.service.IProductCacheService;
import com.newtouch.nms.sip.product.detail.service.IProductDetailsService;
import com.newtouch.nms.sip.product.risk.services.IRiskService;
import com.newtouch.nms.sip.product.structure.dao.IStructureDao;
import com.newtouch.nms.sip.vo.QueryPdDetailVo;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.DBTypes;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProductCacheServiceImpl
implements IProductCacheService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IRiskService riskService;
    @Autowired
    private IProductDetailsService productDetailsService;
    @Autowired
    private IStructureDao structureDao;
    private static final String TABLE_PREFIX = "dsn_rate_";
    @Value(value="${delByKey}")
    private String delByKey;
    private static final String KEYS = "crt_date,mdf_date,crt_user,mdf_user,end_date,start_date,memo,patch_memo,relate_table,rule_templade_id";

    @Override
    public ReturnMsg queryProductListCache(String organId, String channelNo, String deliveryPlatform) {
        Return msg = new Return();
        List headProductList = new ArrayList();
        ArrayList<Map> result = new ArrayList<Map>();
        HashMap headMap = new HashMap();
        HashMap<String, Map> organMap = new HashMap<String, Map>();
        String headOffice = "prdList:" + deliveryPlatform + ":1000000" + channelNo;
        Ulog.info((String)("\u5168\u56fd\u53ef\u552e\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684key" + headOffice));
        String headOfficeResult = (String)CacheManager.get((String)headOffice);
        Ulog.info((String)("\u5168\u56fd\u53ef\u552e\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + headOfficeResult));
        if (!StrUtils.isNull((Object)headOfficeResult)) {
            headProductList = JsonUtils.json2List((String)StrUtils.trimStr((Object)headOfficeResult));
        }
        for (Map map1 : headProductList) {
            headMap.put(StrUtils.trimStr(map1.get("product_no")), map1);
        }
        String branchOffice = "prdList:" + deliveryPlatform + ":" + organId + channelNo;
        Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684key" + branchOffice));
        String branchResult = (String)CacheManager.get((String)branchOffice);
        Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + branchResult));
        if (StrUtils.isNull((Object)branchResult)) {
            branchOffice = "prdList:" + deliveryPlatform + ":" + organId.subSequence(0, 5) + "00" + channelNo;
            Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684key" + branchOffice));
            branchResult = (String)CacheManager.get((String)branchOffice);
            Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + branchResult));
        }
        boolean contains = NodeType.getOrganSpecialList().contains(organId.subSequence(0, 5));
        if (StrUtils.isNull((Object)branchResult) && !contains) {
            branchOffice = "prdList:" + deliveryPlatform + ":" + organId.subSequence(0, 3) + "0000" + channelNo;
            branchResult = (String)CacheManager.get((String)branchOffice);
            Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684key" + branchOffice));
            Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + branchResult));
        }
        if (!StrUtils.isNull((Object)branchResult)) {
            List organProductList = JsonUtils.json2List((String)StrUtils.trimStr((Object)branchResult));
            for (Map map2 : organProductList) {
                organMap.put(StrUtils.trimStr(map2.get("product_no")), map2);
            }
            headMap.putAll(organMap);
        }
        for (String key : headMap.keySet()) {
            result.add((Map)headMap.get(key));
        }
        msg.setDataList(result);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryProductListToRedis(Map<String, Object> param) {
        Return msg = new Return();
        String[] organPrdUuids = StrUtils.trimStr((Object)param.get("organ_prd_uuid")).split("#");
        List organPrd = this.dao.findAll(SipOrganProducts.n().where().addIn(SipOrganProducts.ORGAN_PRD_UUID, organPrdUuids).model());
        for (SipOrganProducts organProduct : organPrd) {
            param.put("organ_id", organProduct.getOrganId());
            param.put("channel_no", organProduct.getChannelNo());
            param.put("delivery_platform", organProduct.getDeliveryPlatform());
            List<Map<String, Object>> organList = this.queryOrganProductList(param);
            if (null == organList || organList.isEmpty()) continue;
            Ulog.info((String)("queryProductListToRedis:redis-put\u4ea7\u54c1\u5217\u8868\u7684keyprdList:" + organProduct.getDeliveryPlatform() + ":" + organProduct.getOrganId() + organProduct.getChannelNo()));
            CacheManager.put((String)("prdList:" + organProduct.getDeliveryPlatform() + ":" + organProduct.getOrganId() + organProduct.getChannelNo()), (Object)JsonUtils.toJson(organList));
        }
        return msg.msg();
    }

    public String getOrganizationLevel(String organizationCode) {
        if (organizationCode.substring(1, 3).equals("00")) {
            return "1";
        }
        if (organizationCode.substring(3, 5).equals("00")) {
            return "2";
        }
        if (organizationCode.substring(5, 7).equals("00")) {
            return "3";
        }
        return "4";
    }

    public String getProductRiskDetailCache(String productNo, String productUuid, String deliveryPlatform, String organId, String channelNo, String addBatch) {
        if (StrUtils.isNull((Object)productNo)) {
            throw new BusinessException("\u5165\u53c2productNo\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)productUuid)) {
            throw new BusinessException("\u5165\u53c2productUuid\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)deliveryPlatform)) {
            throw new BusinessException("\u5165\u53c2deliveryPlatform\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)organId)) {
            throw new BusinessException("\u5165\u53c2organId\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)channelNo)) {
            throw new BusinessException("\u5165\u53c2channelNo\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isNull((Object)addBatch)) {
            throw new BusinessException("\u5165\u53c2addBatch\u4e3a\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5");
        }
        String organizationLevel = this.getOrganizationLevel(organId);
        String redisKey = "prdDetail:" + deliveryPlatform + ":" + productNo + ":" + organId + ":" + channelNo + ":" + addBatch;
        String branchResult = (String)CacheManager.get((String)redisKey);
        if (!StrUtils.isNull((Object)branchResult)) {
            return branchResult;
        }
        String curOrganId = organId;
        String tempOrganId = "1000000";
        int endIndex = 7;
        if ("4".equals(organizationLevel)) {
            endIndex = 7;
        }
        if ("3".equals(organizationLevel)) {
            endIndex = 5;
        }
        if ("2".equals(organizationLevel)) {
            endIndex = 3;
        }
        if ("1".equals(organizationLevel)) {
            return "";
        }
        SipOrganProducts sopSelect = new SipOrganProducts();
        sopSelect.where().addEq(SipOrganProducts.IS_ENABLE, (Object)"ON");
        sopSelect.where().addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo);
        sopSelect.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
        sopSelect.where().addLike(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform);
        sopSelect.where().addEq(SipOrganProducts.DATA_FLAG, (Object)"1");
        while (true) {
            if (curOrganId.equals(organId) && !StrUtils.isNull((Object)addBatch)) {
                sopSelect.where().addEq(SipOrganProducts.ORGAN_ID, (Object)curOrganId);
                sopSelect.where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)addBatch);
            } else {
                sopSelect = new SipOrganProducts();
                sopSelect.where().addEq(SipOrganProducts.ORGAN_ID, (Object)curOrganId);
                sopSelect.where().addEq(SipOrganProducts.IS_ENABLE, (Object)"ON");
                sopSelect.where().addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo);
                sopSelect.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
                sopSelect.where().addLike(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform);
                sopSelect.where().addEq(SipOrganProducts.DATA_FLAG, (Object)"1");
            }
            List sipOrganProductsList = this.dao.findAll((AbsModel)sopSelect);
            if (sipOrganProductsList != null && !sipOrganProductsList.isEmpty()) {
                SipOrganProducts sipOrganProducts = (SipOrganProducts)sipOrganProductsList.get(0);
                String redisKey2 = "prdDetail:" + deliveryPlatform + ":" + productNo + ":" + sipOrganProducts.getOrganId() + ":" + sipOrganProducts.getChannelNo() + ":" + sipOrganProducts.getOrganPrdUuid();
                String branchResult2 = (String)CacheManager.get((String)redisKey2);
                if (!StrUtils.isNull((Object)branchResult2)) {
                    return branchResult2;
                }
            }
            if (tempOrganId.equals(curOrganId)) {
                return "";
            }
            curOrganId = organId.substring(0, endIndex -= 2).concat(tempOrganId.substring(endIndex));
        }
    }

    @Override
    public String queryPrdDetailFromRedis(QueryPdDetailVo queryPdDetailVo) {
        String addBatch = queryPdDetailVo.getAddBatch();
        String deliveryPlatform = queryPdDetailVo.getDeliveryPlatform();
        SipOrganProducts sipOrganProductCurrent = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)addBatch).model());
        if (sipOrganProductCurrent == null || StrUtils.isNull((Object)sipOrganProductCurrent.getOrganPrdUuid())) {
            throw new BusinessException("\u4f20\u5165\u6279\u6b21\u53f7\u6709\u8bef\uff0c\u8bf7\u6838\u5bf9\uff01\uff01\uff01");
        }
        SipProducts product = (SipProducts)this.dao.findOne(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)sipOrganProductCurrent.getProductUuid()).model());
        String cacheResult = this.getProductRiskDetailCache(product.getProductNo(), sipOrganProductCurrent.getProductUuid(), deliveryPlatform, sipOrganProductCurrent.getOrganId(), sipOrganProductCurrent.getChannelNo(), addBatch);
        if (!StrUtils.isNull((Object)cacheResult)) {
            return cacheResult;
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("organ_prd_uuid", sipOrganProductCurrent.getOrganPrdUuid());
        requestMap.put("organ_id", sipOrganProductCurrent.getOrganId());
        requestMap.put("channel_no", sipOrganProductCurrent.getChannelNo());
        requestMap.put("add_batch", sipOrganProductCurrent.getOrganPrdUuid());
        requestMap.put("delivery_platform", deliveryPlatform);
        requestMap.put("product_uuid", sipOrganProductCurrent.getProductUuid());
        requestMap.put("source", queryPdDetailVo.getSource());
        requestMap.put("use_scene", queryPdDetailVo.getUseScene());
        String key = deliveryPlatform + ":" + product.getProductNo() + ":" + sipOrganProductCurrent.getOrganId() + ":" + sipOrganProductCurrent.getChannelNo() + ":" + sipOrganProductCurrent.getOrganPrdUuid();
        ReturnMsg queryAppPrdDetail = this.queryAppPrdDetail(requestMap);
        CacheManager.put((String)("prdDetail:" + key), (Object)RequestsUtil.return2Json(queryAppPrdDetail));
        return RequestsUtil.return2Json(queryAppPrdDetail);
    }

    @Override
    public String queryPrdDetailFromRedis3(QueryPdDetailVo queryPdDetailVo) {
        String[] s;
        Return msg = new Return();
        String organId = queryPdDetailVo.getOrgan_id();
        String channelNo = queryPdDetailVo.getChannel_no();
        String deliveryPlatform = queryPdDetailVo.getDeliveryPlatform();
        String productUuid = queryPdDetailVo.getProduct_uuid();
        String productNo = queryPdDetailVo.getProduct_no();
        List products = new ArrayList();
        if (!StrUtils.isNull((Object)productUuid)) {
            s = productUuid.split(",");
            products = this.dao.findAll(SipProducts.n().where().addIn(SipProducts.PRODUCT_UUID, s).model());
        } else {
            s = productNo.split(",");
            products = this.dao.findAll(SipProducts.n().where().addIn(SipProducts.PRODUCT_NO, s).model());
        }
        ArrayList productDataList = new ArrayList();
        String addBatch = queryPdDetailVo.getAddBatch();
        for (SipProducts product : products) {
            String organPrdUuid;
            productUuid = product.getProductUuid();
            SipOrganProducts sipOrganProductCurrent = new SipOrganProducts();
            if (!StrUtils.isNull((Object)addBatch)) {
                SipOrganProducts sopSelect = new SipOrganProducts();
                sopSelect.where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)addBatch);
                sopSelect.where().addEq(SipOrganProducts.IS_ENABLE, (Object)"ON");
                List sipOrganProductsList = this.dao.findAll((AbsModel)sopSelect);
                if (sipOrganProductsList != null && !sipOrganProductsList.isEmpty()) {
                    sipOrganProductCurrent = (SipOrganProducts)sipOrganProductsList.get(0);
                    organId = sipOrganProductCurrent.getOrganId();
                    channelNo = sipOrganProductCurrent.getChannelNo();
                }
            }
            if (StrUtils.isNull((Object)(organPrdUuid = sipOrganProductCurrent.getOrganPrdUuid()))) {
                sipOrganProductCurrent = this.getSipOrganProducts(organId, channelNo, deliveryPlatform, productUuid, "");
            }
            if (StrUtils.isNull((Object)(organPrdUuid = sipOrganProductCurrent.getOrganPrdUuid()))) {
                throw new BusinessException("\u4ea7\u54c1\u540d\u79f0\uff1a" + product.getProductName() + " \u672a\u4e0a\u67b6\uff0c\u8bf7\u5148\u4e0a\u67b6\uff01\uff01\uff01");
            }
            String cacheResult = this.getProductRiskDetailCache(product.getProductNo(), sipOrganProductCurrent.getProductUuid(), deliveryPlatform, sipOrganProductCurrent.getOrganId(), sipOrganProductCurrent.getChannelNo(), organPrdUuid);
            if (!StrUtils.isNull((Object)cacheResult)) {
                Map map = JsonUtils.json2Map((String)cacheResult);
                List data = (List)map.get("data");
                productDataList.add(data.get(0));
                continue;
            }
            HashMap<String, Object> requestMap = new HashMap<String, Object>();
            requestMap.put("organ_prd_uuid", sipOrganProductCurrent.getOrganPrdUuid());
            requestMap.put("organ_id", sipOrganProductCurrent.getOrganId());
            requestMap.put("channel_no", sipOrganProductCurrent.getChannelNo());
            requestMap.put("add_batch", sipOrganProductCurrent.getOrganPrdUuid());
            requestMap.put("delivery_platform", deliveryPlatform);
            requestMap.put("product_uuid", sipOrganProductCurrent.getProductUuid());
            requestMap.put("source", queryPdDetailVo.getSource());
            requestMap.put("use_scene", queryPdDetailVo.getUseScene());
            String key = deliveryPlatform + ":" + product.getProductNo() + ":" + sipOrganProductCurrent.getOrganId() + ":" + sipOrganProductCurrent.getChannelNo() + ":" + sipOrganProductCurrent.getOrganPrdUuid();
            ReturnMsg queryAppPrdDetail = this.queryAppPrdDetail(requestMap);
            Map productData = (Map)queryAppPrdDetail.getDataList().get(0);
            productDataList.add(productData);
            if (this.delByKey.equals("Y")) {
                productDataList.forEach(p -> ProductCacheServiceImpl.delByKey(p));
            }
            CacheManager.put((String)("prdDetail:" + key), (Object)RequestsUtil.return2Json(queryAppPrdDetail));
        }
        msg.setDataList(productDataList);
        return RequestsUtil.return2Json(msg.msg());
    }

    private static Map<String, Object> delByKey(Map<String, Object> map) {
        Set<String> keySet = map.keySet();
        Iterator<String> iterator2 = keySet.iterator();
        while (iterator2.hasNext()) {
            String key = iterator2.next();
            Object value = map.get(key);
            if (value instanceof List) {
                ((List)value).stream().forEach(o -> {
                    if (o instanceof Map) {
                        Map<String, Object> m = ProductCacheServiceImpl.delByKey(JsonUtils.json2Map((String)JsonUtils.toJson((Object)o)));
                        ((Map)o).clear();
                        ((Map)o).putAll(m);
                    }
                });
            }
            if (value instanceof Map) {
                ProductCacheServiceImpl.delByKey((Map)value);
            }
            if (!(value instanceof String)) continue;
            if (key.contains("json") || key.contains("Json")) {
                if (((String)value).startsWith("[")) {
                    List list = JsonUtils.json2List((String)((String)value));
                    list.forEach(o -> {
                        o.clear();
                        o.putAll(ProductCacheServiceImpl.delByKey(o));
                    });
                    map.put(key, JsonUtils.toJson((Object)list));
                } else {
                    map.put(key, ProductCacheServiceImpl.delByKey(JsonUtils.json2Map((String)((String)value))));
                }
            }
            if (key.contains("rule_info")) {
                if (!StrUtils.isNull((Object)value)) {
                    value = ProductCacheServiceImpl.simplifyRuleInfoJson((String)value);
                }
                map.put(key, value);
            }
            if (!KEYS.contains(key)) continue;
            iterator2.remove();
            map.remove(key);
        }
        return map;
    }

    public static String simplifyRuleInfoJson(String originRuleInfoJson) {
        JSONArray objects = JSONObject.parseArray((String)originRuleInfoJson);
        String[] includeFields = new String[]{"fact_paramsList", "operator", "fact", "value", "param_code"};
        Set includeFieldSet = Arrays.stream(includeFields).collect(Collectors.toSet());
        System.out.println(objects);
        objects.stream().forEach(p -> {
            JSONObject jsonObject = (JSONObject)p;
            JSONArray onSuccessJSONArray = (JSONArray)jsonObject.get((Object)"onSuccess");
            jsonObject.fluentRemove((Object)"onSuccess");
            JSONArray newOnSuccessJSONArray = new JSONArray();
            onSuccessJSONArray.stream().forEach(q -> {
                JSONObject jsonObject1 = (JSONObject)q;
                JSONObject newOnSuccessJsonObject = new JSONObject();
                Set keySet = jsonObject1.keySet();
                keySet.stream().forEach(key -> {
                    if (includeFieldSet.contains(key)) {
                        newOnSuccessJsonObject.put(key, jsonObject1.get(key));
                    }
                    if (key.equals("fact_paramsList") && !StrUtils.isNull((Object)((JSONArray)jsonObject1.get((Object)"fact_paramsList")))) {
                        JSONArray factParamsListJSONArray = (JSONArray)jsonObject1.get(key);
                        JSONArray newFactParamsListJSONArray = new JSONArray();
                        factParamsListJSONArray.stream().forEach(f -> {
                            JSONObject jsonObjectf = (JSONObject)f;
                            JSONObject newFactParamsListJsonObject = new JSONObject();
                            Set keySetf = jsonObjectf.keySet();
                            keySetf.stream().forEach(keyf -> {
                                if (includeFieldSet.contains(keyf)) {
                                    newFactParamsListJsonObject.put(keyf, jsonObjectf.get(keyf));
                                }
                            });
                            newFactParamsListJSONArray.add((Object)newFactParamsListJsonObject);
                        });
                        newOnSuccessJsonObject.put("fact_paramsList", (Object)newFactParamsListJSONArray);
                    }
                });
                newOnSuccessJSONArray.add((Object)newOnSuccessJsonObject);
            });
            jsonObject.put("onSuccess", (Object)newOnSuccessJSONArray);
            JSONArray onFailureJSONArray = (JSONArray)jsonObject.get((Object)"onFailure");
            jsonObject.fluentRemove((Object)"onFailure");
            JSONArray newOnFailureJSONArray = new JSONArray();
            onFailureJSONArray.stream().forEach(q -> {
                JSONObject jsonObject1 = (JSONObject)q;
                JSONObject newOnFailureJsonObject = new JSONObject();
                Set keySet = jsonObject1.keySet();
                keySet.stream().forEach(key -> {
                    if (includeFieldSet.contains(key)) {
                        newOnFailureJsonObject.put(key, jsonObject1.get(key));
                    }
                    if (key.equals("fact_paramsList") && !StrUtils.isNull((Object)((JSONArray)jsonObject1.get((Object)"fact_paramsList")))) {
                        JSONArray factParamsListJSONArray = (JSONArray)jsonObject1.get(key);
                        JSONArray newFactParamsListJSONArray = new JSONArray();
                        factParamsListJSONArray.stream().forEach(f -> {
                            JSONObject jsonObjectf = (JSONObject)f;
                            JSONObject newFactParamsListJsonObject = new JSONObject();
                            Set keySetf = jsonObjectf.keySet();
                            keySetf.stream().forEach(keyf -> {
                                if (includeFieldSet.contains(keyf)) {
                                    newFactParamsListJsonObject.put(keyf, jsonObjectf.get(keyf));
                                }
                            });
                            newFactParamsListJSONArray.add((Object)newFactParamsListJsonObject);
                        });
                        newOnFailureJsonObject.put("fact_paramsList", (Object)newFactParamsListJSONArray);
                    }
                });
                newOnFailureJSONArray.add((Object)newOnFailureJsonObject);
            });
            jsonObject.put("onFailure", (Object)newOnFailureJSONArray);
            JSONObject conditions = (JSONObject)jsonObject.get((Object)"conditions");
            JSONObject newConditions = new JSONObject();
            ProductCacheServiceImpl.recursion(conditions, newConditions);
            jsonObject.put("conditions", (Object)newConditions);
        });
        return objects.toJSONString();
    }

    public static void recursion(JSONObject originalJsonObject, JSONObject newJsonObject) {
        if (StrUtils.isNull((Object)originalJsonObject.get((Object)"and")) && StrUtils.isNull((Object)originalJsonObject.get((Object)"or"))) {
            return;
        }
        String[] includeFields = new String[]{"operator", "fact", "value"};
        Set includeFieldSet = Arrays.stream(includeFields).collect(Collectors.toSet());
        if (!StrUtils.isNull((Object)originalJsonObject.get((Object)"and"))) {
            JSONArray andJsonArrray = (JSONArray)originalJsonObject.get((Object)"and");
            JSONArray newAddJsonArray = new JSONArray();
            andJsonArrray.stream().forEach(q -> {
                JSONObject jsonObject2 = (JSONObject)q;
                JSONObject addJsonObject = new JSONObject();
                Set keySet = jsonObject2.keySet();
                keySet.stream().forEach(key -> {
                    if (includeFieldSet.contains(key)) {
                        addJsonObject.put(key, jsonObject2.get(key));
                    }
                    if (key.equals("fact_paramsList") && !StrUtils.isNull((Object)((JSONArray)jsonObject2.get((Object)"fact_paramsList")))) {
                        JSONArray factParamsListJSONArray = (JSONArray)jsonObject2.get(key);
                        JSONArray newFactParamsListJSONArray = new JSONArray();
                        factParamsListJSONArray.stream().forEach(f -> {
                            JSONObject jsonObjectf = (JSONObject)f;
                            JSONObject newFactParamsListJsonObject = new JSONObject();
                            Set keySetf = jsonObjectf.keySet();
                            keySetf.stream().forEach(keyf -> {
                                if (includeFieldSet.contains(keyf)) {
                                    newFactParamsListJsonObject.put(keyf, jsonObjectf.get(keyf));
                                }
                            });
                            newFactParamsListJSONArray.add((Object)newFactParamsListJsonObject);
                        });
                        addJsonObject.put("fact_paramsList", (Object)newFactParamsListJSONArray);
                    }
                });
                ProductCacheServiceImpl.recursion(jsonObject2, addJsonObject);
                newAddJsonArray.add((Object)addJsonObject);
            });
            newJsonObject.put("and", (Object)newAddJsonArray);
        }
        if (!StrUtils.isNull((Object)originalJsonObject.get((Object)"or"))) {
            JSONArray orJsonArray = (JSONArray)originalJsonObject.get((Object)"or");
            JSONArray newOrJsonArray = new JSONArray();
            orJsonArray.stream().forEach(q -> {
                JSONObject jsonObject2 = (JSONObject)q;
                JSONObject orJsonObject = new JSONObject();
                Set keySet = jsonObject2.keySet();
                keySet.stream().forEach(key -> {
                    if (includeFieldSet.contains(key)) {
                        orJsonObject.put(key, jsonObject2.get(key));
                    }
                    if (key.equals("fact_paramsList") && !StrUtils.isNull((Object)((JSONArray)jsonObject2.get((Object)"fact_paramsList")))) {
                        JSONArray factParamsListJSONArray = (JSONArray)jsonObject2.get(key);
                        JSONArray newFactParamsListJSONArray = new JSONArray();
                        factParamsListJSONArray.stream().forEach(f -> {
                            JSONObject jsonObjectf = (JSONObject)f;
                            JSONObject newFactParamsListJsonObject = new JSONObject();
                            Set keySetf = jsonObjectf.keySet();
                            keySetf.stream().forEach(keyf -> {
                                if (includeFieldSet.contains(keyf)) {
                                    newFactParamsListJsonObject.put(keyf, jsonObjectf.get(keyf));
                                }
                            });
                            newFactParamsListJSONArray.add((Object)newFactParamsListJsonObject);
                        });
                        orJsonObject.put("fact_paramsList", (Object)newFactParamsListJSONArray);
                    }
                });
                ProductCacheServiceImpl.recursion(jsonObject2, orJsonObject);
                newOrJsonArray.add((Object)orJsonObject);
            });
            newJsonObject.put("or", (Object)newOrJsonArray);
        }
    }

    private SipOrganProducts getSipOrganProducts(String organId, String channelNo, String deliveryPlatform, String productUuid, String addBatch) {
        String organizationLevel = this.getOrganizationLevel(organId);
        String curOrganId = organId;
        String tempOrganId = "1000000";
        int endIndex = 7;
        if ("4".equals(organizationLevel)) {
            endIndex = 7;
        }
        if ("3".equals(organizationLevel)) {
            endIndex = 5;
        }
        if ("2".equals(organizationLevel)) {
            endIndex = 3;
        }
        SipOrganProducts sopSelect = new SipOrganProducts();
        sopSelect.where().addEq(SipOrganProducts.IS_ENABLE, (Object)"ON");
        sopSelect.where().addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo);
        sopSelect.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
        sopSelect.where().addLike(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform);
        sopSelect.where().addEq(SipOrganProducts.DATA_FLAG, (Object)"1");
        if ("1".equals(organizationLevel)) {
            List sipOrganProductsList;
            sopSelect.where().addEq(SipProducts.ORGAN_ID, (Object)curOrganId);
            if (!StrUtils.isNull((Object)addBatch)) {
                sopSelect.where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)addBatch);
            }
            if ((sipOrganProductsList = this.dao.findAll((AbsModel)sopSelect)) != null && !sipOrganProductsList.isEmpty()) {
                return (SipOrganProducts)sipOrganProductsList.get(0);
            }
            return new SipOrganProducts();
        }
        while (true) {
            if (curOrganId.equals(organId) && !StrUtils.isNull((Object)addBatch)) {
                sopSelect.where().addEq(SipProducts.ORGAN_ID, (Object)curOrganId);
                sopSelect.where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)addBatch);
            } else {
                sopSelect = new SipOrganProducts();
                sopSelect.where().addEq(SipProducts.ORGAN_ID, (Object)curOrganId);
                sopSelect.where().addEq(SipOrganProducts.IS_ENABLE, (Object)"ON");
                sopSelect.where().addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo);
                sopSelect.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
                sopSelect.where().addLike(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform);
                sopSelect.where().addEq(SipOrganProducts.DATA_FLAG, (Object)"1");
            }
            List sipOrganProductsList = this.dao.findAll((AbsModel)sopSelect);
            if (sipOrganProductsList != null && !sipOrganProductsList.isEmpty()) {
                return (SipOrganProducts)sipOrganProductsList.get(0);
            }
            if (tempOrganId.equals(curOrganId)) {
                return new SipOrganProducts();
            }
            curOrganId = organId.substring(0, endIndex -= 2).concat(tempOrganId.substring(endIndex));
        }
    }

    private List<Map<String, Object>> queryOrganProductList(Map<String, Object> param) {
        String organId = StrUtils.trimStr((Object)param.get("organ_id"));
        String channelNo = StrUtils.trimStr((Object)param.get("channel_no"));
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        String sql = "SELECT * FROM sip_products sp  JOIN sip_organ_products sop ON sp.product_uuid = sop.product_uuid WHERE sop.data_flag= ? AND sop.organ_id = ?  and sop.channel_no=? and delivery_platform = ? and is_enable = ?";
        ArrayList<String> querySql = new ArrayList<String>();
        querySql.add("1");
        querySql.add(organId);
        querySql.add(channelNo);
        querySql.add(deliveryPlatform);
        querySql.add("ON");
        List findAllPrd = this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(querySql)});
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Map productResult : findAllPrd) {
            this.dealResultList(param, querySql, resultList, productResult);
        }
        return resultList;
    }

    private void dealResultList(Map<String, Object> param, List<String> querySql, List<Map<String, Object>> resultList, Map<String, Object> productResult) {
        Object organProduct;
        String type = StrUtils.trimStr((Object)productResult.get("product_catefory"));
        String productUuid = StrUtils.trimStr((Object)productResult.get("product_uuid"));
        param.put("product_uuid", productUuid);
        String productCode = StrUtils.trimStr((Object)productResult.get("product_no"));
        productResult.put("is_omnipotent", "N");
        if ("Z".equals(type)) {
            // empty if block
        }
        if ((organProduct = null) != null) {
            List organPrdList = this.dao.findAll(SipOrganProductInfo.n().where().addEq(SipOrganProductInfo.ORGAN_PRD_UUID, (Object)organProduct.getOrganPrdUuid()).model());
            if (null != organPrdList && !organPrdList.isEmpty()) {
                for (SipOrganProductInfo prdInfo : organPrdList) {
                    String key = prdInfo.getAttrNo();
                    String value = prdInfo.getAttrValue();
                    if ("product_tip".equals(key)) {
                        String originValue = StrUtils.trimStr((Object)productResult.get("product_tip"));
                        if (StrUtils.isNull((Object)originValue) || StrUtils.isNull((Object)value)) {
                            value = StrUtils.isNull((Object)originValue) ? value : originValue;
                        } else {
                            String[] originSplits = originValue.split(",");
                            String[] splits = value.split(",");
                            List<String> list = Arrays.asList(originSplits);
                            for (String elm : splits) {
                                if (list.contains(elm)) continue;
                                list.add(elm);
                            }
                            StringJoiner stringJoiner = new StringJoiner(",");
                            list.forEach(p -> stringJoiner.add((CharSequence)p));
                            value = stringJoiner.toString();
                        }
                    }
                    productResult.put(key, value);
                }
            }
            productResult.put("pol_start_date", organProduct.getPolStartDate());
            productResult.put("pol_end_date", organProduct.getPolEndDate());
            productResult.put("prp_start_date", organProduct.getPrpStartDate());
            productResult.put("prp_end_date", organProduct.getPrpEndDate());
        }
        resultList.add(productResult);
    }

    public ReturnMsg getProductRiskDetail(Map<String, Object> requestMap, String useScene) {
        String productNo = StrUtils.trimStr((Object)requestMap.get("product_code"));
        String channelNo = StrUtils.trimStr((Object)requestMap.get("channel_no"));
        String organId = StrUtils.trimStr((Object)requestMap.get("organ_id"));
        String deliveryPlatform = StrUtils.trimStr((Object)requestMap.get("delivery_platform"));
        String organPrdUuid = StrUtils.trimStr((Object)requestMap.get("organ_prd_uuid"));
        String key = deliveryPlatform + ":" + productNo + ":" + organId + ":" + channelNo + ":" + organPrdUuid;
        ReturnMsg queryAppPrdDetail = this.queryAppPrdDetail(requestMap);
        if ("propose".equals(useScene)) {
            CacheManager.put((String)("prpPrdDetail:" + key), (Object)RequestsUtil.return2Json(queryAppPrdDetail));
        } else {
            CacheManager.put((String)("prdDetail:" + key), (Object)RequestsUtil.return2Json(queryAppPrdDetail));
        }
        return queryAppPrdDetail;
    }

    @Override
    public ReturnMsg queryAppPrdDetail(Map<String, Object> requestMap) {
        Return result = new Return();
        ReturnMsg queryProductDetail = this.queryProductDetail(requestMap);
        List productDataList = queryProductDetail.getDataList();
        Map productDataTable = queryProductDetail.getDataTable();
        List riskList = JsonUtils.json2List((String)JsonUtils.toJson(productDataTable.get("riskInfo")), DsnStructure.class);
        ArrayList<Map> listRisk = new ArrayList<Map>();
        Map product = (Map)productDataList.get(0);
        for (DsnStructure riskVo : riskList) {
            requestMap.put("risk_uuid", riskVo.getNodeNo());
            ReturnMsg queryRiskDetail = this.riskService.queryRiskDetail(requestMap, product);
            Map riskDetail = queryRiskDetail.getDataTable();
            riskDetail.put("product_code", product.get("product_no"));
            riskDetail.put("product_name", product.get("product_name"));
            listRisk.add(riskDetail);
            product.put("pol_policy_risk", listRisk);
        }
        productDataList.forEach(p -> ProductCacheServiceImpl.delByKey(p));
        result.setDataList(productDataList);
        return result.msg();
    }

    @Override
    public ReturnMsg queryProductDetail(Map<String, Object> param) {
        Return msg = new Return();
        ArrayList<Map<String, Object>> queryProductResult = new ArrayList<Map<String, Object>>();
        Map<String, Object> organPrdDetail = this.queryAppOrganPrdDetail(param);
        queryProductResult.add(organPrdDetail);
        msg.setDataList(queryProductResult);
        String productUuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        Ulog.info((String)("\u6839\u636eproduct_uuid\u67e5\u8be2\u4e3b\u9669\u4fe1\u606f\u7684\u5165\u53c2\uff1a" + productUuid));
        List<Map<String, Object>> riskInfo = this.structureDao.queryMainRiskByProductUuid(productUuid);
        Ulog.info((String)("\u6839\u636eproduct_uuid\u67e5\u8be2\u4e3b\u9669\u4fe1\u606f\u7684\u8fd4\u53c2\uff1a" + JsonUtils.toJson(riskInfo)));
        msg.getDataTable().put("riskInfo", riskInfo);
        return msg.msg();
    }

    @Override
    public Map<String, Object> queryAppOrganPrdDetail(Map<String, Object> param) {
        String productUuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        String organId = StrUtils.trimStr((Object)param.get("organ_id"));
        String channelNo = StrUtils.trimStr((Object)param.get("channel_no"));
        String addBatch = StrUtils.trimStr((Object)param.get("add_batch"));
        String deliveryPlatform = StrUtils.trimStr((Object)param.get("delivery_platform"));
        List products = this.dao.findAll4Map(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)productUuid).model());
        if (products.isEmpty()) {
            return null;
        }
        Map product = (Map)products.get(0);
        String curOrganId = "1000000";
        int endIndex = 1;
        while (true) {
            List sipOrganProductsList;
            SipOrganProducts sopSelect = new SipOrganProducts();
            sopSelect.where().addEq(SipOrganProducts.ORGAN_ID, (Object)curOrganId);
            sopSelect.where().addEq(SipOrganProducts.IS_ENABLE, (Object)"ON");
            sopSelect.where().addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo);
            sopSelect.where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid);
            sopSelect.where().addLike(SipOrganProducts.DELIVERY_PLATFORM, (Object)deliveryPlatform);
            sopSelect.where().addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model();
            if (organId.equals(curOrganId) && !StrUtils.isNull((Object)addBatch)) {
                sopSelect.where().addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)addBatch).model();
            }
            if ((sipOrganProductsList = this.dao.findAll((AbsModel)sopSelect)) != null) {
                if (sipOrganProductsList.size() == 1) {
                    List organProductInfoList = this.dao.findAll(SipOrganProductInfo.n().where().addEq(SipOrganProductInfo.ORGAN_PRD_UUID, (Object)((SipOrganProducts)sipOrganProductsList.get(0)).getOrganPrdUuid()).addEq(SipOrganProductInfo.DATA_FLAG, (Object)"1").model());
                    Map<String, SipOrganProductInfo> collect = organProductInfoList.stream().collect(Collectors.groupingBy(SipOrganProductInfo::getAttrNo, Collectors.collectingAndThen(Collectors.toList(), val -> val != null && !val.isEmpty() ? (SipOrganProductInfo)val.get(0) : null)));
                    for (String key : product.keySet()) {
                        SipOrganProductInfo productInfo = collect.get(key);
                        if (productInfo == null || StrUtils.isNull((Object)productInfo.getAttrValue())) continue;
                        product.put(key, productInfo.getAttrValue());
                    }
                }
                if (sipOrganProductsList.size() > 1) {
                    for (SipOrganProducts sipOrganProducts : sipOrganProductsList) {
                        if (!sipOrganProducts.getOrganPrdUuid().equals(addBatch)) continue;
                        List organProductInfoList = this.dao.findAll(SipOrganProductInfo.n().where().addEq(SipOrganProductInfo.ORGAN_PRD_UUID, (Object)((SipOrganProducts)sipOrganProductsList.get(0)).getOrganPrdUuid()).addEq(SipOrganProductInfo.DATA_FLAG, (Object)"1").model());
                        Map<String, SipOrganProductInfo> collect = organProductInfoList.stream().collect(Collectors.groupingBy(SipOrganProductInfo::getAttrNo, Collectors.collectingAndThen(Collectors.toList(), val -> val != null && !val.isEmpty() ? (SipOrganProductInfo)val.get(0) : null)));
                        for (String key : product.keySet()) {
                            SipOrganProductInfo productInfo = collect.get(key);
                            if (productInfo == null || StrUtils.isNull((Object)productInfo.getAttrValue())) continue;
                            product.put(key, productInfo.getAttrValue());
                        }
                    }
                }
            }
            if (organId.equals(curOrganId)) break;
            curOrganId = organId.substring(0, endIndex += 2).concat(curOrganId.substring(endIndex));
        }
        return product;
    }

    private String getNeaUpOrgPrdInfo(String productUuid, String organId, String channelNo, String key) {
        SipOrganProductInfo organProductInfo;
        SipOrganProducts organProduct = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipOrganProducts.PRODUCT_UUID, (Object)productUuid).addEq(SipOrganProducts.ORGAN_ID, (Object)organId).addEq(SipOrganProducts.CHANNEL_NO, (Object)channelNo).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model());
        if (organProduct != null && null != (organProductInfo = (SipOrganProductInfo)this.dao.findOne(SipOrganProductInfo.n().where().addEq(SipOrganProductInfo.ORGAN_PRD_UUID, (Object)organProduct.getOrganPrdUuid()).addEq(SipOrganProductInfo.ATTR_NO, (Object)key).addEq(SipOrganProductInfo.DATA_FLAG, (Object)"1").model()))) {
            return organProductInfo.getAttrValue();
        }
        String sql = "select c.parent_id,c.organ_id,c.company_name,c.class_id from ws_life_t_company_organ  c where c.organ_id = ? and c.data_flag = ? ";
        Map map = this.dao.getJdbcTemplate().queryForMap(sql, new Object[]{organId, "1"});
        String parentOrganId = (String)map.get("parent_id");
        if (StrUtils.isNull((Object)parentOrganId)) {
            return null;
        }
        return this.getNeaUpOrgPrdInfo(productUuid, parentOrganId, channelNo, key);
    }

    @Override
    public ReturnMsg saveProductDetailToRedis(String organPrdUuid) {
        String[] splitArr;
        SipOrganProducts organProduct = (SipOrganProducts)this.dao.findOne(SipOrganProducts.n().where().addEq(SipOrganProducts.IS_ENABLE, (Object)"ON").addEq(SipOrganProducts.ORGAN_PRD_UUID, (Object)organPrdUuid).addEq(SipOrganProducts.DATA_FLAG, (Object)"1").model());
        if (organProduct == null || StrUtils.isNull((Object)organProduct.getOrganPrdUuid())) {
            throw new BusinessException("\u6b64\u6279\u6b21\u53f7\u5bf9\u5e94\u7684\u4ea7\u54c1\u672a\u4e0a\u67b6\uff0c\u8bf7\u68c0\u67e5");
        }
        SipProducts sipProduct = (SipProducts)this.dao.findOne(SipProducts.n().where().addEq(SipProducts.PRODUCT_UUID, (Object)organProduct.getProductUuid()).model());
        String deliveryPlatformStr = organProduct.getDeliveryPlatform();
        for (String deliveryPlatform : splitArr = deliveryPlatformStr.split(",")) {
            String redisKey = "prdDetail:" + deliveryPlatform + ":" + sipProduct.getProductNo() + ":" + organProduct.getOrganId() + ":" + organProduct.getChannelNo() + ":" + organPrdUuid;
            CacheManager.remove((String)redisKey);
            HashMap<String, Object> requestMap = new HashMap<String, Object>();
            requestMap.put("organ_prd_uuid", organPrdUuid);
            requestMap.put("organ_id", organProduct.getOrganId());
            requestMap.put("channel_no", organProduct.getChannelNo());
            requestMap.put("add_batch", organPrdUuid);
            requestMap.put("delivery_platform", deliveryPlatform);
            requestMap.put("product_uuid", organProduct.getProductUuid());
            requestMap.put("source", "app");
            requestMap.put("use_scene", "insure");
            ReturnMsg queryAppPrdDetail = this.queryAppPrdDetail(requestMap);
            CacheManager.put((String)redisKey, (Object)RequestsUtil.return2Json(queryAppPrdDetail));
        }
        Return msg = new Return();
        msg.setSuccessMsg("\u7f13\u5b58\u4ea7\u54c1\u9669\u79cd\u4fe1\u606f\u6210\u529f");
        return msg.msg();
    }

    @Override
    public void delSubOrganRedis(String deliveryPlatform, String productNo, String organId, String channelNo) {
        int endIndex;
        int beginIndex;
        if ("1000000".equals(organId)) {
            beginIndex = 0;
            endIndex = 1;
        } else if ((organId.subSequence(0, 3) + "0000").equals(organId)) {
            beginIndex = 0;
            endIndex = 3;
        } else if ((organId.subSequence(0, 5) + "00").equals(organId)) {
            beginIndex = 0;
            endIndex = 5;
        } else {
            beginIndex = 0;
            endIndex = 7;
        }
        String prdDetailKeyPattern = "prdDetail:" + deliveryPlatform + ":" + productNo + organId.subSequence(beginIndex, endIndex) + (endIndex == 7 ? "" : "*") + channelNo;
        for (String key : CacheManager.keys((String)prdDetailKeyPattern)) {
            CacheManager.remove((String)key);
        }
    }

    @Override
    public List<Map<String, Object>> getProductListCache(String organId, String channelNo, String deliveryPlatform) {
        List headProductList = new ArrayList();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap headMap = new HashMap();
        HashMap<String, Map> organMap = new HashMap<String, Map>();
        HashMap<String, Map> organMa = new HashMap<String, Map>();
        HashMap<String, Map> om = new HashMap<String, Map>();
        String headOffice = "prdList:" + deliveryPlatform + ":1000000" + channelNo;
        Ulog.info((String)("\u5168\u56fd\u53ef\u552e\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684key" + headOffice));
        String headOfficeResult = (String)CacheManager.get((String)headOffice);
        Ulog.info((String)("\u5168\u56fd\u53ef\u552e\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + headOfficeResult));
        if (!StrUtils.isNull((Object)headOfficeResult)) {
            headProductList = JsonUtils.json2List((String)StrUtils.trimStr((Object)headOfficeResult));
        }
        for (Map map1 : headProductList) {
            headMap.put(StrUtils.trimStr(map1.get("product_no")), map1);
        }
        String branchOffice = "prdList:" + deliveryPlatform + ":" + organId + channelNo;
        Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684key" + branchOffice));
        String branchResult = (String)CacheManager.get((String)branchOffice);
        Ulog.info((String)("\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + branchResult));
        branchOffice = "prdList:" + deliveryPlatform + ":" + organId.subSequence(0, 5) + "00" + channelNo;
        Ulog.info((String)("\u5e02\u7ea7\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684key" + branchOffice));
        String branchRe = (String)CacheManager.get((String)branchOffice);
        Ulog.info((String)("\u5e02\u7ea7\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + branchRe));
        branchOffice = "prdList:" + deliveryPlatform + ":" + organId.subSequence(0, 3) + "0000" + channelNo;
        String br = (String)CacheManager.get((String)branchOffice);
        Ulog.info((String)("\u7701\u7ea7\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684key" + branchOffice));
        Ulog.info((String)("\u7701\u7ea7\u5206\u516c\u53f8\u4ea7\u54c1\u5217\u8868\u7f13\u5b58\u7684value" + br));
        if (!StrUtils.isNull((Object)branchResult)) {
            List organProductList = JsonUtils.json2List((String)StrUtils.trimStr((Object)branchResult));
            for (Map map2 : organProductList) {
                organMap.put(StrUtils.trimStr(map2.get("product_no")), map2);
            }
            headMap.putAll(organMap);
        }
        if (!StrUtils.isNull((Object)branchRe)) {
            List organProduct = JsonUtils.json2List((String)StrUtils.trimStr((Object)branchRe));
            for (Map map2 : organProduct) {
                organMa.put(StrUtils.trimStr(map2.get("product_no")), map2);
            }
            for (String s : organMa.keySet()) {
                if (headMap.containsKey(s)) continue;
                headMap.put(s, organMa.get(s));
            }
        }
        if (!StrUtils.isNull((Object)br)) {
            List organ = JsonUtils.json2List((String)StrUtils.trimStr((Object)br));
            for (Map map2 : organ) {
                om.put(StrUtils.trimStr(map2.get("product_no")), map2);
            }
            for (String s : om.keySet()) {
                if (headMap.containsKey(s)) continue;
                headMap.put(s, om.get(s));
            }
        }
        for (String key : headMap.keySet()) {
            result.add((Map)headMap.get(key));
        }
        return result;
    }

    @Override
    public ReturnMsg saveRateDetailToRedis(Map<String, Object> param) {
        Return r = new Return();
        String productUuid = StrUtils.trimStr((Object)param.get("product_uuid"));
        List<Map<String, Object>> mainRiskList = this.structureDao.queryMainRiskByProductUuid(productUuid);
        for (Map<String, Object> mainRisk : mainRiskList) {
            this.cacheRiskRateDetail(mainRisk);
            List<DsnStructure> accyDsnStructureList = this.structureDao.queryAccyRiskByMainRiskUuid(StrUtils.trimStr((Object)mainRisk.get("node_no")));
            for (DsnStructure accyRisk : accyDsnStructureList) {
                Map accyRiskMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)accyRisk));
                this.cacheRiskRateDetail(accyRiskMap);
                List<DsnStructure> exemptDsnStructureList = this.structureDao.queryExemptRiskByAccRiskUuid(accyRisk.getNodeNo());
                for (DsnStructure exemptRisk : exemptDsnStructureList) {
                    Map exemptRiskMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)exemptRisk));
                    this.cacheRiskRateDetail(exemptRiskMap);
                }
            }
            List<DsnStructure> exemptDsnStructureList = this.structureDao.queryExemptRiskByMainRiskUuid(StrUtils.trimStr((Object)mainRisk.get("node_no")));
            for (DsnStructure exemptRisk : exemptDsnStructureList) {
                Map exemptRiskMap = JsonUtils.json2Map((String)JsonUtils.toJson((Object)exemptRisk));
                this.cacheRiskRateDetail(exemptRiskMap);
            }
        }
        return r.msg();
    }

    @Override
    public List<Map> queryRateFromRedis(Map<String, Object> param, String feeId, String riskNo) {
        String tableName = TABLE_PREFIX + riskNo + "_" + feeId.toLowerCase();
        HashMap<String, List> rateAttr = new HashMap<String, List>();
        rateAttr.put("tableName", Collections.singletonList(tableName));
        List inputKeys = (List)CacheManager.getHash((String)tableName, (String)"input", List.class);
        rateAttr.put("input", inputKeys);
        List outputKeys = (List)CacheManager.getHash((String)tableName, (String)"output", List.class);
        rateAttr.put("output", outputKeys);
        StringJoiner sj = new StringJoiner("_");
        List rateList = null;
        for (Object input : inputKeys) {
            String inputKey = StrUtils.trimStr(input);
            sj.add(param.get(inputKey).toString());
            rateList = (List)CacheManager.getHash((String)tableName, (String)sj.toString(), List.class);
        }
        List mapList = JsonUtils.json2List((String)JsonUtils.toJson(rateList), Map.class);
        return mapList;
    }

    private void cacheRiskRateDetail(Map<String, Object> mainRisk) {
        DsnStructure nRateNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)StrUtils.trimStr((Object)mainRisk.get("node_no"))).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RATE.code()).model());
        List rateNodeList = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)nRateNode.getNodeNo()).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.RATE.code()).model());
        for (DsnStructure rateNode : rateNodeList) {
            DsnDynamicData ddd = new DsnDynamicData(true);
            ddd.setRelateFk(rateNode.getNodeNo());
            ddd.setRelateTab("dsn_structure");
            ddd.setRelateField("node_no");
            ddd = (DsnDynamicData)this.dao.findOne((AbsModel)ddd);
            if (ddd == null) continue;
            String nodeNo = ddd.getRelateFk();
            DsnStructure ds = new DsnStructure(true);
            ds.setUpNode(nodeNo);
            List dsList = this.dao.findAll((AbsModel)ds);
            Map<String, List<DsnStructure>> dsGroup = dsList.stream().collect(Collectors.groupingBy(DsnStructure::getNodeType));
            List<String> input = this.queryAttr(dsGroup.get("input").get(0));
            List<String> output = this.queryAttr(dsGroup.get("output").get(0));
            String tableName = rateNode.getRelateTab();
            CacheManager.putHash((String)tableName, (String)"input", input);
            CacheManager.putHash((String)tableName, (String)"output", output);
            try {
                if (!this.queryTableInDB(tableName)) {
                    return;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BusinessException("\u67e5\u8be2\u8868\u662f\u5426\u5b58\u5728\u5f02\u5e38");
            }
            StringBuilder querySql = new StringBuilder("select * from " + tableName + " \uff03NOTCHECK");
            List mapList = this.dao.findAll(querySql.toString(), new AbsModelRepository.Args[0]);
            Map<Object, List<Map>> map = mapList.stream().collect(Collectors.groupingBy(p -> {
                StringJoiner sj = new StringJoiner("_");
                for (String key : input) {
                    sj.add(StrUtils.trimStr(p.get(key)));
                }
                return sj.toString();
            }));
            for (Map.Entry<Object, List<Map>> temp : map.entrySet()) {
                CacheManager.putHash((String)tableName, (String)StrUtils.trimStr((Object)temp.getKey()), temp.getValue());
            }
        }
    }

    private List<String> queryAttr(DsnStructure node) {
        String sql = "SELECT dba.* FROM dsn_structure ds, dsn_biz_attribute dba       WHERE ds.node_no = dba.biz_uuid         AND ds.node_type = ?         AND ds.node_seq like ? ORDER BY dba.display_order";
        List dsnList = this.dao.findAll(sql, DsnBizAttribute.class, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{"attr4Rate", node.getNodeSeq() + "%"})});
        List<String> input = dsnList.stream().map(DsnBizAttribute::getAttrNo).collect(Collectors.toList());
        return input;
    }

    private boolean queryTableInDB(String table_name) throws SQLException {
        Connection conn = this.dao.getJdbcTemplate().getDataSource().getConnection();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = conn.getMetaData().getTables(null, null, "%", types);
        while (rs.next()) {
            String tabName = StrUtils.trimStr((Object)rs.getObject("TABLE_NAME"));
            if (DBTypes.ORACLE.equals((Object)this.dao.getDbType())) {
                table_name = table_name.toUpperCase();
            }
            if (!tabName.equals(table_name)) continue;
            rs.close();
            conn.close();
            return true;
        }
        rs.close();
        conn.close();
        return false;
    }
}

