/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.rule;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.List;

public class RuleInfo
implements Comparable {
    private DsnRules rule;
    private List<DsnRulesConst> ruleConstList;
    private List<DsnRulesParam> rulesParamList;

    public RuleInfo load(DsnRules rule) {
        this.rule = rule;
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.ruleConstList = utils.queryRuleConst(this.rule.getRuleId());
        this.rulesParamList = utils.queryRuleParam(this.rule.getRuleId());
        return this;
    }

    public void merge(RuleInfo ruleInfo) {
        this.rule = ProductEqualsUtils.merge(this.rule, ruleInfo.getRule());
        this.ruleConstList = ProductEqualsUtils.merge(this.ruleConstList, ruleInfo.getRuleConstList());
        this.rulesParamList = ProductEqualsUtils.merge(this.rulesParamList, ruleInfo.getRulesParamList());
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        update.update((AbsModel)this.rule);
        this.ruleConstList.forEach(rulesConst -> update.update((AbsModel)rulesConst));
        this.rulesParamList.forEach(rulesParam -> update.update((AbsModel)rulesParam));
    }

    public TreeNode fetchTreeNode() {
        if (this.rule == null) {
            return null;
        }
        TreeNode node = new TreeNode(CompareEnum.NodeType.RULE_BODY.getTag() + this.rule.getSerno(), this.rule.getRuleName());
        node.getChildren().add(new TreeNode(this.rule.getSerno(), this.rule, CompareEnum.NodeType.INFO));
        if (this.ruleConstList != null && this.ruleConstList.size() > 0) {
            TreeNode ruleConstList = new TreeNode(CompareEnum.NodeType.CONSTANT_ARRAY.getTag() + this.rule.getSerno(), CompareEnum.NodeType.CONSTANT_ARRAY.getLable());
            node.getChildren().add(ruleConstList);
            this.ruleConstList.forEach(rulesConst -> ruleConstList.getChildren().add(new TreeNode(rulesConst.getSerno(), rulesConst, CompareEnum.NodeType.CONSTANT)));
        }
        if (this.rulesParamList != null && this.rulesParamList.size() > 0) {
            TreeNode rulesParamList = new TreeNode(CompareEnum.NodeType.PARAM_ARRAY.getTag() + this.rule.getSerno(), CompareEnum.NodeType.PARAM_ARRAY.getLable());
            node.getChildren().add(rulesParamList);
            this.rulesParamList.forEach(rulesParam -> rulesParamList.getChildren().add(new TreeNode(rulesParam.getSerno(), rulesParam, CompareEnum.NodeType.PARAM)));
        }
        return node;
    }

    public DsnRules getRule() {
        return this.rule;
    }

    public void setRule(DsnRules rule) {
        this.rule = rule;
    }

    public List<DsnRulesConst> getRuleConstList() {
        return this.ruleConstList;
    }

    public void setRuleConstList(List<DsnRulesConst> ruleConstList) {
        this.ruleConstList = ruleConstList;
    }

    public List<DsnRulesParam> getRulesParamList() {
        return this.rulesParamList;
    }

    public void setRulesParamList(List<DsnRulesParam> rulesParamList) {
        this.rulesParamList = rulesParamList;
    }

    public int hashCode() {
        return this.rule.getOtherProperty("md5").hashCode();
    }

    public int compareTo(Object o) {
        ProductUpdateUtils.UpdateFlag flag = (ProductUpdateUtils.UpdateFlag)((Object)this.rule.getOtherProperty("update_flag", ProductUpdateUtils.UpdateFlag.class));
        if (flag == ProductUpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == ProductUpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }
}

