/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.product.transfer.domain.risk;

import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.enums.CompareEnum;
import com.newtouch.nms.sip.product.transfer.domain.risk.ExemptRisk;
import com.newtouch.nms.sip.product.transfer.domain.risk.LiabilityRisk;
import com.newtouch.nms.sip.product.transfer.domain.risk.Risk;
import com.newtouch.nms.sip.product.transfer.domain.vo.TreeNode;
import com.newtouch.nms.sip.product.transfer.utils.ProductEqualsUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductQueryUtils;
import com.newtouch.nms.sip.product.transfer.utils.ProductUpdateUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;

public class ExemptRiskNode {
    private DsnStructure exemptRisk;
    private List<ExemptRisk> exemptRiskList = new ArrayList<ExemptRisk>();
    private Risk risk;

    public ExemptRiskNode load(String upNode) {
        ProductQueryUtils utils = (ProductQueryUtils)SpringContext.getBean(ProductQueryUtils.class);
        this.exemptRisk = utils.queryStructure(upNode, NodeType.N_EXEMPT.code());
        if (this.exemptRisk != null) {
            utils.queryStructures(this.exemptRisk.getNodeNo()).forEach(dsnExemptRisk -> {
                ExemptRisk risk = new ExemptRisk();
                risk.setMainRisk(this.risk);
                risk.load((DsnStructure)dsnExemptRisk);
                this.exemptRiskList.add(risk);
            });
        }
        return this;
    }

    public void merge(ExemptRiskNode exemptRiskNode) {
        this.exemptRisk = ProductEqualsUtils.merge(this.exemptRisk, exemptRiskNode.getExemptRisk());
        this.exemptRiskList = ProductEqualsUtils.merge(this.exemptRiskList, exemptRiskNode.getExemptRiskList(), ExemptRisk.class);
    }

    public void save() {
        ProductUpdateUtils update = (ProductUpdateUtils)SpringContext.getBean(ProductUpdateUtils.class);
        String source = ThreadLocalContext.get().getRqstSource();
        if (!ProductEqualsUtils.isPropose(source)) {
            update.update((AbsModel)this.exemptRisk);
        }
        if (this.exemptRiskList != null) {
            this.exemptRiskList.forEach(risk -> risk.save());
        }
    }

    public TreeNode fetchTreeNode() {
        if (this.exemptRisk == null) {
            return null;
        }
        TreeNode treeNode = new TreeNode(CompareEnum.NodeType.EXEMPT_RISK.getTag() + this.exemptRisk.getSerno(), CompareEnum.NodeType.EXEMPT_RISK.getLable());
        treeNode.getChildren().add(new TreeNode(this.exemptRisk.getSerno(), this.exemptRisk, CompareEnum.NodeType.STRUCTURE));
        if (this.exemptRiskList != null && this.exemptRiskList.size() > 0) {
            TreeNode exemptRiskList = new TreeNode(CompareEnum.NodeType.EXEMPT_RISK_ARRAY.getTag() + this.exemptRisk.getSerno(), CompareEnum.NodeType.EXEMPT_RISK_ARRAY.getLable());
            treeNode.getChildren().add(exemptRiskList);
            for (LiabilityRisk liabilityRisk : this.exemptRiskList) {
                exemptRiskList.getChildren().add(liabilityRisk.fetchTreeNode());
            }
        }
        return treeNode;
    }

    public void setRisk(Risk risk) {
        this.risk = risk;
    }

    public DsnStructure getExemptRisk() {
        return this.exemptRisk;
    }

    public void setExemptRisk(DsnStructure exemptRisk) {
        this.exemptRisk = exemptRisk;
    }

    public List<ExemptRisk> getExemptRiskList() {
        return this.exemptRiskList;
    }

    public void setExemptRiskList(List<ExemptRisk> exemptRiskList) {
        this.exemptRiskList = exemptRiskList;
    }

    public Risk getRisk() {
        return this.risk;
    }
}

