/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.sip.design.attribute.services.impl;

import com.newtouch.base.service.RuleUsedService;
import com.newtouch.nms.sip.design.attribute.services.IAttributeService;
import com.newtouch.nms.sip.design.tree.services.IPublicTreeService;
import com.newtouch.nms.sip.model.DsnAttribute;
import com.newtouch.nms.sip.model.DsnAttributeOption;
import com.newtouch.nms.sip.model.DsnBizAttribute;
import com.newtouch.nms.sip.model.DsnBizAttributeOption;
import com.newtouch.nms.sip.model.DsnStructure;
import com.newtouch.nms.sip.model.SipProductRisks;
import com.newtouch.nms.sip.model.SipRiskRelation;
import com.newtouch.nms.sip.model.SipRisks;
import com.newtouch.nms.sip.model.enums.NodeType;
import com.newtouch.nms.sip.product.main.services.impl.ProductCopyServiceImpl;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.RepEnum;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class AttributeServiceImpl
implements IAttributeService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private IPublicTreeService treeService;
    @Autowired
    private RuleUsedService ruleUsedService;
    private final String splitTag = "\\|";

    @Override
    public ReturnMsg mdfAttributeInit(String nodeNo) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)nodeNo)) {
            msg.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        DsnStructure str = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)nodeNo).model());
        DsnBizAttribute biz_attr = (DsnBizAttribute)this.dao.findOne(DsnBizAttribute.n().where().addEq(DsnBizAttribute.BIZ_UUID, (Object)nodeNo).model());
        biz_attr.setBizUuid(str.getNodeNo());
        biz_attr.setAttrName(str.getNodeName());
        msg.setDataTable(new Object[]{str});
        msg.setDataTable(new Object[]{biz_attr});
        return msg.msg();
    }

    @Override
    public ReturnMsg mdfAttribute(DsnStructure structure, DsnBizAttribute bizAttr, DsnAttribute allAttr, List<DsnBizAttributeOption> optionList) {
        String uiType;
        List all;
        Return msg = new Return();
        this.validateAttr(msg, bizAttr);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        String nodeNo = structure.getNodeNo();
        this.updateStructure(structure, bizAttr.getAttrName());
        bizAttr.setBizUuid(nodeNo);
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT DISTINCT dba.attr_uuid, dba.attr_no, dba.attr_name, dba.ui_type, dba.not_null   FROM dsn_structure ds, dsn_biz_attribute dba, dsn_attribute da  WHERE ds.node_no = dba.biz_uuid AND dba.attr_uuid = da.attr_uuid AND ds.up_node IN (SELECT upds.node_no FROM dsn_structure upds WHERE upds.node_type = (select node_type from dsn_structure where node_no = ?)) AND da.attr_no = ? AND da.attr_name = ? AND da.ui_type = ?");
        queryValue.add(structure.getUpNode());
        queryValue.add(bizAttr.getAttrNo());
        queryValue.add(bizAttr.getAttrName());
        queryValue.add(bizAttr.getUiType());
        if (!StrUtils.isNull((Object)bizAttr.getAttrUuid())) {
            sql.append("AND da.attr_uuid != ? ");
            queryValue.add(bizAttr.getAttrUuid());
        }
        if ((all = this.dao.findAll(String.valueOf(sql), new AbsModelRepository.Args[]{this.dao.args(queryValue)})) != null && !all.isEmpty()) {
            msg.setFailMsg("\u5c5e\u6027\u4ee3\u7801" + bizAttr.getAttrNo() + ",\u5c5e\u6027\u540d\u79f0" + bizAttr.getAttrName() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u5f55\u5165\uff0c\u8bf7\u4ece\u5df2\u6709\u5c5e\u6027\u4e2d\u9009\u62e9");
            return msg.msg();
        }
        if (AttributeServiceImpl.isNumeric(bizAttr.getAttrNo())) {
            msg.setFailMsg("\u5c5e\u6027\u4ee3\u7801" + bizAttr.getAttrNo() + "\u4e0d\u80fd\u4e3a\u7eaf\u6570\u5b57");
            return msg.msg();
        }
        String attrUuid = UUID.shortUUID();
        if (StrUtils.isNull((Object)bizAttr.getAttrUuid())) {
            bizAttr.setAttrUuid(attrUuid);
        }
        if (StrUtils.isNull((Object)allAttr.getAttrUuid())) {
            allAttr.setAttrUuid(attrUuid);
        }
        if (("radio".equals(uiType = StrUtils.trimStr((Object)bizAttr.getUiType())) || "checkbox".equals(uiType) || "select".equals(uiType) || "radioSelect".equals(uiType)) && optionList.isEmpty()) {
            msg.setFailMsg("\u8bf7\u6dfb\u52a0\u5355\u9009/\u591a\u9009\u4fe1\u606f/\u4e0b\u62c9\u9009\u4fe1\u606f");
            return msg.msg();
        }
        this.updateAttribute(bizAttr, allAttr, optionList);
        return msg.msg();
    }

    public static boolean isNumeric(String str) {
        String regex = "[-,+]?[0-9]+[.]?[0-9]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    private Return updateAttribute(DsnBizAttribute bizAttribute, DsnAttribute allAttribute, List<DsnBizAttributeOption> optionList) {
        Return r = new Return();
        bizAttribute.setBizType(this.queryBizType(bizAttribute.getBizUuid()));
        bizAttribute.setIsMapping("N");
        bizAttribute.where().addEq(DsnBizAttribute.BIZ_UUID, (Object)bizAttribute.getBizUuid());
        this.dao.delete((AbsModel)bizAttribute);
        this.dao.save((AbsModel)bizAttribute);
        if (StrUtils.isNull((Object)allAttribute.getAttrInteger())) {
            allAttribute.setAttrInteger(Integer.valueOf(0));
        }
        allAttribute.where().addEq(DsnAttribute.ATTR_UUID, (Object)allAttribute.getAttrUuid());
        DsnAttribute allAttr = (DsnAttribute)this.dao.findOne((AbsModel)allAttribute);
        if (null == allAttr || StrUtils.isNull((Object)allAttr.getAttrName())) {
            this.dao.save((AbsModel)allAttribute);
        }
        if (!optionList.isEmpty()) {
            this.saveDsnBizAttrOption(optionList, bizAttribute.getBizUuid(), allAttribute.getAttrUuid());
        }
        return r;
    }

    private void saveDsnBizAttrOption(List<DsnBizAttributeOption> attrBizOptList, String bizUuid, String attrUuid) {
        this.dao.delete(DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizUuid).model());
        if (attrBizOptList.isEmpty()) {
            return;
        }
        ArrayList<DsnAttributeOption> attrOptList = new ArrayList<DsnAttributeOption>();
        DsnAttributeOption delAttrOpt = DsnAttributeOption.n();
        for (DsnBizAttributeOption attrOption : attrBizOptList) {
            attrOption.setBizUuid(bizUuid);
            if (StrUtils.isNull((Object)attrOption.getOptionNo())) {
                DsnAttributeOption existAttrOption = this.isExistAttrOption(attrUuid, attrOption.getOptionValue(), attrOption.getOptionName());
                if (existAttrOption != null) {
                    attrOption.setOptionNo(existAttrOption.getOptionNo());
                    continue;
                }
                attrOption.setOptionNo(UUID.shortUUID());
            }
            DsnAttributeOption attrOpt = new DsnAttributeOption();
            BeanUtils.copyProperties((Object)attrOption, (Object)attrOpt);
            attrOpt.setAttrUuid(attrUuid);
            delAttrOpt.where().addIn(DsnAttributeOption.OPTION_NO, new String[]{attrOption.getOptionNo()});
            this.dao.delete((AbsModel)delAttrOpt);
            attrOptList.add(attrOpt);
        }
        this.dao.save(attrBizOptList);
        this.dao.save(attrOptList);
    }

    private DsnAttributeOption isExistAttrOption(String attrUuid, String optionValue, String optionName) {
        if (StrUtils.isNull((Object)attrUuid)) {
            Ulog.error((String)"\u9669\u79cd\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        List attrOptionList = this.dao.findAll(DsnAttributeOption.n().where().addEq(DsnAttributeOption.ATTR_UUID, (Object)attrUuid).addEq(DsnAttributeOption.OPTION_VALUE, (Object)optionValue).addEq(DsnAttributeOption.OPTION_NAME, (Object)optionName).model());
        return attrOptionList == null || attrOptionList.isEmpty() ? null : (DsnAttributeOption)attrOptionList.get(0);
    }

    private void validateAttr(Return msg, DsnBizAttribute attribute) {
        String storedField;
        String sotredTable;
        if (StrUtils.isNull((Object)attribute.getAttrName())) {
            msg.setFailMsg("\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)attribute.getAttrNo())) {
            msg.setFailMsg("\u5c5e\u6027\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)attribute.getDisplayOrder())) {
            msg.setFailMsg("\u663e\u793a\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)attribute.getUiType())) {
            msg.setFailMsg("\u663e\u793a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)(sotredTable = attribute.getStoredTab()))) {
            msg.setFailMsg("\u5b58\u50a8\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)(storedField = attribute.getStoredField()))) {
            msg.setFailMsg("\u5b58\u50a8\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtils.isNull((Object)attribute.getNotNull())) {
            msg.setFailMsg("\u662f\u5426\u5fc5\u586b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private boolean checkDupAttr(String attrNo, String upNode) {
        String sql = "SELECT b.serno FROM dsn_structure a, dsn_biz_attribute b  WHERE a.node_no = b.biz_uuid    AND a.relate_tab = ? AND a.up_node = ?    AND b.attr_no = ? ";
        List result = this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(new Object[]{"dsn_biz_attribute", upNode, attrNo})});
        return result.isEmpty();
    }

    private DsnStructure updateStructure(DsnStructure structure, String nodeName) {
        DsnStructure dbStructure = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)structure.getNodeNo()).model());
        dbStructure.setDisplayOrder(structure.getDisplayOrder());
        dbStructure.setNodeName(nodeName);
        dbStructure.setRelateFk(structure.getNodeNo());
        dbStructure.setRelateTab("dsn_biz_attribute");
        dbStructure.setRelateField("biz_uuid");
        dbStructure.setConfigType("use");
        dbStructure.where().addEq(DsnStructure.NODE_NO, (Object)structure.getNodeNo());
        this.dao.update((AbsModel)dbStructure);
        return dbStructure;
    }

    private String queryBizType(String node_no) {
        String upNode = ((DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)node_no).model())).getUpNode();
        DsnStructure strt = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)upNode).model());
        String nodeType = strt.getNodeType();
        if ("attr_group".equals(nodeType) || "input".equals(nodeType) || "output".equals(nodeType) || "n_liability".equals(nodeType)) {
            this.queryBizType(strt.getNodeNo());
        }
        return nodeType;
    }

    @Override
    public ReturnMsg queryAttributeOption(String attr_uuid) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)attr_uuid)) {
            msg.setFailMsg("\u5c5e\u6027\u4e3b\u952e[attr_uuid]\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        DsnBizAttribute attr = (DsnBizAttribute)this.dao.findOne(DsnBizAttribute.n().where().addEq(DsnBizAttribute.ATTR_UUID, (Object)attr_uuid).model());
        ArrayList battrOptionList = new ArrayList();
        battrOptionList.addAll(this.dao.findAll((AbsModel)((DsnBizAttributeOption)DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)attr.getBizUuid()).model()).setOrderBy(new Sort.Order[]{DsnBizAttributeOption.OPTION_ORDER.asc()})));
        if (!battrOptionList.isEmpty()) {
            msg.getDataTable().put("dsn_biz_attribute_option", battrOptionList);
            return msg.msg();
        }
        battrOptionList.addAll(this.dao.findAll((AbsModel)((DsnAttributeOption)DsnAttributeOption.n().where().addEq(DsnAttributeOption.ATTR_UUID, (Object)attr.getAttrUuid()).model()).setOrderBy(new Sort.Order[]{DsnAttributeOption.OPTION_ORDER.asc()})));
        msg.getDataTable().put("dsn_biz_attribute_option", battrOptionList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryBizAttributeOption(String bizUuid) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)bizUuid)) {
            msg.setFailMsg("\u5c5e\u6027\u4e3b\u952e[biz_uuid]\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        DsnBizAttribute attr = (DsnBizAttribute)this.dao.findOne(DsnBizAttribute.n().where().addEq(DsnBizAttribute.BIZ_UUID, (Object)bizUuid).model());
        ArrayList battrOptionList = new ArrayList();
        battrOptionList.addAll(this.dao.findAll((AbsModel)((DsnBizAttributeOption)DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)bizUuid).model()).setOrderBy(new Sort.Order[]{DsnBizAttributeOption.OPTION_ORDER.asc()})));
        if (!battrOptionList.isEmpty()) {
            msg.getDataTable().put("dsn_biz_attribute_option", battrOptionList);
            return msg.msg();
        }
        battrOptionList.addAll(this.dao.findAll((AbsModel)((DsnAttributeOption)DsnAttributeOption.n().where().addEq(DsnAttributeOption.ATTR_UUID, (Object)attr.getAttrUuid()).model()).setOrderBy(new Sort.Order[]{DsnAttributeOption.OPTION_ORDER.asc()})));
        msg.getDataTable().put("dsn_biz_attribute_option", battrOptionList);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryAttrList(String nodeNo) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT dba.attr_uuid, dba.attr_no, dba.attr_name, dba.ui_type ,ds.display_order, dba.not_null ,dba.attr_length, dba.biz_uuid, ds.node_no, ds.node_seq,dba.allow_mdf, dba.unit, dba.max_value, dba.min_value, dba.mult, dba.add_step, dba.reduce_step, dba.group_code, dba.def_value,  dba.custom_input_title, dba.custom_input_mult, dba.custom_please_holder    FROM dsn_structure ds, dsn_biz_attribute dba   WHERE ds.node_no = dba.biz_uuid  AND ds.up_node = ?");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(nodeNo);
        sql.append(" ORDER BY ds.display_order ASC");
        List attrs = this.dao.findAll(sql.toString(), new AbsModelRepository.Args[]{this.dao.args(queryValue)});
        Return msg = new Return();
        msg.setDataList4includes(attrs, new String[]{DsnBizAttribute.ATTR_UUID.column(), DsnBizAttribute.ATTR_NAME.column(), DsnBizAttribute.ATTR_NO.column(), DsnStructure.DISPLAY_ORDER.column(), DsnBizAttribute.UI_TYPE.column(), DsnBizAttribute.NOT_NULL.column(), DsnBizAttribute.ATTR_LENGTH.column(), DsnBizAttribute.BIZ_UUID.column(), DsnStructure.NODE_NO.column(), DsnStructure.NODE_SEQ.column(), DsnBizAttribute.ALLOW_MDF.column(), DsnBizAttribute.UNIT.column(), DsnBizAttribute.MAX_VALUE.column(), DsnBizAttribute.MIN_VALUE.column(), DsnBizAttribute.MULT.column(), DsnBizAttribute.ADD_STEP.column(), DsnBizAttribute.REDUCE_STEP.column(), DsnBizAttribute.GROUP_CODE.column(), DsnBizAttribute.DEF_VALUE.column(), DsnBizAttribute.CUSTOM_INPUT_TITLE.column(), DsnBizAttribute.CUSTOM_INPUT_MULT.column(), DsnBizAttribute.CUSTOM_PLEASE_HOLDER.column()});
        return msg.msg();
    }

    @Override
    public ReturnMsg queryExistAttr(String checked, String upNode, String upName, String queryName, String queryNo) {
        DsnStructure upNodeStruct = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)upNode).model());
        if (StrUtils.isNull((Object)upNodeStruct.getNodeName())) {
            Ulog.error((String)"\u6ca1\u53d6\u5230\u5f53\u524d\u8282\u70b9\u7684\u540d\u79f0\uff01\uff01\uff01");
            return null;
        }
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT DISTINCT dba.attr_uuid, dba.attr_no, dba.attr_name, dba.ui_type, dba.not_null   FROM dsn_structure ds, dsn_biz_attribute dba   WHERE ds.node_no = dba.biz_uuid  ");
        if ("N".equals(checked)) {
            sql.append(" AND ds.up_node IN (SELECT upds.node_no FROM dsn_structure upds WHERE upds.node_type = ?)");
            queryValue.add(upNodeStruct.getNodeType());
        }
        if (!StrUtils.isNull((Object)queryName)) {
            sql.append(" AND dba.attr_name LIKE ?");
            queryValue.add("%" + queryName + "%");
        }
        if (!StrUtils.isNull((Object)queryNo)) {
            sql.append(" AND dba.attr_no LIKE ?");
            queryValue.add("%" + queryNo + "%");
        }
        sql.append(" AND ds.node_name NOT IN (SELECT ex.node_name FROM dsn_structure ex WHERE ex.up_node = ?)");
        queryValue.add(upNodeStruct.getNodeNo());
        ArrayList<RepEnum> callbacks = new ArrayList<RepEnum>();
        callbacks.add(new RepEnum(DsnBizAttribute.UI_TYPE));
        List attrs = this.dao.findAll(sql.toString(), DsnBizAttribute.class, callbacks, new AbsModelRepository.Args[]{this.dao.args(queryValue)});
        Return msg = new Return();
        msg.setDataList4includes(attrs, DsnBizAttribute.class, new String[]{DsnBizAttribute.ATTR_UUID.column(), DsnBizAttribute.ATTR_NAME.column(), DsnBizAttribute.ATTR_NO.column(), DsnBizAttribute.UI_TYPE.column(), DsnBizAttribute.NOT_NULL.column(), DsnBizAttribute.ATTR_LENGTH.column(), "ui_type_name"});
        return msg.msg();
    }

    @Override
    public ReturnMsg selectAttrToSave(String rightSelect, String upNodeNo) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)rightSelect)) {
            msg.setWarnMsg("\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u5c5e\u6027\uff01");
            return msg.msg();
        }
        List<DsnBizAttribute> attrList = this.splitSelectAttr(rightSelect);
        msg = this.checkNodeName(upNodeNo, attrList);
        if (!msg.isSuccessflag()) {
            return msg.msg();
        }
        DsnStructure upStruct = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)upNodeNo).model());
        String nodeType = this.getNodeType(upStruct);
        ArrayList<DsnStructure> structureList = new ArrayList<DsnStructure>();
        List all = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upStruct.getNodeNo()).model());
        Integer maxDisplayOrder = 0;
        if (all != null && !all.isEmpty()) {
            maxDisplayOrder = all.stream().max(Comparator.comparing(DsnStructure::getDisplayOrder)).get().getDisplayOrder();
        }
        for (DsnBizAttribute attr : attrList) {
            String node_no = UUID.shortUUID();
            DsnStructure stru = new DsnStructure();
            stru.setNodeNo(node_no);
            stru.setNodeSeq(upStruct.getNodeSeq() + node_no + ".");
            stru.setUpNode(upStruct.getNodeNo());
            stru.setNodeType(nodeType);
            stru.setNodeName(attr.getAttrName());
            maxDisplayOrder = maxDisplayOrder + 1;
            stru.setDisplayOrder(maxDisplayOrder);
            ProductCopyServiceImpl.dnsBizAttribute(null, attr.getAttrUuid(), stru, this.dao);
            structureList.add(stru);
            this.treeService.saveChildNode(stru);
        }
        this.dao.save(structureList);
        return msg.msg();
    }

    private Return checkNodeName(String upNodeNo, List<DsnBizAttribute> attrList) {
        Return msg = new Return();
        ArrayList<String> nameList = new ArrayList<String>();
        for (DsnBizAttribute attrName : attrList) {
            nameList.add(attrName.getAttrName());
        }
        List structList = this.dao.findAll(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)upNodeNo).addIn(DsnStructure.NODE_NAME, nameList).model());
        if (!structList.isEmpty()) {
            structList.forEach(s -> msg.setFailMsg(s.getNodeName() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0"));
        }
        return msg;
    }

    private List<DsnBizAttribute> splitSelectAttr(String rightSelect) {
        ArrayList<DsnBizAttribute> attrList = new ArrayList<DsnBizAttribute>();
        for (String attrString : rightSelect.split(",")) {
            String[] attrArray = attrString.split("\\|");
            DsnBizAttribute attr = new DsnBizAttribute();
            attr.setAttrUuid(attrArray[0]);
            attr.setAttrName(attrArray[1]);
            attrList.add(attr);
        }
        return attrList;
    }

    private String getNodeType(DsnStructure dsn) {
        String type = "attr";
        String nodeType = dsn.getNodeType();
        if ("output".equals(nodeType) || "input".equals(nodeType)) {
            type = "attr4Rate";
        } else if ("n_liability".equals(nodeType) || "liab_group".equals(nodeType)) {
            type = "attr4Liability";
        } else if ("tbr".equals(nodeType)) {
            type = "tbr_attr";
        } else if ("bbr".equals(nodeType)) {
            type = "bbr_attr";
        } else if ("syr".equals(nodeType)) {
            type = "syr_attr";
        } else if (NodeType.RISK_DETAIL_LIST.contains(nodeType)) {
            type = "attr_detail";
        }
        return type;
    }

    @Override
    public ReturnMsg bizAttrInfoDel(DsnStructure node) {
        String node_seq = node.getNodeSeq();
        List dsList = this.dao.findAll(DsnStructure.n().where().addLikeR(DsnStructure.NODE_SEQ, (Object)node_seq).model());
        for (DsnStructure d : dsList) {
            if (!"rule".equals(d.getNodeType())) continue;
            this.ruleUsedService.delRuleInfo(d.getNodeNo());
        }
        this.dao.delete(DsnStructure.n().where().addLikeR(DsnStructure.NODE_SEQ, (Object)node_seq).model());
        this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)node.getNodeNo()).model());
        this.dao.delete(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)node.getNodeNo()).model());
        DsnBizAttribute bizAttr = (DsnBizAttribute)this.dao.findOne(DsnBizAttribute.n().where().addEq(DsnBizAttribute.BIZ_UUID, (Object)node.getNodeNo()).model());
        this.dao.delete(DsnBizAttribute.n().where().addEq(DsnBizAttribute.BIZ_UUID, (Object)node.getNodeNo()).model());
        this.dao.delete(DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.BIZ_UUID, (Object)node.getNodeNo()).model());
        int attrSize = this.dao.findAll(DsnBizAttribute.n().where().addEq(DsnBizAttribute.ATTR_UUID, (Object)bizAttr.getAttrUuid()).model()).size();
        if (attrSize == 0) {
            this.dao.delete(DsnAttribute.n().where().addEq(DsnAttribute.ATTR_UUID, (Object)bizAttr.getAttrUuid()).model());
            this.dao.delete(DsnAttributeOption.n().where().addEq(DsnAttributeOption.ATTR_UUID, (Object)bizAttr.getAttrUuid()).model());
        }
        Return msg = new Return();
        return msg.msg();
    }

    @Override
    public ReturnMsg doValidateAttrNo(String attr_no) {
        List attrList = this.dao.findAll(DsnAttribute.n().where().addEq(DsnAttribute.ATTR_NO, (Object)attr_no).model());
        Return msg = new Return();
        msg.setDataList(attrList, DsnAttribute.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg doValidateAttrName(String node_name) {
        List attrList = this.dao.findAll(DsnAttribute.n().where().addEq(DsnAttribute.ATTR_NAME, (Object)node_name).model());
        Return msg = new Return();
        msg.setDataList(attrList, DsnAttribute.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg validateOptionName(Map<String, Object> param) {
        Return msg = new Return();
        DsnAttributeOption attrOption = new DsnAttributeOption();
        attrOption.where().addEq(DsnAttributeOption.ATTR_UUID, param.get("attr_uuid"));
        attrOption.where().addEq(DsnAttributeOption.OPTION_NAME, param.get("option_name"));
        msg.setDataList(this.dao.findAll((AbsModel)attrOption), DsnAttributeOption.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg validateOptionValue(Map<String, Object> param) {
        Return msg = new Return();
        DsnBizAttributeOption attrOption = new DsnBizAttributeOption();
        attrOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, param.get("attr_uuid"));
        attrOption.where().addEq(DsnBizAttributeOption.OPTION_VALUE, param.get("option_value"));
        msg.setDataList(this.dao.findAll((AbsModel)attrOption), DsnBizAttributeOption.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg validateOptionOrder(Map<String, Object> param) {
        Return msg = new Return();
        DsnBizAttributeOption attrOption = new DsnBizAttributeOption();
        attrOption.where().addEq(DsnBizAttributeOption.BIZ_UUID, param.get("attr_uuid"));
        attrOption.where().addEq(DsnBizAttributeOption.OPTION_ORDER, param.get("option_order"));
        msg.setDataList(this.dao.findAll((AbsModel)attrOption), DsnBizAttributeOption.class);
        return msg.msg();
    }

    @Override
    public String getAttrNodeNo(Map<String, Object> param) {
        String relateFk = StrUtils.trimStr((Object)param.get("relate_fk"));
        DsnStructure ruleNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)relateFk).model());
        String curNodeType = ruleNode.getNodeType();
        String curNodeNo = ruleNode.getNodeNo();
        String curUpNode = ruleNode.getUpNode();
        DsnStructure attrNode = null;
        while (!(NodeType.N_RISK_ATTR.code().equals(curNodeType) || NodeType.MAIN_RISKS.code().equals(curNodeType) || NodeType.ACCY_RISKS.code().equals(curNodeType) || NodeType.N_MAIN_EXEMPT.code().equals(curNodeType) || NodeType.N_ACCY_EXEMPT.code().equals(curNodeType))) {
            attrNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.NODE_NO, (Object)curUpNode).model());
            curNodeType = attrNode.getNodeType();
            curNodeNo = attrNode.getNodeNo();
            curUpNode = attrNode.getUpNode();
        }
        if (!NodeType.N_RISK_ATTR.code().equals(curNodeType)) {
            attrNode = (DsnStructure)this.dao.findOne(DsnStructure.n().where().addEq(DsnStructure.UP_NODE, (Object)curNodeNo).addEq(DsnStructure.NODE_TYPE, (Object)NodeType.N_RISK_ATTR.code()).model());
        }
        return attrNode.getNodeNo();
    }

    @Override
    public ReturnMsg queryRiskAttrByProductUuid(String productUuid) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)productUuid)) {
            msg.setSuccessMsg(new Message("100002", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        SipProductRisks sipProductRisks = new SipProductRisks();
        sipProductRisks.where().addEq(SipProductRisks.PRODUCT_UUID, (Object)productUuid);
        List sprList = this.dao.findAll((AbsModel)sipProductRisks);
        ArrayList<Map<String, Object>> riskAttrList = new ArrayList<Map<String, Object>>();
        ArrayList<String> riskStrList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)sprList)) {
            for (SipProductRisks risk : sprList) {
                String riskUuid = risk.getRiskUuid();
                riskStrList.add(riskUuid);
                this.getRiskAttrList(riskAttrList, riskUuid);
                SipRiskRelation srr = new SipRiskRelation();
                srr.where().addEq(SipRiskRelation.MAIN_RISK, (Object)riskUuid);
                List srrList = this.dao.findAll((AbsModel)srr);
                if (!CollectionUtils.isNotEmpty((Collection)sprList)) continue;
                for (SipRiskRelation s : srrList) {
                    String riskUuidS = s.getRiskUuid();
                    if (!riskStrList.contains(riskUuidS)) {
                        this.getRiskAttrList(riskAttrList, riskUuidS);
                        riskStrList.add(riskUuidS);
                    }
                    SipRiskRelation srrA = new SipRiskRelation();
                    srrA.where().addEq(SipRiskRelation.MAIN_RISK, (Object)riskUuidS);
                    List srrAList = this.dao.findAll((AbsModel)srrA);
                    if (!CollectionUtils.isNotEmpty((Collection)srrAList)) continue;
                    for (SipRiskRelation sA : srrList) {
                        String riskUuidSA = sA.getRiskUuid();
                        if (riskStrList.contains(riskUuidSA)) continue;
                        this.getRiskAttrList(riskAttrList, riskUuidSA);
                        riskStrList.add(riskUuidSA);
                    }
                }
            }
        }
        msg.getDataTable().put("riskAttrList", riskAttrList);
        msg.setSuccessMsg(new Message("000000", "\u6210\u529f"));
        return msg.msg();
    }

    public void getRiskAttrList(List<Map<String, Object>> riskAttrList, String riskUuid) {
        SipRisks sipRisks = new SipRisks();
        sipRisks.where().addEq(SipRisks.RISK_UUID, (Object)riskUuid);
        SipRisks riskDetail = (SipRisks)this.dao.findOne((AbsModel)sipRisks);
        DsnStructure dsnStructure = new DsnStructure();
        dsnStructure.where().addEq(DsnStructure.NODE_NO, (Object)riskUuid);
        DsnStructure riskDsn = (DsnStructure)this.dao.findOne((AbsModel)dsnStructure);
        String upNode = riskDsn.getUpNode();
        ArrayList<String> sqlList = new ArrayList<String>();
        String sql = "select dba.biz_uuid,dba.attr_uuid,dba.attr_no,dba.attr_name,dba.ui_type from dsn_biz_attribute dba \nleft join dsn_structure ds \non dba.biz_uuid = ds.node_no\nwhere ds.up_node in (select node_no from dsn_structure where up_node = ? and  node_type = ? ) order by dba.display_order ";
        sqlList.add(upNode);
        sqlList.add(NodeType.N_RISK_ATTR.code());
        List getRiskAttrList = this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(sqlList)});
        if (CollectionUtils.isNotEmpty((Collection)getRiskAttrList)) {
            for (Map map : getRiskAttrList) {
                map.put("risk_uuid", riskUuid);
                map.put("risk_name", riskDetail.getRiskName());
            }
            riskAttrList.addAll(getRiskAttrList);
        }
    }

    @Override
    public ReturnMsg attrOptionInfoDel(String optionNo) {
        Return msg = new Return();
        String count = ((DsnBizAttributeOption)this.dao.findOne(((DsnBizAttributeOption)DsnBizAttributeOption.n().where().addEq(DsnBizAttributeOption.OPTION_NO, (Object)optionNo).model()).groupBy().count(DsnBizAttributeOption.SERNO))).getOtherProperty().get("serno_count").toString();
        if (Integer.parseInt(count) > 1) {
            return msg.msg();
        }
        this.dao.delete(DsnAttributeOption.n().where().addEq(DsnAttributeOption.OPTION_NO, (Object)optionNo).model());
        return msg.msg();
    }
}

