/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils;

import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.config.SyAccountConfig;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.uniapis.logger.Ulog;
import com.uniapis.utils.DateUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PdfPngUtils {
    @Autowired
    private HWYObsSDKUtis hwyObsSDKUtis;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private SyAccountConfig syAccountConfig;

    public String pdfpngAndHtml(String pdfFileName, String riskUuid, String materialCode) {
        long startTime = System.currentTimeMillis();
        String uploadUrl = this.syAccountConfig.getUploadUrl();
        String osName = System.getProperty("os.name").toLowerCase();
        String pathName = uploadUrl.replace("staticData/", "") + pdfFileName;
        if (osName.contains("windows")) {
            pathName = "C:" + pathName.replace("/", "\\");
        }
        File file = new File(pathName);
        String dateStr = DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd");
        long timeLong = System.currentTimeMillis();
        if (riskUuid.length() >= 16) {
            riskUuid = riskUuid.substring(0, 16);
        }
        String htmlFileName = "pdMaterial/pdfpnghtml/" + dateStr + "/" + riskUuid + "_" + materialCode + "_" + timeLong + ".html";
        String syPathName = uploadUrl + htmlFileName;
        String obsPath = this.obsConfig.getObsPath();
        String obsPathName = obsPath + htmlFileName;
        try {
            File htmlFile;
            PDDocument doc = PDDocument.load((File)file);
            PDFRenderer renderer = new PDFRenderer(doc);
            int pageCount = doc.getNumberOfPages();
            StringBuilder htmlContent = new StringBuilder();
            htmlContent.append("<!DOCTYPE html>\n");
            htmlContent.append("<html lang=\"zh-CN\">\n");
            htmlContent.append("<head>\n");
            htmlContent.append("    <meta charset=\"UTF-8\">");
            htmlContent.append("    <title>\u52a8\u6001\u62fc\u63a5\u56fe\u7247\u5730\u5740</title>");
            htmlContent.append("</head>");
            htmlContent.append("<style>");
            htmlContent.append("    .mageContainer {");
            htmlContent.append("        text-align: center;");
            htmlContent.append("    }");
            htmlContent.append("    .tk_img {");
            htmlContent.append("        width: 100%;");
            htmlContent.append("    }");
            htmlContent.append("</style>");
            htmlContent.append("<body>");
            htmlContent.append("<div class=\"imageContainer\">");
            for (int i = 0; i < pageCount; ++i) {
                File pngFile;
                BufferedImage image = renderer.renderImageWithDPI(i, 150.0f);
                String pngPath = "pdMaterial/fileImg/" + riskUuid + "/" + materialCode + "/" + timeLong + "/" + materialCode + "_" + (i + 1) + ".png";
                String syFilePath = uploadUrl + pngPath;
                String obsFilePath = obsPath + pngPath;
                if (osName.contains("windows")) {
                    syFilePath = "C:" + syFilePath.replace("/", "\\");
                }
                if (!(pngFile = new File(syFilePath)).getParentFile().exists()) {
                    pngFile.getParentFile().mkdirs();
                }
                ImageIO.write((RenderedImage)image, "png", pngFile);
                String url = this.hwyObsSDKUtis.putObject(obsFilePath, pngFile, "Y");
                htmlContent.append(" <img class=\"tk_img\" src=\"").append("/pscpfiles/staticData/" + pngPath).append("\">\n");
            }
            htmlContent.append("</div>");
            htmlContent.append("</body>");
            htmlContent.append("</html>");
            if (osName.contains("windows")) {
                syPathName = "C:" + syPathName.replace("/", "\\");
            }
            if (!(htmlFile = new File(syPathName)).getParentFile().exists()) {
                htmlFile.getParentFile().mkdirs();
            }
            Ulog.info((String)("\u4ea7\u54c1\u8d44\u6599nas\u6587\u4ef6\u8def\u5f84--->" + syPathName));
            FileUtils.writeStringToFile((File)htmlFile, (String)htmlContent.toString(), (String)"UTF-8");
            Ulog.info((String)("\u4ea7\u54c1\u8d44\u6599obs\u6587\u4ef6\u8def\u5f84--->" + obsPathName));
            String url = this.hwyObsSDKUtis.putObject(obsPathName, htmlFile, "Y");
            long endTime = System.currentTimeMillis();
            Ulog.info((String)("\u5171\u8017\u65f6\uff1a" + (double)(endTime - startTime) / 1000.0 + "\u79d2"));
            return "staticData/" + htmlFileName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void pdf2png(String fileAddress, String filename, String type) {
        long startTime = System.currentTimeMillis();
        File file = new File(fileAddress + "\\" + filename + ".pdf");
        try {
            PDDocument doc = PDDocument.load((File)file);
            PDFRenderer renderer = new PDFRenderer(doc);
            int pageCount = doc.getNumberOfPages();
            for (int i = 0; i < pageCount; ++i) {
                BufferedImage image = renderer.renderImageWithDPI(i, 180.0f);
                ImageIO.write((RenderedImage)image, type, new File(fileAddress + "\\" + filename + "_" + (i + 1) + "." + type));
            }
            long endTime = System.currentTimeMillis();
            Ulog.info((String)("\u5171\u8017\u65f6\uff1a" + (double)(endTime - startTime) / 1000.0 + "\u79d2"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void export(String basePathStr, String materialPath) {
        String[] mPath = materialPath.split("_");
        String riskUuid = mPath[0].split("/")[mPath[0].split("/").length - 1];
        String materialCode = mPath[1];
        String[] split = mPath[2].split("\\.");
        String timeStr = split[0];
        String srcPath = this.syAccountConfig.getUploadUrl() + "pdMaterial/fileImg/" + riskUuid + "/" + materialCode + "/" + timeStr + "/";
        String destDir = basePathStr + "staticData/pdMaterial/fileImg/" + riskUuid + "/" + materialCode + "/" + timeStr + "/";
        try {
            FileUtils.copyDirectory((File)new File(srcPath), (File)new File(destDir));
        }
        catch (Exception e) {
            Ulog.info((String)"\u5bfc\u51fa\u5305\u542b\u56fe\u7247\u7684html\u4e0b\u56fe\u7247\u5931\u8d25");
            e.printStackTrace();
        }
    }

    public void upload(List<File> pngList) {
        try {
            for (File file : pngList) {
                String path = file.getPath().split("fileList")[1].replace("/staticData/", "");
                String nasPath = this.syAccountConfig.getUploadUrl() + path;
                FileInputStream inputStream = new FileInputStream(file);
                File nasFile = new File(nasPath);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)nasFile);
                String key = this.obsConfig.getObsPath() + path;
                String string = this.hwyObsSDKUtis.putObject(key, nasFile, "Y");
            }
        }
        catch (Exception e) {
            Ulog.info((String)"\u5bfc\u5165\u5305\u542b\u56fe\u7247\u7684html\u4e0b\u56fe\u7247\u5931\u8d25");
            e.printStackTrace();
        }
    }
}

