/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain.party;

import com.newtouch.nms.insure.domain.party.Applicant;
import com.newtouch.nms.insure.domain.party.Beneficiary;
import com.newtouch.nms.insure.domain.risk.Main;
import com.newtouch.nms.insure.model.PolPolicyPartyRelation;
import com.newtouch.nms.insure.model.enums.RelationType;
import com.newtouch.nms.insure.utils.MsgUtils;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModelRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.Table;
import org.springframework.beans.BeanUtils;

@Table(name="pol_policy_order_party")
public class Insured
extends Applicant {
    private Map<String, Main> mainRisks = new HashMap<String, Main>();
    private final Map<String, Map<Integer, List<Beneficiary>>> beneficiaries = new HashMap<String, Map<Integer, List<Beneficiary>>>();

    public void fill(List<Insured> syrList, List<PolPolicyPartyRelation> relations) {
        HashMap syrMap = new HashMap();
        syrList.forEach(syr -> {
            Beneficiary aSyr = new Beneficiary();
            BeanUtils.copyProperties((Object)syr, (Object)((Object)aSyr));
            syrMap.put(syr.getPartyUuid(), aSyr);
        });
        relations.forEach(r -> {
            List<Beneficiary> orderSyr;
            Map<Integer, List<Beneficiary>> saveSyrMap = this.beneficiaries.get(r.getRelationType());
            if (saveSyrMap == null) {
                saveSyrMap = new HashMap<Integer, List<Beneficiary>>();
                this.beneficiaries.put(r.getRelationType(), saveSyrMap);
            }
            if ((orderSyr = saveSyrMap.get(r.getBenefitOrder())) == null) {
                orderSyr = new ArrayList<Beneficiary>();
                saveSyrMap.put(r.getBenefitOrder(), orderSyr);
            }
            Beneficiary aSyr = (Beneficiary)((Object)((Object)syrMap.get(r.getAffiliatedRelation())));
            aSyr.setBenefitOrder(r.getBenefitOrder());
            aSyr.setBenefitRatio(r.getBenefitRatio());
            aSyr.setAffiliatedType(r.getAffiliatedType());
            aSyr.setAffiliatedApplicant(r.getAffiliatedApplicant());
            aSyr.setRelation((PolPolicyPartyRelation)((Object)r));
            orderSyr.add(aSyr);
        });
    }

    @Override
    public Return checkValue() {
        Return msg = super.checkValue();
        if (!msg.isSuccessflag()) {
            return msg;
        }
        if (this.beneficiaries.isEmpty()) {
            msg.setFailMsg(MsgUtils.msg("\u8bf7\u5f55\u5165\u53d7\u76ca\u4eba\u4fe1\u606f"));
            return msg;
        }
        this.beneficiaries.values().forEach(listMap -> listMap.values().forEach(partyList -> partyList.forEach(party -> {
            Return partyMsg = party.checkValue();
            if (!partyMsg.isSuccessflag()) {
                msg.setFailMsg(partyMsg.getMsgList());
            }
            if (!partyMsg.getWarnList().isEmpty()) {
                msg.setWarnMsg(partyMsg.getWarnList());
            }
        })));
        if (!msg.isSuccessflag()) {
            return msg;
        }
        this.beneficiaries.entrySet().forEach(s -> {
            RelationType type = RelationType.valueOf((String)s.getKey());
            Map syrMap = (Map)s.getValue();
            if (syrMap.isEmpty()) {
                return;
            }
            ArrayList orderList = new ArrayList(syrMap.keySet());
            Collections.sort(orderList);
            int maxOrder = (Integer)orderList.get(orderList.size() - 1);
            if (orderList.size() != maxOrder) {
                msg.setFailMsg(MsgUtils.msg("\u5f55\u5165\u4e0d\u540c\u53d7\u76ca\u987a\u5e8f\u7684\u53d7\u76ca\u4eba\u65f6\uff0c\u53d7\u76ca\u987a\u5e8f\u5fc5\u987b\u8fde\u7eed"));
            }
            if (maxOrder > 20 || (Integer)orderList.get(0) != 1) {
                msg.setFailMsg(MsgUtils.msg("\u53d7\u76ca\u987a\u5e8f\u9700\u57281\u81f320\u4e4b\u95f4"));
            }
            syrMap.entrySet().forEach(syr -> {
                int order = (Integer)syr.getKey();
                HashSet<String> idSet = new HashSet<String>();
                int benefitRatio = 0;
                for (Beneficiary aSyr : (List)syr.getValue()) {
                    if (idSet.contains(aSyr.getIdNo())) {
                        msg.setFailMsg(MsgUtils.msg("\u53d7\u76ca\u4eba\u201c" + aSyr.getFullName() + "\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u5f55\u5165"));
                    }
                    idSet.add(aSyr.getIdNo());
                    benefitRatio += Integer.parseInt(aSyr.getBenefitRatio());
                }
                if (benefitRatio != 100) {
                    msg.setFailMsg(MsgUtils.msg("\u7b2c\u201c" + order + "\u201d\u987a\u4f4d\u53d7\u76ca\u4eba\u53d7\u76ca\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u4e3a100\uff0c\u8bf7\u4fee\u6539"));
                }
            });
        });
        return msg;
    }

    @Override
    public Return save(AbsModelRepository dao) {
        super.save(dao);
        this.beneficiaries.entrySet().forEach(entry -> ((Map)entry.getValue()).entrySet().forEach(syr -> ((List)syr.getValue()).forEach(aSyr -> aSyr.save(dao))));
        return new Return();
    }

    public List<Beneficiary> getBeneficiaries() {
        ArrayList<Beneficiary> list = new ArrayList<Beneficiary>();
        this.beneficiaries.values().forEach(bef -> bef.values().forEach(befList -> list.addAll((Collection<Beneficiary>)befList)));
        return list;
    }

    public Map<String, Main> getMainRisks() {
        return this.mainRisks;
    }

    public void setMainRisks(Map<String, Main> mainRisks) {
        this.mainRisks = mainRisks;
    }
}

