/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.StrUtils;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="pol_plan_lib")
public class PolPlanLib
extends AbsModel {
    @Column(name="age")
    @JsonProperty(value="age")
    private Integer age;
    @Column(name="agent_id")
    @JsonProperty(value="agent_id")
    private String agentId;
    @JsonFormat(pattern="yyyy-MM-dd")
    @Column(name="birthdate")
    @JsonProperty(value="birthdate")
    private Date birthdate;
    @Column(name="patch_memo")
    @JsonProperty(value="patch_memo")
    private String patchMemo;
    @Column(name="plan_crt_date")
    @JsonProperty(value="plan_crt_date")
    private String planCrtDate;
    @Column(name="plan_uuid")
    @JsonProperty(value="plan_uuid")
    private String planUuid;
    @Column(name="sex")
    @JsonProperty(value="sex")
    private String sex;
    @Transient
    @JsonIgnore
    private final Where<PolPlanLib> where = Where.getInstance((AbsModel)this);
    @Transient
    @JsonIgnore
    private final GroupBy<PolPlanLib> groupby = GroupBy.getInstance((AbsModel)this);
    @Transient
    public static final Field AGE = new Field("age", "age");
    @Transient
    public static final Field AGENT_ID = new Field("agentId", "agent_id");
    @Transient
    public static final Field BIRTHDATE = new Field("birthdate", "birthdate");
    @Transient
    public static final Field PATCH_MEMO = new Field("patchMemo", "patch_memo");
    @Transient
    public static final Field PLAN_CRT_DATE = new Field("planCrtDate", "plan_crt_date");
    @Transient
    public static final Field PLAN_UUID = new Field("planUuid", "plan_uuid");
    @Transient
    public static final Field SEX = new Field("sex", "sex");

    public PolPlanLib() {
    }

    public PolPlanLib(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String sex;
        String planUuid;
        String planCrtDate;
        String patchMemo;
        String agentId;
        Return ret = new Return();
        if (!StrUtils.isNull((Object)this.age) && !StrUtils.isNum((Object)this.age)) {
            ret.setFailMsg("[\u6295\u4fdd\u65f6\u5e74\u9f84]\u5fc5\u987b\u4e3a\u6570\u5b57\uff0c\u5b9e\u9645\u4e3a[" + this.age + "]");
        }
        if ((agentId = StrUtils.trimStr((Object)this.agentId)).length() > 32) {
            ret.setFailMsg("[\u4e1a\u52a1\u5458\u7f16\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + agentId.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.agentId)) {
            ret.setFailMsg("[\u4e1a\u52a1\u5458\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((patchMemo = StrUtils.trimStr((Object)this.patchMemo)).length() > 1024) {
            ret.setFailMsg("[10.\u6570\u8865\u5907\u6ce8]\u4e0d\u80fd\u8d85\u8fc7[1024]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + patchMemo.length() + "]\u4f4d");
        }
        if ((planCrtDate = StrUtils.trimStr((Object)this.planCrtDate)).length() > 32) {
            ret.setFailMsg("[\u65b9\u6848\u521b\u5efa\u65f6\u95f4]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + planCrtDate.length() + "]\u4f4d");
        }
        if ((planUuid = StrUtils.trimStr((Object)this.planUuid)).length() > 32) {
            ret.setFailMsg("[\u65b9\u6848UUID]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + planUuid.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.planUuid)) {
            ret.setFailMsg("[\u65b9\u6848UUID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((sex = StrUtils.trimStr((Object)this.sex)).length() > 8) {
            ret.setFailMsg("[\u6027\u522b]\u4e0d\u80fd\u8d85\u8fc7[8]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + sex.length() + "]\u4f4d");
        }
        return ret;
    }

    public PolPlanLib setAge(Integer age) {
        this.age = age;
        this.where().setChangeColumn(AGE);
        return this;
    }

    public Integer getAge() {
        return this.age;
    }

    public PolPlanLib setAgentId(String agentId) {
        this.agentId = agentId;
        this.where().setChangeColumn(AGENT_ID);
        return this;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public PolPlanLib setBirthdate(Date birthdate) {
        this.birthdate = DateUtils.trunc((Date)birthdate);
        this.where().setChangeColumn(BIRTHDATE);
        return this;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public PolPlanLib setPatchMemo(String patchMemo) {
        this.patchMemo = patchMemo;
        this.where().setChangeColumn(PATCH_MEMO);
        return this;
    }

    public String getPatchMemo() {
        return this.patchMemo;
    }

    public PolPlanLib setPlanCrtDate(String planCrtDate) {
        this.planCrtDate = planCrtDate;
        this.where().setChangeColumn(PLAN_CRT_DATE);
        return this;
    }

    public String getPlanCrtDate() {
        return this.planCrtDate;
    }

    public PolPlanLib setPlanUuid(String planUuid) {
        this.planUuid = planUuid;
        this.where().setChangeColumn(PLAN_UUID);
        return this;
    }

    public String getPlanUuid() {
        return this.planUuid;
    }

    public PolPlanLib setSex(String sex) {
        this.sex = sex;
        this.where().setChangeColumn(SEX);
        return this;
    }

    public String getSex() {
        return this.sex;
    }

    @JsonIgnore
    public PolPlanLib select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<PolPlanLib> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<PolPlanLib> groupBy() {
        return this.groupby;
    }

    @JsonIgnore
    public PolPlanLib setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static PolPlanLib n() {
        return new PolPlanLib();
    }
}

