/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain;

import com.newtouch.nms.insure.domain.party.Applicant;
import com.newtouch.nms.insure.domain.party.Insured;
import com.newtouch.nms.insure.domain.risk.Main;
import com.newtouch.nms.insure.domain.risk.Risk;
import com.newtouch.nms.insure.model.PolPolicy;
import com.newtouch.nms.insure.model.PolPolicyOrder;
import com.newtouch.nms.insure.model.PolPolicyOrderParty;
import com.newtouch.nms.insure.model.PolPolicyParty;
import com.newtouch.nms.insure.model.PolPolicyPartyAddress;
import com.newtouch.nms.insure.model.PolPolicyPartyContract;
import com.newtouch.nms.insure.model.PolPolicyPartyImage;
import com.newtouch.nms.insure.model.PolPolicyPartyRead;
import com.newtouch.nms.insure.model.PolPolicyPartyRelation;
import com.newtouch.nms.insure.model.PolPolicyRisk;
import com.newtouch.nms.insure.model.PolPolicySignature;
import com.newtouch.nms.insure.model.enums.PolicyState;
import com.newtouch.nms.insure.model.enums.YNType;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.msg.Return;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.persistence.Table;
import org.springframework.beans.BeanUtils;

@Table(name="pol_policy_order")
public class Order
extends PolPolicyOrder {
    private final Applicant applicant = new Applicant();
    public Map<String, Insured> insured = new HashMap<String, Insured>();
    private final Map<String, Main> mainRisk = new HashMap<String, Main>();
    private final List<PolPolicyPartyRelation> partyRelations = new ArrayList<PolPolicyPartyRelation>();
    private BiFunction<Order, String, String> generateApplyCode;

    public void fill(Map<String, Object> param, BiFunction<Order, String, String> generateApplyCode) {
        if (generateApplyCode == null) {
            throw new BusinessException("\u83b7\u53d6\u6295\u4fdd\u5355\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.generateApplyCode = generateApplyCode;
        BeanUtils.copyProperties((Object)RequestUtils.getRequestMap(param, Order.class), (Object)((Object)this));
        this.setBranchId(ThreadLocalContext.get().getUser().getOrganId());
        this.setAgentId(ThreadLocalContext.get().getUser().getUserCode());
        this.setApplyDate(DateUtils.sysDate());
        this.setImageNotice(YNType.N.name());
        this.setImageUpload(YNType.N.name());
        this.setDataToken(UUID.shortUUID());
        this.setOrganId(ThreadLocalContext.get().getUser().getOrganId());
        this.setPolicyEntry("01");
        this.fillPartyInfo(param);
        String searchIndex = this.applicant.getFullName();
        if (!this.insured.values().isEmpty()) {
            Insured insured = this.insured.values().iterator().next();
            Risk risk = insured.getMainRisks().values().iterator().next();
            searchIndex = searchIndex + "**" + insured.getFullName() + "**" + risk.getProductName() + "**" + risk.getProductNamePinyin();
        }
        this.setSearchIndex(searchIndex);
    }

    private void fillPartyInfo(Map<String, Object> param) {
        List insureds = JsonUtils.listMap2ListClass((List)((List)param.get("parties")), Insured.class);
        this.partyRelations.addAll(JsonUtils.listMap2ListClass((List)((List)param.get("partyRelations")), PolPolicyPartyRelation.class));
        ArrayList syrList = new ArrayList();
        ArrayList bbrList = new ArrayList();
        insureds.forEach(party -> {
            party.setOrder(this);
            party.fill();
            switch (party.getPartyType()) {
                case TBR: {
                    BeanUtils.copyProperties((Object)party, (Object)((Object)this.applicant));
                    break;
                }
                case BBR: {
                    bbrList.add(party);
                }
                case SYR: {
                    syrList.add(party);
                }
            }
        });
        bbrList.forEach(party -> {
            PolPolicyPartyRelation relation = (PolPolicyPartyRelation)((Object)((Object)this.partyRelations.stream().filter(r -> r.getMasterRelation().equals(this.applicant.getPartyUuid()) && r.getAffiliatedRelation().equals(party.getPartyUuid()) && r.getRelationType().equals("TB")).collect(Collectors.toList()).get(0)));
            if (relation != null) {
                party.setAffiliatedType(relation.getAffiliatedType());
                party.setAffiliatedApplicant(relation.getAffiliatedApplicant());
                party.setRelation(relation);
            }
            List<PolPolicyPartyRelation> syrRelations = this.partyRelations.stream().filter(r -> r.getMasterRelation().equals(party.getPartyUuid()) && (r.getRelationType().equals("BG") || r.getRelationType().equals("BC"))).collect(Collectors.toList());
            party.fill(syrList, syrRelations);
            this.insured.put(party.getPartyUuid(), (Insured)((Object)party));
        });
    }

    public Applicant getApplicant() {
        return this.applicant;
    }

    public Map<String, Insured> getInsured() {
        return this.insured;
    }

    public Map<String, Main> getMainRisk() {
        return this.mainRisk;
    }

    public List<PolPolicyPartyRelation> getPartyRelations() {
        return this.partyRelations;
    }

    @Override
    public Return checkValue() {
        Return msg = this.applicant.checkValue();
        if (!msg.isSuccessflag()) {
            return msg;
        }
        this.insured.values().forEach(party -> {
            Return insuredMsg = party.checkValue();
            if (!insuredMsg.isSuccessflag()) {
                insuredMsg.setAutoRollback(false);
                msg.setReturnMsg(insuredMsg.msg());
            }
        });
        return new Return();
    }

    public Return savePartyInfo(AbsModelRepository dao) {
        this.deletePartyInfo(dao);
        dao.save((AbsModel)this);
        this.applicant.save(dao);
        this.insured.values().forEach(bbr -> bbr.save(dao));
        return new Return();
    }

    public Return saveOrderInfo(AbsModelRepository dao) {
        this.deletePartyInfo(dao);
        PolPolicyOrder thisOrder = new PolPolicyOrder();
        BeanUtils.copyProperties((Object)((Object)this), (Object)((Object)thisOrder));
        dao.save((AbsModel)this);
        ArrayList risks = new ArrayList();
        this.getInsured().values().forEach(insured -> {
            HashSet policyUuidSet = new HashSet();
            insured.getMainRisks().values().forEach(main -> {
                this.savePolicyAndPolicyParty(dao, thisOrder, (Insured)((Object)insured), policyUuidSet, (Main)((Object)((Object)main)));
                risks.add(main);
                main.getAdditionalRisks().values().forEach(risk -> {
                    risks.add(risk);
                    risks.addAll(risk.getExemptRisks().values());
                });
                risks.addAll(main.getExemptRisks().values());
            });
        });
        dao.save(risks);
        return new Return();
    }

    private void savePolicyAndPolicyParty(AbsModelRepository dao, PolPolicyOrder thisOrder, Insured insured, Set<String> policyUuidSet, Main main) {
        if (!policyUuidSet.contains(main.getPolicyUuid())) {
            policyUuidSet.add(main.getPolicyUuid());
            PolPolicy policy = new PolPolicy();
            BeanUtils.copyProperties((Object)((Object)thisOrder), (Object)((Object)policy));
            policy.setPolicyUuid(main.getPolicyUuid());
            policy.setPolicyState(PolicyState.SU.name());
            policy.setApplyDate(DateUtils.sysDate());
            policy.setOrganId(ThreadLocalContext.get().getUser().getOrganId());
            policy.setAgentId(ThreadLocalContext.get().getUser().getUserCode());
            if (StrUtils.isNull((Object)policy.getApplyCode())) {
                policy.setApplyCode(this.generateApplyCode.apply(this, main.getPolicyUuid()));
            }
            dao.save((AbsModel)policy);
            ArrayList<PolPolicyParty> ppPartyList = new ArrayList<PolPolicyParty>();
            PolPolicyParty tbrParty = new PolPolicyParty();
            tbrParty.setPolicyUuid(main.getPolicyUuid());
            tbrParty.setPolicyUuid(this.getApplicant().getPartyUuid());
            tbrParty.setPartyType(this.getApplicant().getPartyType().name());
            ppPartyList.add(tbrParty);
            PolPolicyParty bbrParty = new PolPolicyParty();
            bbrParty.setPolicyUuid(main.getPolicyUuid());
            bbrParty.setPolicyUuid(insured.getPartyUuid());
            bbrParty.setPartyType(insured.getPartyType().name());
            ppPartyList.add(bbrParty);
            insured.getBeneficiaries().forEach(bef -> {
                PolPolicyParty befParty = new PolPolicyParty();
                befParty.setPolicyUuid(main.getPolicyUuid());
                befParty.setPolicyUuid(bef.getPartyUuid());
                befParty.setPartyType(bef.getPartyType().name());
                ppPartyList.add(befParty);
            });
            dao.save(ppPartyList);
        }
    }

    private void deleteOrderInfo(AbsModelRepository dao) {
        dao.findAll(PolPolicy.n().where().addEq(PolPolicy.ORDER_UUID, (Object)this.getOrderUuid()).model()).forEach(policy -> {
            dao.delete(PolPolicySignature.n().where().addIn(PolPolicySignature.POLICY_UUID, new String[]{policy.getPolicyUuid()}).model());
            dao.delete(PolPolicyRisk.n().where().addIn(PolPolicyRisk.POLICY_UUID, new String[]{policy.getPolicyUuid()}).model());
        });
        dao.delete(PolPolicyPartyRead.n().where().addIn(PolPolicyPartyRead.ORDER_UUID, new String[]{this.getOrderUuid()}).model());
        dao.delete(PolPolicy.n().where().addIn(PolPolicy.ORDER_UUID, new String[]{this.getOrderUuid()}).model());
        dao.delete(PolPolicyOrder.n().where().addIn(PolPolicyOrder.ORDER_UUID, new String[]{this.getOrderUuid()}).model());
    }

    private void deletePartyInfo(AbsModelRepository dao) {
        ArrayList<String> partyUuidList = new ArrayList<String>();
        partyUuidList.add(this.applicant.getPartyUuid());
        partyUuidList.addAll(this.insured.keySet());
        String[] partyArray = partyUuidList.toArray(new String[0]);
        dao.delete(PolPolicyOrderParty.n().where().addIn(PolPolicyOrderParty.PARTY_UUID, partyArray).model());
        dao.delete(PolPolicyPartyRelation.n().where().addIn(PolPolicyPartyRelation.MASTER_RELATION, partyArray).model());
        dao.delete(PolPolicyPartyContract.n().where().addIn(PolPolicyPartyContract.PARTY_UUID, partyArray).model());
        dao.delete(PolPolicyPartyAddress.n().where().addIn(PolPolicyPartyAddress.PARTY_UUID, partyArray).model());
        dao.delete(PolPolicyPartyImage.n().where().addIn(PolPolicyPartyImage.PARTY_UUID, partyArray).model());
        dao.delete(PolPolicyParty.n().where().addIn(PolPolicyParty.PARTY_UUID, partyArray).model());
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("order_uuid", "test");
        Order order = new Order();
        BeanUtils.copyProperties(map, (Object)((Object)order));
        System.out.println(order.getOrderUuid());
        Order param = (Order)((Object)RequestUtils.getRequestMap(map, Order.class));
        System.out.println(param.getOrderUuid());
    }
}

