/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain.party;

import com.newtouch.nms.insure.domain.party.Party;
import com.newtouch.nms.insure.domain.risk.Additional;
import com.newtouch.nms.insure.domain.risk.Exempt;
import com.newtouch.nms.insure.domain.risk.Main;
import com.newtouch.nms.insure.model.PolPolicyPartyRead;
import com.newtouch.nms.insure.model.enums.AffiliatedType;
import com.newtouch.nms.insure.model.enums.ContractType;
import com.newtouch.nms.insure.model.enums.IdType;
import com.newtouch.nms.insure.model.enums.MaritalState;
import com.newtouch.nms.insure.model.enums.Nationality;
import com.newtouch.nms.insure.model.enums.PartyType;
import com.newtouch.nms.insure.utils.MsgUtils;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.IdCard;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Table;

@Table(name="pol_policy_order_party")
public class Applicant
extends Party {
    private List<PolPolicyPartyRead> reads = new ArrayList<PolPolicyPartyRead>();
    private static final Pattern NAME_PATTERN = Pattern.compile("[\u4e00-\u9fa5\u3400-\u4db5\u9fb4-\u9fbb\u2e81\u2e84\u2e88\u2e8b\u2e8c\u2e97\u2ea7\u2eaa\u2eae\u2eb3\u2eb6\u2eb7\u2ebb\u2eca\uf92c\uf979\uf995\uf9e7\uf9f1\ufa0c\ufa0d\ufa0e\ufa0f\ufa11\ufa13\ufa14\ufa18\ufa1f\ufa20\ufa21\ufa23\ufa24\ufa27\ufa28\ufa29\u00b7\ua1a4]{2,200}$");
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z9()\\d\\s-\\.\\\u00b7\\-\\!]{1,200}$");
    private static final Pattern NUM_PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");
    private static final List<String> MOBILE_START = new ArrayList<String>(Arrays.asList(new String[0]));
    private static final Pattern WECHAT_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_-]{5,20}$");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,100}$");
    private static final Pattern ZIP_PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");

    @Override
    public Return checkValue() {
        Return msg = new Return();
        if (StrUtils.isNull((Object)this.getFullName())) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u59d3\u540d\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtils.isNull((Object)this.getNationality())) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u56fd\u7c4d\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtils.isNull((Object)this.getIdType())) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u8bc1\u4ef6\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtils.isNull((Object)this.getIdNo())) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u8bc1\u4ef6\u53f7\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtils.isNull((Object)this.getIdEndDate())) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u8bc1\u4ef6\u6709\u6548\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtils.isNull((Object)this.getBirthdate())) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u51fa\u751f\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StrUtils.isNull((Object)this.getSex())) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u6027\u522b\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (this.getPartyContacts().isEmpty()) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u8054\u7cfb\u65b9\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (this.getPartyAddresses().isEmpty()) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u901a\u8baf\u5730\u5740\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (this.getCompanyName().isEmpty()) {
            msg.setFailMsg(MsgUtils.msg("\u201c\u5de5\u4f5c\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        this.checkFullname(msg);
        this.checkIdTypeAndNationality(msg);
        return msg;
    }

    @Override
    public void fill() {
        super.fill();
        this.initReadList();
    }

    @Override
    public Return save(AbsModelRepository dao) {
        super.save(dao);
        if (!this.reads.isEmpty()) {
            dao.save(this.reads);
        }
        return new Return();
    }

    private void initReadList() {
        HashSet riskSet = new HashSet();
        this.getOrder().getInsured().values().forEach(insured -> {
            Collection<Main> mains = insured.getMainRisks().values();
            mains.forEach(risk -> {
                riskSet.add(risk.getRiskCode());
                Collection<Additional> additional = risk.getAdditionalRisks().values();
                additional.forEach(aRisk -> {
                    riskSet.add(aRisk.getRiskCode());
                    Collection<Exempt> exempts = aRisk.getExemptRisks().values();
                    exempts.forEach(exemptsRisk -> riskSet.add(exemptsRisk.getRiskCode()));
                });
                Collection<Exempt> exempts = risk.getExemptRisks().values();
                exempts.forEach(exemptsRisk -> riskSet.add(exemptsRisk.getRiskCode()));
            });
        });
        this.reads.forEach(read -> read.setPartyUuid(this.getPartyUuid()));
    }

    private void checkFullname(Return msg) {
        Matcher nameMatcher = NAME_PATTERN.matcher(this.getFullName());
        Matcher matcher = ZIP_PATTERN.matcher(this.getFullName());
        if (nameMatcher.matches() && matcher.matches() && this.getValidInput(this.getFullName())) {
            msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u59d3\u540d"));
        }
    }

    private boolean getValidInput(String pValue) {
        int[] code;
        for (int c : code = Applicant.getToCodePointArray(pValue)) {
            if (c < 57344 || c > 63743) continue;
            return true;
        }
        return false;
    }

    private static int[] getToCodePointArray(String str) {
        int len = str.length();
        int[] acp = new int[str.codePointCount(0, len)];
        int i = 0;
        int j = 0;
        while (i < len) {
            acp[j] = str.codePointAt(i);
            i = str.offsetByCodePoints(i, 1);
            ++j;
        }
        return acp;
    }

    private void checkIdTypeAndNationality(Return msg) {
        Object typeList = null;
        switch (this.getPartyType()) {
            case BBR: {
                this.checkInsuredIdType(msg);
                this.checkCountry(msg);
                this.checkIdNo(msg);
                this.checkIdEndDate(msg);
                this.checkJob(msg);
                this.checkMaritalState(msg);
                this.checkAddress(msg);
                this.checkMobilePhone(msg);
                this.checkTelephone(msg);
                this.checkOtherContact(msg);
                this.checkAgeDifference(msg);
                break;
            }
            case TBR: {
                this.checkIdType(msg);
                this.checkCountry(msg);
                this.checkIdNo(msg);
                this.checkIdEndDate(msg);
                this.checkJob(msg);
                this.checkMaritalState(msg);
                this.checkAddress(msg);
                this.checkMobilePhone(msg);
                this.checkTelephone(msg);
                this.checkOtherContact(msg);
                break;
            }
            case SYR: {
                this.checkIdType(msg);
                this.checkCountry(msg);
                this.checkIdNo(msg);
                this.checkIdEndDate(msg);
                this.checkJob(msg);
                this.checkMaritalState(msg);
                this.checkAddress(msg);
                this.checkMobilePhone(msg);
                this.checkTelephone(msg);
                this.checkOtherContact(msg);
                break;
            }
            case JHR: {
                this.checkIdType(msg);
                this.checkCountry(msg);
                this.checkIdNo(msg);
                this.checkIdEndDate(msg);
                this.checkJob(msg);
                this.checkMobilePhone(msg);
                this.checkTelephone(msg);
                this.checkOtherContact(msg);
                break;
            }
            case LXR: {
                this.checkMaritalState(msg);
                this.checkMobilePhone(msg);
            }
        }
    }

    private void checkIdType(Return msg) {
        List<IdType> typeList = Arrays.asList(IdType.I);
        if (Nationality.CHN.equals(Nationality.valueOf(this.getNationality())) && !typeList.contains(IdType.valueOf(this.getIdType()))) {
            msg.setFailMsg(MsgUtils.msg("\u6295\u4fdd\u4eba\u3001\u53d7\u76ca\u4eba\u3001\u76d1\u62a4\u4eba\u7684\u56fd\u7c4d/\u5730\u533a\u662f\u4e2d\u56fd\u65f6\uff0c\u8bc1\u4ef6\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u8eab\u4efd\u8bc1"));
        }
    }

    private void checkInsuredIdType(Return msg) {
        List<IdType> typeList = Arrays.asList(IdType.I, IdType.C, IdType.M);
        if (Nationality.CHN.equals(Nationality.valueOf(this.getNationality())) && !typeList.contains(IdType.valueOf(this.getIdType()))) {
            msg.setFailMsg(MsgUtils.msg("\u88ab\u4fdd\u4eba\u7684\u56fd\u7c4d/\u5730\u533a\u662f\u4e2d\u56fd\u65f6\uff0c\u8bc1\u4ef6\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u8eab\u4efd\u8bc1\u3001\u6237\u53e3\u7c3f\u3001\u51fa\u751f\u533b\u5b66\u8bc1\u660e"));
        }
    }

    private void checkAgeDifference(Return msg) {
        if (!AffiliatedType.C.equals(this.getAffiliatedType()) && !AffiliatedType.P.equals(this.getAffiliatedType())) {
            return;
        }
        int age = StrUtils.isNull((Object)this.getAge()) ? 0 : this.getAge();
        Applicant applicant = this.getOrder().getApplicant();
        int applicantAge = StrUtils.isNull((Object)applicant.getAge()) ? 0 : applicant.getAge();
        int minAgeSub = 18;
        if (Math.abs(age - applicantAge) < minAgeSub) {
            msg.setFailMsg(MsgUtils.msg("\u5173\u7cfb\u4e3a\u201c\u7236\u6bcd\u3001\u5b50\u5973\u201d\u5e74\u9f84\u5dee\u9700\u8981\u8d85\u8fc718\u5c81"));
        }
    }

    private void checkMobilePhone(Return msg) {
        this.getPartyContacts().stream().filter(c -> ContractType.MB.equals(c.getContractType())).map(c -> {
            boolean matches = NUM_PATTERN.matcher(c.getContractValue()).matches();
            if (c.getContractType().length() >= 12 || !matches || !MOBILE_START.contains(c.getContractValue().substring(0, 2))) {
                msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u79fb\u52a8\u7535\u8bdd\u53f7\u7801"));
            }
            return c;
        });
    }

    private void checkTelephone(Return msg) {
        this.getPartyContacts().stream().filter(c -> ContractType.HOME.equals(c.getContractType()) || ContractType.OFF.equals(c.getContractType())).map(c -> {
            boolean matches = NUM_PATTERN.matcher(c.getContractValue()).matches();
            String[] split = c.getContractValue().split("-");
            if (split.length > 1) {
                String numCode;
                String areaCode = split[0];
                if (areaCode.length() > 7 || areaCode.length() < 3 || !NUM_PATTERN.matcher(areaCode).matches()) {
                    msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5bb6\u5ead\u7535\u8bdd\u533a\u53f7"));
                }
                if ((numCode = split[1]).length() < 7 || numCode.length() > 13 || !NUM_PATTERN.matcher(numCode).matches()) {
                    msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5bb6\u5ead\u7535\u8bdd"));
                }
            }
            return c;
        });
    }

    private void checkOtherContact(Return msg) {
        this.getPartyContacts().stream().filter(c -> ContractType.WeChat.equals(c.getContractType())).map(c -> {
            boolean matches = WECHAT_PATTERN.matcher(c.getContractValue()).matches();
            if (!matches) {
                msg.setFailMsg(MsgUtils.msg("\u5fae\u4fe1\u53f7\u957f\u5ea6\u57286-20\u4e2a\u5b57\u7b26\u4e4b\u95f4"));
            }
            return c;
        });
        this.getPartyContacts().stream().filter(c -> ContractType.Mail.equals(c.getContractType())).map(c -> {
            boolean matches = EMAIL_PATTERN.matcher(c.getContractValue()).matches();
            if (!matches) {
                msg.setFailMsg(MsgUtils.msg("\u7535\u5b50\u90ae\u7bb1\u8f93\u5165\u9519\u8bef"));
            }
            return c;
        });
    }

    private void checkAddress(Return msg) {
        if (this.getPartyAddresses().isEmpty()) {
            return;
        }
        this.getPartyAddresses().forEach(address -> {
            if (StrUtils.isNull((Object)address.getDetailedAddress())) {
                msg.setFailMsg(MsgUtils.msg("\u901a\u8baf\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"));
                return;
            }
            if (address.getDetailedAddress().length() > 200 || address.getDetailedAddress().length() < 6) {
                msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u901a\u8baf\u5730\u5740"));
                return;
            }
            if (StrUtils.isNull((Object)address.getZipCode())) {
                msg.setFailMsg(MsgUtils.msg("\u90ae\u7f16\u4e0d\u80fd\u4e3a\u7a7a"));
                return;
            }
            if (address.getZipCode().length() != 6) {
                msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7f16"));
                return;
            }
            if (!ZIP_PATTERN.matcher(address.getZipCode()).matches()) {
                msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7f16"));
                return;
            }
            if (!address.getAddressCode().substring(0, 2).equals(address.getZipCode().substring(0, 2))) {
                msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7f16"));
                return;
            }
        });
    }

    private void checkMaritalState(Return msg) {
        int age = StrUtils.isNull((Object)this.getAge()) ? 0 : this.getAge();
        List<MaritalState> maritalStates = Arrays.asList(MaritalState.M, MaritalState.D, MaritalState.W);
        int maxAge = 18;
        if (age < maxAge && maritalStates.contains(MaritalState.valueOf(this.getMaritalState()))) {
            msg.setFailMsg(MsgUtils.msg("\u5e74\u9f84\u572818\u5468\u5c81\u4ee5\u4e0b\u65f6\uff0c\u5a5a\u59fb\u72b6\u51b5\u4e0d\u80fd\u4e3a\u5df2\u5a5a\u3001\u79bb\u5f02\u3001\u4e27\u5076"));
            return;
        }
        if (PartyType.BBR.equals(this.getPartyType()) && AffiliatedType.S.equals(this.getAffiliatedType()) && maritalStates.contains(MaritalState.valueOf(this.getMaritalState()))) {
            msg.setFailMsg(MsgUtils.msg("\u6295\u4fdd\u4eba\u4e0e\u88ab\u4fdd\u4eba\u5173\u7cfb\u4e3a\u914d\u5076\u7684\uff0c\u5a5a\u59fb\u72b6\u51b5\u4e0d\u80fd\u4e3a\u672a\u5a5a\u3001\u79bb\u5f02\u3001\u4e27\u5076"));
            return;
        }
        if (PartyType.BBR.equals(this.getPartyType()) && AffiliatedType.P.equals(this.getAffiliatedType()) && MaritalState.S.equals(this.getMaritalState())) {
            msg.setFailMsg(MsgUtils.msg("\u6295\u4fdd\u4eba\u662f\u88ab\u4fdd\u4eba\u7236\u6bcd\u7684\uff0c\u5a5a\u59fb\u72b6\u51b5\u4e0d\u80fd\u4e3a\u672a\u5a5a"));
            return;
        }
    }

    private void checkJob(Return msg) {
        String jobCode = this.getJobCode();
        int age = StrUtils.isNull((Object)this.getAge()) ? 0 : this.getAge();
        List<String> profession = Arrays.asList("13", "14");
        if (age < 18 && profession.contains(jobCode)) {
            msg.setFailMsg(MsgUtils.msg("\u5f53\u524d\u5e74\u9f84\u4e3a18\u5468\u5c81\u4ee5\u4e0b\uff0c\u804c\u4e1a\u4e0d\u5141\u8bb8\u4e3a\u201c\u56fd\u5bb6\u673a\u5173\u3001\u515a\u7fa4\u7ec4\u7ec7\u3001\u4f01\u4e1a\u3001\u4e8b\u4e1a\u5355\u4f4d\u8d1f\u8d23\u4eba\u201d\u3001\u201c\u516c\u52a1\u5458\u201d\u3001\u201c\u4f01\u4e8b\u4e1a\u5355\u4f4d\u8d1f\u8d23\u4eba\u201d"));
        }
    }

    private void checkIdNo(Return msg) {
        if (IdType.I.equals(this.getIdType()) || IdType.J.equals(this.getIdType())) {
            IdCard card = IdCard.isIdcard((String)this.getIdNo());
            if (!card.isEffective()) {
                msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8bc1\u4ef6\u53f7\u7801"));
                return;
            }
            if (!card.getGender().name().equals(this.getSex())) {
                msg.setFailMsg(MsgUtils.msg("\u6027\u522b\u4e0e\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165"));
                return;
            }
            if (!card.getBirthday().equals(this.getBirthdate())) {
                msg.setFailMsg(MsgUtils.msg("\u51fa\u751f\u65e5\u671f\u4e0e\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165"));
                return;
            }
        } else {
            String regexArr = "^[a-z0-9A-Z]{6,25}+$";
            if (!this.getIdNo().matches(regexArr)) {
                msg.setFailMsg(MsgUtils.msg("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8bc1\u4ef6\u53f7\u7801"));
                return;
            }
        }
    }

    private void checkCountry(Return msg) {
        boolean checkNotChain;
        boolean twnCheck;
        boolean hkgCheck;
        ArrayList<Nationality> countryList = new ArrayList<Nationality>();
        countryList.add(Nationality.HKG);
        countryList.add(Nationality.MAC);
        ArrayList<IdType> idTypes = new ArrayList<IdType>();
        idTypes.add(IdType.J);
        idTypes.add(IdType.G);
        boolean bl = hkgCheck = countryList.contains(Nationality.valueOf(this.getNationality())) && !idTypes.contains(IdType.valueOf(this.getIdType()));
        if (hkgCheck) {
            msg.setFailMsg(MsgUtils.msg("\u6295\u4fdd\u4eba\u3001\u53d7\u76ca\u4eba\u3001\u76d1\u62a4\u4eba\u3001\u88ab\u4fdd\u4eba\u7684\u56fd\u7c4d/\u5730\u533a\u662f\u9999\u6e2f\u3001\u6fb3\u95e8\u65f6\uff0c\u8bc1\u4ef6\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u6e2f\u6fb3\u5c45\u6c11\u6765\u5f80\u5185\u5730\u901a\u884c\u8bc1\u3001\u6e2f\u6fb3\u53f0\u5c45\u6c11\u5c45\u4f4f\u8bc1"));
            return;
        }
        idTypes.clear();
        idTypes.add(IdType.J);
        idTypes.add(IdType.W);
        boolean bl2 = twnCheck = Nationality.TWN.equals(this.getNationality()) && !idTypes.contains(IdType.valueOf(this.getIdType()));
        if (twnCheck) {
            msg.setFailMsg(MsgUtils.msg("\u6295\u4fdd\u4eba\u3001\u53d7\u76ca\u4eba\u3001\u76d1\u62a4\u4eba\u3001\u88ab\u4fdd\u4eba\u7684\u56fd\u7c4d/\u5730\u533a\u662f\u53f0\u6e7e\u65f6\uff0c\u8bc1\u4ef6\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u53f0\u6e7e\u5c45\u6c11\u6765\u5f80\u5927\u9646\u901a\u884c\u8bc1\u3001\u6e2f\u6fb3\u53f0\u5c45\u6c11\u5c45\u4f4f\u8bc1"));
        }
        countryList.add(Nationality.CHN);
        countryList.add(Nationality.TWN);
        idTypes.clear();
        idTypes.add(IdType.E);
        idTypes.add(IdType.P);
        boolean bl3 = checkNotChain = !countryList.contains(Nationality.valueOf(this.getNationality())) && !idTypes.contains(IdType.valueOf(this.getIdType()));
        if (checkNotChain) {
            msg.setFailMsg(MsgUtils.msg("\u8bc1\u4ef6\u7c7b\u578b\u4e3a\u62a4\u7167\u6216\u5916\u56fd\u4eba\u6c38\u4e45\u5c45\u7559\u8bc1\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u53ea\u80fd\u9009\u62e9\u975e\u201c\u4e2d\u56fd\u3001\u4e2d\u56fd\u9999\u6e2f\u3001\u4e2d\u56fd\u6fb3\u95e8\u3001\u4e2d\u56fd\u53f0\u6e7e"));
        }
    }

    private void checkIdEndDate(Return msg) {
        int age = StrUtils.isNull((Object)this.getAge()) ? 0 : this.getAge();
        Date applyDate = this.getOrder().getApplyDate();
        Date endDate = this.getIdEndDate();
        if (endDate.before(applyDate)) {
            msg.setFailMsg(MsgUtils.msg("\u8bc1\u4ef6\u6709\u6548\u671f\u5fc5\u987b\u5728\u5f53\u524d\u5f55\u5165\u65e5\u671f\u4e4b\u540e"));
            return;
        }
        int zero = 0;
        int sixth = 16;
        if (age >= zero && age < sixth) {
            this.getValidIdEndDate(zero, sixth, 5, msg);
        }
        if (age >= sixth && age < 25) {
            this.getValidIdEndDate(sixth, 25, 10, msg);
        }
        if (age >= 26 && age <= 45) {
            this.getValidIdEndDate(26, 45, 20, msg);
        }
        if (age >= 46 && age <= 66) {
            this.getValidIdEndDate(46, 66, 20, msg);
        }
    }

    private void getValidIdEndDate(int minAge, int maxAge, int year, Return msg) {
        Date applyDate = this.getOrder().getApplyDate();
        Date endDate = this.getIdEndDate();
        Calendar apply = Calendar.getInstance();
        apply.setTime(applyDate);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(endDate);
        int applyDay = apply.get(6);
        int endDay = cal2.get(6);
        if (applyDay - endDay > year) {
            msg.setFailMsg("\u5f53\u5ba2\u6237\u5e74\u9f84\u5728\u5927\u4e8e\u7b49\u4e8e" + minAge + "\u5468\u5c81\u5c0f\u4e8e" + maxAge + "\u5468\u5c81\uff0c\uff08\u8eab\u4efd\u8bc1\u6709\u6548\u671f-\u5f55\u5165\u65e5\u671f\uff09<=" + year + "\u5e74");
        }
    }

    public List<PolPolicyPartyRead> getReads() {
        return this.reads;
    }

    public void setReads(List<PolPolicyPartyRead> reads) {
        this.reads = reads;
    }
}

