/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain.party;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.nms.insure.domain.Order;
import com.newtouch.nms.insure.domain.party.Insured;
import com.newtouch.nms.insure.model.PolPolicyOrderParty;
import com.newtouch.nms.insure.model.PolPolicyPartyAddress;
import com.newtouch.nms.insure.model.PolPolicyPartyContract;
import com.newtouch.nms.insure.model.PolPolicyPartyImage;
import com.newtouch.nms.insure.model.PolPolicyPartyRelation;
import com.newtouch.nms.insure.model.enums.AffiliatedType;
import com.newtouch.nms.insure.model.enums.IdType;
import com.newtouch.nms.insure.model.enums.PartyType;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Table;

@Table(name="pol_policy_order_party")
public class Party
extends PolPolicyOrderParty {
    private List<PolPolicyPartyAddress> partyAddresses = new ArrayList<PolPolicyPartyAddress>();
    private List<PolPolicyPartyContract> partyContacts = new ArrayList<PolPolicyPartyContract>();
    private List<PolPolicyPartyImage> images = new ArrayList<PolPolicyPartyImage>();
    private Order order;
    private PolPolicyPartyRelation relation;
    @JsonProperty(value="party_type")
    private PartyType partyType;
    @JsonProperty(value="affiliated_type")
    private AffiliatedType affiliatedType;
    @JsonProperty(value="affiliated_applicant")
    private AffiliatedType affiliatedApplicant;

    public void fill() {
        if (this.getOrder() == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6eOrder\u5bf9\u8c61");
        }
        this.partyAddresses.forEach(address -> {
            address.setPartyUuid(this.getPartyUuid());
            if (StrUtils.isNull((Object)address.getAddressUuid())) {
                address.setAddressUuid(UUID.shortUUID());
            }
        });
        this.partyContacts.forEach(contract -> {
            contract.setPartyUuid(this.getPartyUuid());
            if (StrUtils.isNull((Object)contract.getContractUuid())) {
                contract.setContractUuid(UUID.shortUUID());
            }
        });
        this.images.forEach(image -> {
            image.setPartyUuid(this.getPartyUuid());
            image.setOrderUuid(this.getOrderUuid());
            if (StrUtils.isNull((Object)image.getImageUuid())) {
                image.setImageUuid(UUID.shortUUID());
            }
        });
    }

    public Return save(AbsModelRepository dao) {
        dao.save((AbsModel)this);
        this.partyAddresses.forEach(address -> dao.save((AbsModel)address));
        this.partyContacts.forEach(contract -> dao.save((AbsModel)contract));
        this.images.forEach(image -> dao.save((AbsModel)image));
        if (this.relation != null) {
            dao.save((AbsModel)this.relation);
        }
        return new Return();
    }

    public List<PolPolicyPartyAddress> getPartyAddresses() {
        return this.partyAddresses;
    }

    public void setPartyAddresses(List<PolPolicyPartyAddress> partyAddresses) {
        this.partyAddresses = partyAddresses;
    }

    public List<PolPolicyPartyContract> getPartyContacts() {
        return this.partyContacts;
    }

    public void setPartyContacts(List<PolPolicyPartyContract> partyContacts) {
        this.partyContacts = partyContacts;
    }

    public List<PolPolicyPartyImage> getImages() {
        return this.images;
    }

    public void setImages(List<PolPolicyPartyImage> images) {
        this.images = images;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
        this.setOrderUuid(this.order.getOrderUuid());
    }

    public PartyType getPartyType() {
        return this.partyType;
    }

    public void setPartyType(PartyType partyType) {
        this.partyType = partyType;
    }

    public void setPartyType(String partyType) {
        this.partyType = PartyType.valueOf(partyType);
    }

    public AffiliatedType getAffiliatedType() {
        return this.affiliatedType;
    }

    public void setAffiliatedType(AffiliatedType affiliatedType) {
        this.affiliatedType = affiliatedType;
    }

    public void setAffiliatedType(String affiliatedType) {
        this.affiliatedType = AffiliatedType.valueOf(affiliatedType);
    }

    public AffiliatedType getAffiliatedApplicant() {
        return this.affiliatedApplicant;
    }

    public void setAffiliatedApplicant(AffiliatedType affiliatedApplicant) {
        this.affiliatedApplicant = affiliatedApplicant;
    }

    public void setAffiliatedApplicant(String affiliatedApplicant) {
        this.affiliatedApplicant = AffiliatedType.valueOf(affiliatedApplicant);
    }

    public PolPolicyPartyRelation getRelation() {
        return this.relation;
    }

    public void setRelation(PolPolicyPartyRelation relation) {
        this.relation = relation;
    }

    public static void main(String[] args) {
        int[] a;
        HashMap<String, String> partyMap = new HashMap<String, String>();
        partyMap.put("party_type", "TBR");
        Insured ii = (Insured)((Object)JsonUtils.json2Class((String)JsonUtils.toJson(partyMap), Insured.class));
        System.out.println(ii.getPartyType());
        List<IdType> typeList = Arrays.asList(IdType.I, IdType.C, IdType.M);
        System.out.println(typeList.contains(IdType.valueOf("I")));
        System.out.println(IdType.I.equals("I"));
        for (int i : a = new int[]{1, 2, 3, 4}) {
            switch (i) {
                case 3: {
                    System.out.println("switch" + i);
                }
            }
            System.out.println(i);
        }
    }
}

