/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.nms.insure.model.enums.Sex;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.StrUtils;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="pol_library")
public class PolLibrary
extends AbsModel {
    @Column(name="library_uuid")
    @JsonProperty(value="library_uuid")
    private String libraryUuid;
    @Column(name="sex")
    @JsonProperty(value="sex")
    private String sex;
    @Column(name="age")
    @JsonProperty(value="age")
    private Integer age;
    @JsonFormat(pattern="yyyy-MM-dd")
    @Column(name="birthdate")
    @JsonProperty(value="birthdate")
    private Date birthdate;
    @Column(name="agent_id")
    @JsonProperty(value="agent_id")
    private String agentId;
    @Column(name="data_auth")
    @JsonProperty(value="data_auth")
    private String dataAuth;
    @Transient
    @JsonIgnore
    private Where<PolLibrary> where = Where.getInstance((AbsModel)this);
    @Transient
    @JsonIgnore
    private GroupBy<PolLibrary> groupby = GroupBy.getInstance((AbsModel)this);
    @Transient
    public static final Field LIBRARY_UUID = new Field("libraryUuid", "library_uuid", "\u65b9\u6848UUID");
    @Transient
    public static final Field SEX = new Field("sex", "sex", "\u6027\u522b");
    @Transient
    public static final Field AGE = new Field("age", "age", "\u6295\u4fdd\u65f6\u5e74\u9f84");
    @Transient
    public static final Field BIRTHDATE = new Field("birthdate", "birthdate", "\u51fa\u751f\u65e5\u671f");
    @Transient
    public static final Field AGENT_ID = new Field("agentId", "agent_id", "\u4e1a\u52a1\u5458\u7f16\u7801");
    @Transient
    public static final Field DATA_AUTH = new Field("dataAuth", "data_auth", "09.\u6570\u636e\u6743\u9650");

    public PolLibrary() {
    }

    public PolLibrary(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String dataAuth;
        String agentId;
        Return ret = new Return();
        String libraryUuid = StrUtils.trimStr((Object)this.libraryUuid);
        if (libraryUuid.length() > 32) {
            ret.setFailMsg("[\u65b9\u6848UUID]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + libraryUuid.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.libraryUuid)) {
            ret.setFailMsg("[\u65b9\u6848UUID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtils.isNull((Object)this.age) && !StrUtils.isNum((Object)this.age)) {
            ret.setFailMsg("[\u6295\u4fdd\u65f6\u5e74\u9f84]\u5fc5\u987b\u4e3a\u6570\u5b57\uff0c\u5b9e\u9645\u4e3a[" + this.age + "]");
        }
        if ((agentId = StrUtils.trimStr((Object)this.agentId)).length() > 32) {
            ret.setFailMsg("[\u4e1a\u52a1\u5458\u7f16\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + agentId.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.agentId)) {
            ret.setFailMsg("[\u4e1a\u52a1\u5458\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((dataAuth = StrUtils.trimStr((Object)this.dataAuth)).length() > 256) {
            ret.setFailMsg("[09.\u6570\u636e\u6743\u9650]\u4e0d\u80fd\u8d85\u8fc7[256]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + dataAuth.length() + "]\u4f4d");
        }
        return ret;
    }

    public PolLibrary setLibraryUuid(String libraryUuid) {
        this.libraryUuid = libraryUuid;
        this.where().setChangeColumn(LIBRARY_UUID);
        return this;
    }

    public String getLibraryUuid() {
        return this.libraryUuid;
    }

    public PolLibrary setSex(String sex) {
        if (!StrUtils.isNull((Object)sex)) {
            Sex.valueOf(sex);
        }
        this.sex = sex;
        this.where().setChangeColumn(SEX);
        return this;
    }

    public String getSex() {
        return this.sex;
    }

    public PolLibrary setSex(Sex sex) {
        this.sex = sex.code();
        this.where().setChangeColumn(SEX);
        return this;
    }

    public Sex getSexEnum() {
        if (StrUtils.isNull((Object)this.sex)) {
            return null;
        }
        return Sex.valueOf(this.sex);
    }

    public PolLibrary setAge(Integer age) {
        this.age = age;
        this.where().setChangeColumn(AGE);
        return this;
    }

    public Integer getAge() {
        return this.age;
    }

    public PolLibrary setBirthdate(Date birthdate) {
        this.birthdate = DateUtils.trunc((Date)birthdate);
        this.where().setChangeColumn(BIRTHDATE);
        return this;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public PolLibrary setAgentId(String agentId) {
        this.agentId = agentId;
        this.where().setChangeColumn(AGENT_ID);
        return this;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public PolLibrary setDataAuth(String dataAuth) {
        this.dataAuth = dataAuth;
        this.where().setChangeColumn(DATA_AUTH);
        return this;
    }

    public String getDataAuth() {
        return this.dataAuth;
    }

    @JsonIgnore
    public PolLibrary select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<PolLibrary> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<PolLibrary> groupBy() {
        return this.groupby;
    }

    @JsonIgnore
    public PolLibrary setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static PolLibrary n() {
        return new PolLibrary();
    }

    @JsonIgnore
    public static PolLibrary n(boolean appendWhere) {
        return new PolLibrary(appendWhere);
    }
}

