/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain.party;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.nms.insure.domain.Order;
import com.newtouch.nms.insure.domain.party.Insured;
import com.newtouch.nms.insure.domain.party.PartyCallback;
import com.newtouch.nms.insure.model.PolOrderParty;
import com.newtouch.nms.insure.model.PolOrderPartyAddress;
import com.newtouch.nms.insure.model.PolOrderPartyContract;
import com.newtouch.nms.insure.model.PolOrderPartyImage;
import com.newtouch.nms.insure.model.PolOrderPartyRelation;
import com.newtouch.nms.insure.model.PolOrderPartyTaxCompany;
import com.newtouch.nms.insure.model.PolOrderPartyTaxCountry;
import com.newtouch.nms.insure.model.enums.AffiliatedType;
import com.newtouch.nms.insure.model.enums.IdType;
import com.newtouch.nms.insure.model.enums.PartyType;
import com.newtouch.nms.insure.model.enums.RelationType;
import com.newtouch.nms.insure.model.enums.SaveType;
import com.newtouch.nms.insure.model.enums.TaxChina;
import com.newtouch.nms.insure.utils.FilterType;
import com.newtouch.nms.insure.utils.MsgUtils;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Table;

@Table(name="pol_order_party")
public abstract class Party
extends PolOrderParty {
    private List<PolOrderPartyAddress> address = new ArrayList<PolOrderPartyAddress>();
    private List<PolOrderPartyContract> contact = new ArrayList<PolOrderPartyContract>();
    private List<PolOrderPartyImage> images = new ArrayList<PolOrderPartyImage>();
    private List<PolOrderPartyTaxCountry> country = new ArrayList<PolOrderPartyTaxCountry>();
    private Order order;
    private PolOrderPartyRelation relation;
    private PartyCallback partyCallback;
    @JsonProperty(value="party_type")
    private PartyType partyType;
    @JsonProperty(value="affiliated_type")
    private AffiliatedType affiliatedType;
    @JsonProperty(value="affiliated_applicant")
    private AffiliatedType affiliatedApplicant;

    public void fill() {
        if (StrUtils.isNull((Object)this.getOrderUuid()) && this.getOrder() != null && !StrUtils.isNull((Object)this.getOrder().getOrderUuid())) {
            this.setOrderUuid(this.getOrder().getOrderUuid());
        }
        if (StrUtils.isNull((Object)this.getPartyUuid())) {
            this.setPartyUuid(UUID.shortUUID());
        }
        this.address.forEach(address -> {
            if (StrUtils.isNull((Object)address.getPartyUuid())) {
                address.setPartyUuid(this.getPartyUuid());
            }
            if (StrUtils.isNull((Object)address.getAddressUuid())) {
                address.setAddressUuid(UUID.shortUUID());
            }
        });
        this.contact.forEach(contract -> {
            if (StrUtils.isNull((Object)contract.getPartyUuid())) {
                contract.setPartyUuid(this.getPartyUuid());
            }
            if (StrUtils.isNull((Object)contract.getContractUuid())) {
                contract.setContractUuid(UUID.shortUUID());
            }
        });
        this.country.forEach(taxCountry -> {
            if (StrUtils.isNull((Object)taxCountry.getPartyUuid())) {
                taxCountry.setPartyUuid(this.getPartyUuid());
            }
        });
        this.images.forEach(image -> {
            if (StrUtils.isNull((Object)image.getPartyUuid())) {
                image.setPartyUuid(this.getPartyUuid());
            }
            if (StrUtils.isNull((Object)image.getOrderUuid())) {
                image.setOrderUuid(this.getOrderUuid());
            }
            if (StrUtils.isNull((Object)image.getImageUuid())) {
                image.setImageUuid(UUID.shortUUID());
            }
        });
    }

    public Return save(AbsModelRepository dao) {
        PolOrderParty dbParty = (PolOrderParty)dao.findOne((AbsModel)PolOrderParty.n(true).setOrderUuid(this.getOrderUuid()).setPartyUuid(this.getPartyUuid()));
        if (dbParty == null) {
            if (this.partyCallback != null) {
                this.partyCallback.save(this, this.getPartyType(), SaveType.INS, Party.class);
            }
            dao.save((AbsModel)this);
        } else {
            PolOrderPartyRelation dbRelation;
            FilterType model;
            if (this.partyCallback != null && (model = this.partyCallback.mdfField(this.getPartyType())) != null) {
                model.copy(this, dbParty);
            }
            dbParty.where().addEq(PolOrderParty.ORDER_UUID, (Object)this.getOrderUuid()).addEq(PolOrderParty.PARTY_UUID, (Object)this.getPartyUuid());
            if (dbParty.getTaxChinaEnum() == TaxChina.CR) {
                dbParty.setFamilyNameEng(null);
                dbParty.setFirstNameEng(null);
                dao.delete(PolOrderPartyAddress.n().where().addEq(PolOrderPartyAddress.PARTY_UUID, (Object)dbParty.getPartyUuid()).addIn(PolOrderPartyAddress.ADDRESS_TYPE, new String[]{"04", "02", "04E", "02E"}).model());
            }
            if (this.address.size() > 4) {
                dao.delete((AbsModel)PolOrderPartyAddress.n(true).setPartyUuid(this.getPartyUuid()));
            } else if (this.address.size() == 4 && !this.contact.isEmpty()) {
                dao.delete(PolOrderPartyAddress.n().where().addEq(PolOrderPartyAddress.PARTY_UUID, (Object)dbParty.getPartyUuid()).addIn(PolOrderPartyAddress.ADDRESS_TYPE, new String[]{"04", "02", "04E", "02E"}).model());
            } else {
                dao.delete(PolOrderPartyAddress.n().where().addEq(PolOrderPartyAddress.PARTY_UUID, (Object)dbParty.getPartyUuid()).addNotIn(PolOrderPartyAddress.ADDRESS_TYPE, new String[]{"04", "02", "04E", "02E"}).model());
            }
            if (this.relation != null && !StrUtils.isNull((Object)this.relation.getMasterRelation()) && (dbRelation = (PolOrderPartyRelation)dao.findOne((AbsModel)PolOrderPartyRelation.n(true).setAffiliatedApplicant(this.getPartyUuid()).setRelationType(this.relation.getRelationType()))) != null) {
                dao.delete(PolOrderPartyRelation.n(true).setSerno(dbRelation.getSerno()));
            }
            if (dbParty.getTaxChinaEnum() == TaxChina.CR || !this.country.isEmpty()) {
                dao.delete(PolOrderPartyTaxCountry.n().where().addEq(PolOrderPartyTaxCountry.PARTY_UUID, (Object)dbParty.getPartyUuid()).model());
                dao.delete(PolOrderPartyTaxCompany.n().where().addEq(PolOrderPartyTaxCompany.PARTY_UUID, (Object)dbParty.getPartyUuid()).model());
            }
            dao.delete(PolOrderPartyImage.n(true).setPartyUuid(this.getPartyUuid()).where().addIn(PolOrderPartyImage.IMAGE_TYPE, new String[]{IdType.I.code(), IdType.C.code(), IdType.M.code(), IdType.S.code(), IdType.G.code(), IdType.W.code(), IdType.J.code(), IdType.P.code(), IdType.E.code()}).model());
            dao.delete(PolOrderPartyContract.n().where().addEq(PolOrderPartyContract.PARTY_UUID, (Object)dbParty.getPartyUuid()).model());
            if (this.partyCallback != null) {
                this.partyCallback.save(this, this.getPartyType(), SaveType.MDF, Party.class);
            }
            dao.update((AbsModel)dbParty);
        }
        if (this.address != null && !this.address.isEmpty()) {
            dao.save(this.address);
        }
        if (this.contact != null && !this.contact.isEmpty()) {
            dao.save(this.contact);
        }
        if (this.relation != null && !StrUtils.isNull((Object)this.relation.getMasterRelation())) {
            dao.save((AbsModel)this.relation);
        }
        if (this.images != null && !this.images.isEmpty()) {
            dao.save(this.images);
        }
        return new Return();
    }

    @Override
    public Return checkValue() {
        Return msg = new Return();
        if (StrUtils.isNull((Object)this.getPartyUuid())) {
            msg.setFailMsg(MsgUtils.msg("\u4eba\u5458\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        return msg;
    }

    public List<PolOrderPartyAddress> getAddress() {
        return this.address;
    }

    public void setAddress(List<PolOrderPartyAddress> address) {
        this.address = address;
    }

    public List<PolOrderPartyContract> getContact() {
        return this.contact;
    }

    public void setContact(List<PolOrderPartyContract> contact) {
        this.contact = contact;
    }

    public List<PolOrderPartyImage> getImages() {
        return this.images;
    }

    public void setImages(List<PolOrderPartyImage> images) {
        this.images = images;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
        this.setOrderUuid(this.order.getOrderUuid());
    }

    public PartyType getPartyType() {
        return this.partyType;
    }

    public void setPartyType(PartyType partyType) {
        this.partyType = partyType;
    }

    public void setPartyType(String partyType) {
        this.partyType = PartyType.valueOf(partyType);
    }

    public AffiliatedType getAffiliatedType() {
        return this.affiliatedType;
    }

    public void setAffiliatedType(AffiliatedType affiliatedType) {
        this.affiliatedType = affiliatedType;
    }

    public void setAffiliatedType(String affiliatedType) {
        this.affiliatedType = AffiliatedType.valueOf(affiliatedType);
    }

    public AffiliatedType getAffiliatedApplicant() {
        return this.affiliatedApplicant;
    }

    public void setAffiliatedApplicant(AffiliatedType affiliatedApplicant) {
        this.affiliatedApplicant = affiliatedApplicant;
    }

    public void setAffiliatedApplicant(String affiliatedApplicant) {
        this.affiliatedApplicant = AffiliatedType.valueOf(affiliatedApplicant);
    }

    public PolOrderPartyRelation getRelation() {
        return this.relation;
    }

    public void setRelation(PolOrderPartyRelation relation) {
        this.relation = relation;
    }

    public List<PolOrderPartyTaxCountry> getCountry() {
        return this.country;
    }

    public void setCountry(List<PolOrderPartyTaxCountry> country) {
        this.country = country;
    }

    public PartyCallback getPartyCallback() {
        return this.partyCallback;
    }

    public void setPartyCallback(PartyCallback partyCallback) {
        this.partyCallback = partyCallback;
    }

    public PolOrderPartyRelation initRelation(RelationType type, String masterUuid) {
        PolOrderPartyRelation relation = new PolOrderPartyRelation();
        relation.setPolicyUuid(UUID.shortUUID());
        relation.setRelationType(type);
        relation.setMasterRelation(masterUuid);
        relation.setAffiliatedRelation(this.getPartyUuid());
        relation.setAffiliatedType(this.getAffiliatedType());
        return relation;
    }

    public static void main(String[] args) {
        int[] a;
        HashMap<String, String> partyMap = new HashMap<String, String>();
        partyMap.put("party_type", "TBR");
        Insured ii = (Insured)((Object)JsonUtils.json2Class((String)JsonUtils.toJson(partyMap), Insured.class));
        System.out.println((Object)ii.getPartyType());
        List<IdType> typeList = Arrays.asList(IdType.I, IdType.C, IdType.M);
        System.out.println(typeList.contains((Object)IdType.valueOf("I")));
        System.out.println(IdType.I.equals("I"));
        for (int i : a = new int[]{1, 2, 3, 4}) {
            switch (i) {
                case 3: {
                    System.out.println("switch" + i);
                }
            }
            System.out.println(i);
        }
    }
}

