/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain.party;

import com.newtouch.nms.insure.domain.party.Applicant;
import com.newtouch.nms.insure.domain.party.Beneficiary;
import com.newtouch.nms.insure.domain.party.Guardian;
import com.newtouch.nms.insure.domain.risk.Main;
import com.newtouch.nms.insure.model.enums.BenefType;
import com.newtouch.nms.insure.model.enums.PartyType;
import com.newtouch.nms.insure.model.enums.RelationType;
import com.newtouch.nms.insure.utils.MsgUtils;
import com.uniapis.msg.Return;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Table;

@Table(name="pol_policy_order_party")
public class Insured
extends Applicant {
    private Applicant master;
    private List<Beneficiary> beneficiary = new ArrayList<Beneficiary>();
    private Guardian guardian;
    private Map<String, Main> mainRisks = new HashMap<String, Main>();
    private List<Main> risk = new ArrayList<Main>();
    private final Map<Integer, List<Beneficiary>> beneficiaries = new HashMap<Integer, List<Beneficiary>>();

    public Insured() {
        this.setPartyType(PartyType.BBR);
    }

    public void fill(String orderUuid, String applicantUuid, Map<String, Object> param) {
        if (StrUtils.isNull((Object)orderUuid)) {
            throw new BusinessException(MsgUtils.msg("\u8ba2\u5355uuid\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        if (StrUtils.isNull((Object)applicantUuid)) {
            throw new BusinessException(MsgUtils.msg("\u6295\u4fdd\u4ebauuid\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        if (param != null) {
            ClassUtils.copyProperties((Object)JsonUtils.map2Class(param, Insured.class), (Object)((Object)this));
        }
        this.setOrderUuid(orderUuid);
        super.fill();
        if ((this.beneficiary == null || this.beneficiary.isEmpty()) && param != null && param.containsKey("benef")) {
            this.beneficiary = JsonUtils.listMap2ListClass((List)((List)param.get("benef")), Beneficiary.class);
        }
        if (this.beneficiary != null && !this.beneficiary.isEmpty()) {
            this.beneficiary.forEach(syr -> {
                syr.setOrder(this.getOrder());
                syr.setPartyCallback(this.getPartyCallback());
                syr.setMaster(this);
                syr.fill();
            });
            this.beneficiaries.clear();
            this.beneficiaries.putAll(this.beneficiary.stream().collect(Collectors.groupingBy(syr -> syr.getBenefitOrder())));
        }
        if (this.guardian != null) {
            this.setMaster(this);
            this.setOrder(this.getOrder());
            this.setPartyCallback(this.getPartyCallback());
            this.guardian.fill();
        }
        this.setRelation(this.initRelation(RelationType.TB, applicantUuid));
        if ((this.risk == null || this.risk.isEmpty()) && param != null && param.containsKey("risk")) {
            this.risk = JsonUtils.listMap2ListClass((List)((List)param.get("risk")), Main.class);
        }
        if (this.risk != null && !this.risk.isEmpty()) {
            this.risk.forEach(risk -> {
                risk.setInsured(this);
                if (StrUtils.isNull((Object)risk.getPartyUuid())) {
                    risk.setPartyUuid(this.getPartyUuid());
                }
                if (StrUtils.isNull((Object)risk.getOrderUuid())) {
                    risk.setOrderUuid(this.getOrderUuid());
                }
                if (StrUtils.isNull((Object)risk.getRiskUuid())) {
                    risk.setRiskUuid(UUID.shortUUID());
                }
            });
        }
    }

    @Override
    public void fill() {
        if (this.getOrder() == null) {
            throw new BusinessException(MsgUtils.msg("\u8ba2\u5355\u5bf9\u8c61\u672a\u8bbe\u7f6e", new Object[0]));
        }
        if (StrUtils.isNull((Object)this.getOrder().getOrderUuid())) {
            throw new BusinessException(MsgUtils.msg("\u8ba2\u5355uuid\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        if (this.getMaster() == null) {
            throw new BusinessException(MsgUtils.msg("\u6295\u4fdd\u4eba\u5bf9\u8c61\u672a\u8bbe\u7f6e", new Object[0]));
        }
        if (StrUtils.isNull((Object)this.getMaster().getPartyUuid())) {
            throw new BusinessException(MsgUtils.msg("\u6295\u4fdd\u4ebauuid\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        this.fill(this.getOrder().getOrderUuid(), this.getMaster().getPartyUuid(), null);
    }

    @Override
    public Return checkValue() {
        Return msg = super.checkValue();
        if (this.getBeneficiary() != null && !this.getBeneficiary().isEmpty()) {
            this.getBeneficiary().forEach(syr -> msg.addReturn(syr.checkValue()));
        }
        if (this.guardian != null) {
            msg.addReturn(this.guardian.checkValue());
        }
        if (!msg.isSuccessflag()) {
            return msg;
        }
        if (this.getBenefTypeEnum().equals((Object)BenefType.DES) && this.beneficiaries.isEmpty()) {
            msg.setFailMsg(MsgUtils.msg("\u8bf7\u5f55\u5165\u53d7\u76ca\u4eba\u4fe1\u606f", new Object[0]));
            return msg;
        }
        HashSet idSet = new HashSet();
        this.beneficiaries.entrySet().forEach(partyList -> {
            ArrayList rateList = new ArrayList();
            ((List)partyList.getValue()).forEach(party -> {
                rateList.add(Integer.parseInt(party.getBenefitRatio()));
                Return partyMsg = party.checkValue();
                if (idSet.contains(party.getIdNo())) {
                    msg.setFailMsg(MsgUtils.msg("\u53d7\u76ca\u4eba\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u5f55\u5165", party.getFullName()));
                }
                if (!partyMsg.isSuccessflag()) {
                    msg.setFailMsg(partyMsg.getMsgList());
                }
                if (!partyMsg.getWarnList().isEmpty()) {
                    msg.setWarnMsg(partyMsg.getWarnList());
                }
                idSet.add(party.getIdNo());
            });
            int benefitRatio = rateList.stream().mapToInt(i -> i).sum();
            if (benefitRatio != 100) {
                msg.setFailMsg(MsgUtils.msg("\u7b2c\u201c%s\u201d\u987a\u4f4d\u53d7\u76ca\u4eba\u53d7\u76ca\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u4e3a100\uff0c\u8bf7\u4fee\u6539", partyList.getKey()));
            }
        });
        if (!msg.isSuccessflag()) {
            return msg;
        }
        int maxOrder = Collections.max(this.beneficiaries.keySet());
        int minOrder = Collections.min(this.beneficiaries.keySet());
        if (this.beneficiaries.keySet().size() != maxOrder) {
            msg.setFailMsg(MsgUtils.msg("\u53d7\u76ca\u987a\u5e8f\u5fc5\u987b\u8fde\u7eed", new Object[0]));
        }
        if ((double)maxOrder > MsgUtils.num("insured.benef.maxOrder") && (double)minOrder < MsgUtils.num("insured.benef.minOrder")) {
            msg.setFailMsg(MsgUtils.msg("\u53d7\u76ca\u987a\u5e8f\u9700\u5728%s\u81f3%s\u4e4b\u95f4", MsgUtils.num("insured.benef.maxOrder"), MsgUtils.num("insured.benef.minOrder")));
        }
        return msg;
    }

    @Override
    public Return save(AbsModelRepository dao) {
        super.save(dao);
        this.beneficiaries.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(syr -> {
            syr.setPartyCallback(this.getPartyCallback());
            syr.save(dao);
        }));
        dao.save(this.risk);
        return new Return();
    }

    public Map<Integer, List<Beneficiary>> getBeneficiaries() {
        return this.beneficiaries;
    }

    public Map<String, Main> getMainRisks() {
        return this.mainRisks;
    }

    public void setMainRisks(Map<String, Main> mainRisks) {
        this.mainRisks = mainRisks;
    }

    public List<Main> getRisk() {
        return this.risk;
    }

    public void setRisk(List<Main> risk) {
        this.risk = risk;
    }

    public List<Beneficiary> getBeneficiary() {
        return this.beneficiary;
    }

    public void setBeneficiary(List<Beneficiary> beneficiary) {
        this.beneficiary = beneficiary;
    }

    public Applicant getMaster() {
        return this.master;
    }

    public void setMaster(Applicant master) {
        this.master = master;
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public void setGuardian(Guardian guardian) {
        this.guardian = guardian;
    }

    public static void main(String[] args) {
        String json = FileUtils.readLocalFile((String)"/Users/Work/Workspace/source/n-mp/back-end/newtouch-nms/nms-insure-model/src/main/java/com/newtouch/nms/insure/domain/request-insured.json").stream().collect(Collectors.joining());
        Insured i = new Insured();
        i.fill("aaa", "bbbb", JsonUtils.json2Map((String)json));
        Insured insured = (Insured)((Object)JsonUtils.json2Class((String)json, Insured.class));
        System.out.println((Object)insured);
    }
}

