/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.nms.insure.domain.OrderCallback;
import com.newtouch.nms.insure.domain.party.Applicant;
import com.newtouch.nms.insure.domain.party.Insured;
import com.newtouch.nms.insure.domain.party.PartyCallback;
import com.newtouch.nms.insure.domain.risk.Main;
import com.newtouch.nms.insure.model.PolOrder;
import com.newtouch.nms.insure.model.PolOrderParty;
import com.newtouch.nms.insure.model.PolOrderPartyAddress;
import com.newtouch.nms.insure.model.PolOrderPartyContract;
import com.newtouch.nms.insure.model.PolOrderPartyImage;
import com.newtouch.nms.insure.model.PolOrderPartyRelation;
import com.newtouch.nms.insure.model.PolOrderPartyTaxCompany;
import com.newtouch.nms.insure.model.PolOrderPartyTaxCountry;
import com.newtouch.nms.insure.model.PolOrderPartyTruthfully;
import com.newtouch.nms.insure.model.PolOrderPartyTruthfullyResult;
import com.newtouch.nms.insure.model.PolPolicy;
import com.newtouch.nms.insure.model.PolPolicyParty;
import com.newtouch.nms.insure.model.PolPolicyPartySign;
import com.newtouch.nms.insure.model.PolPolicyPay;
import com.newtouch.nms.insure.model.PolPolicyRisk;
import com.newtouch.nms.insure.model.PolPolicyShare;
import com.newtouch.nms.insure.model.enums.PartyType;
import com.newtouch.nms.insure.model.enums.PolicyState;
import com.newtouch.nms.insure.model.enums.RiskType;
import com.newtouch.nms.insure.model.enums.SaveType;
import com.newtouch.nms.insure.utils.FilterType;
import com.newtouch.nms.insure.utils.MsgUtils;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Table;

@Table(name="pol_policy_order")
public class Order
extends PolOrder {
    private Applicant applicant;
    public List<Insured> insured;
    public Map<String, Insured> insureds = new HashMap<String, Insured>();
    private final Map<String, Main> mainRisk = new HashMap<String, Main>();
    private OrderCallback orderCallback;
    private PartyCallback partyCallback;
    @JsonProperty(value="save_type")
    public SaveType saveType;

    public void fill(Map<String, Object> param) {
        if (param != null) {
            ClassUtils.copyProperties((Object)RequestUtils.getRequestMap(param, Order.class), (Object)((Object)this));
        }
        this.fillPartyInfo(param);
        StringBuilder searchIndex = new StringBuilder(this.applicant.getFullName());
        if (!this.insured.isEmpty()) {
            this.insured.forEach(insured -> insured.getRisk().stream().filter(r -> RiskType.M.equals((Object)r.getRiskTypeEnum())).forEach(r -> searchIndex.append("**" + insured.getFullName() + "**" + r.getProductName() + "**" + r.getProductNamePinyin())));
            this.insured.forEach(insured -> insured.getMainRisks().values().forEach(r -> searchIndex.append("**" + insured.getFullName() + "**" + r.getProductName() + "**" + r.getProductNamePinyin())));
        }
        this.setSearchIndex(searchIndex.toString());
    }

    private void fillPartyInfo(Map<String, Object> param) {
        if (param != null && param.containsKey("applicant")) {
            if (this.applicant == null) {
                this.applicant = new Applicant();
            }
            this.applicant.setOrder(this);
            this.applicant.setPartyCallback(this.partyCallback);
            this.applicant.fill(this.getOrderUuid(), (Map)param.get("applicant"));
        } else {
            this.applicant.setOrder(this);
            this.applicant.setPartyCallback(this.partyCallback);
            this.applicant.fill();
        }
        if (param != null && param.containsKey("insured")) {
            if (this.insured == null) {
                this.insured = new ArrayList<Insured>();
            }
            this.insured.addAll(JsonUtils.listMap2ListClass((List)((List)param.get("insured")), Insured.class));
        }
        this.insured.forEach(insured -> {
            insured.setOrder(this);
            insured.setMaster(this.applicant);
            insured.setPartyCallback(this.partyCallback);
            insured.fill();
            this.insureds.put(insured.getPartyUuid(), (Insured)((Object)insured));
        });
    }

    public Return saveOrderInfo(AbsModelRepository dao) {
        Return ret = new Return();
        PolOrder dbOrder = (PolOrder)dao.findOne((AbsModel)Order.n(true).setOrderUuid(this.getOrderUuid()));
        if (dbOrder == null) {
            if (this.orderCallback != null) {
                this.orderCallback.save(this, SaveType.INS);
            }
            this.setPolicyStep(1);
            this.setDataToken(UUID.shortUUID());
            this.setBranchId(ThreadLocalContext.get().getUser().getOrganId());
            this.setOrganId(ThreadLocalContext.get().getUser().getOrganId());
            this.setAgentId(ThreadLocalContext.get().getUser().getUserCode());
            dao.save((AbsModel)this);
        } else {
            FilterType mode;
            if (!dbOrder.getDataToken().equals(this.getDataToken())) {
                ret.setFailMsg(MsgUtils.msg("\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u60a8\u91cd\u65b0\u8fdb\u5165\u9875\u9762\u83b7\u53d6\u6700\u65b0\u6570\u636e\u4e4b\u540e\u91cd\u65b0\u8fdb\u884c\u64cd\u4f5c\u3002", new Object[0]));
                return ret;
            }
            if (this.orderCallback != null && (mode = this.orderCallback.mdfField()) != null) {
                mode.copy(this, dbOrder);
            }
            if (!StrUtils.isNull((Object)this.getPolicyStep()) && this.getPolicyStep() > dbOrder.getPolicyStep()) {
                dbOrder.setPolicyStep(this.getPolicyStep());
            }
            dbOrder.where().addEq(PolOrder.ORDER_UUID, (Object)this.getOrderUuid());
            if (this.orderCallback != null) {
                this.orderCallback.save(this, SaveType.MDF);
            }
            dbOrder.setDataToken(UUID.shortUUID());
            this.setDataToken(dbOrder.getDataToken());
            dao.update((AbsModel)dbOrder);
        }
        if (this.applicant != null && !StrUtils.isNull((Object)this.applicant.getPartyUuid())) {
            this.applicant.save(dao);
        }
        if (this.insured != null && !this.insured.isEmpty()) {
            this.insured.forEach(insured -> insured.save(dao));
        }
        return new Return();
    }

    public void deletePartyInfo(AbsModelRepository dao, List<PartyType> partyTypes, List<String> partyUuid) {
        List dbParties;
        PolOrderParty qParty = PolOrderParty.n(true).setOrderUuid(this.getOrderUuid());
        if (partyTypes != null && !partyTypes.isEmpty()) {
            qParty.where().addIn(PolOrderParty.ORDER_UUID, (String[])partyTypes.stream().map(s -> s.code()).toArray(String[]::new));
        }
        if (partyUuid != null && !partyUuid.isEmpty()) {
            qParty.where().addIn(PolOrderParty.PARTY_UUID, partyUuid);
        }
        if ((dbParties = dao.findAll((AbsModel)qParty)).isEmpty() || this.partyCallback == null) {
            return;
        }
        Map<String, PolOrderParty> dbPartyMap = this.diffPartyKey(this.partyCallback.diffField(null), dbParties);
        ArrayList<PolOrderParty> pageParties = new ArrayList<PolOrderParty>();
        pageParties.add(this.applicant);
        this.insured.forEach(bbr -> {
            pageParties.add((PolOrderParty)((Object)bbr));
            bbr.getBeneficiary().forEach(syr -> pageParties.add((PolOrderParty)((Object)syr)));
        });
        Map<String, PolOrderParty> pagePartyMap = this.diffPartyKey(this.partyCallback.diffField(null), pageParties);
        Set<String> diffKey = dbPartyMap.keySet();
        diffKey.removeAll(pagePartyMap.keySet());
        String[] partyArray = (String[])diffKey.stream().map(key -> ((PolOrderParty)((Object)((Object)dbPartyMap.get(key)))).getPartyUuid()).toArray(String[]::new);
        this.delParty(dao, partyArray);
    }

    public void delParty(AbsModelRepository dao, String[] partyArray) {
        if (partyArray == null || partyArray.length == 0) {
            return;
        }
        dao.delete(PolOrderParty.n().where().addIn(PolOrderParty.PARTY_UUID, partyArray).model());
        dao.delete(PolOrderPartyRelation.n().where().addIn(PolOrderPartyRelation.MASTER_RELATION, partyArray).model());
        dao.delete(PolOrderPartyRelation.n().where().addIn(PolOrderPartyRelation.AFFILIATED_RELATION, partyArray).model());
        dao.delete(PolOrderPartyContract.n().where().addIn(PolOrderPartyContract.PARTY_UUID, partyArray).model());
        dao.delete(PolOrderPartyAddress.n().where().addIn(PolOrderPartyAddress.PARTY_UUID, partyArray).model());
        dao.delete(PolOrderPartyImage.n().where().addIn(PolOrderPartyImage.PARTY_UUID, partyArray).model());
        dao.delete(PolOrderPartyTaxCountry.n().where().addIn(PolOrderPartyTaxCountry.PARTY_UUID, partyArray).model());
        dao.delete(PolOrderPartyTaxCompany.n().where().addIn(PolOrderPartyTaxCompany.PARTY_UUID, partyArray).model());
        dao.delete(PolPolicyParty.n().where().addIn(PolPolicyParty.PARTY_UUID, partyArray).model());
        dao.delete(PolPolicyPay.n().where().addIn(PolPolicyPay.PARTY_UUID, partyArray).model());
        String[] tfUuid = (String[])dao.findAll(PolOrderPartyTruthfully.n().where().addIn(PolOrderPartyTruthfully.PARTY_UUID, partyArray).model()).stream().map(ppt -> ppt.getTruthfullyUuid()).toArray(String[]::new);
        dao.delete(PolOrderPartyTruthfullyResult.n().where().addIn(PolOrderPartyTruthfullyResult.TRUTHFULLY_UUID, tfUuid).model());
        dao.delete(PolOrderPartyTruthfully.n().where().addIn(PolOrderPartyTruthfully.PARTY_UUID, partyArray).model());
        dao.delete(PolPolicyRisk.n().where().addIn(PolPolicyRisk.PARTY_UUID, partyArray).model());
        dao.delete(PolPolicyShare.n().where().addIn(PolPolicyShare.PARTY_UUID, partyArray).model());
    }

    public Return checkValue(boolean isMdf) {
        Return msg = new Return();
        if (isMdf && StrUtils.isNull((Object)this.getDataToken())) {
            msg.setFailMsg(MsgUtils.msg("\u6570\u636e\u53e3\u4ee4\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        if (StrUtils.isNull((Object)this.getOrderUuid())) {
            msg.setFailMsg(MsgUtils.msg("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        if (StrUtils.isNull((Object)this.getCurrentRole())) {
            msg.setFailMsg(MsgUtils.msg("\u5f53\u524d\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]));
        }
        if (!msg.isSuccessflag()) {
            return msg;
        }
        if (this.applicant != null && !StrUtils.isNull((Object)this.applicant.getPartyUuid())) {
            msg.addReturn(this.applicant.checkValue());
        }
        if (this.insured != null && !this.insured.isEmpty()) {
            this.insured.forEach(party -> msg.addReturn(party.checkValue()));
        }
        return msg;
    }

    private void savePolicyAndPolicyParty(AbsModelRepository dao, PolOrder thisOrder, Insured insured, Set<String> policyUuidSet, Main main) {
        if (!policyUuidSet.contains(main.getPolicyUuid())) {
            policyUuidSet.add(main.getPolicyUuid());
            PolPolicy policy = new PolPolicy();
            ClassUtils.copyProperties((Object)((Object)thisOrder), (Object)((Object)policy));
            policy.setPolicyUuid(main.getPolicyUuid());
            policy.setPolicyState(PolicyState.SU.name());
            policy.setApplyDate(DateUtils.sysDate());
            policy.setOrganId(ThreadLocalContext.get().getUser().getOrganId());
            policy.setAgentId(ThreadLocalContext.get().getUser().getUserCode());
            dao.save((AbsModel)policy);
            ArrayList<PolPolicyParty> ppPartyList = new ArrayList<PolPolicyParty>();
            PolPolicyParty tbrParty = new PolPolicyParty();
            tbrParty.setPolicyUuid(main.getPolicyUuid());
            tbrParty.setPolicyUuid(this.getApplicant().getPartyUuid());
            tbrParty.setPartyType(this.getApplicant().getPartyType().name());
            ppPartyList.add(tbrParty);
            PolPolicyParty bbrParty = new PolPolicyParty();
            bbrParty.setPolicyUuid(main.getPolicyUuid());
            bbrParty.setPolicyUuid(insured.getPartyUuid());
            bbrParty.setPartyType(insured.getPartyType().name());
            ppPartyList.add(bbrParty);
            insured.getBeneficiary().forEach(bef -> {
                PolPolicyParty befParty = new PolPolicyParty();
                befParty.setPolicyUuid(main.getPolicyUuid());
                befParty.setPolicyUuid(bef.getPartyUuid());
                befParty.setPartyType(bef.getPartyType().name());
                ppPartyList.add(befParty);
            });
            dao.save(ppPartyList);
        }
    }

    private void deleteOrderInfo(AbsModelRepository dao) {
        dao.findAll(PolPolicy.n().where().addEq(PolPolicy.ORDER_UUID, (Object)this.getOrderUuid()).model()).forEach(policy -> {
            dao.delete(PolPolicyPartySign.n().where().addIn(PolPolicyPartySign.POLICY_UUID, new String[]{policy.getPolicyUuid()}).model());
            dao.delete(PolPolicyRisk.n().where().addIn(PolPolicyRisk.POLICY_UUID, new String[]{policy.getPolicyUuid()}).model());
        });
        dao.delete(PolPolicyPartySign.n().where().addIn(PolPolicyPartySign.ORDER_UUID, new String[]{this.getOrderUuid()}).model());
        dao.delete(PolPolicy.n().where().addIn(PolPolicy.ORDER_UUID, new String[]{this.getOrderUuid()}).model());
        dao.delete(PolOrder.n().where().addIn(PolOrder.ORDER_UUID, new String[]{this.getOrderUuid()}).model());
    }

    private Map<String, PolOrderParty> diffPartyKey(FilterType diffFields, List<PolOrderParty> dbParties) {
        return dbParties.stream().collect(Collectors.toMap(party -> diffFields.getFields().stream().map(key -> StrUtils.trimStr((Object)ClassUtils.getProperty((Object)party, (String)key))).collect(Collectors.joining("#")), party -> party, (existing, replacement) -> existing));
    }

    public Applicant getApplicant() {
        return this.applicant;
    }

    public void setApplicant(Applicant applicant) {
        this.applicant = applicant;
    }

    public void setInsured(List<Insured> insured) {
        this.insured = insured;
    }

    public List<Insured> getInsured() {
        return this.insured;
    }

    public Map<String, Insured> getInsureds() {
        return this.insureds;
    }

    public void setInsureds(Map<String, Insured> insureds) {
        this.insureds = insureds;
    }

    public Map<String, Main> getMainRisk() {
        return this.mainRisk;
    }

    public OrderCallback getOrderCallback() {
        return this.orderCallback;
    }

    public void setOrderCallback(OrderCallback orderCallback) {
        this.orderCallback = orderCallback;
    }

    public PartyCallback getPartyCallback() {
        return this.partyCallback;
    }

    public void setPartyCallback(PartyCallback partyCallback) {
        this.partyCallback = partyCallback;
    }

    public SaveType getSaveType() {
        return this.saveType;
    }

    public void setSaveType(SaveType saveType) {
        this.saveType = saveType;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("order_uuid", "test");
        Order order = new Order();
        ClassUtils.copyProperties(map, (Object)((Object)order));
        System.out.println(order.getOrderUuid());
        Order param = (Order)((Object)RequestUtils.getRequestMap(map, Order.class));
        System.out.println(param.getOrderUuid());
    }
}

