/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.utils;

import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.utils.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum FilterType {
    INCLUDE,
    EXCLUDE{

        @Override
        public void copy(AbsModel source, AbsModel target) {
            List allFields = ClassUtils.getClassFields(source.getClass());
            List<String> includeFields = allFields.stream().map(f -> f.getName()).collect(Collectors.toList());
            includeFields.removeAll(this.getFields());
            this.setFields(includeFields);
            super.copy(source, target);
        }
    };

    private List<String> fields = new ArrayList<String>();

    public List<String> getFields() {
        return this.fields;
    }

    public FilterType setFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public FilterType addFields(Field ... fields) {
        this.fields.addAll(Arrays.stream(fields).map(f -> f.property()).collect(Collectors.toList()));
        return this;
    }

    public FilterType addFields(String ... fields) {
        this.fields.addAll(Arrays.stream(fields).collect(Collectors.toList()));
        return this;
    }

    public void copy(AbsModel source, AbsModel target) {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        if (source == null || target == null) {
            return;
        }
        for (String field : this.fields) {
            ClassUtils.setProperty((Object)target, (String)field, (Object)ClassUtils.getProperty((Object)source, (String)field));
        }
    }
}

