/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.nms.insure.model.enums.RiskType;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.StrUtils;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="pol_library_risks")
public class PolLibraryRisks
extends AbsModel {
    @Column(name="library_uuid")
    @JsonProperty(value="library_uuid")
    private String libraryUuid;
    @Column(name="risk_type")
    @JsonProperty(value="risk_type")
    private String riskType;
    @Column(name="product_code")
    @JsonProperty(value="product_code")
    private String productCode;
    @Column(name="product_name")
    @JsonProperty(value="product_name")
    private String productName;
    @Column(name="risk_code")
    @JsonProperty(value="risk_code")
    private String riskCode;
    @Column(name="risk_name")
    @JsonProperty(value="risk_name")
    private String riskName;
    @Column(name="parent_risk_code")
    @JsonProperty(value="parent_risk_code")
    private String parentRiskCode;
    @Column(name="display_order")
    @JsonProperty(value="display_order")
    private Integer displayOrder;
    @Column(name="data_auth")
    @JsonProperty(value="data_auth")
    private String dataAuth;
    @Column(name="shard_code")
    @JsonProperty(value="shard_code")
    private String shardCode;
    @Transient
    @JsonIgnore
    private Where<PolLibraryRisks> where = Where.getInstance((AbsModel)this);
    @Transient
    @JsonIgnore
    private GroupBy<PolLibraryRisks> groupby = GroupBy.getInstance((AbsModel)this);
    @Transient
    public static final Field LIBRARY_UUID = new Field("libraryUuid", "library_uuid", "\u65b9\u6848UUID");
    @Transient
    public static final Field RISK_TYPE = new Field("riskType", "risk_type", "\u9669\u79cd\u7c7b\u578b");
    @Transient
    public static final Field PRODUCT_CODE = new Field("productCode", "product_code", "\u4ea7\u54c1\u4ee3\u7801");
    @Transient
    public static final Field PRODUCT_NAME = new Field("productName", "product_name", "\u4ea7\u54c1\u540d\u79f0");
    @Transient
    public static final Field RISK_CODE = new Field("riskCode", "risk_code", "\u9669\u79cd\u4ee3\u7801");
    @Transient
    public static final Field RISK_NAME = new Field("riskName", "risk_name", "\u9669\u79cd\u540d\u79f0");
    @Transient
    public static final Field PARENT_RISK_CODE = new Field("parentRiskCode", "parent_risk_code", "\u4e0a\u7ea7\u9669\u79cd\u4ee3\u7801");
    @Transient
    public static final Field DISPLAY_ORDER = new Field("displayOrder", "display_order", "\u663e\u793a\u987a\u5e8f");
    @Transient
    public static final Field DATA_AUTH = new Field("dataAuth", "data_auth", "09.\u6570\u636e\u6743\u9650");
    @Transient
    public static final Field SHARD_CODE = new Field("shardCode", "shard_code", "10.\u5206\u533a\u4ee3\u7801");

    public PolLibraryRisks() {
    }

    public PolLibraryRisks(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String shardCode;
        String dataAuth;
        String parentRiskCode;
        String riskName;
        String riskCode;
        String productName;
        String productCode;
        Return ret = new Return();
        String libraryUuid = StrUtils.trimStr((Object)this.libraryUuid);
        if (libraryUuid.length() > 32) {
            ret.setFailMsg("[\u65b9\u6848UUID]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + libraryUuid.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.libraryUuid)) {
            ret.setFailMsg("[\u65b9\u6848UUID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((productCode = StrUtils.trimStr((Object)this.productCode)).length() > 32) {
            ret.setFailMsg("[\u4ea7\u54c1\u4ee3\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + productCode.length() + "]\u4f4d");
        }
        if ((productName = StrUtils.trimStr((Object)this.productName)).length() > 128) {
            ret.setFailMsg("[\u4ea7\u54c1\u540d\u79f0]\u4e0d\u80fd\u8d85\u8fc7[128]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + productName.length() + "]\u4f4d");
        }
        if ((riskCode = StrUtils.trimStr((Object)this.riskCode)).length() > 32) {
            ret.setFailMsg("[\u9669\u79cd\u4ee3\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + riskCode.length() + "]\u4f4d");
        }
        if ((riskName = StrUtils.trimStr((Object)this.riskName)).length() > 512) {
            ret.setFailMsg("[\u9669\u79cd\u540d\u79f0]\u4e0d\u80fd\u8d85\u8fc7[512]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + riskName.length() + "]\u4f4d");
        }
        if ((parentRiskCode = StrUtils.trimStr((Object)this.parentRiskCode)).length() > 32) {
            ret.setFailMsg("[\u4e0a\u7ea7\u9669\u79cd\u4ee3\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + parentRiskCode.length() + "]\u4f4d");
        }
        if (!StrUtils.isNull((Object)this.displayOrder) && !StrUtils.isNum((Object)this.displayOrder)) {
            ret.setFailMsg("[\u663e\u793a\u987a\u5e8f]\u5fc5\u987b\u4e3a\u6570\u5b57\uff0c\u5b9e\u9645\u4e3a[" + this.displayOrder + "]");
        }
        if ((dataAuth = StrUtils.trimStr((Object)this.dataAuth)).length() > 256) {
            ret.setFailMsg("[09.\u6570\u636e\u6743\u9650]\u4e0d\u80fd\u8d85\u8fc7[256]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + dataAuth.length() + "]\u4f4d");
        }
        if ((shardCode = StrUtils.trimStr((Object)this.shardCode)).length() > 32) {
            ret.setFailMsg("[10.\u5206\u533a\u4ee3\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + shardCode.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.shardCode)) {
            ret.setFailMsg("[10.\u5206\u533a\u4ee3\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ret;
    }

    public PolLibraryRisks setLibraryUuid(String libraryUuid) {
        this.libraryUuid = libraryUuid;
        this.where().setChangeColumn(LIBRARY_UUID);
        return this;
    }

    public String getLibraryUuid() {
        return this.libraryUuid;
    }

    public PolLibraryRisks setRiskType(String riskType) {
        if (!StrUtils.isNull((Object)riskType)) {
            RiskType.valueOf(riskType);
        }
        this.riskType = riskType;
        this.where().setChangeColumn(RISK_TYPE);
        return this;
    }

    public String getRiskType() {
        return this.riskType;
    }

    public PolLibraryRisks setRiskType(RiskType riskType) {
        this.riskType = riskType.code();
        this.where().setChangeColumn(RISK_TYPE);
        return this;
    }

    public RiskType getRiskTypeEnum() {
        if (StrUtils.isNull((Object)this.riskType)) {
            return null;
        }
        return RiskType.valueOf(this.riskType);
    }

    public PolLibraryRisks setProductCode(String productCode) {
        this.productCode = productCode;
        this.where().setChangeColumn(PRODUCT_CODE);
        return this;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public PolLibraryRisks setProductName(String productName) {
        this.productName = productName;
        this.where().setChangeColumn(PRODUCT_NAME);
        return this;
    }

    public String getProductName() {
        return this.productName;
    }

    public PolLibraryRisks setRiskCode(String riskCode) {
        this.riskCode = riskCode;
        this.where().setChangeColumn(RISK_CODE);
        return this;
    }

    public String getRiskCode() {
        return this.riskCode;
    }

    public PolLibraryRisks setRiskName(String riskName) {
        this.riskName = riskName;
        this.where().setChangeColumn(RISK_NAME);
        return this;
    }

    public String getRiskName() {
        return this.riskName;
    }

    public PolLibraryRisks setParentRiskCode(String parentRiskCode) {
        this.parentRiskCode = parentRiskCode;
        this.where().setChangeColumn(PARENT_RISK_CODE);
        return this;
    }

    public String getParentRiskCode() {
        return this.parentRiskCode;
    }

    public PolLibraryRisks setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
        this.where().setChangeColumn(DISPLAY_ORDER);
        return this;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public PolLibraryRisks setDataAuth(String dataAuth) {
        this.dataAuth = dataAuth;
        this.where().setChangeColumn(DATA_AUTH);
        return this;
    }

    public String getDataAuth() {
        return this.dataAuth;
    }

    public PolLibraryRisks setShardCode(String shardCode) {
        this.shardCode = shardCode;
        this.where().setChangeColumn(SHARD_CODE);
        return this;
    }

    public String getShardCode() {
        return this.shardCode;
    }

    @JsonIgnore
    public PolLibraryRisks select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<PolLibraryRisks> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<PolLibraryRisks> groupBy() {
        return this.groupby;
    }

    @JsonIgnore
    public PolLibraryRisks setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static PolLibraryRisks n() {
        return new PolLibraryRisks();
    }

    @JsonIgnore
    public static PolLibraryRisks n(boolean appendWhere) {
        return new PolLibraryRisks(appendWhere);
    }
}

