/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain.party;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.nms.insure.domain.Order;
import com.newtouch.nms.insure.domain.party.Insured;
import com.newtouch.nms.insure.domain.party.PartyCallback;
import com.newtouch.nms.insure.model.PolOrderParty;
import com.newtouch.nms.insure.model.PolOrderPartyAddress;
import com.newtouch.nms.insure.model.PolOrderPartyContract;
import com.newtouch.nms.insure.model.PolOrderPartyImage;
import com.newtouch.nms.insure.model.PolOrderPartyRelation;
import com.newtouch.nms.insure.model.PolOrderPartyTaxCountry;
import com.newtouch.nms.insure.model.enums.AffiliatedType;
import com.newtouch.nms.insure.model.enums.IdType;
import com.newtouch.nms.insure.model.enums.PartyType;
import com.newtouch.nms.insure.model.enums.RelationType;
import com.newtouch.nms.insure.model.enums.SaveType;
import com.newtouch.nms.insure.utils.FilterType;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Table;

@Table(name="pol_order_party")
public abstract class Party
extends PolOrderParty {
    private List<PolOrderPartyAddress> address = new ArrayList<PolOrderPartyAddress>();
    private List<PolOrderPartyContract> contact = new ArrayList<PolOrderPartyContract>();
    private List<PolOrderPartyImage> images = new ArrayList<PolOrderPartyImage>();
    private List<PolOrderPartyTaxCountry> country = new ArrayList<PolOrderPartyTaxCountry>();
    private Order order;
    private PolOrderPartyRelation relation;
    private PartyCallback partyCallback;
    @JsonProperty(value="party_type")
    private PartyType partyType;
    @JsonProperty(value="affiliated_type")
    private AffiliatedType affiliatedType;
    @JsonProperty(value="affiliated_applicant")
    private AffiliatedType affiliatedApplicant;

    public void fill() {
        if (StrUtils.isNull((Object)this.getOrderUuid()) && this.getOrder() != null && !StrUtils.isNull((Object)this.getOrder().getOrderUuid())) {
            this.setOrderUuid(this.getOrder().getOrderUuid());
        }
        if (StrUtils.isNull((Object)this.getPartyUuid())) {
            this.setPartyUuid(UUID.shortUUID());
        }
        this.address.forEach(address -> {
            if (StrUtils.isNull((Object)address.getPartyUuid())) {
                address.setPartyUuid(this.getPartyUuid());
            }
            if (StrUtils.isNull((Object)address.getAddressUuid())) {
                address.setAddressUuid(UUID.shortUUID());
            }
        });
        this.contact.forEach(contract -> {
            if (StrUtils.isNull((Object)contract.getPartyUuid())) {
                contract.setPartyUuid(this.getPartyUuid());
            }
            if (StrUtils.isNull((Object)contract.getContractUuid())) {
                contract.setContractUuid(UUID.shortUUID());
            }
        });
        this.country.forEach(taxCountry -> {
            if (StrUtils.isNull((Object)taxCountry.getPartyUuid())) {
                taxCountry.setPartyUuid(this.getPartyUuid());
            }
        });
        this.images.forEach(image -> {
            if (StrUtils.isNull((Object)image.getPartyUuid())) {
                image.setPartyUuid(this.getPartyUuid());
            }
            if (StrUtils.isNull((Object)image.getOrderUuid())) {
                image.setOrderUuid(this.getOrderUuid());
            }
            if (StrUtils.isNull((Object)image.getImageUuid())) {
                image.setImageUuid(UUID.shortUUID());
            }
        });
    }

    public Return save(AbsModelRepository dao) {
        PolOrderParty dbParty = (PolOrderParty)dao.findOne((AbsModel)PolOrderParty.n(true).setOrderUuid(this.getOrderUuid()).setPartyUuid(this.getPartyUuid()));
        if (dbParty == null) {
            if (this.partyCallback != null) {
                this.partyCallback.save(this, this.getPartyType(), SaveType.INS);
            }
            dao.save((AbsModel)this);
        } else {
            FilterType model;
            if (this.partyCallback != null && (model = this.partyCallback.mdfField(this.getPartyType())) != null) {
                model.copy(this, dbParty);
            }
            dbParty.where().addEq(PolOrderParty.ORDER_UUID, (Object)this.getOrderUuid()).addEq(PolOrderParty.PARTY_UUID, (Object)this.getPartyUuid());
            if (this.partyCallback != null) {
                this.partyCallback.save(this, this.getPartyType(), SaveType.INS);
            }
            dao.update((AbsModel)dbParty);
        }
        if (this.address != null && !this.address.isEmpty()) {
            dao.save(this.address);
        }
        if (this.contact != null && !this.contact.isEmpty()) {
            dao.save(this.contact);
        }
        if (this.images != null && !this.images.isEmpty()) {
            dao.save(this.images);
        }
        if (this.relation != null) {
            dao.save((AbsModel)this.relation);
        }
        return new Return();
    }

    @Override
    public Return checkValue() {
        if (this.partyCallback != null) {
            return this.partyCallback.check(this, this.getPartyType());
        }
        return new Return();
    }

    public List<PolOrderPartyAddress> getAddress() {
        return this.address;
    }

    public void setAddress(List<PolOrderPartyAddress> address) {
        this.address = address;
    }

    public List<PolOrderPartyContract> getContact() {
        return this.contact;
    }

    public void setContact(List<PolOrderPartyContract> contact) {
        this.contact = contact;
    }

    public List<PolOrderPartyImage> getImages() {
        return this.images;
    }

    public void setImages(List<PolOrderPartyImage> images) {
        this.images = images;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
        this.setOrderUuid(this.order.getOrderUuid());
    }

    public PartyType getPartyType() {
        return this.partyType;
    }

    public void setPartyType(PartyType partyType) {
        this.partyType = partyType;
    }

    public void setPartyType(String partyType) {
        this.partyType = PartyType.valueOf(partyType);
    }

    public AffiliatedType getAffiliatedType() {
        return this.affiliatedType;
    }

    public void setAffiliatedType(AffiliatedType affiliatedType) {
        this.affiliatedType = affiliatedType;
    }

    public void setAffiliatedType(String affiliatedType) {
        this.affiliatedType = AffiliatedType.valueOf(affiliatedType);
    }

    public AffiliatedType getAffiliatedApplicant() {
        return this.affiliatedApplicant;
    }

    public void setAffiliatedApplicant(AffiliatedType affiliatedApplicant) {
        this.affiliatedApplicant = affiliatedApplicant;
    }

    public void setAffiliatedApplicant(String affiliatedApplicant) {
        this.affiliatedApplicant = AffiliatedType.valueOf(affiliatedApplicant);
    }

    public PolOrderPartyRelation getRelation() {
        return this.relation;
    }

    public void setRelation(PolOrderPartyRelation relation) {
        this.relation = relation;
    }

    public List<PolOrderPartyTaxCountry> getCountry() {
        return this.country;
    }

    public void setCountry(List<PolOrderPartyTaxCountry> country) {
        this.country = country;
    }

    public PartyCallback getPartyCallback() {
        return this.partyCallback;
    }

    public void setPartyCallback(PartyCallback partyCallback) {
        this.partyCallback = partyCallback;
    }

    public PolOrderPartyRelation initRelation(RelationType type, String masterUuid) {
        PolOrderPartyRelation relation = new PolOrderPartyRelation();
        relation.setPolicyUuid(UUID.shortUUID());
        relation.setRelationType(RelationType.TB);
        relation.setMasterRelation(masterUuid);
        relation.setAffiliatedRelation(this.getPartyUuid());
        relation.setAffiliatedType(this.getAffiliatedType());
        return relation;
    }

    public static void main(String[] args) {
        int[] a;
        HashMap<String, String> partyMap = new HashMap<String, String>();
        partyMap.put("party_type", "TBR");
        Insured ii = (Insured)((Object)JsonUtils.json2Class((String)JsonUtils.toJson(partyMap), Insured.class));
        System.out.println((Object)ii.getPartyType());
        List<IdType> typeList = Arrays.asList(IdType.I, IdType.C, IdType.M);
        System.out.println(typeList.contains((Object)IdType.valueOf("I")));
        System.out.println(IdType.I.equals("I"));
        for (int i : a = new int[]{1, 2, 3, 4}) {
            switch (i) {
                case 3: {
                    System.out.println("switch" + i);
                }
            }
            System.out.println(i);
        }
    }
}

