/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.nms.insure.domain.party;

import com.newtouch.nms.insure.domain.party.Insured;
import com.newtouch.nms.insure.domain.party.Party;
import com.newtouch.nms.insure.model.PolOrderPartyRelation;
import com.newtouch.nms.insure.model.enums.PartyType;
import com.newtouch.nms.insure.model.enums.RelationType;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.Map;
import javax.persistence.Table;

@Table(name="pol_policy_order_party")
public class Beneficiary
extends Party {
    private Insured master;
    private int benefitOrder;
    private String benefitRatio;

    public Beneficiary() {
        this.setPartyType(PartyType.SYR);
    }

    public void fill(String orderUuid, String insuredUuid, Map<String, Object> param) {
        if (param != null) {
            ClassUtils.copyProperties((Object)JsonUtils.map2Class(param, Beneficiary.class), (Object)((Object)this));
        }
        if (this.getOrder() == null || StrUtils.isNull((Object)this.getOrder().getOrderUuid())) {
            this.setOrderUuid(orderUuid);
        } else {
            this.setOrderUuid(this.getOrder().getOrderUuid());
        }
        super.fill();
        String masterUuid = insuredUuid;
        if (this.getMaster() != null && StrUtils.isNull((Object)this.getMaster().getPartyUuid())) {
            masterUuid = this.getMaster().getPartyUuid();
        }
        PolOrderPartyRelation relation = this.initRelation(RelationType.BG, masterUuid);
        relation.setBenefitRatio(this.benefitRatio);
        relation.setBenefitOrder(this.benefitOrder);
        this.setRelation(relation);
    }

    @Override
    public void fill() {
        this.fill(this.getOrder().getOrderUuid(), this.getMaster().getPartyUuid(), null);
    }

    public Insured getMaster() {
        return this.master;
    }

    public void setMaster(Insured master) {
        this.master = master;
    }

    public int getBenefitOrder() {
        return this.benefitOrder;
    }

    public void setBenefitOrder(int benefitOrder) {
        this.benefitOrder = benefitOrder;
    }

    public String getBenefitRatio() {
        return this.benefitRatio;
    }

    public void setBenefitRatio(String benefitRatio) {
        this.benefitRatio = benefitRatio;
    }
}

