/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.compute;

import com.deepoove.poi.exception.ExpressionEvalException;
import com.deepoove.poi.expression.DefaultEL;
import com.deepoove.poi.render.compute.EnvModel;
import com.deepoove.poi.render.compute.RenderDataCompute;

public class DefaultELRenderDataCompute
implements RenderDataCompute {
    private DefaultEL elObject;
    private DefaultEL envObject;
    private boolean isStrict;

    public DefaultELRenderDataCompute(EnvModel model, boolean isStrict) {
        this.elObject = DefaultEL.create(model.getRoot());
        if (null != model.getEnv() && !model.getEnv().isEmpty()) {
            this.envObject = DefaultEL.create(model.getEnv());
        }
        this.isStrict = isStrict;
    }

    @Override
    public Object compute(String el) {
        try {
            if (null != this.envObject) {
                try {
                    Object val = this.envObject.eval(el);
                    if (null != val) {
                        return val;
                    }
                }
                catch (Exception val) {
                    // empty catch block
                }
            }
            return this.elObject.eval(el);
        }
        catch (ExpressionEvalException e) {
            if (this.isStrict) {
                throw e;
            }
            return null;
        }
    }
}

