/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.DocxRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.Render;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.processor.DocumentProcessor;
import com.deepoove.poi.render.processor.LogProcessor;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRender
implements Render {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRender.class);

    @Override
    public void render(XWPFTemplate template, Object root) {
        Objects.requireNonNull(template, "Template must not be null.");
        Objects.requireNonNull(root, "Data root must not be null");
        LOGGER.info("Render template start...");
        RenderDataCompute renderDataCompute = template.getConfig().getRenderDataComputeFactory().newCompute(root);
        StopWatch watch = new StopWatch();
        try {
            watch.start();
            this.renderTemplate(template, renderDataCompute);
            this.renderInclude(template, renderDataCompute);
        }
        catch (Exception e) {
            if (e instanceof RenderException) {
                throw (RenderException)e;
            }
            throw new RenderException("Cannot render docx template, please check the Exception", e);
        }
        finally {
            watch.stop();
        }
        LOGGER.info("Successfully Render template in {} millis", (Object)TimeUnit.NANOSECONDS.toMillis(watch.getNanoTime()));
    }

    private void renderTemplate(XWPFTemplate template, RenderDataCompute renderDataCompute) {
        new LogProcessor().process(template.getElementTemplates());
        DocumentProcessor documentRender = new DocumentProcessor(template, template.getResolver(), renderDataCompute);
        documentRender.process(template.getElementTemplates());
    }

    private void renderInclude(XWPFTemplate template, RenderDataCompute renderDataCompute) throws IOException {
        List<MetaTemplate> elementTemplates = template.getElementTemplates();
        long docxCount = elementTemplates.stream().filter(meta -> meta instanceof RunTemplate && ((RunTemplate)meta).findPolicy(template.getConfig()) instanceof DocxRenderPolicy).count();
        if (docxCount >= 1L) {
            template.reload(template.getXWPFDocument().generate());
            this.applyDocxPolicy(template, renderDataCompute, docxCount);
        }
    }

    private void applyDocxPolicy(XWPFTemplate template, RenderDataCompute renderDataCompute, long docxItems) {
        List<MetaTemplate> elementTemplates = null;
        RenderPolicy policy = null;
        NiceXWPFDocument current = template.getXWPFDocument();
        block0: for (long i = 0L; i < docxItems && !(elementTemplates = template.getElementTemplates()).isEmpty(); ++i) {
            for (MetaTemplate metaTemplate : elementTemplates) {
                RunTemplate runTemplate;
                if (!(metaTemplate instanceof RunTemplate) || !((policy = (runTemplate = (RunTemplate)metaTemplate).findPolicy(template.getConfig())) instanceof DocxRenderPolicy)) continue;
                LOGGER.info("Start render TemplateName:{}, Sign:{}, policy:{}", new Object[]{runTemplate.getTagName(), runTemplate.getSign(), ClassUtils.getShortClassName(policy.getClass())});
                policy.render(runTemplate, renderDataCompute.compute(runTemplate.getTagName()), template);
                if (current == template.getXWPFDocument()) {
                    ++i;
                    continue;
                }
                current = template.getXWPFDocument();
                continue block0;
            }
        }
    }
}

