/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.config;

import com.ctrip.framework.apollo.spring.config.ConfigPropertySourcesProcessor;
import com.ctrip.framework.apollo.spring.config.PropertySourcesProcessor;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.w3c.dom.Element;

public class NamespaceHandler
extends NamespaceHandlerSupport {
    private static final Splitter NAMESPACE_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();

    public void init() {
        this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new BeanParser());
    }

    static class BeanParser
    extends AbstractSingleBeanDefinitionParser {
        BeanParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return ConfigPropertySourcesProcessor.class;
        }

        protected boolean shouldGenerateId() {
            return true;
        }

        protected void doParse(Element element, BeanDefinitionBuilder builder) {
            String namespaces = element.getAttribute("namespaces");
            if (Strings.isNullOrEmpty((String)namespaces)) {
                namespaces = "application";
            }
            int order = Integer.MAX_VALUE;
            String orderAttribute = element.getAttribute("order");
            if (!Strings.isNullOrEmpty((String)orderAttribute)) {
                try {
                    order = Integer.parseInt(orderAttribute);
                }
                catch (Throwable ex) {
                    throw new IllegalArgumentException(String.format("Invalid order: %s for namespaces: %s", orderAttribute, namespaces));
                }
            }
            PropertySourcesProcessor.addNamespaces(NAMESPACE_SPLITTER.splitToList((CharSequence)namespaces), order);
        }
    }
}

