/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.actuate.endpoint;

import com.alibaba.boot.dubbo.actuate.endpoint.AbstractDubboEndpoint;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import com.alibaba.dubbo.registry.support.AbstractRegistryFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

@Endpoint(id="dubboshutdown")
public class DubboShutdownEndpoint
extends AbstractDubboEndpoint {
    @WriteOperation
    public Map<String, Object> shutdown() throws Exception {
        LinkedHashMap<String, Integer> shutdownCountData = new LinkedHashMap<String, Integer>();
        int registriesCount = AbstractRegistryFactory.getRegistries().size();
        int protocolsCount = this.getProtocolConfigsBeanMap().size();
        ProtocolConfig.destroyAll();
        shutdownCountData.put("registries", registriesCount);
        shutdownCountData.put("protocols", protocolsCount);
        Map<String, ServiceBean> serviceBeansMap = this.getServiceBeansMap();
        if (!serviceBeansMap.isEmpty()) {
            for (ServiceBean serviceBean : serviceBeansMap.values()) {
                serviceBean.destroy();
            }
        }
        shutdownCountData.put("services", serviceBeansMap.size());
        ReferenceAnnotationBeanPostProcessor beanPostProcessor = this.getReferenceAnnotationBeanPostProcessor();
        int referencesCount = beanPostProcessor.getReferenceBeans().size();
        beanPostProcessor.destroy();
        shutdownCountData.put("references", referencesCount);
        TreeMap<String, Object> shutdownData = new TreeMap<String, Object>();
        shutdownData.put("shutdown.count", shutdownCountData);
        return shutdownData;
    }
}

