/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.actuate.endpoint;

import com.alibaba.boot.dubbo.actuate.endpoint.AbstractDubboEndpoint;
import com.alibaba.dubbo.config.spring.ServiceBean;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="dubboservices")
public class DubboServicesMetadataEndpoint
extends AbstractDubboEndpoint {
    @ReadOperation
    public Map<String, Map<String, Object>> services() {
        Map<String, ServiceBean> serviceBeansMap = this.getServiceBeansMap();
        LinkedHashMap<String, Map<String, Object>> servicesMetadata = new LinkedHashMap<String, Map<String, Object>>(serviceBeansMap.size());
        for (Map.Entry<String, ServiceBean> entry : serviceBeansMap.entrySet()) {
            String serviceBeanName = entry.getKey();
            ServiceBean serviceBean = entry.getValue();
            Map<String, Object> serviceBeanMetadata = this.resolveBeanMetadata(serviceBean);
            Object service = this.resolveServiceBean(serviceBeanName, serviceBean);
            if (service != null) {
                serviceBeanMetadata.put("serviceClass", service.getClass().getName());
            }
            servicesMetadata.put(serviceBeanName, serviceBeanMetadata);
        }
        return servicesMetadata;
    }

    private Object resolveServiceBean(String serviceBeanName, ServiceBean serviceBean) {
        int index = serviceBeanName.indexOf("#");
        if (index > -1) {
            Class interfaceClass = serviceBean.getInterfaceClass();
            String serviceName = serviceBeanName.substring(index + 1);
            if (this.applicationContext.containsBean(serviceName)) {
                return this.applicationContext.getBean(serviceName, interfaceClass);
            }
        }
        return null;
    }
}

