/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.actuate.endpoint;

import com.alibaba.boot.dubbo.actuate.endpoint.AbstractDubboEndpoint;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="dubboreferences")
public class DubboReferencesMetadataEndpoint
extends AbstractDubboEndpoint {
    @ReadOperation
    public Map<String, Map<String, Object>> references() {
        LinkedHashMap<String, Map<String, Object>> referencesMetadata = new LinkedHashMap<String, Map<String, Object>>();
        ReferenceAnnotationBeanPostProcessor beanPostProcessor = this.getReferenceAnnotationBeanPostProcessor();
        referencesMetadata.putAll(this.buildReferencesMetadata(beanPostProcessor.getInjectedFieldReferenceBeanMap()));
        referencesMetadata.putAll(this.buildReferencesMetadata(beanPostProcessor.getInjectedMethodReferenceBeanMap()));
        return referencesMetadata;
    }

    private Map<String, Map<String, Object>> buildReferencesMetadata(Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedElementReferenceBeanMap) {
        LinkedHashMap<String, Map<String, Object>> referencesMetadata = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<InjectionMetadata.InjectedElement, ReferenceBean<?>> entry : injectedElementReferenceBeanMap.entrySet()) {
            InjectionMetadata.InjectedElement injectedElement = entry.getKey();
            ReferenceBean<?> referenceBean = entry.getValue();
            Map<String, Object> beanMetadata = this.resolveBeanMetadata(referenceBean);
            beanMetadata.put("invoker", this.resolveBeanMetadata(referenceBean.get()));
            referencesMetadata.put(String.valueOf(injectedElement.getMember()), beanMetadata);
        }
        return referencesMetadata;
    }
}

