/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.OidcAuthenticateResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OidcAuthenticateRequest
extends RequestBase
implements JsonpSerializable {
    private final String nonce;
    @Nullable
    private final String realm;
    private final String redirectUri;
    private final String state;
    public static final JsonpDeserializer<OidcAuthenticateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OidcAuthenticateRequest::setupOidcAuthenticateRequestDeserializer);
    public static final Endpoint<OidcAuthenticateRequest, OidcAuthenticateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<OidcAuthenticateRequest, OidcAuthenticateResponse>("es/security.oidc_authenticate", request -> "POST", request -> "/_security/oidc/authenticate", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, OidcAuthenticateResponse._DESERIALIZER);

    private OidcAuthenticateRequest(Builder builder) {
        this.nonce = ApiTypeHelper.requireNonNull(builder.nonce, this, "nonce");
        this.realm = builder.realm;
        this.redirectUri = ApiTypeHelper.requireNonNull(builder.redirectUri, this, "redirectUri");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
    }

    public static OidcAuthenticateRequest of(Function<Builder, ObjectBuilder<OidcAuthenticateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String nonce() {
        return this.nonce;
    }

    @Nullable
    public final String realm() {
        return this.realm;
    }

    public final String redirectUri() {
        return this.redirectUri;
    }

    public final String state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("nonce");
        generator.write(this.nonce);
        if (this.realm != null) {
            generator.writeKey("realm");
            generator.write(this.realm);
        }
        generator.writeKey("redirect_uri");
        generator.write(this.redirectUri);
        generator.writeKey("state");
        generator.write(this.state);
    }

    protected static void setupOidcAuthenticateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nonce, JsonpDeserializer.stringDeserializer(), "nonce");
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm");
        op.add(Builder::redirectUri, JsonpDeserializer.stringDeserializer(), "redirect_uri");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<OidcAuthenticateRequest> {
        private String nonce;
        @Nullable
        private String realm;
        private String redirectUri;
        private String state;

        public final Builder nonce(String value) {
            this.nonce = value;
            return this;
        }

        public final Builder realm(@Nullable String value) {
            this.realm = value;
            return this;
        }

        public final Builder redirectUri(String value) {
            this.redirectUri = value;
            return this;
        }

        public final Builder state(String value) {
            this.state = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OidcAuthenticateRequest build() {
            this._checkSingleUse();
            return new OidcAuthenticateRequest(this);
        }
    }
}

