/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.BinaryEndpoint;
import co.elastic.clients.transport.endpoints.BinaryResponse;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StreamCompletionRequest
extends RequestBase
implements JsonpSerializable {
    private final String inferenceId;
    private final List<String> input;
    @Nullable
    private final JsonData taskSettings;
    public static final JsonpDeserializer<StreamCompletionRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StreamCompletionRequest::setupStreamCompletionRequestDeserializer);
    public static final Endpoint<StreamCompletionRequest, BinaryResponse, ErrorResponse> _ENDPOINT = new BinaryEndpoint<StreamCompletionRequest>("es/inference.stream_completion", request -> "POST", request -> {
        boolean _inferenceId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/completion");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            buf.append("/_stream");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _inferenceId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("inferenceId", request.inferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, null);

    private StreamCompletionRequest(Builder builder) {
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.input = ApiTypeHelper.unmodifiableRequired(builder.input, (Object)this, "input");
        this.taskSettings = builder.taskSettings;
    }

    public static StreamCompletionRequest of(Function<Builder, ObjectBuilder<StreamCompletionRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    public final List<String> input() {
        return this.input;
    }

    @Nullable
    public final JsonData taskSettings() {
        return this.taskSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.input)) {
            generator.writeKey("input");
            generator.writeStartArray();
            for (String item0 : this.input) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupStreamCompletionRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::input, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "input");
        op.add(Builder::taskSettings, JsonData._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StreamCompletionRequest> {
        private String inferenceId;
        private List<String> input;
        @Nullable
        private JsonData taskSettings;

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder input(List<String> list) {
            this.input = Builder._listAddAll(this.input, list);
            return this;
        }

        public final Builder input(String value, String ... values) {
            this.input = Builder._listAdd(this.input, value, values);
            return this;
        }

        public final Builder taskSettings(@Nullable JsonData value) {
            this.taskSettings = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StreamCompletionRequest build() {
            this._checkSingleUse();
            return new StreamCompletionRequest(this);
        }
    }
}

