/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.ExplainDataLifecycleResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ExplainDataLifecycleRequest
extends RequestBase {
    @Nullable
    private final Boolean includeDefaults;
    private final List<String> index;
    @Nullable
    private final Time masterTimeout;
    public static final Endpoint<ExplainDataLifecycleRequest, ExplainDataLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ExplainDataLifecycleRequest, ExplainDataLifecycleResponse>("es/indices.explain_data_lifecycle", request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_lifecycle");
            buf.append("/explain");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.includeDefaults != null) {
            params.put("include_defaults", String.valueOf(request.includeDefaults));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ExplainDataLifecycleResponse._DESERIALIZER);

    private ExplainDataLifecycleRequest(Builder builder) {
        this.includeDefaults = builder.includeDefaults;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.masterTimeout = builder.masterTimeout;
    }

    public static ExplainDataLifecycleRequest of(Function<Builder, ObjectBuilder<ExplainDataLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean includeDefaults() {
        return this.includeDefaults;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExplainDataLifecycleRequest> {
        @Nullable
        private Boolean includeDefaults;
        private List<String> index;
        @Nullable
        private Time masterTimeout;

        public final Builder includeDefaults(@Nullable Boolean value) {
            this.includeDefaults = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExplainDataLifecycleRequest build() {
            this._checkSingleUse();
            return new ExplainDataLifecycleRequest(this);
        }
    }
}

