/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch.cat.health.HealthRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class HealthResponse
implements JsonpSerializable {
    private final List<HealthRecord> healthRecords;
    public static final JsonpDeserializer<HealthResponse> _DESERIALIZER = HealthResponse.createHealthResponseDeserializer();

    private HealthResponse(Builder builder) {
        this.healthRecords = ApiTypeHelper.unmodifiableRequired(builder.healthRecords, (Object)this, "healthRecords");
    }

    public static HealthResponse of(Function<Builder, ObjectBuilder<HealthResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<HealthRecord> healthRecords() {
        return this.healthRecords;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (HealthRecord item0 : this.healthRecords) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static JsonpDeserializer<HealthResponse> createHealthResponseDeserializer() {
        JsonpDeserializer<List<HealthRecord>> valueDeserializer = JsonpDeserializer.arrayDeserializer(HealthRecord._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().healthRecords((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HealthResponse> {
        private List<HealthRecord> healthRecords;

        public final Builder healthRecords(List<HealthRecord> list) {
            this.healthRecords = Builder._listAddAll(this.healthRecords, list);
            return this;
        }

        public final Builder healthRecords(HealthRecord value, HealthRecord ... values) {
            this.healthRecords = Builder._listAdd(this.healthRecords, value, values);
            return this;
        }

        public final Builder healthRecords(Function<HealthRecord.Builder, ObjectBuilder<HealthRecord>> fn) {
            return this.healthRecords(fn.apply(new HealthRecord.Builder()).build(), new HealthRecord[0]);
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            List<HealthRecord> value = JsonpDeserializer.arrayDeserializer(HealthRecord._DESERIALIZER).deserialize(parser, mapper);
            return this.healthRecords(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HealthResponse build() {
            this._checkSingleUse();
            return new HealthResponse(this);
        }
    }
}

