/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GeoHashPrecision
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<GeoHashPrecision> _DESERIALIZER = JsonpDeserializer.lazy(GeoHashPrecision::buildGeoHashPrecisionDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private GeoHashPrecision(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case GeohashLength: {
                return this.geohashLength().toString();
            }
            case Distance: {
                return this.distance();
            }
        }
        throw new IllegalStateException("Unknown kind " + String.valueOf((Object)this._kind));
    }

    private GeoHashPrecision(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static GeoHashPrecision of(Function<Builder, ObjectBuilder<GeoHashPrecision>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isGeohashLength() {
        return this._kind == Kind.GeohashLength;
    }

    public Number geohashLength() {
        return (Number)TaggedUnionUtils.get(this, Kind.GeohashLength);
    }

    public boolean isDistance() {
        return this._kind == Kind.Distance;
    }

    public String distance() {
        return (String)TaggedUnionUtils.get(this, Kind.Distance);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case GeohashLength: {
                    generator.write(((Number)this._value).doubleValue());
                    break;
                }
                case Distance: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<GeoHashPrecision> buildGeoHashPrecisionDeserializer() {
        return new UnionDeserializer.Builder<GeoHashPrecision, Kind, Object>(GeoHashPrecision::new, false).addMember(Kind.GeohashLength, JsonpDeserializer.numberDeserializer()).addMember(Kind.Distance, JsonpDeserializer.stringDeserializer()).build();
    }

    public static enum Kind {
        GeohashLength,
        Distance;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoHashPrecision> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<GeoHashPrecision> geohashLength(Number v) {
            this._kind = Kind.GeohashLength;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoHashPrecision> distance(String v) {
            this._kind = Kind.Distance;
            this._value = v;
            return this;
        }

        @Override
        public GeoHashPrecision build() {
            this._checkSingleUse();
            return new GeoHashPrecision(this);
        }
    }
}

