/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Rank;
import co.elastic.clients.elasticsearch._types.RankBase;
import co.elastic.clients.elasticsearch._types.RankVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RrfRank
extends RankBase
implements RankVariant,
JsonpSerializable {
    @Nullable
    private final Long rankConstant;
    @Nullable
    private final Long windowSize;
    public static final JsonpDeserializer<RrfRank> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RrfRank::setupRrfRankDeserializer);

    private RrfRank(Builder builder) {
        this.rankConstant = builder.rankConstant;
        this.windowSize = builder.windowSize;
    }

    public static RrfRank of(Function<Builder, ObjectBuilder<RrfRank>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Rank.Kind _rankKind() {
        return Rank.Kind.Rrf;
    }

    @Nullable
    public final Long rankConstant() {
        return this.rankConstant;
    }

    @Nullable
    public final Long windowSize() {
        return this.windowSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.rankConstant != null) {
            generator.writeKey("rank_constant");
            generator.write(this.rankConstant.longValue());
        }
        if (this.windowSize != null) {
            generator.writeKey("window_size");
            generator.write(this.windowSize.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRrfRankDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rankConstant, JsonpDeserializer.longDeserializer(), "rank_constant");
        op.add(Builder::windowSize, JsonpDeserializer.longDeserializer(), "window_size");
    }

    public static class Builder
    extends RankBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RrfRank> {
        @Nullable
        private Long rankConstant;
        @Nullable
        private Long windowSize;

        public final Builder rankConstant(@Nullable Long value) {
            this.rankConstant = value;
            return this;
        }

        public final Builder windowSize(@Nullable Long value) {
            this.windowSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RrfRank build() {
            this._checkSingleUse();
            return new RrfRank(this);
        }
    }
}

